---
title: SEO para iniciantes – O básico
authors: Diego Eis
type: post
date: 2008-09-15
url: /seo-iniciantes-basico/
aktt_tweeted:
  - 1
tweetbackscheck:
  - 1356453781
shorturls:
  - 'a:3:{s:9:"permalink";s:45:"https://tableless.com.br/seo-iniciantes-basico";s:7:"tinyurl";s:26:"https://tinyurl.com/3gyyccx";s:4:"isgd";s:19:"https://is.gd/XsAra3";}'
twittercomments:
  - 'a:16:{i:10415472725991424;s:6:"136248";i:10632497654145024;s:6:"136254";i:10717828126609408;s:7:"retweet";i:10415994338025472;s:7:"retweet";i:144743985095778304;s:7:"retweet";i:154247924954562560;s:7:"retweet";i:154243825626382337;s:7:"retweet";i:154241606063624192;s:7:"retweet";i:154240323407712256;s:7:"retweet";i:154240239739736064;s:7:"retweet";i:154239987964055552;s:7:"retweet";i:154239908393914369;s:7:"retweet";i:154239385167085568;s:7:"retweet";i:154239321988276225;s:7:"retweet";i:170114014184083457;s:7:"retweet";i:170107546961575936;s:7:"retweet";}'
tweetcount:
  - 42
dsq_thread_id: 503038524
categories:
  - Artigos
  - O Básico
  - SEO
  - Técnicas e Práticas
tags:
  - google
  - metatag
  - otimizacao para buscadores
  - SEO

---
Se você não sabe por onde começar o **trabalho de SEO**, há alguns passos por onde você pode se aventurar até entender melhor todo o sistema. Os pontos à seguir são muito superficiais e nenhum garante que seu site ficará na primeira página. Mas a combinação de todos eles te garante uma base sólida para os pontos mais profundos do tratamento SEO.<!--more-->

### Organizando as URLs

Coloque ordem na casa. Tenha um mapa do site com as URLs utilizadas em cada uma das páginas. Encontre as URLs antigas que mudaram e as que dão erro 404 (não encontrado). Mapeie todos esses endereços e utilize o .htaccess para colocar tudo em ordem novamente.
  
O Google tem o [WebMaster Tools][1] que pode te ajudar a descobrir quais URLs estão quebradas (404), quais o Robô do Google indexou e etc.

Pelo arquivo .htaccess, redirecione os endereços antigos e possíveis endereços que usuários costumam digitar errado para o endereço correto.
  
Prefira sempre URLs amigáveis. São fáceis de lembrar e o Google dá pontos para URLs com termos relevantes.

Essas são algumas ferramentas que podem lhe ajudar:

  * <https://www.pagerank.net/>
  * <https://www.seochat.com/seo-tools/>
  * <https://tools.seobook.com/>

### Estudo de palavras-chaves e termos importantes

Faça um estudo de palavras-chaves e termos importantes para o site. Para esse primeiro momento, você não precisa de um editor profissional para tratar do texto. Pergunte para usuários como eles chegaram até o site. Se chegaram por algum sistema de busca, pergunte pelo termo que ele utilizou. Selecione pessoas que não tem nada a ver com desenvolvimento e peça a elas para que façam uma busca no Google sobre o assunto que o site é relacionado. Essa é uma das melhores maneiras de saber quais as palavras mais importantes e que devem compor os textos do site.

Depois deste trabalho, você poderá espalhar as palavras-chaves títulos, parágrafos, em metatags, titles e  alts das imagens.
  
O Google tem um sistema chamado [AdWord Keyword Tool][2]. Ele foi feito para pessoas que tem campanhas no sistema de AdWords do Google possam encontrar palavras chaves mais relevantes e possam compor sua cartilha de anúncios. Mas o [AdWord Keyword Tool][2] pode ser usado para a escolha de palavras e termos relevantes para a composição dos textos do site. Neste sistema ele mostra a quantidade de buscas pela palavra e a popularidade da palavra entre os concorrentes.

### Titles e Metatags

É importante que cada uma das páginas do site **tenha um Title e Metatags Descriptions diferentes**. Isso traz mais relevância às páginas e aumenta o alcance dos termos e palavras chaves. Tente fazer uma descrição e títulos relativos ao assunto abordado na página.

Se você não utiliza um CMS (muito aconselhável), tente fazer um gerenciamento de metatags com seu programador. É extremamente importante que você consiga facilmente modificar as metatags do seu site.

### Textos e Títulos

O designer que criou o layout pode prever lugares para Títulos, sub-títulos e parágrafos. Essa forma é uma boa maneira para dar mais relevância aos termos mais importantes do site. Lembre-se de cuidar do código dos títulos e parágrafos com carinho. Não substitua a tag P por spans ou qualquer outra tag. A tag P indica para os sistemas que aquelo bloco é um texto, e faz parte de uma redação. Colocando qualquer outra tag para marcar parágrafos ou títulos, você não estará dando a importância necessárias para os sistemas de busca e faltará com acessibilidade, o que pode ser muito pior para o seu público.

**Nunca repita demasiadamente níveis de títulos**. Se você rechear seu código apenas com um tipo de título, por exemplo, H2. Você não estará dizendo ao buscador qual informação é mais importante. Ele entenderá que você está tentando dizer que todos os títulos tem a mesma importância, o que, obviamente, é mentira. Ele não conseguirá distinguir qual conteúdo é mais relevante e não pontuará bem seu site. Por isso, mescle os títulos. E classifique-os com as tags de acordo com a sua importância em relação ao texto.

Estas são apenas alguns passos simples que você mesmo pode controlar e monitorar. Como disse no começo, deixar tudo isso em ordem não quer dizer que você irá ficar em primeiro, seu concorrente pode ter feito isso antes de você e pode ter feito melhor. Por isso, há todo um trabalho que você precisa fazer para que os resultados sejam sempre mais efetivos e duradouros.

 [1]: https://www.google.com/webmasters/tools/
 [2]: https://adwords.google.com/select/KeywordToolExternal