---
title: Seja bem-vindo ao Big Data e Eu serei seu guia — Parte 1 - Cursos
authors: Allan Sene
type: post
date: 2017-07-24
excerpt: Um guia pra começar bem na sua carreira de Engenheiro de Dados/Especialista Big Data, sem gastar rios de dinheiro.
categories:
  - Big Data
  - Semântica
tags:
  - Big Data
  - Semântica
image: https://i.imgur.com/K8GN3jx.jpg
---

Bastante gente, seja na
[faculdade](https://www.dcc.ufmg.br/dcc/), redes sociais ou em
[meetups](https://www.meetup.com/Meetup-de-Machine-Learning-Belo-Horizonte/),
sempre pede indicações de cursos e recursos para começar a aprender sobre Big
Data/Machine Learning e suas ferramentas. Eu já tinha escrito parte deste guia
lá no grupo [Big Data Brasil](https://www.facebook.com/groups/bigdatabrasil/) no
Facebook, mas eu sempre quis *oficializar* e estender mais um pouco essa fonte.

Você deve saber que, em língua portuguesa, há uma grande lacuna a ser preenchida
de fontes confiáveis e de fácil acesso de informação e referências de
aprendizado em Computação, principalmente sub-áreas mais recentemente em *voga*,
como Sistemas Distribuídos, de [Processamento de Dados
Massivos](https://en.wikipedia.org/wiki/Big_data) e de Aprendizado de Máquina.

Este então é o principal motivo deste *post* e até mesmo deste *blog*: dar o
mínimo de contribuição para a disseminação do conhecimento, com o que estiver ao
meu alcance. E seria muito bom se você também contribuísse, para que essa lista
fique cada vez mais completa e útil para futuros padawans no mundo dos dados :).

Este post vai ser dividido em 2 partes: esta com **referências de cursos **pra
quem está começando e [outra com conceitos
essenciais](https://medium.com/@allansenne/seja-bem-vindo-ao-big-data-e-eu-serei-seu-guia-parte-2-enfrentando-um-problema-d2c20278095)**
**explicados de uma maneira bem didática, que todo Engenheiro de
Dados/Especialista em Big Data deve dominar, sendo agnóstico à ferramentas e
tecnologias
[novas](https://medium.com/@allansenne/destrua-seu-data-warehouse-f362ae6e4460)
e
[legais](https://medium.com/@allansenne/recomendaÃ§Ã£o-de-textos-sem-dor-de-cabeÃ§a-teoria-e-prÃ¡tica-com-elasticsearch-ea91c231146a),
que [como você já
sabe](https://medium.com/@allansenne/as-verdades-que-o-mercado-brasileiro-e-vocÃª-precisam-ouvir-sobre-big-data-9fb6f8d5b9d3),
mudam muito rapidamente na nossa área.

Assim sendo, vou postar aqui alguns cursos que já fiz e que, na minha opinião,
valem mais do que muita pós-graduação de R$ 60.000 que a gente vê por aí.

### Machine Learning

> **Coursera — Especialização em Machine Learning da UofW**<br>
> [https://pt.coursera.org/specializations/machine-learning](https://pt.coursera.org/specializations/machine-learning)

Melhor curso de Machine Learning Online que já vi! Todos os outros pecam, ou em
[exigir conhecimento muito
profundo](https://www.coursera.org/learn/machine-learning) de
estatística/cálculo/álgebra linear, ou em dar pouca realidade prática e de mundo
real para os alunos.

Esse curso foi construído pelo nosso conterrâneo [Dr. Carlos
Guestrin](https://www.linkedin.com/in/carlos-guestrin-5352a869/), formado na
USP, professor na Universidade de Washington e dono da
[Turi](https://turi.com/), que foi [comprada pela
Apple](https://techcrunch.com/2016/08/05/apple-acquires-turi-a-machine-learning-company/)
há pouco tempo. Inclusive, um dos destaques desse curso é o próprio Prof.
Carlos, que é muito divertido e usa vários exemplos e intuições que facilitam
demais o aprendizado, até em conceitos complexos como
[LDA](https://en.wikipedia.org/wiki/Latent_Dirichlet_allocation). Óbvio: futebol
tá presente em vários deles haha!

A especialização passa por todos os grandes tópicos de ML: Regressão,
Classificação, Clustering e Recuperação de Informação, cuminando, para quem
pagar a especialização, em um projeto muito bacana usando Deep Learning. Além de
falar de técnicas de otimização como
[Cross-Validation](https://pt.wikipedia.org/wiki/ValidaÃ§Ã£o_cruzada), [Feature
Engineering](https://en.wikipedia.org/wiki/Feature_engineering) e
[Regularização](https://en.wikipedia.org/wiki/Lasso_(statistics)).

Para quem quiser ter só um overview sobre ML e seus métodos mais comuns e suas
aplicações, como Analistas de Produto ou Gerentes de Projeto ou [até mesmo você
Cientista de
Dados](https://ericbrown.com/you-probably-dont-need-machine-learning.htm), o
[primeiro curso da série](https://www.coursera.org/learn/ml-foundations) já
basta.

### Big Data

> **EDx — Especialização em Engenharia e Ciência de Dados com Apache Spark da UC
> Berkeley**<br>
[https://www.edx.org/xseries/data-science-engineering-apacher-sparktm](https://www.edx.org/xseries/data-science-engineering-apacher-sparktm)

Se quer aprender sobre a ferramenta [big data que mais cresce hoje no
mercado](https://veekaybee.github.io/strata/), por quê não começar aprendendo com
gente que ajudou a criá-la no [Amplab da UC
Berkeley](https://amplab.cs.berkeley.edu/) e que está no
[Databricks](https://databricks.com/) -marca comercial por traz do Spark- hoje?
Esta série explica todo o fundamento da tecnologia, desde o [fundamental
RDD](https://spark.apache.org/docs/latest/programming-guide.html#rdd-persistence)
até como o Spark distribui as *tasks* entre os *workers* no modo *cluster*. As
aulas não são tão divertidas como as do Prof. Carlos, mas os labs são incríveis!
São todos casos reais de recuperação da informação, limpeza de dados e
aprendizado de máquina. Um deles, de ML, você usa de
[PCA](https://en.wikipedia.org/wiki/Principal_component_analysis) para mapear a
atividade do cérebro dum peixe. É sensacional!

> **Udemy — Cursos do Frank Kane**

> [https://www.udemy.com/user/frankkane/](https://l.facebook.com/l.php?u=https://www.udemy.com/user/frankkane/&h=ATMBxRsSS2P7prCmBlu0ZVGPR_qReWaYE01OJYdmFXaJgzMVJbTbnveWRfkUBvl1umg4GAYUkIruSCtN74fkV8FYr4HSqYMWh7x4gQWizEYLsaNK_MoZYEuYFUgVJzUblARiNQ&enc=AZOW0zdDzgxfcRZmYv2Qn_mL-uBCn72gmyBZdlnv0OMoMNy-c_a-7t_Ee4_sdTNTlH4Ke09TckepngTSkjQM4HRgk4vfPw7WQUS6G4710jWCsPjubX1EfWByraHf0sZB2-busv9n0dPbc_vKrAhmD35cSqgfO1Qko06UKmuDv42oTw&s=1)

[Frank Kane](https://www.linkedin.com/in/frank-kane-76443417/) é um dos melhores
instrutores sobre Big Data da internet. Com passagens por gigantes como IMDb e
Amazon, ele têm diversos videos no
[Youtube](https://www.youtube.com/user/kanefrank) ensinando sobre as ferramentas
mais utilizadas no mercado, como Kafka e Spark. O seu diferencial é o olhar
prático de seus cursos. São todos guiados por *hands-on* em simulações de casos
reais enquanto ele explica o core das ferramentas.

Recomendo especialmente o de [Scala + Spark
Streaming](https://www.udemy.com/taming-big-data-with-spark-streaming-hands-on/?couponCode=STREAMINGWEB)**,**
porque os cursos do EDx que citei anteriomente deixam a desejar nesses 2
assuntos muito importantes da plataforma. Spark Streaming inclusive é uma
implementação dos paradigmas mais importantes pra [data
pipelines](https://radar.oreilly.com/2015/09/three-best-practices-for-building-successful-data-pipelines.html),
assunto que irei abordar no próximo post dessa série.

Kane também tem um curso bem abrangente e bem avaliado sobre [Machine Learning
com
Python](https://www.udemy.com/data-science-and-machine-learning-with-python-hands-on/),
porém como eu não fiz, não tenho como opinar sobre sua qualidade. Se você já
fez, comenta aí embaixo o que você achou :)

### Cloud Computing

> **Udemy — Preparação para Certificação AWS do CloudGuru**<br>
> [https://www.udemy.com/aws-certified-developer-associate/…](https://www.udemy.com/aws-certified-developer-associate/?couponCode=DEC1202)<br>
[https://www.udemy.com/aws-certified-solutions-architect-a…/…](https://l.facebook.com/l.php?u=https://www.udemy.com/aws-certified-solutions-architect-associate/?couponCode=DEC1202&h=ATOics6ar-sqKiJ0V1ZsbV3kdQK56xwXCSU8W7wKCMpOA8O3-xllzxliE0KkV4L5AKe5XyeRNevovoJWLtw2ZyE7ltgNtt2CwAbfiEOCbHLnsAMHG__djlBXmH5WDIbag3xQiA&enc=AZPge4z3SAQu0hmn89CToDB29dHH6F8CKeUam5tOlmmJgReF4x7hC3n68ITXHxjp3DhQDDgYpfTxEDD67XiMFogvW4U5SJTCuPkKZfP1wcHza04w3DVxpDRL7KfzMHzm9kLa8AcQuMVKYSjsZwiSZnsGZ4zNlqFK6_30c1Gbvjagzw&s=1)

[CloudGuru](https://acloud.guru/) é o maior produtor de conteúdo sobre c*loud
computing* do mundo. Seus cursos são [best-sellers e têm o maior número de altos
ratings no Udemy](https://www.udemy.com/courses/it-and-software/). Ambos os
cursos dão um ótimo overview sobre como funciona a AWS, com demonstrações,
conceitos e simulados, mais que o suficiente para você passar no exame e
continuar seus estudos por conta própria.

**Mas e se eu não quero fazer Certificação AWS? ***Ainda assim recomendo este
curso. ***Por quê?*** Porque, mesmo com Google Cloud e Azure no páreo, a AWS
continua e deve continuar por anos na frente deste mercado da nuvem. Já não
bastasse isso, grande parte das ferramentas das concorrentes têm semelhantes na
Amazon e, provavelmente, num custo menor ou igual.*

Como já disse em [posts
anteriores](https://medium.com/@allansenne/destrua-seu-data-warehouse-f362ae6e4460),
criar e manter uma cloud privada com ferramentas distribuídas é caro e
dispendioso, então é muito provável que você vá utilizar no mundo real serviços
que abstraem o monitoramento, provisionamento e construção das arquiteturas para
que você se foque realmente no que precisa: **seu objetivo final**. Este curso
passa por todas as ferramentas da AWS, sendo que maioria delas vão te ajudar e
muito para ser pragmático rumo as soluções que você vai montar na sua carreira
como Engenheiro de Dados.

*****

*Os cursos do Udemy são pagos, porém *[sempre há cupons de
desconto](https://www.google.com.br/search?q=udemy+coupon&oq=udemy+cup)** ***de
até 90% off na internet.*

*****

Se também tiverem boas recomendações, mandem aí nos comentários pra gente! Se
achou bacana o guia, clique no ❤ e compartilhe com seus colegas :).

Não deixe de me seguir para não perder os próximos artigos! \o/

### Para ler mais sobre esse assunto:
* [Big Data](https://medium.com/tag/big-data?source=post)
* [Machine Learning](https://medium.com/tag/machine-learning?source=post)
* [Software Development](https://medium.com/tag/software-development?source=post)
* [Cloud Computing](https://medium.com/tag/cloud-computing?source=post)
* [Backend](https://medium.com/tag/backend?source=post)


### [Escrito originalmente no canal do Tableless no Medium](https://medium.com/tableless?source=footer_card)

Um lugar para ler e discutir sobre desenvolvimento, design, web semântica,
back-end e outros assuntos relacionados a web. Se você quiser publicar artigos
conosco, envie um email: medium[at]tableless.com.br ou *clique no link*
[https://bit.ly/escreva-tableless-medium](https://bit.ly/escreva-tableless-medium)
