---
title: A revolução dos sites com JAMstack
authors: Tailo Mateus Gonsalves
type: post
image: https://cdn-images-1.medium.com/max/433/1*z-eMJOy5m2YVOsd--LDPEQ.png
date: 2018-03-27
excerpt: Uma nova maneira de criar sites e aplicativos
sponsor: alura
categories:
  - Tecnologias e tendências
  - jamstack
---


JAMstack é uma nova maneira de criar sites e aplicativos que ofereçam melhor
desempenho, maior segurança, menor custo de escala e uma melhor experiência de
desenvolvimento. Para ser considerado uma JAMstack o projeto deve atender os
seguintes critérios:

* JavaScript 
* APIs
* Marcação

![](https://cdn-images-1.medium.com/max/800/1*W5wpg3QBfz2F-zt9cub77Q.png)
<span class="figcaption_hack">O que é JAMstack?</span>

O termo foi criado por [Mathias Biilman](https://twitter.com/biilmann) para
descrever “Uma arquitetura de desenvolvimento moderno baseado em JavaScript no
cliente, API reutilizáveis e Markup pré-construído”.

### **Um exemplo de JAMstack**

<br> 

Imagine um CMS, cada visita na aplicação ela teria que gerar consultas no banco
de dados no back-end, coletar as informações e após devolver para o usuário. Com
o JAMstack é exibido o HTML gerado, sem a necessidade de renderizar informações
de um servidor.  Com isso o tempo de carregamento é mais rápido e diminui os
riscos com segurança.

Em um CMS tradicional, em muitos casos, o código é enviado através de um FTP e
as atualizações de conteúdo realizados com WordPress ou Drupal. Na JAMstack esse
processo de envio de código ou atualizar conteúdo pode ser realizado somente
pelo Git.

Enquanto isso em um universo paralelo, isso está acontecendo:


![](https://cdn-images-1.medium.com/max/800/1*hkA6XlCSB2sfDMl4H9OfUg.jpeg)
<span class="figcaption_hack">Gráfico comparando Git e FTP</span>

### Sou empresário, como ganho com isso?

<br> 

Vou te mostrar uma fórmula curta e que talvez possa te convencer:

Site mais rápido -> melhor experiência do usuário e classificação do Google ->
mais tráfego -> mais dinheiro.


![](https://cdn-images-1.medium.com/max/800/1*xl31p_qdHAe73krTJAka_Q.gif)
<span class="figcaption_hack">Cale-se e pegue meu dinheiro</span>

Mas caso você for apenas um desenvolvedor, também tenho uma fórmula para te
deixar muito feliz:

Site mais simples -> mais seguro e confiável -> menos coisas imprevistas -> paz
de espírito.

### O outro lado da moeda

<br> 

E os usuários não técnicos? Produtores de conteúdo que estão acostumados com os
editores do estilo do WordPress e que não estão familiarizados com markdown e
GitHub? 

Este é realmente um problema e algumas soluções estão começando a surgir.
Ferramentas como [Prose.io,](https://prose.io/) integram o GitHub para fornecer
uma UI mais amigável para os autores não técnicos.

Para as lojas virtuais que utilizam WordPress ou WooCommerce, um site estático é
uma opção totalmente viável. [Snipcart](https://snipcart.com/) é um carrinho de
compras escrito em JavaScript e permite que desenvolvedores adicionem novas
funcionalidades em qualquer site. Ainda existem outras soluções como
[Foxycart](https://www.foxycart.com/) e [botão de comprar do
Shopify](https://www.shopify.co.uk/buy-button).

Logo…

### Isso é para mim?



Como qualquer ferramenta ou metodologia, não existe bala de prata, tudo vai
depender do problema que você quer resolver. A principal desvantagem que
observei são os serviços para usuários com pouco conhecimento técnico, as
ferramentas para esse público ainda estão em evolução.

No entanto, o desenvolvimento web estático atingiu um nível que em muitos casos
as vantagens superaram as desvantagens, e o uso das novas ferramentas,
plataformas e serviços vai impulsionar ainda mais esse ecossistema.

### Para ler mais

[Official site](https://jamstack.org)

[A JAMstack-ready CMS](https://www.contentful.com/r/knowledgebase/jamstack-cms)

[What is JAMstack and why should I care?](https://www.packtpub.com/books/content/what-jamstack-and-why-should-i-care)

[New to JAMstack? How to make a site from A to Z](https://www.netlify.com/blog/2016/11/15/new-to-jamstack-how-to-make-a-site-from-a-to-z)

[Build a JAMstack-Powered Website in 4 Steps](https://hackernoon.com/build-a-jamstack-powered-website-in-4-steps-b1282d545197)

[Go static: 5 reasons to try JAMstack on your next project](https://builtvisible.com/go-static-try-jamstack)

[JAMstack for Clients: Benefits, Static Site CMS, & Limitations](https://snipcart.com/blog/jamstack-clients-static-site-cms)

<br> 