---
title: Responsive Web Design – focando a coisa certa
authors: Diego Eis
type: post
date: 2012-03-20
excerpt: Será que todo mundo precisa de um design responsivo? Você pode não estar dando atenção para o que realmente importa.
url: /responsive-web-design-voce-esta-fazendo-isso-errado/
tweetbackscheck:
  - 1356411081
shorturls:
  - 'a:3:{s:9:"permalink";s:31:"https://tableless.com.br/?p=5718";s:7:"tinyurl";s:26:"https://tinyurl.com/86m5kxl";s:4:"isgd";s:19:"https://is.gd/ithSF5";}'
twittercomments:
  - 'a:0:{}'
dsq_thread_id: 617869992
categories:
  - Acessibilidade
  - Adaptive Web Design (AWD)
  - Artigos
  - Código
  - Mercado
  - Mobile
  - Responsive Web Design (RWD)
  - Técnicas e Práticas
  - Tecnologia e Tendências
tags:
  - 2012
  - acessibilidade
  - design
  - dispositivos moveis
  - internet
  - internetmovel

---
Eu andei pensando em um assunto e procurando sobre [encontrei um artigo][1], fresquinho, no [Brad Frost][2] que veio de encontro ao que eu estava matutando. Eu escrevi em tempos passados um artigo sobre [por que estávamos desenvolvendo apenas para iPhone][3]. Foi aí que começamos a pensar em versões mobiles. Mas fazíamos versões mobiles dos nossos sistemas e websites simplesmente sem entender quando a necessidade de ter um site mobile era real. Muitas empresas gastaram uma boa grana para ter sua versão mobile, mas apenas para se manter na moda.

Agora, a bola da vez é [criar designs responsivos][4] como se não houvesse o amanhã. É aí que entra a pergunta: você precisa de um design responsivo?

A maioria dos browsers para dispositivos móveis fazem um bom trabalho em websites que não tem versão específica para mobiles. Desde a vinda do iPhone, todos os browsers para mobiles se adequaram de uma forma que antes apenas o Opera abordava. Hoje, quando navegamos em qualquer website, tendo ou não versão para mobile, temos uma boa experiência. Aí vem o ponto: será que criar um site responsivo é o mais importante para o negócio do seu cliente? Produzir um website mobile friendly não é apenas modificar sua carinha, colocar ícones bonitinhos e pronto. Há outros pontos a serem abordados que são tão ou mais importantes que este.

Veja um comentário do Brad Frost em seu artigo:

<blockquote lang="en">
  <p>
    <strong>Your visitors don’t give a shit if your site is responsive.</strong> They don’t care if it’s a separate mobile site. They don’t care if it’s just a plain ol’ desktop site. They <strong>do</strong> give a shit if they can’t get done what they need to get done. They <strong>do</strong> give a shit when your site takes 20 seconds to load. They do care when interactions are awkward and broken.
  </p>
</blockquote>

Entende o que eu quero dizer? Um dispositivo móvel já é mais dinâmico por natureza que os desktops. Os aparelhos móveis de hoje em dia nos fazem querer os resultados mais rapidamente. Se você tiver um website desenhado apenas para desktops, mas mesmo assim ele é rápido, os usuários de mobile vão agradecer. Já vi muitos websites mobiles que foram apenas adequados&#8230; Isso não é produzir um site mobile. Se seu site é bem desenhado e sua usabilidade impecável, ter um design responsivo passa a ser secundário e você passa a dar atenção coisas mais importantes, por que mesmo sendo uma versão desktop, o usuário conseguirá navegar sem muitos problemas.

### Mas você quer dizer que sites mobile não importam?

Não, não quero dizer isso. Pelo contrário, eles importam e muito. **A experiência do usuário é muito melhor se houver uma versão mobile**, sem sombra de dúvida. Mas do que adianta ter uma versão mobile se o site demora 20 segundos para carregar? O dev cria a versão mobile, mas ele não faz adaptação nenhuma nas imagens (e não estou falando apenas de mudar a dimensão dela), não usa com inteligência o font-face, que embora seja maravilhoso, come muita banda&#8230; Acontece que ter carinha bonita não quer dizer que é fácil de usar.

### Experiência de usuário é o foco

O foco é buscar a melhor experiência possível que o usuário pode ter em seu dispositivo. Nós usamos responsive web design para levar a experiência do usuário para outro nível. Não apenas por que está todo mundo fazendo. Você não precisa fazer seu site se adequar ao redimensionar a janela. É bonito? Sim, claro, mas só pra impressionar, porque não é muito útil se você parar para pensar. 

No front-end, a experiência do usuário vai muito além do design. Responsive web design não é uma modinha é mais uma ferramenta para usarmos em pról da boa experiência do usuário. É por isso que na construção dos nossos projetos, [podemos iniciar o trabalho pensando primeiramente nos mobiles][5] e depois nos desktops. Isso nos faz mirar em objetivos mais importantes, não apenas para mobiles, mas para os desktops também, bem como tablets, tvs e todo o resto que vem por aí.

Alguns artigos para você dar uma olhada:

  * [Why is Responsive Web Design Such A Big Deal? Seriously…You Tell Me][6]
  * [responsive web design: missing the point][7]
  * [Which One: Responsive Design, Device Experiences, or RESS?][8]
  * [Mobile First – A arte de pensar com foco][5]
  * [A usabilidade deve ser pensada por todos][9]

 [1]: https://bit.ly/GAQ3RX
 [2]: https://twitter.com/#!/brad_frost
 [3]: https://tableless.com.br/porque-so-para-o-iphone/
 [4]: https://wp.me/p1vY5N-12Z
 [5]: https://tableless.com.br/mobile-first-a-arte-de-pensar-com-foco/
 [6]: https://kolakube.com/responsive-design-big-deal/
 [7]: https://bradfrostweb.com/blog/web/responsive-web-design-missing-the-point/?utm_source=feedburner&utm_medium=feed&utm_campaign=Feed%3A+brad-frosts-blog+%28Brad+Frost+Web%29
 [8]: https://www.lukew.com/ff/entry.asp?1509
 [9]: https://tableless.com.br/a-usabilidade-deve-ser-pensada-por-todos/