---
title: Responsive Web Design – Adaptação vs Otimização
authors: Diego Eis
type: post
date: 2012-06-26
excerpt: 'O que é melhor: um site que se adapta bem em diversas telas ou um site totalmente otimizado e de alta perfomance?'
url: /responsive-web-design-adaptacao-vs-otimizacao/
tweetbackscheck:
  - 1356389564
shorturls:
  - 'a:3:{s:9:"permalink";s:31:"https://tableless.com.br/?p=6359";s:7:"tinyurl";s:26:"https://tinyurl.com/6ma7et6";s:4:"isgd";s:19:"https://is.gd/2gSOXg";}'
twittercomments:
  - 'a:0:{}'
dsq_thread_id: 741274064
categories:
  - Adaptive Web Design (AWD)
  - Artigos
  - CSS
  - HTML
  - Mobile
  - Responsive Web Design (RWD)
tags:
  - CSS
  - html
  - mobile
  - mobiles
  - responsive

---
Uma pancada de pessoas já me perguntaram sobre qual é o melhor: criar um site responsive e adaptável ou uma versão específica para mobiles e outros dispositivos. A resposta é: depende.

Depende. Cada situação é um caso diferente. O Responsive tem vantagens e desvantagens, assim como versões específicas. A ideia é sempre fazer a melhor expediência possível para o usuário. Isso inclui, além de design, velocidade, performance e vários outros pontos. Por isso cada projeto precisa ser estudado para que você entenda qual é a melhor situação.

### A Viagem

Esse exemplo é bastante utilizado para simplificar:

#### Cenário um

Quando nos preparamos para uma viagem, é normal que você organize a sua mala. Se você é uma pessoa que não gosta de carregar peso ou não gosta de malas grandes, vai procurar otimizar sua mala da melhor maneira possível tentando saber qual o clima do local de destino, por exemplo. Se estiver calor, você não vai preparar uma mala cheia de casacos e calças. Se estiver frio, você não vai perder tempo colocando camisetas e bermudas. Você vai otimizar a sua mala colocando apenas as roupas que você tem quase certeza de que vai utilizar. Fazendo assim sua mala fica leve e menor. Provavelmente você não vai precisar despachar essa bagagem, ganhando tempo quando chegar ao destino.

#### Cenário dois

Há outro cenário que é quando a viagem será para vários lugares ou para algum lugar, como São Paulo, onde o clima muda drasticamente de uma hora para outra, você com certeza vai organizar uma mala com várias combinações de roupas. Vai levar casacos, calças, bermudas e camisetas. Nunca se sabe quando será frio pela manhã e calor durante a tarde. Por isso você terá uma mala pronta para todas as ocasiões, mas mais pesada que a primeira mala e um pouco maior.

### Qual dos dois cenários é o melhor?

Quando fazemos um site Responsivo nós temos uma mala completa. Nosso site estará pronto para ser visitado de uma Tablet, Smartphone ou uma TV de 52&#8221;. Nós carregamos todo o conteúdo que o usuário **pode** precisar e decidimos, o que o usuário verá de acordo com o tamanho da tela. O site fica ligeiramente mais pesado, em compensação temos um site preparado para qualquer condição.

Quando produzimos um site específico para cada dispositivo, temos certeza de que o usuário carregará o que ele realmente precisa. O problema é que temos que adivinhar de alguma forma qual é o meio de acesso do usuário está utilizando e redirecioná-lo. Nesse caso você tem um certo retrabalho, tanto na parte de back-end quanto na de front-end e design. Você vai ter que manter duas versões de alguma coisa. 

Para saber qual dos dois cenários é o melhor, vai depender do seu projeto.
  
Não tem nada dizendo que todos os sistemas deve ter versões específicas em vez de responsivos. Seu sistema pode ser simples de forma que você não precise esconder muito conteúdo, matendo a performance e adaptando o layout para parecer decentemente em dispositivos móveis. Existem sites mais pesados que muitos sistemas por aí, onde a quantidade de conteúdo é muito grande e que ter uma versão específica seria muito melhor.

Por isso, escolher uma ou outro método depende das características do seu projeto.Em qualquer um dos dois métodos você precisará de um planejamento forte de design e UX para servir melhor seu conteúdo. 

### Responsive específico cross-device

O responsive tem também uma vantagem interessante. Existem várias tablets, notebooks e smartphones. Cada um desses gêneros tem dispositivos com tamanhos de telas totalmente diferentes. Você pode fazer um site específico para cada dispositivos, responsivo. Como assim? A ideia é que o site se adapte nas diversas telas de um determinado gênero de dispositivo. Logo, o site seria bem visualizado em uma tablet de 7 ou de 10 polegadas. Em um celular de 3, 4 ou 5 polegadas.

No fundo, o objetivo sempre é entregar a melhor experiência para o visitante. Não importa se você vai entregar um site adaptável ou se vai fazer algo específico. Você precisa, obrigatoriamente, entregar o conteúdo da melhor forma possível.