---
title: Realinhamento ou Redesign
authors: Diego Eis
type: post
date: 2015-04-13
excerpt: Eu não sei você, mas eu adoro quando meus apps e websites preferidos mudam seus designs.
url: /realinhamento-redesign/
categories:
  - Design
  - UX
tags:
  - design
  - redesign
  - usabilidade
  - ux

---
Eu não sei você, mas sempre que pipoca a bolotinha vermelha no meu AppStore mostrando que existem atualizações de alguns Apps, eu sempre, sempre olho o change notes para ver se há alguma mudança de design na interface. Eu quase nunca fico empolgado por mudanças nas funcionalidades, embora sejam muito bem-vindas. 

> A feature without design is like an idea without language.﻿ **Jurgen Appelo**

Todo mundo gosta de coisas bonitas. Pelo menos a maioria das pessoas. Você se veste bem para agradar a si mesmo e para agradar as pessoas a sua volta. Uma série de outras escolhas diárias se baseiam nesse contexto: desde a escolha do celular até a caneta chique que um executivo usa para assinar contratos. Por que em produtos web isso seria diferente?

Como usuário, quando um bom design é feito, eu percebo menos os problemas em funcionalidades. Parece que eu fico mais tolerante porque vejo, pelo design e pela usabilidade do produto, que existe um apresso pela qualidade. Por causa desse sentimento de constante mudança, é possível entender que uma determinada funcionalidade não vai ficar muito tempo com defeito ou incompleta. Coisas assim você não percebe em testes de usabilidade. Você não consegue medir esse tipo de sentimento do usuário antes de entregar o produto. Uma das melhores formas para entender como o usuário “funciona” é prestando atenção em como você usa seus aplicativos, websites e serviços todos os dias.

Fazer constantemente pequenas mudanças na interface é uma forma de mostrar para o usuário que produto que ele usa todos os dias tem sido melhorado constantemente. Desde o realinhamento visual de um ícone, o posicionamento de um botão, até uma simples mudança de font dão um sentimento para o usuário de que tem coisa nova no pedaço. Mesmo que nenhuma feature matadora saia toda semana, mudanças de design constantes mostram para o usuário que há alguém preocupado com a evolução do projeto e não apenas em apagar incêndios, bugs e tickets de reclamações.

É aqui que entra uma ideia muito interessante: realinhamento em detrimento ao redesign.

## Realinhamento e Redesign

Este conceito pode ajudar você a melhorar constantemente o design do seu produto, website, app ou qualquer outra coisa que seja: é a regra do realinhamento. Você não faz redesign, você faz um realinhamento na interface. Esse realinhamento é focado, preciso e rápido. 

### Redesign

O Redesign, geralmente, foca na estética do site/produto. O redesign está ligado àquele sentimento de costume da interface. Quem nunca ouviu algo assim: “Já fazem dois anos desde o último redesign do site, ele se parece velho agora. Um redesign traria mais visitantes.” 

Redesigns dão trabalho. Você precisa parar uma equipe para pensar tudo novamente do zero. Essa equipe cavuca novamente todos os problemas do projeto, investigando porque esse layout foi feito do jeito que está. Esse tipo de sentimento é normal e muitas vezes é verdades, já que um pequenos realinhamentos de interface não foram feitos durante um longo período. 

Mas ter um design igual durante muito tempo pode não ser um problema, mas um pretexto. Os usuários estão felizes com esse design de 5 anos atrás. O site tem funcionado bem e as vendas não estão sendo afetadas. As visitas se mantém constantes ou estão aumentando, logo você não teria motivos para mudar. O ponto é que a estrutura do site está velha e talvez as novas features que você quer lançar não se adequem ou sejam difíceis de implementar por causa dessa estrutura antiga. Aí é hora de pensar em um redesign.

Você também precisa ter certeza do impacto que isso vai causar nos seus usuários. Se for um produto, o usuários podem se sentir perdidos, já que você mudou as funcionalidades de lugar, adicionou novas ações, mudou a estrutura e etc. Em um website isso pode ser dramático se as vendas caírem. Redesigns estão mais ligados a instinto da equipe do que dados. Você pode até monitorar e analisar o comportamento do usuário, mas um redesign é na maioria das vezes imprevisível. 

É aí que entra a vantagem do realinhamento.

### Realinhamento

Quando realinhamos a interface, nós temos um processo de evolução constante. Você não precisa mudar o site inteiro, só pequenas partes do layout. Você consegue focar na experiência e na usabilidade de elementos específicos do produto. Tenta resolver o que não está funcionando e melhora as partes da interface que já estão funcionando muito bem. Em muitos casos o realinhamento inclui redesenhar totalmente porções do site. Isso é normal e completamente compreensível, já que você tem liberdade de fazer um upgrade visual, tanto para facilitar o uso quanto para adequar o estilo da interface.

Esse processo de realinhamento é muito interessante quando se trabalha com a ideia de [Atomic Design][1]. Os desenvolvedores front-end adoram essa abordagem por que geralmente eles constróem os módulos do website ou da interface do produto em módulos independentes, mas que se combinam quando colocados na interface. Quando um realinhamento é feito, ele consegue executar essa mudança apenas nos elementos escolhidos.

O Realinhamento é interessante também para que os dados que você já tem dos visitantes sejam melhores analisados e usados. Você não tem uma quebra de análise, você tem uma evolução na sua análise. Com pequenas mudanças, você consegue tomar decisões mais direcionadas e acompanhar com mais facilidade os resultados.

Muitas vezes, antes de você ter a facilidade de executar realinhamento, você vai precisar passar por uma fase de redesign completo. As vezes seu produto estão tão ruim do ponto de vista de planejamento visual e de código, que é mais fácil você fazer um redesign completo, preparando o campo para um ambiente mais adequado para produzir realinhamentos constantes. Caso contrário, dependendo do seu projeto, a execução dos realinhamentos, mesmo que de pequenas porções do layout, serão demorados, aí perde-se toda a graça.

Escolher entre redesign e realinhamento não é sobre um estar certo ou errado, mas sobre necessidade. As vezes é difícil executar esse tipo de mudança na sua empresa. Muitas bocas vão ser contra um redesign completo, por exemplo. Principalmente quando se mexe com vendas.

 [1]: https://tableless.com.br/o-que-e-design-atomic/ "O que é Design Atômico?"