---
title: Reação é melhor que previsão
authors: Diego Eis
type: post
date: 2016-12-23
url: /reacao-e-melhor-que-previsao/
titulo_personalizado:
  - 'Reação é melhor que <strong>previsão</strong>'
categories:
  - Design
  - Destaques
  - UX
tags:
  - design
  - entrevista usuário
  - ux

---
Entender o usuário é algo difícil. Você pode perceber isso facilmente comparando a sua forma de usar algum serviço de internet, digamos o Facebook, com qualquer outra pessoa ao seu redor. Provavelmente você tem um costume totalmente diferente de navegar, consumir conteúdo, comentar etc. Pessoas diferentes, usam de formas diferentes um mesmo produto e isso é totalmente normal. É por isso que tentar prever cenários para desenvolver um produto para internet é algo complicado.

> But in the end, for something this complicated, it&#8217;s really hard to design products by focus groups. A lot of times, people don&#8217;t know what they want until you show it to them. &#8212; Steve Jobs 

Para tentar diminuir essa dificuldade, é costume antigo entre os profissionais entrevistarem os usuários (além de fazer outras cerimônias) afim de tentar entender qual a sua perspectiva do usuário sobre o produto/site. Geralmente, com um bom papo, você consegue pescar uma série de pontos importantes afim de tentar adiantar a solução de problemas de uso. Métodos assim, podem não ser tão eficazes por vários motivos, aqui vão alguns deles:

  1. **Geralmente o usuário não sabe se expressar.** Muitas vezes, o que o usuário fala não é exatamente o problema real. Você precisa conhecer muito bem seu projeto para conseguir traduzir qual o sentido real do problema para saber onde atacar.
  2. **Entrevistas com os usuários dependem do engajamento do usuário.** Fazer com o que o usuário saia da sua casa para ir até você é uma tarefa difícil e muito incomoda. Para compensar isso, alguns inventam de pagar ou dar alguma recompensa para o usuário, por um trabalho, que ao meu ver, não é de responsabilidade do usuário, mas da pessoa que está planejando o projeto. Já vi pessoas se prepararem uma semana para um encontro com os usuários, mas que nenhum usuário apareceu. As vezes a gente precisa ir até onde o usuário está, o que é ruim, por que o ambiente onde ele trabalha tem muitas distrações.
  3. **Testes guiados são importantes, mas os resultados são danificados pelo ambiente estranho e pela ansiedade dos usuários.** Você já parou do lado de um designer ou de um programador enquanto ele executava uma tarefa? Cara, é desconfortável ter um papagaio de pirata &#8220;fiscalizando&#8221; o que você está fazendo. Geralmente os usuários não executam suas tarefas naturalmente, como eles executariam em dias comuns. Quando usamos frequentemente um produto, nós nos acostumamos com a interface, fluxo e outras ações. Em entrevistas, é inevitável que o usuários sinta que está sendo avaliado. Achar o contrário é se enganar. 
  4. **Você não vai obter respostas reais com perguntas meia boca.** É muito difícil obter boas respostas com perguntas como: &#8220;Qual a primeira ação que você faria nessa tela?&#8221; ou &#8220;Qual a primeira impressão sobre essa tela?&#8221;. Há uma série de técnicas para tornar essas [entrevistas mais inteligentes][1], mas infelizmente isso não é tão fácil de executar. Conto nos dedos as pessoas que vi fazerem isso da maneira correta.

Tenho certeza de que você pode citar vários outros cenários parecidos, onde usamos várias técnicas e cerimonias na tentativa de prever qual seria a melhor solução para o usuário, mas que na real, não dão respostas que possamos usar **de verdade** para solucionar os problemas do produto.

![][2]

Outro dia vi uma apresentação com a seguinte frase: **Evite Fails no projeto e economize tempo**. Para mim, esse é o típico comentário de alguém que não tem a mentalidade ágil e que não sabe trabalhar com pequenas entregas incrementais, que atrasa a entrega de valor para o cliente porque quer entregar &#8220;algo completo&#8221;.

Bom, minha sugestão: **não tente prever o que seria melhor para o usuário, tente reagir à experimentos e aos dados de uso real de produção**. Colocar no ar uma mudança pequena e medir o comportamento dos usuários, ajuda muito mais a entender qual será o próximo passo. É um erro tentar prever o que seria melhor para um produto se baseando na opinião de pessoas, que embora sejam seus clientes diretos, tem expectativas e níveis de conhecimento diferentes.

## Entrega rápida de valor

Essa previsão mentirosa me leva a outro assunto: entregas pequenas são melhores que entregas grandes.
  
Planejar grandes mudanças de uma vez é furada. Qualquer um sabe disso. Mudanças pequenas são controláveis, causam menos impacto, são fáceis de medir os acertos e os erros. Existem exceções, claro, por exemplo em casos onde o produto precisa de um redesign completo e o realinhamento progressivo de interface é impossível. Há produtos antigos que não tem a possibilidade de fazer um realinhamento ao longo do tempo e por isso o redesign completo, feito de uma vez, é a única opção. Mas tirando essas exceções, entregas pequenas, funcionais e incrementais é o mais indicado.

Eu sei que é difícil pensar dessa forma. A maioria dos UXzes e Devs prefere pensar na funcionalidade por inteiro. Eles têm a falsa impressão de que entregar algo pequeno, mesmo que seja funcional, é o mesmo que entregar algo incompleto. Não entra na cabeça deles entregar um pedacinho em vez da obra completa. Eles podem fazer um pedaço pequeno, porém essencial da funcionalidade, medir o comportamento do usuário e aí sim tomar a decisão de qual será o próximo passo. Transformação e adaptação é o nome do jogo.

Mas há um ponto para tomar cuidado em entregas incrementais: a feature precisa ser terminada. Ela precisa ter um ponto onde possamos dizer que ela está &#8220;completa&#8221;. A abordagem de entregas incrementais pode virar um ciclo infinito e a feature pode mudar muitas vezes durante um longo período de tempo. O outro ponto é que se o P.O. não priorizar as outras tarefas da feature, ela realmente pode ficar incompleta, embora fique totalmente funcional.

Moral da história: prefira tomar decisões baseadas em dados ao invés de tentar prever as ações do usuário. Dados são fatos. Usuários, infelizmente, mentem&#8230; e há um monte de profissionais que caem nessas mentiras.

 [1]: https://www.uxdesign.blog.br/pesquisa-com-usuarios/perguntas-a-serem-evitadas-em-pesquisa-com-usuarios/
 [2]: https://gifimgs.com/res/1216/585c791fb62d8123354586.gif