---
title: 'Querido usuário: Por favor, atualize seu browser'
authors: Diego Eis
type: post
date: 2012-07-15
excerpt: Um texto que pode ajudar os usuários normais a atualizar seus browsers antigos.
url: /querido-usuario-atualize-seu-browser/
tweetbackscheck:
  - 1356394490
shorturls:
  - 'a:3:{s:9:"permalink";s:31:"https://tableless.com.br/?p=6421";s:7:"tinyurl";s:26:"https://tinyurl.com/cd58zub";s:4:"isgd";s:19:"https://is.gd/8OIjSj";}'
twittercomments:
  - 'a:0:{}'
dsq_thread_id: 766583375
categories:
  - Artigos
  - Browsers
  - Mercado
  - Tecnologia e Tendências
tags:
  - 2012
  - Browsers
  - chrome
  - firefox
  - internet explorer
  - opera
  - safari
  - usuarios

---
Compras. Redes sociais. Email. Leitura. Buscando. Banco. Pesquisa. Tudo isso são tarefas comuns que pessoas fazem na Internet. Você provavelmente faz todas essas coisas em algum momento. Então, você é igual a muitas pessoas, voc6e provavalmente faz essas coisas toda semana (e muitas vezes todos os dias).

O blog que você está lendo agora, Tableless, normalmente publica conteúdo que envolve designers gráficos, web designer e desenvolvedores web com níveis de conhecimento técnico variáveis. Mas hoje, esse artigo é para você &#8211; uma pessoa que não é programadora, mas é um usuário da web todos os dias.

Nós do Tableless, durante algum tempo com desingers e desenvolvedores ao redor do mundo, queremos que você tenha a melhor experiência possível na Web. De fato, nas comunidades de design e desenvolvimento, nós gastamos horas incontáveis todas as semanas discutindo e pesquisando padrões e práticas que nós sabemos que farão sua experiência ser infinitamente melhor.

Mas **o browser que você está usando pode estar limitando esse potencial**. Então, por favor, leia esse artigo, aí então você poderá aprender o quão drástico é tentar melhorar sua experiência na web.

### Seu browser está muito velho

Todos que acessam páginas na internet em um computador utilizam um navegador (também conhecido como Browser). Sem um browser você não pode ver ou interagir com websites. Como você acessa websites como Facebook e YouTube? Você provavelmente utiliza um programa comum que se abre quando você clica em um grande ícone com um &#8220;E&#8221; azul na sua área de trabalho. Ele deve se parecer com isso:

[<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2012/07/ie-logo.jpg" alt="Logo do Internet Explorer" title="Logo do Internet Explorer" width="500" height="300" class="alignnone size-full wp-image-6423" srcset="uploads/2012/07/ie-logo.jpg 500w, uploads/2012/07/ie-logo-300x180.jpg 300w" sizes="(max-width: 500px) 100vw, 500px" />][1]

Este &#8220;e&#8221; não é um atalho para um programa genérico de Internet. Ele é um atalho para um browser feito pela Microsoft, chamado de &#8220;Internet Explorer&#8221; (também conhecido apenas como IE). Ao passar de 17 anos, este browser foi o browser mais popular. Em uma vez, ele foi o melhor browser que você poderia utilizar. Mas isso não mais verdade agora.

Internet Explorer está atualmente em sua versão 9, e a versão 10 é supostamente a versão oficial lançada a mais ou menos um ano atrás. Mas a maioria das pessoas não estão usando o IE9 &#8211; a maioria dos usuários de internet que usam o browser da Microsoft ainda estão usando uma versão anterior, não estável, insegura e lerda do IE (algo como IE8 ou mais velho).

A verdade é, até o IE9 (o qual teve um grande melhoramento comparando com as versões antigas do Internet Explorer) não é tão atual quantos os outros browsers do mercado. Então, se você ainda utilizando essa versão do Internet Explorer, **nós recomendamos fortemenete que você atualize para uma versão diferente do browser**. Para ajudá-lo nessa decisão, nós temos algumas opções para você.

Mas antes de apresentar outros browsers para você, nos deixe rapidamente mostrar algumas razões pelo qual utilizar browsers antigos como o IE7 e o IE8 não é uma coisa boa.

### O que está de errado com browsers antigos?

Browsers antigos (especialmente o Internet Explorer nas versões 6, 7 e 8) são menos estáveis e **muito mais vulneráveis para virus, spywares, malware, e outras motivos de segurança**. Isto obviamente são grandes problemas para se preocupar &#8211; especialmente para pessoas que compram online. Logo, apenas o motivo de segurança já é uma boa razão para você atualizar. Mas temos mais do que isso.

#### Browsers antigos são lerdos e travam mais

Primeiramente, browsers antigos são muito lerdos. Toda página da internet que carrega em um browser, executa uma série de diferentes tarefas. Uma dessas tarefas é processar o carregamento de diversos arquivos. Estes arquivos incluem imagens, código de programação e outros recursos para ajudar a melhorar o visual e as funcionalidades do site que você está visitando. Velhos browsers não executam essas tarefas na mesma velocidade dos novos browsers. Isto faz sua experiência na Web ser muito lerda, e então algumas vezes isso dá pane no seu browser fazendo-o travar.

#### Browsers antigos não conseguem mostrar novos websites

Outro problema dos browsers velhos é que suas capacidades visuais são muito limitadas. Por exemplo, em um browser antigo, para mostrar uma simples animação, a pessoa que criou o website precisa utilizar um arquivo de vídeo ou um Flash (como os que encontramos no YouTube) ou muito código de programação extra (chamado de Javascript). Isso quer dizer que a página irá levar muito tempo carregando, dificultando novamente sua experiência no site.

Novos browsers suportam novas tecnologias (como HTML5 e CSS3). Estas linguagens servem como uma fundação para muitos websites hoje e virtualmente para TODOS os websites e aplicações. Mas infelizmente, muitos destes **novos websites não irão aparecer ou funcionar da mesma maneira em browsers antigos com o IE8**.

Para demonstrar este problema, dê uma olhada na imagem abaixo. Essa imagem é um screeshot tirada de um infográfico de um site chamado [Rainforest Deforestation][2] (um site sobre reflorestamento). Veja como ele aparece no IE8:

[<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2012/07/krause-ie8.jpg" alt="" title="krause-ie8" width="500" height="296" class="alignnone size-full wp-image-6426" srcset="uploads/2012/07/krause-ie8.jpg 500w, uploads/2012/07/krause-ie8-300x177.jpg 300w" sizes="(max-width: 500px) 100vw, 500px" />][3]

Agora veja como ele aparece em browsers novos como o Chrome ou o Firefox:

[<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2012/07/krause-chrome.jpg" alt="" title="krause-chrome" width="500" height="276" class="alignnone size-full wp-image-6425" srcset="uploads/2012/07/krause-chrome.jpg 500w, uploads/2012/07/krause-chrome-300x165.jpg 300w" sizes="(max-width: 500px) 100vw, 500px" />][4]

IE8 causa muitos problemas nessa página: muitos elementos gráficos não estão aparecendo, todas as animações não funcionam e muitos blocos de textos estão mal alinhados. Isso é causado pelo fato de que a página foi construída com novas tecnologias de design que os browsers antigos com o IE8 não suportam.

### Opção de novos browsers

Agora que você entende que é altamente recomendável atualizar seu browser, vamos olhar quais as opções você tem de novos browsers, e quais as qualidades estes novos browsers tem. Por favor, entenda que mudar para estes novos browsers é grátis e não toma mais do que alguns minutos.

#### [Google Chrome][5]

Em Maio de 2012, de acordo com um site de estatísticas, o [Google Chrome][5] (todas as versões combinadas) se tornou o browser mais popular no mundo (comparando com o IE, com todas as suas versões combinadas). Chrome foi lançado em 2008 e tem um número maior de vantagens sob browsers antigos com o IE8.

[<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2012/07/chrome-logo1.jpg" alt="" title="chrome-logo1" width="500" height="300" class="alignnone size-full wp-image-6430" srcset="uploads/2012/07/chrome-logo1.jpg 500w, uploads/2012/07/chrome-logo1-300x180.jpg 300w" sizes="(max-width: 500px) 100vw, 500px" />][5]

#### [Mozilla Firefox][6]

O [Firefox][6] foi o principal competidor do Internet Explorer desde algo em torno do ano 2000. Até Google Chrome se tornar o browser mais popular, Firefox é um grande browser com muitas vantagens sob browsers antigos.

[<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2012/07/ff-logo.jpg" alt="" title="ff-logo" width="500" height="300" class="alignnone size-full wp-image-6427" srcset="uploads/2012/07/ff-logo.jpg 500w, uploads/2012/07/ff-logo-300x180.jpg 300w" sizes="(max-width: 500px) 100vw, 500px" />][6]

#### [Opera][7]

Comparado com os outros browsers, Opera não é tão usado, mas tem sido utilizado por muitos usuários desde os anos 90. Opera sempre foi um browser vanguardista em inovação e suporte a muitas tecnologias e características que fazem websites se tornarem mais rápidos e mais ricos.

[<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2012/07/opera-logo.jpg" alt="" title="opera-logo" width="500" height="300" class="alignnone size-full wp-image-6428" srcset="uploads/2012/07/opera-logo.jpg 500w, uploads/2012/07/opera-logo-300x180.jpg 300w" sizes="(max-width: 500px) 100vw, 500px" />][7]

#### [Apple Safari][8]

Este é o browser utilizado pelos usuários de iPhones e iPads. Em relação as suas características, o Safari é muito parecido com o Google Chrome e foi lançado em torno do ano de 2003.

[<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2012/07/safari-logo.jpg" alt="" title="safari-logo" width="500" height="300" class="alignnone size-full wp-image-6429" srcset="uploads/2012/07/safari-logo.jpg 500w, uploads/2012/07/safari-logo-300x180.jpg 300w" sizes="(max-width: 500px) 100vw, 500px" />][8]

### Por que os novos browsers são melhores?

Os browsers mostrados acima tem um número de gigante de vantagens contra os browsers novos, incluindo:

  * Eles travam e congelam menos.
  * **São mais seguros contra virus, malware e outros problemas de segurança conhecidos**.
  * Muito mais rápidos no carregamento de páginas.
  * Uma área de visualização maior.
  * Uma larga variedade de plugins e aplicações que dão características extras para melhorar a navegação na web.
  * Diferentemente do IE9 e o IE10, eles podem ser instalados no Windows XP.
  * Novos browsers se atualizam automaticamente para a versão mais atual ou eles irão te notificar quando houver uma versão melhor do que a versão que você está usando.

#### Sobre a atualização automática

O último ponto da lista de menções é o fato de que novos browsers irão automaticamente avisar você sobre uma mais nova &#8211; isto é uma boa coisa. Quando você tem um browser que não se atualiza automaticamente você perde um número importante de benefícios além daqueles que já citamos. Alguns como:

  * Você irá raramente verá aquele aviso que diz &#8220;seu browser não pode ver este site&#8221;.
  * Se qualquer problema conhecido de vulnerabilidades de segurança for conhecido, eles irão arrumar automaticamente.
  * Sempre que seu browser estiver atualizado, seu browser ficará mais rápido, isso significa que o tempo gasto esperando pelo carregamento de páginas será mínimo.

Browsers velhos como IE7 e IE8 não notificam você automaticamente sobre uma nova atualização, então se você quiser usar um browser antigo, sua experiência na web será menos segura (e menos interessante).

#### Extensões e Plugins

Como mencionamos anteriormente, uma das características dos novos browsers é a habilidade de adicionar extensões, add-ons e plugins. O [Chrome Web Store][9] tem centenas de extensões úteis, incluindo:

  * [Notificações do Facebook][10], que deixa você atualizado com as atividades dos seus amigos sempre quando você não está no Facebook.
  * [Lista de desejos da Amazon][11], que te permite adicionar virtualmente qualquer produto de qualquer website para a sua lista de desejos da Amazon.
  * [Dicionário do Google][12], que permite clicar duas vezes em qualquer palavra para ver qual é sua definição.

[<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2012/07/chrome-store.jpg" alt="" title="chrome-store" width="1196" height="636" class="alignnone size-full wp-image-6432" srcset="uploads/2012/07/chrome-store.jpg 1196w, uploads/2012/07/chrome-store-300x159.jpg 300w, uploads/2012/07/chrome-store-1024x544.jpg 1024w" sizes="(max-width: 1196px) 100vw, 1196px" />][5]

E os [complementos para Firefox][13]? Bem, adicionalmente às extensões mencionadas do Chrome, há algumas escolhas populares e úteis incluindo:

  * [Vídeo DownloadHelper][14] que permite baixar e converter facilmente vídeos, audios e fotos do YouTube e outros sites similares.
  * [WOT &#8211; Safe Surfing][15], que mostra quais websites você pode confiar, baseado na experiência de milhões de usuários.
  * [FastestFox][16], que ajuda a economizar tempo e aumentar a produtividade aumentando a velocidade de tarefas repetitivas que você executa no browser.

Tanto o Chrome quanto o Firefox não são os únicos browsers que oferecem esse tipo de extensões. Você pode procurar extensões para [Safari][17] e para o [Opera][18] se você escolher utilizar esses browsers.

### &#8220;Todos os meus favoritos estão no Internet Explorer&#8221;

Todo mundo tem favoritos (ou Bookmarks, como alguns chamam) no browser que são usados regularmente e isto é uma preocupação válida se você não quer mudar de browser por que todos os seus favoritos estão em um browser antigo. Mas mudar seus favoritos de um browser antigo para um browser novo não é difícil.

Para instruções de como transferir seus favoritos para seu novo browser, visite o site [Browsing Better][19] website. Quando você visitar a página, clique no ícone do browser que você está usando atualmente e siga as instruções das imagens que aparecerem.

<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2012/07/ie-export.jpg" alt="" title="ie-export" width="500" height="395" class="alignnone size-full wp-image-6433" srcset="uploads/2012/07/ie-export.jpg 500w, uploads/2012/07/ie-export-300x237.jpg 300w" sizes="(max-width: 500px) 100vw, 500px" />

### Eu não quero mudar &#8211; Estou feliz com o Internet Explorer

Se mesmo depois de ter lido tudo que escrevemos acima você ainda não querer mudar para um browser diferente, nós temos uma última opção para que você considere.
  
Você pode continuar utilizando o Internet Explorer e ter a velocidade e experiências parecidas com a do Google Chrome bastando instalar um add-on do Internet Explorer chamado [Chrome Frame][20].

<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2012/07/chrome-frame.jpg" alt="" title="chrome-frame" width="476" height="485" class="alignnone size-full wp-image-6434" srcset="uploads/2012/07/chrome-frame.jpg 476w, uploads/2012/07/chrome-frame-294x300.jpg 294w" sizes="(max-width: 476px) 100vw, 476px" />

Chrome Frame é um add-on que ativa novas tecnologias como o HTML5 e CSS3 nas versões 6, 7, 8 e 9 do Internet Explorer. Se as páginas que você visita estiver utilizando alguma dessas novas tecnologias, você terá uma experiência muito similar ao Google Chrome &#8211; mesmo quando utilizar versões antigas do Internet Explorer.

Instalar o Chrome Frame é rápido, fácil e grátis. Chrome Frame é completamente invisível e não muda nada na maneira de como você acessa as páginas no Internet Explorer. Mas ele irá melhorar sua velocidade e experiência como no Google Chrome, mas sem a necessidade de mudar de browser. Entretanto, se você está em um ambiente corporativo, talvez você tenha que avisar o administrador da rede antes de instalar, por que pode ser que alguns sites não sejam exibidos corretamente &#8211; _Obrigado ao Jochem Bokkers por esta observação_.

#### E sobre sistemas que não são atualizados?

Se você está utilizando um sistema em sua empresa onde você não pode atualizar ou fazer o download de um novo browser, o Chrome Frame é uma alternativa viável. Você [Você não precisa de nenhum privilégio de administrador especial para instalar o Chrome Frame][21], então você pode utilizar a mesma versão do Internet Explorer e quase que instantaneamente ter uma experiência superior e quase idêntica como se estivesse utilizando a última versão do Google Chrome.

### Conclusão

Existem aqui incontáveis razões para você atualizar seu browser antigo para algo mais atual. Então, confie em nós quando dissermos que sua experiência na web irá melhorar infinitamente se você escolher fazer essa atualziação.

Não importa o que você esteja fazendo na web &#8211; lendo emails, comprando, fazendo transações no bankline ou qualquer outra coisa &#8211; um novo browser irá permitir que sua experiência seja segura, rápida e muito mais bonita.

**_Este artigo é uma tradução do artigo original feito pela [Smashing Magazine][22]._**

 [1]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2012/07/ie-logo.jpg
 [2]: https://www.jonathan-krause.de/rainforest
 [3]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2012/07/krause-ie8.jpg
 [4]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2012/07/krause-chrome.jpg
 [5]: https://www.google.com.br/chrome
 [6]: https://www.mozilla.org/pt-BR/firefox/new/?from=getfirefox
 [7]: https://www.opera.com/
 [8]: https://www.apple.com/br/safari/
 [9]: https://chrome.google.com/webstore/category/home?hl=pt-BR&utm_source=chrome-ntp-launcher
 [10]: https://chrome.google.com/webstore/detail/nmameahlembdcigphohgiodcgjomcgeo
 [11]: https://chrome.google.com/webstore/detail/ciagpekplgpbepdgggflgmahnjgiaced
 [12]: https://chrome.google.com/webstore/detail/mgijmajocgfcbeboacabfgobmjgjcoja
 [13]: https://addons.mozilla.org/pt-BR/firefox/
 [14]: https://addons.mozilla.org/pt-BR/firefox/addon/video-downloadhelper/
 [15]: https://addons.mozilla.org/pt-BR/firefox/addon/wot-safe-browsing-tool/
 [16]: https://addons.mozilla.org/pt-BR/firefox/addon/fastestfox-browse-faster/
 [17]: https://extensions.apple.com/
 [18]: https://addons.opera.com/e
 [19]: https://browsingbetter.com/#saving
 [20]: https://www.google.com/chromeframe?prefersystemlevel=true&hl=pt-BR
 [21]: https://www.chromium.org/developers/how-tos/chrome-frame-getting-started/chrome-frame-faq#TOC-Do-I-need-to-be-an-Administrator-to-install-Google-Chrome-Frame-
 [22]: https://www.smashingmagazine.com/2012/07/10/dear-web-user-please-upgrade-your-browser/?utm_source=TablelessComBr&utm_medium=LinkTableless&utm_campaign=TablelessComBr&utm_nooverride=1