---
title: Quem são os responsáveis por aplicar a acessibilidade em projetos digitais?
authors: Marcelo Sales
type: post
date: 2017-11-13
excerpt: Você não pode (e não deve) ser o único responsável em falar sobre acessibilidade dentro de uma empresa, mas você pode (e deve) fazer parte dessa equipe.
image: https://i.imgur.com/XTie51a.jpg
categories:
  - Acessibilidade
  - WCAG
  - W3C
---

Você não pode (e não deve) ser o único responsável em falar sobre acessibilidade
dentro de uma empresa, mas você pode (e deve) fazer parte dessa equipe.

Todos sabem (ou deveriam saber) que a acessibilidade não deve ser tratada apenas
como um *checklist* no fim do processo de desenvolvimento de aplicações web.
Muito menos deve ser uma responsabilidade apenas da equipe de desenvolvimento,
como em muitos casos acontece. Mas qual é afinal o papel de cada profissional
envolvido neste processo? Todas as áreas precisam realmente estar envolvidas?

[John Foliot](https://medium.com/@johnfoliot), principal especialista em
acessibilidade da consultoria norte-americana [Deque](https://www.deque.com/)
tuitou o seguinte:

<blockquote class="twitter-tweet" data-lang="en"><p lang="en" dir="ltr">I just want to note that it&#39;s Web CONTENT Accessibility Guidelines, not Web PAGES Accessibility Guidelines.</p>&mdash; John Foliot (@johnfoliot) <a href="https://twitter.com/johnfoliot/status/857959377340387328?ref_src=twsrc%5Etfw">April 28, 2017</a></blockquote>
<script async src="https://platform.twitter.com/widgets.js" charset="utf-8"></script>


Ou seja, é essencial lembrar que o [WCAG](https://youtu.be/3dQuTBjtqb0?t=1m44s)
tem a ver com **CONTEÚDO **e não necessariamente padrões para uma página em si
ou aplicação específica. Seus princípios, recomendações e diretrizes focam em um
padrão para que seu conteúdo alcance todas as pessoas e neste caso, todos são
responsáveis para que isso ocorra da melhor forma.

### Principais membros do time

Em uma apresentação realizada pelo mesmo John Foliot, **“The Road to Sustainable
Corporate Accessibility”**, em que ele compartilha a sua visão do que seria uma
boa equipe de acessibilidade, ele nos apresenta 4 principais funções macros.

<iframe src="//www.slideshare.net/slideshow/embed_code/key/3Xs2E4jFAPDrU1" width="595" height="485" frameborder="0" marginwidth="0" marginheight="0" scrolling="no" style="border:1px solid #CCC; border-width:1px; margin-bottom:5px; max-width: 100%;" allowfullscreen> </iframe> <div style="margin-bottom:5px"> <strong> <a href="//www.slideshare.net/3Play/the-road-to-sustainable-corporate-accessibility" title="The Road to Sustainable Corporate Accessibility" target="_blank">The Road to Sustainable Corporate Accessibility</a> </strong> from <strong><a href="https://www.slideshare.net/3Play" target="_blank">3Play Media</a></strong> </div>

> “As equipes mais bem sucedidas possuem esses quatro membros chaves.”

## Gestor executivo

Essa é a pessoa que defenderá e sustentará a necessidade de aplicação de
acessibilidade por todas as equipes e também a visão que a empresa terá diante
do mercado. Principalmente em grandes empresas, algumas decisões precisam ser
tomadas "de cima para baixo" pra fazer com que a equipe engrene, principalmente
quando o assunto ainda é novo. Essa será a pessoa responsável por deixar claro a
importância da acessibilidade para todos.

Claro que isso não deve ser feito visando apenas o cumprimento da legislação.
Essa função tem também a influência de fomentar o espírito de equipe, a
positividade na aplicação de acessibilidade e consequentemente disseminar a
cultura de acessibilidade entre os envolvidos, direcionando assim um futuro
ideal para o tratamento do assunto em futuros projetos da empresa.

<iframe width="560" height="315" src="https://www.youtube.com/embed/wwqf2uRg9lY" frameborder="0" allowfullscreen></iframe>
<span class="figcaption_hack">Adam Rowse, diretor geral do Barclays, um dos principais bancos do reino unido,
explica neste vídeo de 1 minuto como eles ajudam as empresas a se tornarem mais
acessíveis.</span>

## Coordenador de Acessibilidade Web

Empresas, cuja cultura de acessibilidade já está enraizada em seu DNA possuem
áreas específicas que são responsáveis pela disseminação do conceito e aplicação
do assunto por todos os setores e colaboradores. Algumas responsabilidades dessa
função de coordenador são:

* Comunicar políticas de acessibilidade dentro da empresa;
* Promover a sensibilização para a acessibilidade, em todas as esferas de atividades, colaboradores e equipes;
* Identificar necessidades e promover treinamentos para diversas áreas;
* Garantir que a acessibilidade web permaneça presente na mente de quem toma as decisões e de todos os envolvidos em projetos.

Enfim, é um dos que podem ser chamados de evangelista de acessibilidade na
empresa.

## “Campeão” de Acessibilidade Web

Apesar do termo "campeão" não ser muito usual por aqui, essa é a pessoa
responsável por *"fazer as coisas acontecerem"* na empresa. Normalmente é o
principal apoio do coordenador de acessibilidade web.

Precisa ter uma visão clara sobre acessibilidade, compreender profundamente
todos os tipos de deficiências, entender precisamente os benefícios e reais
ganhos quando se atende a essas questões e também precisa compreender a
legislação a ponto de tomar decisões legais e que podem comprometer o andamento
da aplicação das diretrizes por parte das equipes e possíveis falhas de
conformidade.

> **Spoiler:** Esse profissional será citado mais adiante, mas ele tem um pé na
> cozinha de **User eXperience**. ;)

## Especialista em Acessibilidade Web (por funções)

Este profissional, segundo John, é a pessoa que precisa ter uma forte
compreensão de como a acessibilidade afeta a sua área de especialização. Daí a
separação por funções.

Analista de negócios e gerentes de projetos precisam compreender que algumas
decisões impactam diretamente a experiência e podem prejudicar o acesso a
informação/conteúdo. Designers devem focar em design inclusivo e entenderem que
além da visão, audição e tato também devem fazer parte de suas criações.
Desenvolvedores devem entender de semântica, padrões web e dominar boas práticas
para fazer com que o acesso a informação seja o mais simples possível.

Enfim, em todos os departamentos, deveria haver algum tipo de especialista
integrado a equipe para que se forneça o apoio necessário ao entendimento e
correta aplicação dos critérios básicos e essenciais de acessibilidade.

### Ok, mas se a empresa em que trabalho não tem especialistas, como faz?

A visão do John é essencial, porém parte do princípio de um mundo corporativo
ideal, mas o fato é que a maioria das empresas não possuem a menor possibilidade
de ter especialistas em todos os níveis hierárquicos.

Em muitos casos costuma ser importante termos decisões tomadas de cima pra
baixo, principalmente em grandes empresas onde é complicado priorizar tarefas
essenciais que muitos teimam em considerar como “*features*”, mas para
complementar a visão de John, o artigo **“**[Accessibility is everyone’s job: a
role-based model for
teams](https://simplyaccessible.com/article/role-based-a11y/)**”** de [Mark
Palmer](https://medium.com/@caledoniaman), especialista em acessibilidade da
consultoria [Simply Accessible](https://simplyaccessible.com/), detalha um pouco
mais alguns cargos e funções.

Tomei a liberdade e mesclei áreas e funções que o Mark cita em seu artigo com
alguns que fazem mais sentido a boa parte da realidade de empresas nacionais.
Não necessariamente você terá todas as áreas na empresa em que trabalha, mas daí
basta replicar para a sua realidade. Vamos a elas…

## Negócios

*Demandas não devem ser vistas como uma simples necessidade de compliance*

Normalmente as demandas surgem da área de negócios e é claro que o objetivo
principal é um ROI de dar sorrisos amplos aos principais investidores. Não vou
entrar em detalhes de negócios neste artigo, mas vale lembrar a todos que não
necessariamente o ROI se dá em torno de dinheiro propriamente dito.

Tim Cook, foi questionado (diversas vezes, na verdade) sobre os gastos da Apple
em torno de programas relacionados a acessibilidade e sustentabilidade e a sua
explicação normalmente é simples:

> "A empresa faz muitas coisas por diversas razões além do lucro."

[Neste artigo da Forbes, "Why Tim Cook Doesn’t Care About ‘The Bloody
ROI’"](https://www.forbes.com/sites/stevedenning/2014/03/07/why-tim-cook-doesnt-care-about-the-bloody-roi/#653374cc55f2), há um detalhamento maior sobre este ponto.

A verdade é que podemos repensar a forma como tratamos alguns assuntos e como
eles geram retorno para a empresa. Por exemplo, **retorno positivo perante a
sociedade** e **uma melhor experiência para TODOS os usuários**.

Senhores analistas de negócios, leiam o [artigo "Accessibility for Business and
Pleasure"](https://www.paciellogroup.com/blog/2016/01/accessibility-for-business-and-pleasure/)
da [Sarah Horton](https://medium.com/@gradualclearing), estrategista de UX do
[Paciello Group](https://www.paciellogroup.com/) e entendam o quanto investir em
acessibilidade pode ser prazeroso para o lazer e também para os negócios! :)

## Marketing

*Conteúdo claro, simples e sem ambiguidade*

Em muitos casos há um equipe especializada em conteúdo, caso a empresa não tenha
quem cuide do conteúdo é a equipe de marketing que normalmente assume esse
papel. Faz sentido, pois normalmente são eles que definem campanhas que entram
no ar, o tom de voz e a forma que a empresa se comunica com seus clientes.

Segundo o WCAG, o terceiro princípio de acessibilidade é o **"compreensível"**,
ou seja, a informação precisa ser clara o suficiente para que o usuário
entenda-a corretamente. Desde títulos de páginas, passando por explicações de
produtos e até mesmo mensagens de erro que possam surgir ao preencher um
formulário. Esses profissionais tem uma parcela muito grande no que diz respeito
a responsabilidade com acessibilidade. Basta pensar que usuários com baixa visão
ou cegos, dependem de um leitor de telas e neste caso a mensagem precisa ser
clara, inclusive para os ouvidos.

## Design

*Emoção e sentimento para todos os sentidos, não apenas a visão*

Essa é a equipe que define cores, tamanhos de textos, espaços clicáveis, alinha
corretamente elementos, enfim, define a camada de apresentação visual de sites e
aplicativos. Normalmente baseados em uma identidade visual pré-definida e regras
rígidas de aplicação e uso da marca.

Mas muito além de regras, o objetivo principal é cativar o cliente e criar uma
relação de identidade com os usuários. O foco é a emoção e neste caso, vale
ressaltar que essa emoção deve ser conquistada não apenas através da visão. O
tato e principalmente a audição também precisam ser bem pensados e transmitir
emoção enquanto facilita o acesso a informação.

Vale lembrar que o quarto princípio de acessibilidade, **"robusto"**, é
basicamente tudo sobre design responsivo e conteúdo adaptável a diversos meios e
tecnologias assistivas, portanto essa equipe também tem uma boa parcela de
responsabilidade na aplicação de acessibilidade.

## UX

*Experiências impecáveis independentemente de habilidades e/ou deficiências*

Se há uma equipe que pode ser considerada a principal responsável pela correta
aplicação de acessibilidade, essa é a equipe de **User eXperience**.

Essa equipe precisa ter na ponta da língua as melhores práticas em fornecer um
conteúdo acessível para todos os usuários, independentemente de suas habilidades
e/ou deficiências. Todos precisam ter a mesma experiência ou quase a mesma.

> Devemos fornecer os mesmos meios de uso para todos os usuários:<br> - idênticos
> sempre que possível<br> - equivalente quando não for possível

Esses profissionais precisam entender conceitos de acessibilidade para conseguir
promover testes adequados com usuários e seus diferentes graus de dificuldade de
acesso a informação. Precisam entender como leitores de tela e outros tipos de
tecnologias assistivas (por exemplo, impressoras em braile) funcionam. Precisam
entender corretamente quais são os recursos disponíveis de assistência em
sistemas operacionais (mobile e desktop) e browsers (como usuários que dependem
de zoom, utilizam um navegador?). Precisam entender como hierarquizar
adequadamente o conteúdo na tela e como este conteúdo irá se comportar em um
ambiente responsivo (a ordem de leitura dos elementos será alterada, será que a
experiência também?).

Enfim, são muitas variáveis e se a intenção é fornecer a melhor experiência
possível para TODOS os usuários, então este será o profissional que definirá
especificações e poderá ajudar outras equipes envolvidas a aplicar corretamente
a experiência projetada.

> No artigo ["O que fazer e o que não fazer ao projetar para Acessibilidade"](https://uxdesign.blog.br/o-que-fazer-e-o-que-nÃ£o-fazer-ao-projetar-para-acessibilidade-7da75261fa7b), há boas dicas de como projetar adequadamente para cada tipo de deficiência.

**A equipe de UX deve abraçar o papel de evangelistas de acessibilidade**.

John Foliot citou que entre os cargos que ele considera essenciais, há a
presença de um "campeão de acessibilidade web", não seria incomum dizer que este
campeão seria da área de UX.

## Tecnologia

*Implementação de código semântico e dentro de padrões universais*

Se a equipe de UX é considerada como a maior responsável pelo sucesso da
aplicação de acessibilidade a equipe de TI é a segunda maior responsável.

Grande parte dos problemas de implementação de acessibilidade em sites se deve
pelo desconhecimento de padrões web na construção de código.

> Websites aren’t broken by default, they are functional, high-performing, and
> accessible. You break them.

**HTML é uma linguagem naturalmente acessível**, todas as suas tags possuem
significado semântico e todos os leitores sabem interpretar corretamente esse
significado, o problema ocorre quando essas tags não são aplicadas
adequadamente.

É bem provável que isso se deve ao fato de que por ser uma linguagem simples, o
HTML é subestimado por boa parte dos desenvolvedores. É bem comum pessoas
gritarem aos quatro ventos coisas como, *"eu manjo de html"* ou *"html é
fácil"*. Basta ler duas ou três linhas de código desses desenvolvedores para
entendermos o *"quão fácil"* é a linguagem… ;)

**Esse profissional precisa ter a semântica na veia e respirar front-end.**
Precisa saber de cor coisas como DOM, CSSOM, Render Tree, Reflow e Paint.
Precisa entender que a [Accessibility Tree](https://whatsock.com/training/) vai
influenciar diretamente na tecnologia assistiva utilizada. Precisa saber que
propriedades que ocultam elementos em tela via CSS também o fazem para o leitor
de telas (mas não deveria). Precisa conhecer
[ARIA](https://developer.mozilla.org/pt-BR/docs/Web/Accessibility/ARIA) e saber
como aplicar de forma efetiva.

E principalmente, precisa entender que o site tem que ser operável não apenas
por mouse! Seu conteúdo precisa ser acessado utilizando apenas um teclado, com
tecnologia de voz, com telas touch, com JS e CSS desabilitados e o que mais você
puder. Não basta funcionar apenas com mouse.

Felizmente, a documentação do W3C para acessibilidade é uma das mais completas
já produzidas. É fácil encontrar conceitos detalhados, exemplos de aplicação,
casos de sucesso e insucesso.

Amigo desenvolvedor, caso esses conceitos passam longe do seu conhecimento,
talvez valha uma reciclagem. Comece os estudos por este artigo **"**[A Practical
Starter Guide on Developing Accessible
Websites](https://journal.code4lib.org/articles/12697)**"** e siga para o
[material do
W3C](https://www.acessibilidade.gov.pt/w3/TR/UNDERSTANDING-WCAG20/Overview.html)
em seguida! :)

## Qualidade e testes

*Porque alguém tem que ajudar a garantir a excelência*

Essa é a equipe que irá ajudar com a qualidade final do "entregável". Perceba
que eu citei que é a equipe que **"irá ajudar"** e não a equipe responsável.
Isso por que é muito comum acharem que essa equipe é a que fará todo o processo
de homologação e consequentemente também é bem comum eles ficarem com "toda a
culpa", caso algo publicado esteja incorreto, afinal "alguém tem que levar a
culpa, né?". Todos os envolvidos são responsáveis pela entrega final, o sucesso
não vem sozinho, as falhas também não.

O ideal é que os testadores sejam especialistas e conheçam critérios de sucesso,
diretrizes e os princípios de acessibilidade. Porém, além disso é necessário que
eles tenham noção de UX e em alguns casos de desenvolvimento, para além dos
testes (com visão de usuário) auxiliar as outras equipes com dicas e sugestões
(com visão técnica) na correção de problemas.

## Usuário

*Também somos usuários!*

Não podemos esquecer de nós mesmos. Quando desenvolvemos produtos e serviços,
normalmente nos esquecemos que nós também somos usuários de muitos desses
produtos e serviços. Se você não consegue se colocar no lugar de outras pessoas
e compreender situações que essas pessoas passariam ao tentar usar determinados
recursos, o artigo “[Um Alfabeto de Problemas de
Acessibilidade](https://medium.com/@acessibilito/um-alfabeto-de-problemas-de-acessibilidade-4d8779449334)”
pode ajudar.

> Nossa necessidade de web acessível pode durar um minuto, uma hora ou o resto de
> nossas vidas. Nunca saberemos.

Lembre-se que você poderá necessitar de tecnologias assistivas (um mero recurso
de zoom, por exemplo) em algum momento de sua vida e pergunte a si mesmo:

> "Será que eu consigo utilizar o que eu mesmo estou projetando?"

### TL;DR

É absolutamente mais comum do que a gente imagina pensar que a acessibilidade é
algo que apenas desenvolvedores devem pensar. A maioria das pessoas ainda pensam
assim. Elas acreditam que é algo técnico e isso é natural se pensarmos que as
diretrizes WCAG 1.0 (que foram criadas em 1999, é sempre bom lembrar) tratava-se
exclusivamente de critérios técnicos, porém a WCAG 2.0 (de 2008) refuta esse
pensamento trazendo uma visão mais humana as questões, mas aparentemente as
pessoas ainda se baseiam em opiniões e causos que ouvem “por aí”.

Vale reforçar mais uma vez que a acessibilidade não deve ser tratada como um
*checklist* ou uma *feature* de projeto. **Trata-se uma jornada e não um fim.**
Não há um *deadline* para a sua aplicação, pois é algo que mesmo após a
implantação deve ser seguidamente validada, pois nada impede de que se não
houver um correto ciclo de produção, algum conteúdo deixe de ser acessível em um
determinado momento, seja por conta de atualizações frequentes, seja por conta
de falha em um das etapas de implementação.

A acessibilidade precisa ser pensada desde o início de qualquer projeto e DEVE
ter o envolvimento de todos os profissionais para que se garanta a sua correta
aplicação e manutenção.

> "Para que o processo de acessibilidade seja incorporado dentro de uma empresa,
> todos devem entender a sua importância. E se algumas pessoas ou equipes
> desconhecem essa importância, cabe aqueles que conhecem ajudar seus pares para
> que a compreendam adequadamente."

A frase acima está diretamente ligada a uma cultura de acessibilidade dentro das
instituições, mas isso será papo para um outro post. :)

## Para ler mais sobre acessibilidade
* [Categoria Acessibilidade](https://tableless.com.br/categories/acessibilidade/)
* [Acessibilidade](https://medium.com/tag/acessibilidade?source=tableless)
* [Equipe](https://medium.com/tag/equipe?source=tableless)
* [Conteúdo](https://medium.com/tag/conteÃºdo?source=tableless)
* [WCAG](https://medium.com/tag/wcag?source=tableless)
* [Pessoas](https://medium.com/tag/pessoas?source=tableless)
