---
title: Quem cuida das pessoas no seu time?
authors: Diego Eis
type: post
sponsor: alura
date: 2018-05-11
excerpt: Todos precisam de alguém para ajudar no caminho diário.
image: https://i.imgur.com/gKpfKJy.jpg
categories:
  - html
  - gestão de equipes
---

A estrutura que eu tenho visto nascerem em times de desenvolvimentos é mais ou menos assim:

- Agile Coach cuida do processo. Se certifica que as coisas estão nos trilhos, de que as métricas do time estão em dia, se há algum impedimento ou se o time precisa de alguma coisa para completar sua missão do sprint;
- O PO/PM para dar o norte das próximas coisas que precisam ser executadas, gerenciando o backlog e deixando claro o objetivo das tarefas, alinhando a visão da empresa com a visão do produto, necessidades dos clientes e objetivos do negócio;
- TechLead que direciona o time na parte técnica, definindo quais tecnologias serão usadas, como serão usadas, além tirar dúvidas, sendo referência técnica do time e analisando viabilidade técnica com o que será feito no futuro.

![](https://i.imgur.com/tDJTK76.png)

Embora tenha esses três personagens com tarefas e responsabilidades diferentes, eles não tem uma responsabilidade importante: cuidar do time. Quem cuida da carreira dos integrantes do time de desenvolvimento? Quem verifica se eles estão felizes, motivados e energizados para executar as tarefas do dia a dia? Quem é a pessoa que senta regularmente com cada um dos integrantes para dar feedback?
Pense aí e tente identificar o papel na sua empresa que chega mais perto de fazer isso.

Em algumas empresas que faz isso é o gerente de tecnologia. O problema é que o gerente de tecnologia, geralmente, deveria estar sendo o ponto de contato entre tecnologia e diretoria + stakeholders. Ele deveria estar cada vez mais envolvido com a estratégia de tecnologia da empresa, além de se certificar que todos os times estão se comunicando bem e que ninguém está fazendo algo muito absurdo de forma global. Outra coisa também é a densidade de devs apenas contra um gerente de tecnologia.

![](https://i.imgur.com/VZCjmVu.png)

Essa estrutura é um pouco impossível de lidar. Pessoas precisam de atenção. 

Já vi sugestões de que que é o RH deveria ter esse papel. De fato, o RH poderia ser o grupo na empresa que mais deveria ocupar essa responsabilidade, contudo, o RH pouco sabe sobre o desenvolvimento pessoal do dev. Eles usarão feedback dos pares e do gerente para conseguir ter uma imagem, bem turva diga-se de passagem, da performance e dos interesses do dev.

Geralmente o RH se municia de ferramentas genéricas para tentar controlar diversos pontos que começam desde avaliações 360 até steps de carreira. Essa ferramentas são valiosíssimas, mas geralmente não supre a atenção individual necessária.

## Um líder multidisciplinar

A minha sugestão é um tanto polêmica e muito difícil de alcançar, dado o perfil de pessoa que a empresa deve encontrar. Normalmente esse tipo de pessoa é formado pela empresa, contudo, já vi esse tipo de estrutura dar certo, funcionando muito bem. A Locaweb é um exemplo incrível desse formato. Lá existem muitos times de desenvolvimento, com a estrutura que eu vou apresentar agora: o time tem como líder um personagem que tem apenas duas responsabilidades: pessoas e processos.

Esse personagem precisa entender muito bem de metodologias ágeis e (quase) tudo o que um Agile Coach deve saber. O trabalho dele é totalmente localizado no time. É ele que vai organizar as cerimonias, métricas e dia a dia do time. Ele não vai mudar o tempo inteiro de projeto. Ele não vai se o responsável por aplicar o Mindset ágil numa empresa de 1200 pessoas. Ele é o responsável por cuidar da "cultura ágil" do time, e só.

Além disso, ele é responsável pelas pessoas. É ele que fará os 1-0-1 com o time. É ele que pensará com o dev o caminho da carreira dentro da empresa e com a ajuda do RH, ele traça um plano individual e na medida pra cada um dos membros do time. Esse personagem também tem autonomia, muito autonomia. Ele pode contratar, demitir, definir salário, obviamente tudo isso alinhado com o RH e o gestor da área. Ele pode liberar feriado, home office, etc. Enfim, ele é o responsável pelo time sob todas as formas: performance, entrega, motivação, processo, objetivos, alinhamento, autonomia, etc...

Eu já estive na pele de um personagem assim durante cinco anos lá na Locaweb. No início eu achei bem estranho ter um papel só para lidar com pessoas e processos. Mas depois de alguns dias eu não senti problemas, pelo contrário, como muitas decisões estão concentradas em mim, o time não dependia de várias pessoas para ter respostas. Não há overlap de responsabilidades e com um time muito senior, o processo agile é quase que transparente. Com alguém focado no aprimoramento dos integrantes do time e principalmente no grupo como um todo, o trabalho de manter um processo ágil é diminuto. Essa responsabilidade naturalmente passa a ser compartilhada pelo time, onde eles são os guardiões do mindset ágil, passando a se cobrar para manter a casa em ordem.

Esse líder do time teria como responsabilidades:

- Cuidar do mindset ágil do time, vigiando os princípios ágeis e aculturando o time nesse mindset, delegando e compartilhando responsabilidades para o time;
- Dele seria a responsabilidade de extrair as métricas de performance do grupo, além de expor isso para os stakeholder e também para o time;
- Delegaria ao a responsabilidade de resolver e decidir o caminho técnico do grupo. A referência técnica do time também teria um papel importante nesse ponto;
- Cuidaria das pessoas. Isso quer dizer que ele ajudaria os integrantes do time a terem um plano de carreira, faria feedbacks regulares, etc;
- Ele também ficaria com a responsabilidade de aprimoramente e atualização do conhecimento do time, promovendo cursos, eventos, etc. Lá na Locaweb, nós testamos vários formatos para decidir quem iria em qual evento ou quem precisava de determinado curso. Existem várias formas de fazer isso: meritocracia, pró-atividade, se o dev era engajado fora da empresa fazendo palestras, escrevendo artigos etc... 
- Teria autonomia suficiente para ser um gestor total do time, tendo a responsabilidade de contratar, demitir, redefinir salários e cargos, sempre se apoiando no RH para tais tarefas. Mas ter autonomia é imprescindível nesse tipo de papel para que a burocracia não mate a independência do time como um todo;
- A estrutura e organização do time também seria de sua responsabilidade. 

## E o Techlead e o PO/PM?
Você deve estar se perguntando: "Diego, mas e o techlead que é a referência técnica do time?"  
Ué, você já deve ter percebido que em times de desenvolvimento, invariavelmente, há uma pessoa especial, que o time se apoia para tirar dúvidas e tem como referência natural. Esse cara seria o líder técnico do time. Talvez nem tanto pelo cargo, mas pela responsabilidade que o próprio time colocou sobre ele. Quando eu estava nessa cadeira, eu deixa bem claro para esse membro do time que ele tinha um papel importante a executar e que todos contavam com ele, não apenas como dev do time, mas também como referência.

![](https://i.imgur.com/Y9ZPm3Q.png)

Além disso tem o PO/PM, que vai ser a interface de negócio com o time. Ele vai manter o backlog transparente e atualizado, vai tirar as dúvidas do time sobre as execuções e manter todas as tarefas que um gestor de produto tem no dia a dia. 

## E aquela ideia de gestão flat?
  
Sendo polêmico de novo: eu nunca vi isso funcionar do jeito que pregam. Sempre, sempre vai ter um líder técnico, sempre vai ter aquele grupo de veteranos que o resto dos times respeitam. Sempre vai ter pessoas com mais poder de influencia que outras. Existem lugares que conseguiram se dar bem nesse sentido, mas o que eu ouço por aí é que se negócio não é só maravilhas e geralmente os ambientes são mais caóticos que o comum.

Mesmo assim, um ótimo líder consegue ter um tal nível de autonomia e alinhamento com o time, que essa coisa de hierarquia simplesmente some. Tudo depende muito do líder e da forma com que ele trata as pessoas. Um líder que não respeita a criatividade e a coletividade do time, certamente vai ter dificuldades, tanto numa gestão flat, quanto numa gestão comum. Esse papel deve ter essas características:

- não deve ter problemas para delegar;
- ele deve influenciar mais do que impor;
- empatia, empatia, empatia;
- entender que seu time não é uma ilha;
  
E aquela história de que cada um faz a sua carreira?
Na minha opinião, bullshit. Geralmente a empresa prega essa mensagem para tentar dividir a ideia de que você é independente e pode seguir qualquer caminho que desejar dentro da empresa. Contudo, geralmente, quando você define o caminho, não tem ninguém ali do lado no seu dia a dia para te mentorar ou te ajudar a medir seu progresso. Esse líder do time estaria ali, tanto para te ajudar, quanto para fazer o papel de seu advogado para o RH e para outros stakeholders.

## Conclusão

Eu trabalhei assim durante boa parte da minha carreira e tenho visto várias empresas, principalmente as que fazem essa tal de transformação digital, tendo dificuldades em conseguir motivar e manter seus devs. A resposta não é fácil e não estou dizendo que essa é a correta. Pode ser que não faça sentido nenhum na empresa onde você trabalha. Pode ser que você ache um absurdo misturar as responsabilidades de processo + pessoas numa pessoa só. Tanto faz qual seja o seu motivo, tente colocar os membros do time em primeiro lugar. 