---
title: Quanto menos tempo o visitante passar em seu site, melhor!
authors: Paulo César Moraes
type: post
date: 2015-06-20
excerpt: Conheça o seu público, personalize seu conteúdo e ofereça uma experiência focada no tempo aos usuários do seu site.
url: /quanto-menos-tempo-o-visitante-passar-em-seu-site-melhor/
categories:
  - Acessibilidade
  - UX
tags:
  - Conteúdo
  - google analytics
  - usabilidade
  - ux

---
Você deve estar pensando: &#8220;Mas este cara é louco! Quanto mais tempo o visitante passar em meu site, melhor!&#8221;. E que tal detalharmos o título em: &#8220;_Quanto menos tempo o visitante passar em seu site **consumindo um determinado conteúdo**, melhor._&#8220;? Ainda não? Deixe-me explicar.

**Tempo**, um dos substantivos mais valiosos em nossas vidas, se não o mais. Na Internet não poderia ser diferente. Vivemos em constante correria, e na agitação do dia-a-dia, o tempo tem sido um fator determinante no planejamento da usabilidade (UX) de um projeto web.

Existe um motivo, uma necessidade, para que o visitante chegue até o seu site, e a maneira com que você supre esta necessidade é a variável que define a qualidade de seu conteúdo.

Sabendo da importância do tempo na vida de qualquer pessoa, podemos dizer que **quanto menos tempo o visitante passar em seu site até que sua necessidade seja preenchida**, melhor.

## Mas como saber e fornecer o que meu visitante precisa?

O primeiro e mais importante fator, é saber o que seu visitante busca. Para fornecer o que o usuário quer, é necessário conhecer sua necessidade. Parece óbvio, mas na prática, muitos acabam deixando isso de lado.

Uma ferramenta poderosa ao seu lado para realizar tal análise é o **<a href="https://www.google.com/analytics/" target="_blank">Google Analytics</a>**. Já conhecido por muitos, ele é capaz de mostrar como os usuários chegam até o seu site e qual conteúdo acessam mais. Com estes dados, e sabendo o que seu projeto é capaz de fornecer de melhor àquela pessoa, você pode focar seu tempo (que é tão precioso quanto o do visitante) na criação de um conteúdo que atenda as expectativas de quem chega até você. Confira aqui um post que ensina melhor <a href="https://tableless.com.br/monitoramento-de-eventos-com-google-analytics/" target="_blank">como monitorar eventos com o Google Analytics</a>.

[<img class=" size-full wp-image-39272 aligncenter" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/10/google-analytics_products_sm_01.jpg" alt="Google Analytics" width="474" height="164" srcset="uploads/2013/10/google-analytics_products_sm_01.jpg 474w, uploads/2013/10/google-analytics_products_sm_01-329x113.jpg 329w" sizes="(max-width: 474px) 100vw, 474px" />][1]

Além da &#8220;mãozinha&#8221; que o Google lhe oferece, que tal desenvolver sua própria ferramenta de análise? Saber quais os termos mais buscados em seu site e quais páginas são mais acessadas, à sua maneira, parece uma boa ideia?

## Já sei o que meu usuário quer! Como satisfazer suas expectativas?

Se você já sabe tudo o que seu visitante busca em seu site, você tem a faca e o queijo na mão para converter a necessidade do usuário em satisfação. Seguindo algumas dicas, você é capaz de gerar um resultado que agrade e supere o que ele (e você também) espera.

### Foco no que faz de melhor

Você sabe a meta de seus usuários e sabe, dentre elas, quais você tem a capacidade de gerar conteúdo e soluções com melhor qualidade. Foque-se em atender de maneira exemplar aquilo que fornece de melhor. Prefira gerar excelentes conteúdos e soluções relacionadas a um ou dois assuntos do que cinco &#8220;meia-bocas&#8221;. Acredite, o retorno será mais positivo.

### Não tenha medo de dizer: &#8220;eu não posso lhe ajudar&#8221;

Você precisa ser objetivo e sincero com seu usuário. Antes de fornecer o conteúdo, deixe claro se você pode ajudá-lo com aquilo que busca. Se você tem um blog, coloque no começo de seus artigos o que será apresentado, ensinado, discutido, para que ele saiba logo de início se aquele conteúdo supre sua necessidade de conhecimento. Poupe seu tempo e evite frustrações.

### Facilite a navegação

Existem poucas coisas piores para um visitante do que não conseguir navegar facilmente pelo conteúdo. Mantenha uma navegação clara, simplificada, e garanta que seus usuários saberão como utilizar seu site.

### Saiba se ele está feliz

Outro recurso, bastante ignorado por sinal, que pode lhe trazer um ótimo retorno, é o _**feedback**_. Você precisa saber se aquele conteúdo foi útil e atendeu da melhor maneira possível o que aquele visitante buscava. Faça testes, pesquise, PERGUNTE! Não tenha medo de querer saber se o usuário está satisfeito com a solução que lhe propôs. Estimule comentários.

### Personalize de acordo com a necessidade

Você sabe como o usuário acessa seu site, de onde veio, e o porquê de ter chegado até lá. Personalize-o de acordo com essas informações para fornecer a seu visitante SEMPRE aquilo que ele precisa. Siga isso e torne seu visitante um usuário fidelizado.

## Conclusão

Tempo&#8230; tempo&#8230; tempo. Tenha sempre essa palavra em mente quando estiver planejando sua interface e seu conteúdo. &#8220;O melhor site do mundo&#8221; é aquele que fornece a solução ideal no menor tempo possível. Por isso o título desse artigo.

É interessante que o usuário passe bastante tempo em seu site? Sim, mas desde que o retorno que ele obtenha através do conteúdo consumido seja justamente proporcional a esse tempo. Foco em fornecer soluções no menor tempo possível e, em paradoxo, você terá um usuário fiel por muito tempo.

 [1]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/10/google-analytics_products_sm_01.jpg