---
title: Quando o Scrum irá falhar
authors: marcoaacoliveira
type: post
date: 2016-05-07
url: /quando-o-scrum-ira-falhar/
categories:
  - Mercado
tags:
  - agile
  - desenvolvimento agil
  - scrum

---
Nesse artigo vamos abordar um pouco os pontos críticos do Scrum, a intenção aqui não é explicar o framework (o Scrum é considerado um framework para gestão de projetos) em si, mas dar um panorama dos casos mais comuns de falhas críticas ao se tentar adotar o Scrum ou modificá-lo. Caso esteja procurando um artigo para entender melhor o que é o Scrum, recomendo esse [aqui][1], escrito pela Dani authors: Dani Guerrato
paid: true. Ou ainda, caso queira mergulhar de cabeça recomendo a leitura do [Scrum Guide][2] (em português).

Introdução feita, vamos ao que realmente interessa aqui: O Scrum não é uma bala de prata (a essa altura você já deve saber que nenhuma metodologia ágil é). Se você, assim como eu, já foi (ou é) responsável por trazê-lo para sua empresa, esteja atento ao seu ambiente e aprenda com a implementação do Scrum. Citarei aqui e explicarei sobre cada um dos pontos críticos do Scrum:

## Quando a comunicação não é suficiente

Esse talvez seja o mais óbvio ponto crítico do Scrum. Em qualquer projeto, a comunicação se faz necessária, mas diferente de outras metodologias de gerenciamento de projeto, o Scrum delega a responsabilidade do gerenciamento à própria equipe de desenvolvimento e daí a comunicação se torna ainda mais crítica. Como uma equipe pode chegar a um consenso e se autogerenciar se não há uma boa (ou nenhuma) comunicação? Sem comunicação, não há gerenciamento.

Portanto Scrum Master (ou não), fique atento a esse ponto, ao perceber pequenos atritos não resolvidos, desgaste ou qualquer sinal de que a comunicação do time de desenvolvimento, Product Owner ou até mesmo a sua, não esta indo bem. Trabalhe em cima disso.

Existe um artefato que tem como objetivo garantir uma comunicação mais fluída e um gerenciamento mais democrático e dinâmico: Planning Poker. Nele todos os membros da equipe de desenvolvimento jogam cartas para determinar o peso de cada estória de usuário. Ao jogarem cartas distintas para uma mesma User Story, é discutido (geralmente entre os jogadores que colocaram os dois pontos mais distantes) o motivo deles avaliarem aquela estória daquela forma; e Mike Cohn defende que você considere uma estória como avaliada somente quando todos do time chegarem a um consenso quanto ao peso daquela estória. Isso garante o diálogo, além de melhorar o comprometimento e a motivação.

&nbsp;

## Quando a motivação acaba

Como garantir algo tão subjetivo durante todo o projeto? Esse é um problema grave não só no Scrum, mas em qualquer outra metodologia ágil. E a resposta é como esperado: você não garante!

Então nada pode ser feito para que sua equipe se motive? Não, o fato de que motivação é algo subjetivo, não quer dizer que você não possa prover as ferramentas ou o ambiente necessário para sua equipe continuar seguindo motivada.

Vou considerar aqui que os colaboradores com quem você convive já são pessoas motivadas por natureza, que é o que se espera num ambiente ágil, e que é necessário apenas manter a motivação. Então vou citar aqui os principais motivos que levam um colaborador a se desmotivar durante o projeto:

<li style="font-weight: 400">
  Stakeholders não comprometidos, mas envolvidos apenas com cobranças desalinhadas. Sabe aquele cliente que nunca comparece aos eventos Scrum e um belo dia resolve ficar a par do projeto? Esse cliente geralmente vai acabar com sua Sprint, vai destruir a blindagem do seu time de desenvolvimento e deixará seu Product Owner (caso não seja ele mesmo) louco. Tenha um cuidado especial com o efeito negativo desse stakeholder na motivação do seu time.
</li>
<li style="font-weight: 400">
  Projetos longos que não se renovam. Não me entenda mal. As metodologias ágeis existem com o lema de que mudanças são sempre bem vindas, mas se um projeto se alonga por tempo demasiado você irá perceber um certo desânimo na sua equipe. Principalmente se são mudanças que exigem uma série de atividades desgastantes e que acabam levando o projeto a situações do passado (desfazer estórias de usuário é uma das mais críticas).
</li>
<li style="font-weight: 400">
  Equipe muito pouco reconhecida por projetos. Nada pior que uma entrega ou finalização de projeto com sucesso, onde o time scrum (PO, SM e equipe de desenvolvimento) não é nem sequer reconhecido pelo seu bom trabalho. É válido destacar aqui que o desenvolvimento ágil tem como objetivo entregar produtos com muito mais valor ao cliente, contudo é mais desgastante para os comprometidos com o projeto. Por isso eu recomendo a qualquer gestor que ao término de cada projeto crie sua maneira de bonificar (isso varia de acordo a sua cultura organizacional) a equipe. Lembre-se sempre de que coisas simples como uma pizza, um happy hour ou qualquer outro tipo de confraternização é suficiente para levantar o moral e deixar sua equipe pronta para o próximo projeto.
</li>

&nbsp;

## Quando os pontos negativos individuais interferem no trabalho em equipe

Como saber se sua equipe trabalha bem em time? Em alguns casos temos uma equipe madura o suficiente para termos um trabalho em equipe direto e enxuto. Mas quando isso não acontece? Quando um membro do time insiste em ser prolixo nas reuniões? Ou quando questões pequenas consomem mais tempo de discussão do que realmente importa? Quem é o responsável por fazer essas coisas funcionarem?

Bem, considerando que temos um líder-servo como papel do Scrum (Scrum Master), cai sobre ele a responsabilidade com toda sua habilidade para servir e liderar ao mesmo tempo lidar com essa situação.

Uma boa abordagem é fazer mentorias (aconselhamentos ou tutorias) individuais em pequenas reuniões (bate-papos). Faça com que todo o processo seja o menos assustador possível para aquele que deve ter pontos negativos trabalhados, lembre-se que motivação é uma das chaves do desenvolvimento ágil e você não quer perder um membro motivado em pleno desenvolvimento do projeto, certo? Portanto, o recomendável é fazer da forma mais sutil possível: entenda os motivos que levam o membro a agir daquela forma e através de sugestões e conselhos mostre como ele pode ser mais produtivo para o time como um todo. Lembre-se, o Scrum Master deve ter um excelente conhecimento de sua equipe, logo, essas pequenas mentorias e bate-papos devem ser feitos constantemente.

&nbsp;

## Quando o PO não encontra o cliente

Essa é a maior falha em todo projeto, seja em uma metodologia ágil ou clássica.

Nesse cenário seu time entrega o que promete com excelência, as cerimonias são cumpridas com precisão, o seu burndown encontra-se impecável.

Mas nada do que é entregue é realmente um agregador de valor ao cliente final e provavelmente isso se dará quando o seu Product Owner estiver falando com o Stakeholder errado!

Pegando um exemplo simples e claro: Imagine que sua empresa está desenvolvendo um sistema de ponto para uma fábrica, o dono da empresa é seu principal Stakeholder e o Product Owner mantém constante contato com ele. Porém a cada finalização de Sprint você nota que muito trabalho teve que voltar ao backlog ou teve que ser reescrito em outras estórias de usuário. O exemplo ilustra um sinal claro, que um PO atento logo se alarmara, de que é hora de trazer um novo Stakeholder à frente do projeto e ouvi-lo falar sobre qual será o produto ideal para ele.

É muito comum, porém, que nem sempre o seu cliente final seja alguém próximo. Ou até mesmo que seu Stakeholder nem sequer o conheça! Aqui entram algumas técnicas do desenvolvimento Lean que eu acho bastante interessantes e que pode ser muito útil para sua empresa e seu trabalho receberem recomendações futuras por salvar a vida de um Stakeholder perdido.

Se você já vem trabalhando com Scrum, para entender o Lean é apenas mais alguns passos adiante, por tanto irei abordar aqui rapidamente, mas caso tenha interesse deixarei esse [link][3] para maior aprofundamento. O Lean basicamente propõe que você desenvolva um MVP (Minimo Produto Viável, em português), para entrar num ciclo de Construir, Medir e Aprender. Isso tudo feito em pequenas iterações onde cada ciclo completo você tem uma nova iteração 100% funcional (até agora bem familiar, correto?).

O ponto principal para você que acabou tendo que conhecer o cliente final do seu cliente, sem mesmo que ele o conheça, é que a cada etapa de Medir e Aprender você deve focar em conhecer mais sobre o usuário final: Teste A/B, Personas, teste presenciais de um possível usuário final, heatmap e muitas outras são técnicas e ferramentas válidas para esse momento. Se você não conhece nenhum dos nomes citados anteriormente, convido-o para que faça uma pausa e dê uma lida, ou ao menos separe alguns materiais para uma lida no futuro.

## Quando o time não é seu próprio gerente

E quando o projeto inteiro é negociado sem conhecimento algum do time de desenvolvimento? E ao avaliar as estórias de usuários se dão conta de que o projeto iria demorar cerca de 6 meses, mas que a negociação e o contrato foram fechados para um prazo de 2 meses? Aqui está claro o problema: o time de desenvolvimento não é seu próprio gerente, suas cerimônias e artefatos estão perdidos! (Meio dramático, eu sei)

Mas isso serve para reforçar que esse é um dos momentos mais frustrantes para a equipe de desenvolvimento, pois não será refeita a negociação e sim serão apertados os prazos e as estimativas serão direcionadas por fatores externos.

Se você está percebendo um grande problema aqui, você provavelmente já pegou bem a ideia do Scrum… O time de desenvolvimento não mais se encontra blindado e será constantemente influenciado por fatores externos, tais como: cliente, diretores, gerentes ou qualquer nível hierárquico que sua empresa possa possuir. Isso é grave… Isso é muito grave!

Se você pode evitar essa situação faça!

Caso contrário futuramente será totalmente irremediável durante a execução do projeto e provavelmente fará com que seu time constantemente acabe passando algumas etapas da iteração por cima de outras, levando à um projeto concluído com baixa qualidade e que possivelmente gerará dores de cabeça para seu cliente e por consequência para você em um futuro muito próximo.

Obrigado por ler até aqui, espero ter apresentado pontos a serem analisados por você e evitados! Caso tenha mais algum ponto crítico que acha interessante que seja adicionado a esse artigo, elogio ou crítica deixe um comentário 😀

 [1]: https://tableless.com.br/desenvolvimento-agil-utilizando-scrum/
 [2]: https://www.scrumguides.org/docs/scrumguide/v1/Scrum-Guide-Portuguese-BR.pdf
 [3]: https://theleanstartup.com/