---
title: 'Qualidade em Uso: expandindo a Usabilidade'
authors: Talita Pagani
type: post
date: 2011-08-29
excerpt: A Qualidade em Uso visa cobrir não apenas a facilidade de uso, mas também as funcionalidades e o suporte apropriado às atividades de uso em cenário real. É considerado não somente a visão do usuário, mas do contexto de uso em ambiente de trabalho.
categories:
  - design
tags:
  - usabilidade
  - ux
  - experiência do usuário
  - melhores práticas
  - qualidade
  - qualidade em uso
---
A usabilidade, ainda é vista como um “diferencial” ou “vantagem estratégica” dentro das organizações durante o processo de desenvolvimento de websites. Sabemos que, na realidade, é um critério de qualidade que deve ser atendido pela aplicação, ainda que muitos percebam isto de forma implícita. Mas este conceito ainda não está maduro dentro das organizações. Diversas abordagens como a engenharia de usabilidade e o design de interação vêm sendo adotadas dentro dos processos de desenvolvimento para assegurar uma boa experiência de uso das aplicações. Porém, é necessário ampliar esta visão da experiência do usuário, considerando outros fatores além daqueles relacionados ao design.

## Qualidade em Uso

Qualidade em Uso é um termo cunhado em meados da década de 90 por [Nigel Bevan][1] e incorporada à norma [ISO/IEC 9126][2], originalmente se referindo à qualidade de software. Ela estende a caracterização da qualidade e ergonomia de software contida em determinadas normas ISO, englobando o contexto do ambiente de trabalho para caracterizar a satisfação de uso, focando não apenas no usuário, mas em seu comportamento ao interagir com um sistema computacional. A qualidade interna (propriedades do código) e a qualidade externa (comportamento do software durante a execução) influenciam a qualidade em uso e estão contidas na mesma. Dessa forma, temos a percepção da qualidade verificada através do uso.

<div id="attachment_4019" style="width: 586px" class="wp-caption aligncenter">
  <a href="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2011/07/Slide3.png"><img class="size-full wp-image-4019  " src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2011/07/Slide3.png" alt="Escopos da Qualidade em Uso - adaptado de Bevan (1999)" width="576" height="370" srcset="uploads/2011/07/Slide3.png 960w, uploads/2011/07/Slide3-300x192.png 300w" sizes="(max-width: 576px) 100vw, 576px" /></a>
  
  <p class="wp-caption-text">
    Escopos da Qualidade em Uso - adaptado de Bevan (1999)
  </p>
</div>

<div id="attachment_4018" style="width: 586px" class="wp-caption aligncenter">
  <a href="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2011/07/Slide4.png"><img class="size-full wp-image-4018 " src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2011/07/Slide4.png" alt="Fatores interligados da Qualidade em Uso" width="576" height="222" srcset="uploads/2011/07/Slide4.png 960w, uploads/2011/07/Slide4-300x115.png 300w" sizes="(max-width: 576px) 100vw, 576px" /></a>
  
  <p class="wp-caption-text">
    Fatores interligados da Qualidade em Uso - adaptado de Bevan (1999)
  </p>
</div>

## Objetivos da Qualidade em Uso

A Qualidade em Uso tem como principal objetivo a avaliação de como as características do software atendem às necessidades dos usuários. Esta qualidade é analisada sob quatro características:

  * **Eficiência:** capacidade do produto de software de permitir ao usuário atingir metas específicas como completude, em um contexto de uso específico;
  * **Produtividade:** capacidade do produto de software de permitir que seus usuários empreguem quantidade adequada de recursos em relação à efetividade alcançada em um contexto de uso específico;
  * **Segurança:** capacidade do produto de software de apresentar níveis aceitáveis de riscos de danos a pessoas, negócios, software, propriedade ou ambiente em um contexto de uso específico;
  * **Satisfação:** capacidade do produto de software de satisfazer usuários em um contexto de uso específico.

## Expandindo a usabilidade

A abordagem da Qualidade em Uso visa cobrir não apenas a facilidade de uso, mas assegurar funcionalidades e suporte apropriado para atividades de uso em cenário real. É considerado não somente a visão do usuário, mas do contexto de uso em ambiente de trabalho.

Enquanto a usabilidade está, geralmente, associada com a melhoria da interface com o usuário, o objetivo maior da qualidade em uso está relacionado também com os requisitos de negócio. Com isso, há um aumento de eficiência e de produtividade, pois a interface deve ser ajustada às tarefas mais comuns, permitindo ao usuário operar o software de modo mais eficiente e efetivo, se concentrando apenas nas tarefas que deve realizar e não na decodificação da interface. Além disso, um processo adequado para implementação e verificação da qualidade em uso pode reduzir erros, treinamentos e aumentar a aceitação do software. Embora também seja objetivo da usabilidade reduzir a carga de trabalho do usuário ao interagir com a interface, ela tem um escopo limitado à interação usuário-sistema sem considerar fatores internos e externos do software e fatores ambientais. Além disso, a usabilidade é intrinsecamente ligada às necessidades do usuário final, enquanto a Qualidade em Uso visa instanciar na aplicação desenvolvida a visão de diferentes tipos de usuários que poderão operar o sistema.

Um software, seja uma aplicação desktop, web ou mobile oferece uma boa experiência de uso quando é eficiente, eficaz, adequado aos requisitos, agregando valor às tarefas que o usuário precisa executar e proporcionando satisfação.

## Resumindo

<table border="1" cellspacing="0" cellpadding="0">
  <tr>
    <td valign="top" width="288">
      <strong>Usabilidade</strong>
    </td>
    
    <td valign="top" width="288">
      <strong>Qualidade em Uso</strong>
    </td>
  </tr>
  
  <tr>
    <td valign="top" width="288">
      Diretivas gerais
    </td>
    
    <td valign="top" width="288">
      Diretivas variáveis conforme o contexto
    </td>
  </tr>
  
  <tr>
    <td valign="top" width="288">
      Recomendações para o projeto diferenciadas pelo tipo de aplicação (web, mobile, etc)
    </td>
    
    <td valign="top" width="288">
      Recomendações para o projeto diferenciadas pelo tipo de aplicação e necessidades do projeto
    </td>
  </tr>
  
  <tr>
    <td valign="top" width="288">
      Centrada na interação entre usuário e sistema
    </td>
    
    <td valign="top" width="288">
      Centrada na interação entre usuário, sistema e cenário real de uso
    </td>
  </tr>
  
  <tr>
    <td valign="top" width="288">
      Foco na facilidade de uso
    </td>
    
    <td valign="top" width="288">
      Foco em todos os aspectos que asseguram a qualidade da experiência do usuário com o sistema
    </td>
  </tr>
  
  <tr>
    <td valign="top" width="288">
      Refere-se à apresentação e funcionalidades relativas à interface
    </td>
    
    <td valign="top" width="288">
      Refere-se às características da interface, desempenho do sistema e qualidade do código
    </td>
  </tr>
  
  <tr>
    <td valign="top" width="288">
      Responsabilidade maior dos designers e especialistas de usabilidade
    </td>
    
    <td valign="top" width="288">
      Responsabilidade de designers, programadores, gerente de projeto, especialistas de usabilidade, etc
    </td>
  </tr>
  
  <tr>
    <td valign="top" width="288">
      “Usuário” refere-se ao usuário final
    </td>
    
    <td valign="top" width="288">
      “Usuário” refere-se ao usuário final, pessoa que fará manutenção no sistema, cliente, etc
    </td>
  </tr>
</table>

_Com a colaboração de meus colegas de mestrado: Carlos Eduardo de Souza, Jônatas Leite, Kênia Rosa, Maíra Canal, Renata Firmino, Rodrigo Silvestre e Rogério Xavier._

### Referências e Leitura Complementar

BEVAN, N. **Quality in Use: Meeting User Needs for Quality**. In: Journal of System and Software, 1999.

BEVAN, N.; AZUMA, M. **Quality in Use: Incorporating Human Factors into the Software Engineering Lifecycle.** Proceedings of the 3rd International Software Engineering Standards Symposium (ISESS &#8217;97), p.169, June 01-06, 1997

 [1]: https://www.nigelbevan.com/
 [2]: https://en.wikipedia.org/wiki/ISO/IEC_9126