---
title: Programadores podem se tornar bons escritores?
authors: Tiago Dória
paid: true
type: post
date: 2014-09-05
excerpt: Escrever código todos os dias pode ser comparado a escrever um livro?
url: /programadores-podem-se-tornar-bons-escritores/
categories:
  - Destaques
  - Mercado
  - Tecnologia e Tendências
tags:
  - Tecnologia e Tendências
---

Num mundo em que quase tudo é intermediado por tecnologia, escrever códigos é uma das habilidades mais interessantes e necessárias. É uma atividade que se tornou criativa e lúdica (vide as crianças que se divertem nas [aulas de programação][1]).

Na área de comunicação, por exemplo, escrever códigos se tornou extremamente importante. Não é à toa, as velhas habilidades do campo da comunicação já não conseguem mais responder aos atuais problemas de gestão e consumo de informação. É necessário pensar em algoritmos e dominar a lógica computacional. Enfim, é preciso dominar novas habilidades para resolver novos problemas.

Hoje aprender a programar é fácil e barato. Existem diversos cursos e a [comunidade de desenvolvedores][2] está mais robusta. Ademais, atualmente, há linguagens simples de aprender, com uma semântica mais próxima da utilizada no dia a dia.

Com essa facilidade no acesso ao ensino de programação, surge a questão a respeito da semelhança entre aprender a escrever códigos e aprender um novo idioma (inglês, espanhol, alemão).

Ou melhor, qual a semelhança entre as <a href="https://pt.wikipedia.org/wiki/L%C3%ADngua_natural" target="_blank">linguagens naturais</a> e as <a href="https://pt.wikipedia.org/wiki/Lingu%C3%ADstica_computacional" target="_blank">de programação</a>? Desenvolver um software e escrever um livro são coisas parecidas? Afinal de contas, ambas não são atividades de escrita que trabalham com códigos, tendo como objetivo final a comunicação? Por serem acostumados a lidar com semântica, “regras gramaticais” e concisão, programadores poderiam se tornar bons escritores?

A discussão é interessante: aplicações hoje são desenvolvidas não apenas para transmitir ideias, mas também para comunicar emoções. Além disso, programadores têm hoje uma vasta influência no campo da comunicação. Vide o que acontece quando o Google ou o Facebook realizam uma modificação em seus algoritmos de conteúdo ou de exibição de publicidade.

A relação entre linguagens naturais, programação e comunicação me interessa bastante até porque estou sentindo esse debate na pele aqui, em Boston.

Como muitos sabem, meu DNA é na área de comunicação (escrita). Na prática, percebo que tais campos, na realidade, têm muitos aspectos em comum. Há diferenças, claro. Escritores (comunicadores) trabalham com metáforas, algo que programadores não dominam. Entretanto, as semelhanças são muito maiores que as diferenças:

**1)** Em suas atividades, bons escritores/comunicadores e programadores não podem ser redundantes. Precisam ter clareza.
  
**2)** Assim como escritores, programadores têm diferentes estilos.
  
**3)** Bons programadores sabem “brincar” com as regras, assim como escritores famosos como Balzac e James Joyce.
  
**4)** Escritores escrevem para pessoas. Da mesma forma, programadores escrevem códigos para computadores e pessoas (seus colegas também programadores).
  
**5)** Ambos são processos criativos que trabalham com um estrutura definida e têm o objetivo de comunicar.

É emblemático que o processo de aprender programação é muito parecido com o de estudar um novo idioma. Quando você aprende um novo idioma, tenta codificar seu modo de pensar para essa nova linguagem (inglês, espanhol, alemão). Da mesma forma, quando você aprende programação, tenta aplicar e codificar o seu modo de pensar logicamente em uma linguagem de software.

A propósito, existe um princípio no desenvolvimento de código chamado [DRY][3] (Don&#8217;t Repeat Yourself), que é muito similar à atividade de editar um texto na área de comunicação. Esse processo é apoiado na elegância e na não-repetição de código.

Aliás, essa é uma das minhas partes preferidas no processo de escrever códigos. Adoro debugar códigos e aplicar o conceito de DRY, talvez porque em grande parte da minha vida tenha feito exatamente isso, mas no campo da comunicação com <a href="https://pt.wikipedia.org/wiki/L%C3%ADngua_natural" target="_blank">linguagens naturais</a>.

Mas onde vamos chegar com todo esse debate sobre linguagens naturais, programação e comunicação? Bom, vou compartilhar com vocês o que tenho visto por aqui, em Boston. As barreiras entre todas as áreas do conhecimento vêm desmoronando numa rapidez tremenda. Não será nenhuma surpresa se daqui a algum tempo projetos que veem a programação como um processo criativo busquem programadores em faculdades de letras e de comunicação.

Por outro lado, há um movimento já consolidado de programadores entrarem na área de comunicação e mídia. Os blogs já foram o pontapé inicial dessa quebra de barreiras. Hoje as melhores publicações de tecnologia são escritas por atuais ou ex-desenvolvedores.

É muito positivo que programadores se encarem como comunicadores e escritores. Geralmente, programadores que se veem assim se tornam competentes profissionais, tendo como princípio a concisão, a clareza e a elegância em seu trabalho. No final das contas, quem lucra com toda essa postura é o usuário final, que ganha acesso a melhores serviços baseados em software para resolver, sem demora ou frustrações, os seus problemas.

_PS &#8211; Quem quiser se aprofundar mais no assunto vale acompanhar o trabalho do cientista da computação <a href="https://www-cs-faculty.stanford.edu/~uno/" target="_blank">Donald Knuth</a>, que há décadas pesquisa a relação entre literatura, estética e programação._

 [1]: https://www.youtube.com/watch?v=Ok6LbV6bqaE
 [2]: https://github.com
 [3]: https://tableless.com.br/?s=DRY