---
title: Projeto, Produtos Digitais e Continuidade
authors: Diego Eis
type: post
date: 2019-02-06
publishdate: 2019-02-06
excerpt: Em uma palavra, o que diferencia Projetos de Produtos Digitais? Continuidade.
image: https://i.imgur.com/2n5Qx8t.jpg
categories:
  - Gestão
  - Produtos Digitais
tags:
  - Product Management
---

Eu já me fiz muitas vezes a pergunta sobre qual a diferença entre gestão de Projetos e gestão de Produtos Digitais. Acho que não existe uma resposta completa o suficiente e talvez cada um, de acordo com sua experiência, tem uma resposta diferente. Nesse artigo, segue a minha versão da resposta, breve e simplista. 

# Escopo, budget e deadline 

Tradicionalmente o projeto tem um plano, que precisa ser executado num tempo determinado e que vai cumprir com um determinado KPI definido pela companhia. 

De acordo com o PMI: 

> A project is **temporary** in that it has a defined beginning and end in time, > > and therefore defined scope and resources. — [https://www.pmi.org/about/learn-about-pmi/what-is-project-management](https://www.pmi.org/about/learn-about-pmi/what-is-project-management) 

Quando temos um projeto para construir um edifício, muito obviamente esse projeto tem um começo, meio e um fim. Para executar esse começo, meio e fim, temos um budget definido, com uma quantidade de recursos limitada, definição dos materiais usados, ferramentas e tudo o mais. 

Mas vamos encurtar a história: **se você é um gestor de projeto, seu único objetivo é gerenciar a entrega para que ela seja feita a tempo e dentro do budget.** De certa forma, você não precisa se preocupar se o projeto vai de fato resolver o problema pelo qual ele está sendo feito, porque no início do projeto, alguém ou um grupo de pessoas, já elencou todos os objetivos que seriam cumpridos e decidiu que o projeto, feito nesse determinado escopo, alcançaria esses objetivos. Logo, o gestor deveria apenas seguir o plano e entregar na data e dentro budget. 

Muitas vezes o **pós projeto** não é pensado num mundo guiado a escopo, budget e deadline. E é por isso que um produto digital — sem levar em consideração que é melhor pensar em construir serviços e não produtos — não é guiado por um escopo fechado/aberto, budget ou deadline, porque geralmente produtos digitais são guiados pelas regras da **continuidade**. 

# O fator continuidade 

Se escopo, budget e deadline são usados como requisitos para restringir um projeto que tem data de término, como se restringe algo que tecnicamente não termina nunca? Na verdade, não se restringe. Em produtos/serviços digitais as regras são diferentes e por isso o pensamento fixo não funciona nunca. 

As regras de gestão de projeto NUNCA devem ser aplicadas na sua totalidade em um ambiente de desenvolvimento de serviços digitais. Por causa do fator de continuidade dos serviços digitais, a gestão é forçada a ser mais maleável, levando mais em consideração o pensamento evolutivo e adaptável, do que um pensamento de mudanças bruscas. 

Existem alguns pontos de atenção que mudam drasticamente a forma com que gerimos um produto/serviço contínuo em vez de um projeto com começo, meio e fim. Abaixo, segue o que eu julgo ser os pilares que marcam as diferenças entre os dois mundos: 

* Começamos a ter um pensamento mais amplo voltado à **serviço** digital em vez de **produto** digital; * Criar um **produto/serviço baseado no pensamento de plataforma**; * Usar o **efeito de rede para amplificar o valor** do produto/serviço; * Decisões guiadas por **dados e métricas de engajamento e retenção do usuário**; * **Foco para entrega de valor** e não deadline ou quantidade de tasks; 

Todos esses (e outros) pontos só existem se houver um senso de continuidade do produto e eles modificam drasticamente a forma com que montamos o time, lidamos com as pessoas, gerenciamos expectativas, calculamos performance, entendemos crescimento do produto/serviço, medimos qualidade e satisfação do usuário. 

Em um Produto/Serviço digital, o fator de continuidade muda a forma com que lidamos com os resultados, com o planejamento e principalmente com a organização do time. 

Obviamente existem similaridades: por exemplo, em projeto nós temos um roadmap de entregas baseado em deadline. Já em serviços digitais usamos um roadmap baseado em entregas de valor para o usuário e para o produto. Enquanto a sequencia em um roadmap de projeto é feito para chegarmos ao final sem grandes problemas ou mudanças no plano, o roadmap de um serviço/produto digital é planejado levando em consideração a entrega de valor e cumprimento de metas. Entendeu a diferença? Enquanto as entregas de um servem a completude do projeto, a do outro é o alcance de objetivos. 

# O mindset ágil também muda 

Enquanto no ambiente de projetos usamos metodologias e mindset ágil para aumentar e controlar a performance do time, num ambiente de serviços digitais, nós usamos o mindset ágil para potencializar e adiantar a entrega de valor para o usuário. 

Os times também tendem a ser cobrados de forma diferente, além de terem perspectivas diferentes: um time preza pela velocidade de entrega, o outro preza pelo impacto que as suas entregas trarão para o usuário. 

> Em um projeto é muito melhor organizar as tarefas para dar uma percepção aos > stakeholders de completude do projeto. Já em um serviço digital com mindset contínuo, as entregas devem ser organizadas de acordo com o seu impacto de valor no usuário. 

Obviamente que a velocidade de entrega é importante nos dois casos, mas em um ambiente de projeto, o time não precisa pensar no quão o usuário será impactado, por um simples motivo: apenas existirão usuários reais quando o projeto for entregue. O único usuário importante usando e vendo o projeto são os stakeholders e por isso, muitas vezes, a ordem das entregas do time é organizada para dar um senso de completude do projeto e não impacto de valor. 

# Conclusão 

Presencio todos os dias gestores tentando aplicar as regras de projeto em desenvolvimento de serviços digitais. Obviamente eles fracassam miseravelmente. Em vez de tentarem mudar o mindset, eles culpam a complexidade de gerir grandes projetos e também o time, por errarem estimativas e por não serem performáticos o bastante. Mas mal conseguem perceber que o problema é que eles estão jogando um jogo com as regras trocadas. 

Na minha experiência, quase nunca precisamos fazer grandes projetos para resolver problemas específicos. Pelo contrário: devemos ser guiados por indicadores que queremos melhorar. O que eu devo fazer para melhorar a conversão? Quais tarefas eu devo executar para aumentar o tempo de permanência no e-commerce? Quais features eu devo fazer para aumentar o engajamento e a retenção do usuário? 

Não há como ter garantia nenhuma de que um grande projeto, que será entregue de uma vez, irá melhorar esses problemas de uma hora para outra. Por isso, sempre tenha em mente pequenas entregas de valor, monitoramento das mudanças de comportamento do usuário e ponteiros de negócios. Esses pontos são essenciais para o desenvolvimento saudável de Produtos Digitais.