---
title: PMs decidem negócio?
authors: Diego Eis
type: post
image: https://diegoeis.com/images/uploads/post-pm-nao-decide-negocio/sean-pollock-PhYq704ffdA-unsplash.jpg
date: 2020-09-07
excerpt: A responsabilidade de uma PM é o direcionamento do produto, não do negócio
categories:
  - Digital Product
tags:
  - Product Management
---

Eu não sei de onde tiraram essa história de que Product Managers decidem direções de negócio. E sim, essa é uma afirmação polêmica e apenas retrata minha opinião (que pode mudar a qualquer momento, mesmo achando isso difícil).

Gestoras de Produto decidem a direção do produto, mas não do negócio. Product Managers são responsáveis por garantir a viabilidade do produto e a entrega de valor. Sobre o negócio, PMs no máximo ajudam com dados e argumentos que ajudarão os verdadeiros responsáveis pela decisão analisarem as opções e gerações de cenários para então bater o martelo.  

> Let’s start with the role of the product manager. In an empowered product team, where the product manager needs to ensure value and viability, deep knowledge of the customer, the data, the industry and especially your business (sales, marketing, finance, support, legal, etc.) is absolutely non-negotiable and essential. — Marty Cagan, o papa dos produtos  

Esse quote do Cagan pode estar sendo mal interpretado por mim, mas “ensure value and viability” me da o entendimento de que PMs são responsáveis por **garantir** que:

1. o valor em questão seja coerente e sendo facilitado por meio do produto, de forma que tanto o usuário quanto o negócio estejam se beneficiando;
2. e que é viável de ser entregue pela empresa, levando em consideração visão do produto, do negócio, expectativas dos stakeholders, momento do produto e mercado. 

Não há maneira de construir um produto e influenciar o serviço oferecido se não soubermos como o negócio funciona ou como o mercado se comporta. Mas isso não quer dizer que PMs decidem a direção do negócio. Algumas empresas até podem dar alguma oportunidade e seria muito legal isso acontecer. Mas decisões de negócio ou decisões que envolvem o que e como a [empresa pode vender mais](https://www.oberlo.com.br/blog/como-vender-mais) são feitas pelo presidente da empresa, C-Levels, investidores, board administrativo, diretoria etc etc etc. Depois que essas decisões são tomadas, aí sim o PM e a área de produto, tendo o alinhamento necessário, decidem com o produto será direcionado e construído.

## Visão deturpada do mercado

Acho que há uma visão muito deturpada sobre responsabilidades e papéis de gestores de Produto. Isso é perigoso porque pessoas podem deixar suas carreiras pra tentar migrar de área, tendo uma expectativa de algo que não existe.

Esse desenho de um cenário utópico serve apenas para perseguirmos melhoria e evolução contínua. Mas você não deve definir suas prioridades e expectativas se baseando nas utopias que outros insistem em glamorizar.

Outro motivo pelo qual os PMs não podem decidir negócio ou ainda mais: decidir exatamente como será feito e executado no produto, é por que isso tira o poder de autonomia do time, diminui a criatividade e não cria um ambiente de colaboração. O PM deve auxiliar o time, por meio das suas priorizações e decisões de direção de produto. E isso, por si só, leva tempo.


## Ilustrando as responsabilidades
Existe uma pirâmide interessantíssima criada pelo [Curtis Stanier](https://twitter.com/crstanier), que mostra a relação das iniciativas, riscos e envolvimento da liderança sênior. Segue abaixo:

![](https://diegoeis.com/images/uploads/post-pm-nao-decide-negocio/iniciativas-vs-riscos-vs-quantidade.png)

Outro dia, publiquei no Linkedin uma imagem que mostra um pouco a relação de impacto e autonomia com as responsabilidades:

![](https://diegoeis.com/images/uploads/post-pm-nao-decide-negocio/progressao-pm.png)

O ponto não é quem **manda** em cada parte, mas onde cada responsabilidade tem mais impacto e liberdade de atuação. 

Eu usei a imagem seguinte para correlacionar, devo dizer que de forma muito simplista, a responsabilidade de PMs com o cargo e nível tático/estratégico em empresas. Obviamente toda essa correlação pode mudar e se transformar dependendo da empresa e também do nível de autonomia que as empresas dão para PMs.

![](https://diegoeis.com/images/uploads/post-pm-nao-decide-negocio/Group%202%20Copy.png)

## A PM como representante de todas as áreas

Mas todo esse rap não quer dizer que o PM não tenha um papel importante na organização, pelo contrário, embora o PM não seja o decisor do negócio, ela deve ser uma grande contribuidora com informações e perspectivas de mercado e usuário. [Nesse capítulo do Product Guru’s](https://anchor.fm/product-gurus/episodes/39-Diego-Eis---Gesto-Moderna-de-Produtos-Digitais-eg0log), eu falo algo assim:
- Para o pessoal de negócio, o Product Manager representa o usuário e a área de tecnologia.
- Para o pessoal de tecnologia a PM representa o usuário e o negócio.
- Para o usuário a Product Manager representa a empresa.

O Product Manager tem que ser um diplomata, tem que ser uma pessoa que consegue conversar bem, influenciar bem as pessoas. É por isso que todo mundo coloca a comunicação como um pouco bem importante para ser uma Product Manager.

## Concluindo

Meu objetivo, em vários dos meus textos sobre produto, é tentar fazer com que treinemos um senso crítico. Não estou dizendo que em hipótese alguma PMs nunca terão ou não devem ter o poder de decisão de negócio. Eu acho que seria ótimo PMs terem uma visão profunda e estratégica de negócio que os permitissem ter um lugar na mesa do board, isso sem deixar de gerir o produto, porque se não, o PM se transformaria apenas uma pessoa de negócio “comum”.

Já vi empresas tentando a abordagem de transformar pessoas de Negócio em Gestores de Produtos. Mas há um conflito de interesse muito grande que ocasiona uma mudança constante de escopo, foco e prioridade. Não dá certo. Ou pelo menos não vi dar certo. Talvez o contrário: PMs se transformarem em pessoas de negócio seja possível. Ou não.
Você tem uma experiência pra contar? Qual sua opinião?

