---
title: Princípio de Paretto e o desenvolvimento de jogos indie
authors: Thiago Teles
type: post
date: 2016-07-01
url: /principio-de-paretto-e-o-desenvolvimento-de-jogos-indie/
categories:
  - Artigos
  - Na prática
tags:
  - desenvolvimento jogos
---
O _Princípio de Paretto_, também conhecido como _proporção 80/20_, foi criado pelo economista italiano Vilfredo Pareto em 1906. Paretto enunciou este princípio através do conhecimento empírico, após analisar a sociedade italiana, mas especificamente ele observou que 80% das terras pertenciam a 20% da população, restando para os outros 80% da população os 20% de terras restantes. Em suma, significava que 80% das riquezas daquela sociedade estavam concentradas nas &#8220;mãos&#8221; de 20% da população.

Através do tempo, esta forma de observar e analisar, foi sendo amplamente aplicada a outras áreas, como política, economia, gestão de projetos, dentre outras. Isso porque Paretto não formulou uma regra, e sim um princípio de proporcionalidade, e como tal pode ser adaptado para qualquer forma de aplicação.

Simplificando o _Princípio de Paretto_, podemos extrair em síntese que:

**80% dos resultados são originados de apenas 20% das ações.**

Sabendo disso, podemos afirmar que devemos dedicar a maior parte do tempo àquelas ações que mais geram resultados. Mas como sabermos quais são as ações que merecem uma maior atenção e dedicação? E como aplicar este princípio às nossas atividades? As respostas para estes questionamentos são simples:

  * Defina bem seus objetivos e estabeleça níveis de prioridades.
  * Defina metas e prazos para realizá-las.
  * Não perca tempo com ações secundárias.
  * Aprenda a dizer não às tarefas que não são de sua responsabilidade.
  * Jamais assuma todas as responsabilidades, aprenda a delegar tarefas.
  * Confie na capacidade dos outros membros de sua equipe.
  * Analise o seu dia, tente entender de qual maneira você produz melhor, e então desenvolva métodos eficazes de trabalho.

## Aplicando o Princípio de Paretto no desenvolvimento de jogos indie

### 80% do desenvolvimento do jogo é concluído em 20% do tempo

Isso quer dizer que a parte &#8220;bruta&#8221; de um jogo, pode ser realizada apenas com 20% do tempo de trabalho. Os outros 80% do tempo são gastos para o &#8220;polimento&#8221; do projeto.

Neste ponto, o ideal é definir bem:

  1. Qual o MVP (Minimun Viable Product), ou seja, qual a versão mais simples do seu jogo que poderá ser desenvolvida com uma quantidade mínima de tempo e esforço.
  2. Quais são os elementos prioritários dentro deste contexto. Defina-os bem e comece por eles.
  3. Defina bem cada etapa do processo de desenvolvimento. É importante entender que existem etapas que podem ser executadas concomitantemente. Nem todo o processo é linear. Com isso em mente, defina os responsáveis diretos de cada etapa e coloque-as para andar juntas.
  4. A cada etapa entregue, realize testes e corrija de imediato os possíveis bugs ou problemas.

Ao final destas etapas, você terá como resultado o seu jogo em versão MVP. O restante do tempo será utilizado para &#8220;polimento&#8221;, adições, DLC&#8217;s. Enfim, o mais importante é que você terá em mãos um jogo funcional e que já poderá ser lançado.

### 80% da diversão de um jogo vem apenas de 20% dos seus elementos

Os jogos normalmente possuem muitos elementos, porém se analisarmos bem, nem todos os elementos são preponderantes para garantir a diversão ou a imersão de todos os jogadores.

Aplicando o _Princípio de Paretto_ para entender a diversão e imersão de um jogo, podemos analisar que existem elementos chave, que são os responsáveis diretos. Sendo ainda que estes elementos responsáveis pela diversão do jogo, não serão os mesmo para todos os jogadores, pois isso muda de acordo com o arquétipo do jogador. Refletindo mais um pouco, e adicionando a questão dos arquétipos, dos traços de personalidades e dos aspectos psicográficos, conseguimos entender de fato, porque apenas uma média de 20% dos elementos de um jogo garantem uma média de 80% da diversão ou imersão.

Por este motivo um game possui, em sua grande maioria, muitos elementos distintos. Essa pluralidade tem por objetivo agradar os mais diversos tipos (ou arquétipos) de jogadores, tendo cada um seus desejos e expectativas próprios. Seguindo este pensamento, podemos afirmar que todos os elementos de um jogo são responsáveis pela diversão e imersão, porém, dependendo do tipo do jogador, apenas uma pequena parcela destes elementos é que serão responsáveis diretos para a diversão e imersão daquele jogador em específico.

## Conclusão

Não importa aonde apliquemos o _Princípio de Paretto_, o importante é entender que devemos focar nosso tempo, esforço e dedicação nas ações prioritárias, aprendermos a definir metas e cumpri-las. Dessa maneira conseguimos obter uma melhor produtividade, além de uma gestão de tempo mais eficaz e eficiente.