---
title: Primeiros passos rumo ao Full-Stack com JavaScript
authors: Cristofer Sousa
type: post
publishdate: 2018-01-22
date: 2018-01-18
excerpt: O que você acha de se tornar um Full-Stack Developer JS?
image: https://cdn-images-1.medium.com/max/2000/1*nSNrYZUwaC43rbF5JD1Zag.jpeg
categories:
  - Carreira
  - Mercado
tags:
  - javascript
---

Tem receio do JavaScript? Não entende muito bem como funcionam as coisas na linguagem?<br>
Você sabia que nessa linguagem de programação,[ existem objetos, closures e
principalmente padrões de
projeto](https://tableless.com.br/o-que-todo-dev-js-precisa-saber/)
como Java, Groovy, Python, Ruby, PHP e tantas outras?

Segundo, [Stoyan Stefanov](https://twitter.com/stoyanstefanov), em seu livro
Pattern JavaScript ele diz:

> Com o JavaScript você pode programar em uma variedade cada vez maior de
> plataformas. Você pode escrever código no lado do servidor (Node.js), aplicações

desktop (que funcionam em todos os sistemas operacionais) e extensões de
aplicação como ( Firefox ou Photoshop), aplicações para dispositivos móveis e
scripts de linha de comando. O JavaScript é uma linguagem incomum. Ela não
possui[classes](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Classes),
e funções são usadas como objetos de primeira classe em várias tarefas.
Curiosamente linguagens como Java e PHP começaram a adicionar funcionalidades
como closures e funções anônimas, que os desenvolvedores JavaScript vêm
utilizando corriqueiramente há algum tempo.

Com JavaScript devemos pensar fora da caixa, ele não é apenas uma linguagem para
manipular dentro da web, com ele você pode programar diretamente no [hardware
seja (arduino, raspberry e tantos outros)](https://braziljs.org/blog/interacao-com-hardware-usando-javascript/),
como programar seu próprio [drone](https://t.co/bMFGr4zs7B), as possibilidades
são [infinitas](https://www.sitepoint.com/javascript-beyond-web/).

Pois é, se você é um daqueles desenvolvedores que tinha um certo "receio" com o
JavaScript, acho que está na hora de rever seus conceitos sobre o
[(ECMAScript)](https://www.ecma-international.org/publications/files/ECMA-ST/Ecma-262.pdf),
atualmente na versão 6, aka ECMA2015.

Pois bem e para sermos um Full-Stack JavaScript Developer? Bom, o JavaScript que
a maioria conhece serve apenas para manipular
[DOM](https://developer.mozilla.org/pt-PT/docs/Gecko_DOM_Reference/Introduction)(Document
Object Model) ou validar campos de formulários, certo? Errado! Hoje podemos
fazer de tudo com JavaScript, inclusive roda-lo no servidor como uma linguagem
Server-Side, ou seja, agora temos o JavaScript do lado do
Servidor([NodeJs](https://nodejs.org/en/)) e do lado do Cliente da qual podemos
adotar alguns frameworks ou bibliotecas, como [Angular, Ember, Backbone, React,
Meteor ou até mesmo o jQuery](https://whichcatisyourjavascriptframework.com/).

Ferramentas essas que fazem o “ciclo de vida” dos produtos serem extremamente
produtivos em relação a escalabilidade e agilidade no desenvolvimento
Client-Side, pensando em manutenibilidade e outros fatores. Outro ponto que acho
extremamente relevante abordar é que uma das comunidade mais ativas é do
Node.JS,[ +70000 módulos no NPM(Node Package Manager)](https://www.npmjs.org/).

![](https://cdn-images-1.medium.com/max/800/1*4_n18FH8hRrvlLyRufD1sQ.png)
<span class="figcaption_hack">NodeJs</span>

E sobre o financeiro? Afinal saco vazio não para de pé, certo?

Veja os dois links abaixo que mostra a média salarial para pessoas que dominam o
NodeJs, nem preciso mencionar que com o [dólar atual a
R$3.90](https://dolarhoje.com/) é extremamente interessante trabalhar para
empresas no exterior além do conforto do home-office, vai refletindo sobre isso
até o final do post e veja abaixo:

* [PayScale](https://www.payscale.com/research/US/Skill=Node.js/Salary)
* [Quora](https://www.quora.com/What-is-the-average-Node-js-salary)

Bom, até aqui você já percebeu que o JavaScript oferece inúmeros recursos,
frameworks, padrões entre outros que facilitam a vida do desenvolvedor, que tal
você então dar uma chance para o JS, ainda não está convencido?

Veja quem está adotando Node no seus projetos:

* [Linkedin](https://engineering.linkedin.com/nodejs/blazing-fast-nodejs-10-performance-tips-linkedin-mobile)
* [Walmart](https://venturebeat.com/2012/01/24/why-walmart-is-using-node-js/)
* [Groupon](https://www.datacenterknowledge.com/archives/2013/12/06/need-speed-groupon-migrated-node-js/)
* [Microsoft](https://techcrunch.com/2013/11/21/microsoft-launches-node-js-tools-for-visual-studio/)
* [Paypal](https://www.paypal-engineering.com/2013/11/22/node-js-at-paypal/)
* [Outras](https://github.com/nodejs/node-v0.x-archive/wiki/Projects,-Applications,-and-Companies-Using-Node)

Agora, já pensou em você ter uma equipe da qual não precisa se preocupar com
qual tecnologia adotar, todos falando, digerindo e respirando apenas uma única
linguagem? Sim, o JavaScript ❤! É o que chamamos de [Universal
JavasScript](https://medium.com/@mjackson/universal-javascript-4761051b7ae9#.8com6l1tf).

> E quanto ao cenário Front-End!? Não preciso mencionar sobre a importância,
> certo? Aos amigos que já fazem parte desse cenário e se divertem com
[jQuery](https://youmightnotneedjquery.com/), [recomendo que possam adotar
JavaScript puro](https://youmightnotneedjquery.com/) em suas aplicações para
assim entrar de uma vez por todas, para o lado negro da força, adotando seja o
Angular ou outro framework que mencionei anteriormente.

![](https://cdn-images-1.medium.com/max/800/1*Mn_mGNUGxK6gCROym_z8Bg.png)
<span class="figcaption_hack">JavaScript Logo</span>

*****

Para você acreditar ainda mais, na adoção do JavaScript, veja essa thread do
[Stack Overflow](https://stackoverflow.com/research/developer-survey-2015#tech),
que fornece um panorama global de como está caminhando a tecnologia.

![](https://cdn-images-1.medium.com/max/800/1*RKz11TsfDy7Mtw4ATbRlnQ.png)
<span class="figcaption_hack">Developer Survey — Stack Overflow</span>

*****

Se após isso tudo, não o convenci do porquê dar um voto de confiança para o
JavaScript do lado do servidor, e sobre a importância de aprende-lo nativamente,
então tudo bem, nos vemos em outras conversas sobre outras tecnologias. Cabe
ressaltar ainda que o JavaScript, assim como qualquer outra linguagem nunca será
a bala de prata, evidencio apenas que o JavaScript é como um canivete suíço ele
te oferece mais ferramentas e recursos para trabalhar em duas
vertentes(client-side e server-side), com uma única linguagem.

*****

Agora se você está animado para dar o start, então vamos aprender JavaScript do
zero da forma correta, vou passar algumas boas sugestões, para que isso se torne
realidade e garanto que você irá aprender JS em menos de 2 meses!

![](https://cdn-images-1.medium.com/max/800/1*ZE5valizc_x1B73Gs11v_g.jpeg)
<span class="figcaption_hack">Guide Books | JavaScript</span>

Recomendo primeiramente que siga a **Metodologia Read-Search-Ask,** que consiste
em (Leia, Pesquise e Pergunte) ou seja leia a respeito, pesquise por respostas e
*por último* pergunte nas salas de chat/fórum. Geralmente o desenvolvedor ou
aspirante já sai metralhando todos os grupos igual “rambo na hora da vingança”
em busca de alguma alma caridosa que resolva seu problema com 2 linhas de
código, não seja um desenvolvedor [POG (programador orientado a
gambiarras)](https://pt.slideshare.net/josenaldomatos/programao-orientada-a-gambiarra-30097904).

Sendo assim, e seguindo a metodologia mencionada, recomendo que leia esses
livros:

* [JavaScript Guia Definitivo 6.ª edição — David
Flanagam](https://www.submarino.com.br/produto/112167569/livro-javascript-o-guia-definitivo)
* [Padrões JavaScript — Stoyan
Stefanov](https://novatec.com.br/livros/padroesjavascript/)
* [JavaScript de Alto Desempenho — Nicholas C.
Zakas](https://novatec.com.br/livros/javascriptdesemp/)
* [O Melhor do JavaScript — Douglas
Crockford](https://www.altabooks.com.br/o-melhor-do-javascript.html)
* [Ninja JavaScript — John Resig / Bear
Bibeault](https://www.novatec.com.br/livros/ninja-javascript/)

Obs: Você irá aprender JavaScript corretamente em 6 semanas com esses livros que
mencionei. Todos estão disponíveis em pt-br, ou seja, para quem não está
confortável em ler inglês é uma boa alternativa. ;)

Quer entender como usar os livros com um cronograma detalhado sobre quais
capítulos você vai ler por semana? Veja nesse
[link](https://codeinbrasil.wordpress.com/2013/04/28/como-aprender-javascript-corretamente-javascript-is-sexy/)
do Eric Douglas que ele traduziu do artigo [JavaScript is
Sexy](https://javascriptissexy.com/how-to-learn-javascript-properly/), com o
primeiro livro que citei, você consegue fazer coisas fantásticas, os outros 04
livros irão coloca-lo em um nível acima da média como Developer JavaScript.

Ok, já passei o material "técnico" mas, aí você você vai falar que não tem uma
reserva de dinheiro para adquirir livros e não tem a cultura de comprar livros,
pois tem muita coisa gratuita na internet, certo? Tem sim! Nesses casos alguns
links que recomendo, seriam:

* [JavaScript Furtivo](https://leanpub.com/javascriptfurtivo) (ebook) | Eric
Douglas — pt-br
* [Eloquent JavaScript (ebook)](https://braziljs.github.io/eloquente-javascript/) |
Marijn Haverbeke — pt-br
* [Learning JavaScript Design Patterns
(ebook)](https://addyosmani.com/resources/essentialjsdesignpatterns/book/)| Addy
Osmani— en-us
* [Série You Don ‘t Know JavaScript
(ebook](https://github.com/getify/You-Dont-Know-JS))| Kyle Simpson — en-us
* [Programming JavaScript Applications (ebook)
](https://chimera.labs.oreilly.com/books/1234000000262/index.html)| Eric Elliot —
en-us
* [JSBooks Free Resources (ebooks) — en-us](https://jsbooks.revolunet.com/)
* [Rodrigo
Brana](https://www.youtube.com/playlist?list=PLQCmSnNFVYnT1-oeDOSBnt164802rkegc)s
(video-aula)
* [WebSchool](https://www.youtube.com/playlist?list=PL77JVjKTJT2iAlBJX3buyljqzfoR9nV_R)
(video-aula)
* [Universidade
XTI](https://www.youtube.com/watch?v=VtJuifD4dSE&list=PLxQNfKs8YwvEk85FbeXxDnFecAntIQdRf)
(video-aula)

Mas vou supor que você não gosta de ler ou essas videos-aulas não são
relevantes, você prefere mais mão na massa(hands-on), bom nesse caso segue
alguns links que irão dar uma força nesse ponto:

* [CodeAcademy (pt-br)](https://www.codecademy.com/pt)
* [Developer
Mozilla](https://developer.mozilla.org/pt-BR/docs/Aprender/Getting_started_with_the_web/JavaScript_basico)
* [CodeSchool](https://www.codeschool.com/paths/javascript)
* [Learn-Js](https://www.learn-js.org/)
* [Team TreeHouse](https://teamtreehouse.com/library/javascript-basics)
* [freeCodeCamp](https://www.freecodecamp.com/)

Essas são instituições que visam ensinar JavaScript através de exercícios
práticos com terminal no browser.

O primeiro item da lista CodeAcademy está disponível em português, porém o
restante, é disponibilizado apenas em inglês, ou seja aprenda inglês. Você terá
em mãos a documentação sem erros de tradução, e artigos de excelente qualidade.

Existe muita gente boa daqui do nosso lado([Brazilian
JS](https://braziljs.org/)), fazendo coisas excelentes e ajudando a comunidade
brutalmente, como é o caso do [Jaydson Gomes](https://jaydson.org/), [Felipe
Moura](https://felipenmoura.com/home/), [Jean
Nascimento](https://nomadev.com.br/), [Jean Ermer](https://jcemer.com/),[ Fernando
Daciuk](https://blog.da2k.com.br/), [Eric
Douglas](https://github.com/ericdouglas), [Henrique Silvério
](https://github.com/HenriqueSilverio?tab=repositories), [Guilherme
Diego](https://medium.com/@guidiego), [Almir
Filho](https://loopinfinito.com.br/), [Diego
Eis](https://tableless.com.br/author/diegoeis/), [Daniel Filho](https://dnl.pw/),
[Davidson Felipe](https://www.fellipe.com/blog/), [Zeno
Rocha](https://zenorocha.com/blog), [Willian Bruno](https://wbruno.com.br/),
entre tantos outros que daria outro artigo para evidenciar isso, pois tem muita
gente bacana, empenhada nisso!

Uma boa plataforma que você pode estudar é a
[freeCodeCamp](https://www.freecodecamp.com/), que é a proposta mais **épica**
que eu conheci até o momento. Inclusive foi essa plataforma que me incentivou a
escrever esse artigo*.*

![](https://cdn-images-1.medium.com/max/800/1*C1Sk_k3mZuXTErHe-JNAxA.png)

A proposta do freeCodeCamp é fazer com que você aprenda JavaScript, HTML5 e
CSS3, fora versionamento com Git, MongoDB(NoSQL) e outras bibliotecas como D3.js
e o React.js , isso tudo de forma online e gratuita.

No final de cada curso você deverá compor uma tarefa para alguma ONG utilizando
os conhecimentos do último treinamento, além de uma capacitação para entrevistas
técnicas para empresas, assim como certificações para cada módulo que você
avança. O freeCodeCamp não é apenas uma plataforma autodidata, ela deseja que
você trabalhe em equipe então em alguns momentos você irá trabalhar em par ou
mesmo interagir com a equipe.

Para te convencer a usar a plataforma, o total é de 2.080 horas de conteúdo
prático, me diz depois nos comentários abaixo qual plataforma de ensino gratuito
focado em JavaScript tem uma carga horária dessas.

![](https://cdn-images-1.medium.com/max/800/1*pcO6xVSZ57FLLzp74acwLg.png)

Bem, é isso, espero que tenha aguçado sua vontade de querer aprender JavaScript,
se quiser manter-se atualizado sobre as principais novidades assina as "Weekly
's" abaixo e receberá semanalmente, informes sobre artigos, plugins, padrões,
carreira e muito mais!

* [BrazilJS Weekly](https://braziljs.org/#weekly)
* [JavaScript Weekly](https://javascriptweekly.com/)

**Bônus 1:** Existe esse guide [SuperHero JS](https://superherojs.com/),
*"…Creating, testing and maintaining a large JavaScript code base is not easy —
especially since great resources on how to do this are hard to find. This page
is a collection of the best articles, videos and presentations we’ve found on
the topic…"*, na íntegra esse guide vai abordar sobre Testes com JavaScript e
uma coletânea similar a essa que estou disponibilizando para vocês, ela existe
há uns 03 anos senão me falha a memória, está em inglês, vale muito a pena
segui-la também!

![](https://cdn-images-1.medium.com/max/800/1*vN4W4SSNiviavjgoaJy90g.png)

**Bônus 2:** Lembra que comentei da metodologia **Read-Search-Ask**, lhe
informei sobre livros** (READ)**, passei videos e pessoas para buscar conteúdo
relevante **(SEARCH)**. E o **(ASK)?** [Você não vai ficar criando dúvidas em
redes sociais como o
(facebook)](https://imasters.com.br/gerencia-de-ti/mercado/por-que-voce-deveria-parar-de-fazerresponder-perguntas-tecnicas-via-redes-sociais/?trace=1519021197)
né?! Sugiro boas alternativas como:

* [Stack Overflow](https://pt.stackoverflow.com/)
* [Slack BrazilJS](https://t.co/Y3lNJbl8Jj)
* [Front-End GitHub](https://github.com/frontendbr/forum)

Abraços, nos vemos em outra oportunidade. ;)