---
title: Porque você deve sua vida a Dave Winer
authors: Eduardo Fernandes
type: post
paid: true
date: 2014-05-21
excerpt: O developer norte-americano de 59 anos criou o RSS, o primeiro sistema de blogs, entre outras tecnologias. E está de olho no futuro da publicação digital
url: /porque-voce-deve-sua-vida-dave-winer/
dsq_thread_id: 2703031663
categories:
  - Artigos
  - Carreira
  - Opinião
  - CMS
  - Mercado
  - Microdata
  - Tecnologia e Tendências
tags:
  - rss
  - Carreira
  - Microdata
---
Talvez você não saiba, mas sua vida é muito influenciada por [Dave Winer][1]. Você deve usar as invenções desse developer norte-americano com mais frequência do que bebe água ou do que vai ao banheiro (se bem que, vai saber).

Winer criou o primeiro web CMS. O RSS. Os podcasts. Foi um dos desenvolvedores do XML-RPC protocol. Ou seja: esteve e, aos 59 anos, ainda está no centro da [web syndication][2], provavelmente um dos fenômenos tecnológicos mais importantes do século 20.

Espere aí.

Fenômenos tecnológicos nada. Fenômenos culturais.

Facebook, Twitter, Netflix, WordPress, entre tantos outros produtos, influenciadores culturais, processadores de ideias e de dinheiro, têm, em seus corações, alguma forma de web syndication. Se não o próprio RSS, algo parecido ou influenciado por esse conceito.

Não que Winer tenha _exatamente_ criado a web syndication. Mas facilitou horrores a popularização e o desenvolvimento dessa tecnologia. De forma que, toda vez que você está no Facebook ou recebe uma notificação no celular, estabelece algum tipo de link cármico com o autor do (note)blog [Scripting News][3].

A invenção da web syndication foi um momento crucial para a história recente da humanidade. Parece exagero? Não é. Pense em como você organiza sua vida cotidiana. Fala com os parentes via Whatsapp, usa a busca do Google para decidir onde comer, depende de sistemas de mapas, compra coisas via internet etc.

Por trás de todos esses sistemas, há CMSs, feeds, arquivos de textos sendo publicados, processados, classificados por algorítimos e depois servidos de acordo com diferentes contextos, sejam eles tecnológicos (que tipo de aparelho você usa para acessar a informação) ou sociais e geográficos.

Mais que isso: produzimos tanta informação, que cada vez mais dependemos de informação _sobre_ a informação. Ou seja: os meta dados (meta data). São mais textos que tentam nos ajudar a entender como _usar_ textos. Que, por sua vez, são processados por scripts (também textos) que produzem outros textos. Ufa.

Essas informações, em si, [cada vez mais se tornam uma força política][4] e econômica. Além de uma [nova identidade cultural][5]. A web syndication nos ensinou a pensar como computadores. E hoje esperamos que eles pensem por nós, de maneira quase humana. Não só fazendo cálculos, mas conectando significados, influenciando decisões, filtrando ideias. Tudo por meio desse obscuro tráfego de dados e meta dados.

Primeiro, nos viciamos em periodicidades (na Era da Imprensa). Depois acrescentamos as timelines (da Era das Redes Sociais). Agora precisamos também de notificações, que [algum som][6] ou ícone nos chame a atenção para algo supostamente importante.

Faça um experimento: vá até uma rua movimentada de uma grande cidade e imite o assobio do [Whatsapp][7]. Você verá algumas pessoas entrarem em estado de alerta imediato. Ou terem ímpeto de procurarem seus celulares.

Por incrível que pareça, esses novos instant messengers (além de apps como o [Secret][8]) ainda comportam alguma espontaneidade humana. Mas quanto tempo até também precisarmos explicitamente de meta data para poder dar conta desse fluxo de informações? E, então, o que virá depois da Era das Notificações?

De qualquer forma, independentemente do ambiente, parece que a tendência é sempre produzir mais informação sobre informação. Textos para _redistribuição_, syndication.

E você achava que o filme [Inception][9] era esperto. Ele é só uma espécie de outline. O que nos leva de volta a Dave Winer, o criador do primeiro processador de outlines. E também de um dos mais recentes CMSs baseados nessa tecnologia, o [Fargo][10]. Além do formato [noteblog][11], que pretende ser uma espécie de alternativa tanto aos blogs quanto ao Twitter.

Enfim, acho que você já entendeu, mas não custa enfatizar: dei toda essa volta maluca para chamar sua atenção para Dave Winer. Ou melhor, para a _intuição_ um tanto excêntrica desse engenheiro, que, despretensiosamente, funciona como uma antena para o _zeitgeist_ de pelo menos duas décadas de publicação digital.

Agora ele está (ainda mais) interessado na ideia de <a href="https://river2.newsriver.org/" rel="bookmark">rio de informações</a> — [e, de quebra, em reformar o site do New York Times][12]. #ficaadica: [Scripting News][3].

 [1]: https://davewiner.com/
 [2]: https://en.wikipedia.org/wiki/Web_syndication
 [3]: https://scripting.com/
 [4]: https://caosordenado.com/o-estado-paralelo-digital-global/
 [5]: https://caosordenado.com/matutando-sobre-as-redes-sociais/
 [6]: https://www.youtube.com/watch?v=bxC5Xo_KaC4
 [7]: https://www.youtube.com/watch?v=7UXIKu4t6D4
 [8]: https://www.secret.ly/
 [9]: https://en.wikipedia.org/wiki/Inception
 [10]: https://fargo.io/
 [11]: https://scripting.com/2014/03/20/theNoteblogFormat.html
 [12]: https://scripting.com/2014/05/16/#a1400253877