---
title: Porque é a web que comanda
authors: Diego Eis
type: post
date: 2010-01-27
excerpt: Porque fazer um sistema que deve ser instalado no iPhone se você pode fazer um sistema web que pode ser acessível em todos os smartphones?
url: /porque-e-a-web-que-comanda/
aktt_notify_twitter:
  - no
tweetbackscheck:
  - 1356384255
shorturls:
  - 'a:3:{s:9:"permalink";s:50:"https://tableless.com.br/porque-e-a-web-que-comanda";s:7:"tinyurl";s:26:"https://tinyurl.com/43t78k6";s:4:"isgd";s:19:"https://is.gd/s1F3nX";}'
twittercomments:
  - 'a:0:{}'
dsq_thread_id: 503039333
categories:
  - Artigos
  - Browsers
  - Mobile
  - Tecnologia e Tendências
tags:
  - CSS
  - desenvolvimento web
  - dispositivos moveis
  - html
  - html5
  - internet
  - internetmovel
  - iphone
  - Javascript
  - navegadores
  - padroes web
  - web

---
A AppStore fez sucesso. Bastante. Por vários motivos: um deles foi por conta da remuneração do desenvolvedor. Teve gente que ganhou milhares de dólares sozinho vendendo aplicações por 99 centavos. Obviamente isso chamou a atenção de muita gente, que começou a fazer aplicações enlouquecidamente para ganhar alguns trocados. Consequentemente um grande números de aplicações que não precisam ser instaláveis no aparelho, apareceram. Vários desenvolvedores não perceberam que dependendo do seu sistema, ele não precisa ser desenvolvido exclusivamente para ser instalado na plataforma do iPhone.

Hoje, aparelhos como o iPhone, que tem um browser com um bom suporte a HTML 5 e CSS 3, possibilitam criar sistemas e aplicativos baseados em web, com características, designs e comportamentos idênticos aos de aplicações instaláveis nos aparelhos. E o melhor, podem ser utilizados de qualquer lugar, pela web. Outro ponto negativo é que desenvolver para iPhone/iPod Touch é um bocado burocrático. Você precisa ter o SDK que só funciona no OS X, e você precisa aprender Objective C para programar os Apps para Apple. Em contrapartida, para fazer um App baseado em Web, onde seus clientes acessarão o sistema diretamente pelo browser do aparelho, é preciso saber Javascript, HTML 5 e CSS 3. Se você já é desenvolvedor Web, você já sabe desenvolver para iPhone, iPod Touch, Android e qualquer outro dispositivo similar.

Se você gosta dos efeitos de transição dos aparelhos, você pode fazê-los sem problemas utilizando JQuery ou CSS 3. Há até um [plugin de JQuery chamado JQTouch][1], que permite fazer efeitos idênticos ao do iPhone. Esse plugin foi pensado exatamente para funcionar em Mobile Safari e outros aparelhos com browsers avançados, como no Android.

Um caso sobre o que estamos falando é a aplicação do Itaú. Se você tem um iPhone, baixe o aplicativo pela AppStore. Ao abrir o aplicativo, perceba que o sistema não faz nada além de mostrar o site do Itaú. É muito mais interessante e barato ensinar o usuário a visitar o site em vez de procurar um aplicativo e instalar. Não é necessário nem divulgar um endereço mobile do site &#8211; esse aliás é outra discussão. 

Obviamente, há exceções. A maioria dos jogos, se não todos, e alguns sistemas disponíveis funcionam melhor (ainda) se forem instalados no aparelho. Mas a grande maioria dos sistemas, principalmente aqueles que o usuário simplesmente insere ou verifca informações e dados, podem ser servidos diretamente pela web.

No caso do iPhone, os sistemas que utilizam recursos do aparelho, como por exemplo fazer o aparelho vibrar, bluetooth, bateria, GPS e etc, precisam ser instalados. Isso não se aplica a alguns mobiles da Nokia que são baseados na plataforma WRT.
  
A plataforma WRT permite que você desenvolva aplicativos utilizando Javascript, HTML e CSS. E por meio de Javascript, você pode ativar os recursos que ter utilizar no aparelho. Nesse caso, há uma vantagem em cima do iPhone: você não precisa aprender Objective C. Basta saber Javascript, CSS e HTML. 

O cenário de hoje é interessante. Tudo o que o desenvolvedor sempre sonhou em utilizar de HTML 5 e CSS 3 pode ser aplicado no desenvolvimento para web mobile. Os browsers estão mais espertos e a cada dia trazem novidades interessantes para melhorar o desenvolvimento dos padrões e da web. Realmente, daqui pra frente, é um novo mundo que se forma. Um mundo tão ou mais complexo que o desenvolvimento web para desktops como conhecemos hoje. Pra mim, é mais apaixonante.

  * [Guidelines de User Experience][2] da Apple.
  * [Forum Nokia &#8211; Web Runtime][3]

 [1]: https://www.jqtouch.com/
 [2]: https://developer.apple.com/iphone/library/documentation/UserExperience/Conceptual/MobileHIG/Introduction/Introduction.html
 [3]: https://www.forum.nokia.com/Technology_Topics/Web_Technologies/Web_Runtime/