---
title: 'Por que todo desenvolvedor deveria aprender design?'
authors: Guilherme Costa
type: post
publishdate: 2018-07-04
date: 2018-07-04
excerpt: 'Afinal, todo o time de desenvolvimento está diretamente ligado com pontos chave na experiência do usuário.'
image: https://i.imgur.com/Uv1OpwA.jpg
sponsor: organizze
categories:
  - Opinião
  - Design
tags:
  - Carreira
  - Mercado
---

Equipe toda reunida para validação e deploy das novas features desenhadas para o
projeto, quando a janela do browser poppa, o coração do time de criação se
parte: está tudo diferente do que foi produzido por eles. E então, começa a
guerra. “Mas aquilo não era aplicável!”, “Mas é uma diferença de nada no
tamanho!”, “Se você tivesse mandado o arquivo organizado pelo menos!”, “Assim
era mais rápido! Não precisa de tanta firula”. O que era pra ser uma
confraternização de um ciclo fechado, vira uma guerra. E ninguém se salvará.

Te soa familiar? Você não está sozinho. Mas vem comigo que dá pra melhorarmos
isso.

*****

Só pra não perder o costume, a recomendação musical da vez fica por conta da
banda norte-irlandesa **Two Door Cinema Club**. Os caras já são figura carimbada
na cena indie mundial, mas como o timing é perfeito com o lançamento de seu mais
novo álbum *Gameshow* e com a vinda para o Brasil no domingo para participar do
Lollapalooza, deixo de presente essa apresentação maravilhosa que eles fizeram
para lançar o álbum. Se você não conhecia, ouça, e ouça muito!

A banda já contava com dois grandes álbuns: *Tourist History* e *Beacon*, mas
que são muito parecidos em forma. Gameshow resgata toda a nostalgia da música
pop dançante dos anos 80, de sua capa até seus arranjos e falsetes empregados
por Alex Trimble.

*****

Já é lugar comum o discurso de que "todo designer deveria aprender a programar",
mas muito pouco se fala do caminho inverso, e hoje venho trazer uma perspectiva
diferente do assunto: os principais motivos para todo desenvolvedor (é,
inclusive você aí do Back End) aprender design. Afinal, todo o time de
desenvolvimento está diretamente ligado com pontos chave na experiência do
usuário (sim, a famigerada UX, que, se você não faz ideia de que estou falando,
precisa **mesmo** ler esse texto até o final).

### Criar soluções melhores

Via de regra, os projetos que trabalhamos nascem para atender necessidades de um
público-alvo, que pode ser desde um app para auxiliar no controle financeiro até
o gerenciamento e acompanhamento de fichas médicas.

Entender como atender essas necessidades é o que faz um projeto ser bem
sucedido, e você como desenvolvedor tem uma bagagem inestimável para trazer à
mesa desde o início da concepção de um produto.

Saber como os usuários se comportam e o que esperam te dará maior poder na hora
de pensar suas soluções, e quando você menos perceber vai estar falando a mesma
língua que seu designer e entender o porquê de ele reclamar que aquele menu
quebrou em duas linhas ou que aquela ação poderia ter menos cliques para
acontecer.

> Entender as necessidades do seu usuário não compete somente ao time de criação,
> deixar essa tarefa somente à cargo do designer é limitar o projeto à um único
prisma.

Então sim, você como desenvolvedor deveria se envolver no projeto desde o
entendimento do briefing até os primeiros rascunhos advindos de um brainstorm.

### Ter mais agilidade nas tarefas diárias

Você precisa mesmo abrir um "chamado técnico" para o time de criação para pegar
um recorte de uma imagem ou saber qual o código hexadecimal (ou hsl, ou rgba, ou
whatever) daquela cor que será inserida no projeto?

Isso definitivamente não é produtivo, e por mais que gostaríamos que tudo viesse
mastigadinho para nós, essa não é a realidade do dia a dia de um time de
criação/tech.

> Saber se virar em pequenos problemas do dia a dia reduzirá a carga inútil na
> equipe de criação, te dará maior autonomia e agilidade em suas entregas.

### Ser mais feliz no trabalho

Parece que não, mas entender que quando o seu designer te pede para alterar
alguma coisa que pra você parece perfeitamente ok não significa que ele é
mesquinho e quer destruir sua vida, mas sim porque ele está pensando no sucesso
do produto e colocando uma expectativa de que as coisas saiam como o planejado
vai te fazer trabalhar muito mais feliz.

Nosso trabalho costuma ser o local em que passamos o maior tempo do nosso dia,
então conviver bem com as pessoas que colaboram com você é o mínimo que você
pode fazer por sua saúde mental. Sério.

*****

"Ok, ok. Você me convenceu. Mas por onde que eu começo, Guilherme?"

Ora, não seja por isso, preparei um roteiro básico pra quem quer entender um
pouco mais sobre design:

#### Hack Design

Um curso que chega semanalmente pra você por email que aborda todos os pontos do
design desde o princípio, e totalmente grátis. Parece bom demais pra ser
verdade, não é mesmo? Basta [se inscrever](https://hackdesign.org/) e
aproveitar.

#### Alguns livros

Abaixo listarei alguns livros que acredito serem um bom pontapé inicial, mas não
é exatamente obrigatório sua leitura, buscar conhecimento na web já ajuda e
muito.

1.  "[Não me faça pensar](https://www.amazon.com.br/NÃ£o-Me-FaÃ§a-Pensar-Atualizado/dp/8576088509)",
de Steve Krug;
1.  "[Design de navegação web](https://www.amazon.com.br/Design-NavegaÃ§Ã£o-Web-Otimizando-ExperiÃªncia-ebook/dp/B019HNBXSI/)",
de James Kalbach;
1.  "[Psicodinâmica das cores em comunicação](https://www.amazon.com.br/PsicodinÃ¢mica-das-Cores-em-ComunicaÃ§Ã£o/dp/8521205465)",
de Modesto Farina, Clotilde Peres e Dorinho Bastos;
1.  "[Pensar com tipos](https://www.amazon.com.br/Pensar-com-Tipos-Ellen-Lupton/dp/8540502836)",
de Ellen Lupton;
1.  "[UX fundamentals: interaction design](https://go.usabilla.com/ux-fundamentals-interaction-design-ebook)", de
Lana Miller;

#### Leia também

Abaixo alguns artigos que podem servir de guideline para você, além de reforçar
o que já foi dito por aqui, aproveite!

1. [10 design concepts that every web developer needs to know](https://www.creativebloq.com/web-design/10-design-concepts-web-developers-need-know-11135255)
1. [The core principles of UI design - InVision Blog](https://blog.invisionapp.com/core-principles-of-ui-design/)
1. [Os Princípios de UX para Aplicativos em Dispositivos Móveis](https://www.thinkwithgoogle.com/intl/pt-br/articles/mobile-app-ux-principles.html)

*****

Espero que eu tenha conseguido te convencer com esses pontos e que as dicas
possam te ajudar, mas se não foi o suficiente, que tal batermos um papo nos
comentários? Você também pode me contar sobre como foi experimentar aprender um
pouco de design e qual foi o impacto no seu trabalho!

Por hoje é isso, e vamos codar! ;D
