---
title: Por que inscrever seu site no prêmio de acessibilidade?
authors: Reinaldo Ferraz
type: post
date: 2016-03-04
excerpt: O Todos@Web vai além de uma premiação. É um reconhecimento das boas práticas de acessibilidade e uma forma de receber feedback gratuito de especialistas em acessibilidade sobre seu projeto.
url: /por-que-inscrever-seu-site-no-premio-de-acessibilidade/
categories:
  - Acessibilidade
  - Eventos e Workshops
  - Geral
tags:
  - acessibilidade
  - evento
  - prêmio

---
Tenho conversado com algumas pessoas que trabalham com desenvolvimento e tem belos sites que poderiam participar do [Prêmio Nacional de Acessibilidade na Web][1]. Quando recomendo que inscrevam seu trabalho, ouço os mais diversos argumentos:

  * Não tenho chance de ganhar
  * Não tenho material para inscrever
  * Meu site não é 100% acessível
  * Não conheço todos os requisitos de acessibilidade

Baseado nessas respostas, gostaria de elencar alguns bons motivos para que as pessoas sim, inscrevam seu site no prêmio:

## Você tem chances sim de ganhar

O site inscrito passa por uma avaliação inicial e os inscritos recebem orientações para corrigir o código em tempo de uma nova avaliação. Muitas vezes os comentários apontam para simples correções. Com o site corrigido, as chances de ficar entre os finalistas aumenta consideravelmente.

## Basta descrever as boas práticas usadas para inscrever um projeto

Para inscrever um projeto web basta preencher um formulário com a URL do projeto e uma descrição das boas práticas utilizadas no desenvolvimento do site. Estruturação de cabeçalhos, textos alternativos, uso de ARIA e por ai vai. Você vai perceber que boa parte dessas boas práticas já são feitas de forma automática durante o desenvolvimento do projeto. Você não está &#8220;incluindo acessibilidade&#8221;. Ela já faz parte do processo de desenvolvimento.

## O prêmio não é um selo de site 100% acessível

O objetivo do prêmio é reconhecer iniciativas que vão tornar a Web mais acessível. A premiação não é um selo e sim um reconhecimento pelo trabalho em tornar a Web mais acessível. Seu site pode não ser 100% acessível, mas ele pode ser melhor que boa parte dos sites. E pode ficar melhor ainda.

## O site será avaliado por especialistas

Talvez a parte mais valiosa do prêmio na minha opinião. O site vai passar por uma bateria de avaliações feitas por mais de 20 especialistas em acessibilidade, usabilidade e padrões Web. Independente de classificar o site entre os finalistas, o relatório com os comentários da comissão que avalia o site é um ótimo material para promover mudanças que melhorem a acessibilidade do site. Esse documento é entregue somente para o responsável do site. Ninguém mais vai ter acesso a esse relatório.

## Existe muito material sobre acessibilidade na Web

Além da documentação do W3C, como as [WCAG 2.0 (em português)][2] e [WAI-ARIA 1.0][3], existe muito conteúdo espalhado pela rede. Aqui no [Tableless tem muito material sobre acessibilidade][4], além de artigos, palestras, tutoriais e vídeos espalhados pela rede.

## A premiação

O prêmio é encerrado com uma bela premiação. Além de participar da cerimônia de premiação, divulgação e publicação das melhores práticas de acessibilidade, ganhar um **prêmio de R$ 5.000,00** e um troféu de melhor projeto Web do ano não é nada mal.

O prêmio tem uma função muito nobre: Aumentar a preocupação com a acessibilidade na Web nas mais diversas áreas. Nós, como desenvolvedores, temos um papel fundamental na mudança desse cenário de uma web cheia de barreiras para uma que seja inclusiva.

As [inscrições são gratuitas e estão abertas][5] até o mês de maio. Maiores informações, como categorias, premiação e regulamento podem ser acessadas na página do prêmio em <https://premio.ceweb.br/>.

 [1]: https://premio.ceweb.br/
 [2]: https://www.w3.org/Translations/WCAG20-pt-br/
 [3]: https://www.w3.org/TR/wai-aria/
 [4]: https://tableless.com.br/?s=acessibilidade
 [5]: https://premio.ceweb.br/inscricoes/