---
title: Plugins de GIT para Sublime e Brackets
authors: Diego Eis
type: post
date: 2015-01-20
excerpt: Conheça alguns plugins para integrar o Git no Sublime e Brackets
url: /plugins-de-git-para-sublime-e-brackets/
categories:
  - git
  - Código
  - Editores
tags:
  - Brackets
  - git
  - plugins
  - sublime

---
Além do browser, outras duas ferramentas que os desenvolvedores usam todo o santo dia quase que todo o tempo é o seu editor de código e também o GIT. Aqui vão algumas indicações de plugins para Sublime e Brackets que ajudarão na integração do GIT com estes dois editores.

## Git no Sublime

Se você tiver o Package Control instalado no Sublime, é uma boa ideia instalar estes plugins direto por lá.

### Git Gutter

Um plugin simples que mostra o status das linhas modificadas no seu arquivo.

<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/01/git-gutter.png" alt="git-gutter" width="291" height="177" class="alignnone size-full wp-image-46663" srcset="uploads/2015/01/git-gutter.png 291w, uploads/2015/01/git-gutter-229x139.png 229w" sizes="(max-width: 291px) 100vw, 291px" />

<https://github.com/jisaacks/GitGutter>

### Sublime GIT

Traz alguma integração do GIT para o Sublime. Você consegue executar alguns comandos direto pelo Sublime, facilitando bastante tarefas como commit, status, diff, log etc…

<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/01/sublime-git.png" alt="sublime-git" width="624" height="306" class="alignnone size-full wp-image-46666" srcset="uploads/2015/01/sublime-git.png 624w, uploads/2015/01/sublime-git-265x130.png 265w, uploads/2015/01/sublime-git-400x196.png 400w" sizes="(max-width: 624px) 100vw, 624px" />

<https://github.com/kemayo/sublime-text-git>

### GitStatus

Monitora os arquivos modificados e seus status no repositório.

<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/01/gitstatus.png" alt="gitstatus" width="389" height="100" class="alignnone size-full wp-image-46665" srcset="uploads/2015/01/gitstatus.png 389w, uploads/2015/01/gitstatus-265x68.png 265w" sizes="(max-width: 389px) 100vw, 389px" />

<https://github.com/vlakarados/gitstatus>

## Git no Brackets

Estou tentando usar o Brackets a maior parte do meu tempo. Está sendo bastante interessante. Os plugins funcionam bem e tem bastante gente ajudando o desenvolvimento do projeto.

### Brackets Git

Este plugin é sensacional. Ele mostra os arquivos modificados e você consegue comitar todos estes arquivos direto pelo Brackets. Além de outras facilidades como ver um painel de histórico e o diff do arquivo. Acho que só esse plugin já seria o suficiente para trabalhar bem com Git no Brackets.

<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/01/brackets-git-1.jpg" alt="brackets-git-1" width="1114" height="451" class="alignnone size-full wp-image-46660" srcset="uploads/2015/01/brackets-git-1.jpg 1114w, uploads/2015/01/brackets-git-1-265x107.jpg 265w, uploads/2015/01/brackets-git-1-400x162.jpg 400w" sizes="(max-width: 1114px) 100vw, 1114px" />

<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/01/brackets-git-2.jpg" alt="brackets-git-2" width="1114" height="451" class="alignnone size-full wp-image-46661" srcset="uploads/2015/01/brackets-git-2.jpg 1114w, uploads/2015/01/brackets-git-2-265x107.jpg 265w, uploads/2015/01/brackets-git-2-400x162.jpg 400w" sizes="(max-width: 1114px) 100vw, 1114px" />

<https://github.com/zaggino/brackets-git>

### Brackets Git Info

Bem simples, só mostra o nome do branch atual ao lado do nome do projeto. Mas isso o Brackets Git já faz.

<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/01/brackets-git-info.png" alt="brackets-git-info" width="209" height="160" class="alignnone size-full wp-image-46662" srcset="uploads/2015/01/brackets-git-info.png 209w, uploads/2015/01/brackets-git-info-182x139.png 182w" sizes="(max-width: 209px) 100vw, 209px" />

<https://github.com/couzteau/brackets-git-info>

### Git Integration Command Line

Um plugin que permite fazer os comandos do git via linha de comando, direto do Brackets.

<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/01/git-integration.png" alt="git-integration" width="1740" height="1446" class="alignnone size-full wp-image-46664" srcset="uploads/2015/01/git-integration.png 1740w, uploads/2015/01/git-integration-167x139.png 167w, uploads/2015/01/git-integration-400x332.png 400w" sizes="(max-width: 1740px) 100vw, 1740px" />

<https://github.com/jayproulx/git-integration>