---
title: Personalidade no Design
authors: Will Sales
type: post
date: 2012-11-12
excerpt: O design de interfaces está em uma ampla categoria chamada Interação Humano-Computador. Se isto lhe soa familar, saiba que é muito do que os designers de UX lidam todos os dias.
url: /personalidade-no-design/
tweetbackscheck:
  - 1356389575
shorturls:
  - 'a:3:{s:9:"permalink";s:31:"https://tableless.com.br/?p=7225";s:7:"tinyurl";s:26:"https://tinyurl.com/axnz9zv";s:4:"isgd";s:19:"https://is.gd/w1DwGi";}'
twittercomments:
  - 'a:0:{}'
dsq_thread_id: 925266725
categories:
  - Traduções
tags:
  - 2012
  - alistapart
  - design
  - traducoes
  - usabilidade
  - ux

---
_Traduzido com autorização da <a href="https://www.alistapart.com/" target="_blank">A List Apart Magazine</a> e do autor._

_Estamos animados em apresentar um trecho do 3° capítulo do livro “_<a href="https://www.abookapart.com/products/designing-for-emotion" target="_blank"><em>Designing for Emotion</em></a>_” de Aarron Walter (Ed. A Book Apart, 2011)_

Chamamos de personalidade, o centro de relações duradouras, em torno de qualidades únicas, e perspectivas que todos possuímos. Através de nossa personalidade, expressamos uma gama de emoções humanas. Personalidade é a força que nos atrai a certas pessoas e nos repele de outras. Pelo fato de a personalidade exercer grande influência em nosso processo de tomada de decisões, a mesma pode ser uma poderosa ferramenta no design.

## Personalidade é a plataforma para a emoção

O design de interfaces está em uma ampla categoria chamada Interação Humano-Computador, ou IHC, em conjunto com a ciência da computação, ciência comportamental e o design. Especialistas em IHC entendem de psicologia, usabilidade, design de interação, conceitos de programação, e princípios básicos de design visual. Se isto lhe soa familar, saiba que é muito do que os designers de UX lidam todos os dias.

Vou contar um segredo, não sou fã do nome _“Interação Humano-Computador”_. Quando desenvolvo um projeto, trabalho arduamente na experiência da interface, sentindo que haverá um ser humano do outro lado, e não um computador. Pode até soar a mesma coisa, mas nomes são importantes. Nomes moldam a nossa percepção, e nos sugestionam ideias que se encaixam em determinadas categorias.

O design emocional tem como principal objetivo facilitar a comunicação entre seres humanos. Se estivermos desenvolvendo bem o nosso trabalho, o computador ficará apenas como plano de fundo, e a personalidade virá à tona. Para atingirmos este objetivo, devemos levar em conta a maneira como interagimos uns com os outros na vida real.

Eu gostaria que você parasse por um momento, e lembrasse de alguém que você teve uma conexão recente na vida real. Talvez tenha encontrado essa pessoa enquanto estava em algum evento, ou talvez um amigo tenha lhe apresentado, e a conversa que se seguiu tenha sido interessante, cativante e até mesmo divertida. O que havia nessa pessoa que fez com que a conversa fosse tão emocionante? Vocês provavelmente tinham interesses em comum, e isso provocou uma discussão, mas não foi só isso que fez com que o encontro fosse tão memorável certo? Foi sua personalidade que lhe atraiu a essa pessoa, que levou a discussão e que lhe deixou tão animado. Suas personalidades interceptaram a troca de brincadeiras, o tom de voz, e a cadência da conversa. Isso fez com que você baixasse a guarda, e confiasse nessa pessoa. Personalidades promovem amizades e servem como uma plataforma para as ligações emocionais.

Prenda-se a esta lembrança. Revisite-a quando for iniciar um novo projeto. É este tipo de sentimento que estamos tentando construir através do design emocional. Vamos criar esta sensação de excitação, e a vincularemos ao nosso público através da concepção de uma personalidade, que será incorporada a nossa interface.

Pensaremos em nossos projetos de design não como uma fachada interativa, mas como pessoas com quem o nosso público possa ter uma conversa inspirada. Produtos também são pessoas.

Como sempre a História explica a nossa atual situação, e vamos verificar que designers têm feito experiências com personalidades, a fim de criar uma experiência mais humana, há séculos.

**Uma breve História da personalidade no design**

Existe um histórico de injeção de personalidade nas coisas que fizemos, numa tentativa de humanizar as criações mecânicas. Quando Johannes Gutenberg – ourives e pai da máquina de impressão – fez experimentos com tipos móveis, em meados do século XV, foi a mão humana que o inspirou. Antes da máquina de impressão, os escribas – que geralmente eram monges – escreviam  a mão, meticulosamente, cada página de seus manuscritos religiosos, usando pena e tinta. Transcrever uma bíblia era um dever sagrado, e os escribas achavam que era uma maneira  para canalizar a mensagem divina.  Por esta razão, a presença da “mão” nesses manuscritos tem grande importância espiritual.

Então, quando Gutenberg projetou e moldou os tipos originais, usados para imprimir centenas de bíblias, a forma da fonte imitava o estilo caligráfico dos escribas. E embora tenha criado máquinas para produzir a mensagem divina, ele esforçou-se para tentar fazer uma representação mais humana (figura 3.1)

<img class="aligncenter" src="https://www.alistapart.com/d/personality-in-design/figure3_1.jpg" alt="" width="540" height="334" />

_Figura 3.1: Os tipos móveis de Gutenberg imitavam a caligrafia dos escribas, na tentativa de fazer com que suas bíblias, produzidas mecanicamente, fossem mais humanizadas._

Podemos ver a tendência do design humano manifestando-se no século XX, quando a produção em massa permeou quase todos os setores da indústria.

O Volkswagen Beetle (Fusca no Brasil), lançado em 1938 e produzido até 2003, foi o projeto mais vendido na história automobilística, e seu design distintamente humano contribuiu para o seu sucesso (figura 3.2). Concebido como o “Carro do povo”, o design antropomorfizado o tornou mais que um carro para o povo: Tornou-o uma pessoa. Os faróis arredondados que denotavam olhos, enquanto o seu capô em forma de concha sorria para nós, personificando uma ideia de um rosto de bebê. Embora originalmente projetado com uma aerodinâmica sem personalidade, a “face” do Fusca transmite uma atitude esperançosa e divertida, que fez com que gerações se relacionassem facilmente a ela, mesmo com mudanças culturais ao longo de sete décadas.

<img class="aligncenter" src="https://www.alistapart.com/d/personality-in-design/figure3_2.jpg" alt="" width="540" height="383" />

_Figura 3.2: Personalidade à frente e no centro do design do Volkswagen Fusca, que ajudou a torná-lo um sucesso esmagador por gerações._

Este sorriso que cumprimenta o motorista reflete a emoção e estabelece um tipo específico de relacionamento. É difícil não retribuir a um sorriso, mesmo vindo de um objeto. Em torno desta simples interação, construímos uma persona emocional para este automóvel, levando-o a jogos (“Slug bug red!”) e como herói no filme “Herbie”. Criamos memórias ao redor dessas experiências, e elas nos lembraram as emoções positivas que o Fusca inspira.

Embora a bíblia de Gutenberg e o Fusca sejam casos interessantes, não há um exemplo mais concreto de personalidade no design do que a campanha publicitária da Apple _“Get a Mac”_ (Nota do Tradutor – <a href="https://www.youtube.com/watch?v=BdGqf4d2GHM" target="_blank">Exemplo da campanha</a>). Nos anúncios, Justin Long interpreta um jovem e moderno Mac – John Hodgman é um PC comum – que sem esforço algum consegue resolver problemas complexos e todas as suas tarefas. Esses anúncios transmitem uma experiência de personalidade e ajudam os consumidores a comparar os diferentes relacionamentos que poderiam ter com o seu computador. Os anúncios não falam sobre especificações ou características, e sim sobre como você se sentiria se comprasse um Mac. Compreendendo a história da personalidade no design, vamos voltar ao presente, onde nos esforçamos para tentar entender o nosso público, e damos o nosso melhor para desenvolver experiências atraentes para a web.

## Personas

No web design atual pesquisamos, planejamos e criamos coforme as motivações e atitudes do nosso público. Os desenvolvedores de experiência de usuário entrevistam o seu público, e então criam personas – um dossiê sobre um arquétipo de usuário representando um grupo maior. Pense nas personas como um artefato de pesquisa do usuário. Elas ajudam a equipe de web a permanecer consciente do seu público-alvo e manter o foco em suas necessidades.

O exemplo de persona mostrado na Figura 3.3, criado por Todd Zaki Warfel (designer na messagefirst), conta a estória de Julia. Através deste documento, aprendemos sobre a sua demografia, seus interesses, seus conhecimentos em diversos assuntos, e o que influência as suas decisões sobre assuntos pertinentes ao projeto – nós começamos a entender quem é a Júlia. Temos agora um vislumbre de sua personalidade, o que nos ajuda a entender as suas motivações e formar as decisões seguintes no design.

<img class="aligncenter" src="https://www.alistapart.com/d/personality-in-design/figure3_3.jpg" alt="" width="540" height="825" />

_Figura 3.3: Personas ajudam a guiar o processo do design, mantendo o foco nas necessidades do usuário._

Embora Júlia não seja uma pessoa real, mas um arquétipo representativo de um grupo de usuários, ela está realmente próxima de ser uma pessoa bastante  conhecida pelo time da messagefirst (empresa que a criou). Eles desenvolvem todas as suas personas desta maneira, o que é muito útil. Quando se deparam com um ponto complicado no processo de seus projetos, em que estejam inseguros de quais percepções, valores e comportamentos esperar de seu público numa determinada interface, podem simplesmente telefonar e fazer perguntas. Isto não só ajuda a criar soluções perfeitas no design, mas também os mantém focados em pessoas reais que usarão esta interface.

Sabemos que todo usuário necessita que o nosso design seja funcional, confiável e utilizável. Ao compreender nosso público, podemos atender melhor suas necessidades. Esta informação também nos ajuda a atender a camada superior desta hierarquia, nos indicando a personalidade (no design) mais suscetível a criar uma conexão emocional. A Persona é uma ferramenta padrão no processo de design, mas ela só oferece uma imagem parcial do relacionamento construido com nosso público. Sabemos quem elas são, mas quem somos nós?

Mencionamos no início do artigo que produtos podem ser pessoas também. Seguindo esta linha de raciocínio, nosso projeto não deveria ter uma persona também, funcionando como a ficha da persona do usuário? Deveria? Sim, deveria.

### Projetando uma Persona para o seu website

Se o seu website fosse uma pessoa, quem ele seria? Ele seria sério, bem vestido, um homem de negócios, confiável e capaz? Ou ele seria um amigo rabugento, que deixa as tarefas mundanas mais divertidas?

Seguindo uma estrutura similar a do usuário, você também pode detalhar a personalidade do seu projeto desenvolvendo uma persona. A personalidade pode manifestar-se na interface através do design visual, da reprodução e interações.  A persona descreve como a personalidade será dirigida a cada segmento, e ajuda a equipe a construir um resultado unificado e consistente. O objetivo é construir uma personalidade que seja retratada de forma tão clara como Justin Long e John Hodgman o fizeram nos anúncios do “Get a Mac “.

Antes de darmos uma olhada na persona que criei para o Mailchimp, vamos examinar os componentes desta documentação. Veja o que você deve incluir ao projetar a sua persona.

_**Nome da marca:**_ O nome da sua empresa ou serviço

_**Resumo:**_ Um pequeno resumo da personalidade de sua marca. O que faz com que a personalidade de sua marca seja única?

_**Imagem da Personalidade:**_ É a imagem atual de uma pessoa que incorpore as características que você deseja incluir em sua marca. Isto faz com que a personalidade fique menos abstrata. Escolha uma pessoa famosa, ou alguém que seja familiar a sua equipe. Se sua marca tem um mascote ou representante que já incorpore essa personalidade, utilize-o. Descreva os  atributos do mascote que comunique a personalidade da marca.

_**Características da marca:**_ Liste de cinco a sete características que melhor descrevam a sua marca, junto com uma característica que você deseja evitar. Isto ajuda a quem desenvolve esta persona, a criar uma personalidade mais consistente, evitando traços que levariam a sua marca na direção errada.

**_Mapa da personalidade:_** Podemos mapear personalidades através de um eixo cartesiano X/Y. O eixo X representa o grau ao qual a personalidade é hostil ou amigável; já o eixo Y  mostra o grau de submissão ou dominação.

_**Voz:**_ Se a sua marca pudesse falar, como seria?  O que ela diria? Ela falaria com uma voz popular ou mais refinada? Descreva os aspectos específicos da voz da sua marca, e como ela pode mudar em situações diversas de comunicação.  As pessoas mudam a sua linguagem e o seu tom, a fim de adequar-se a situação. Assim deve ser a voz da sua marca.

_**Exemplos de reprodução:** _Forneça exemplos de reprodução que podem ser usados em diferentes situações na sua interface. Isto ajuda os desenvolvedores  a entender como a sua persona deve se comunicar.

**_Visual léxico:_** Se você é um designer, crie este documento para si e/ou a equipe de design. Você pode criar um visual léxico do projeto da sua persona que inclui resumo de cores, tipografia e estilo visual que transmita a personalidade da sua marca. Você pode ser bem generalista nestes conceitos, ou incluir um <a href="https://www.webdesignerdepot.com/2008/12/why-mood-boards-matter/" target="_blank">mood board</a>.

**_Métodos de envolvimento:_** Descreva os métodos de envolvimento emocional que você pode usar em sua interface, para ajudar o desenvolvedor da persona  a criar uma experiência memorável.

Agora daremos uma olhada num exemplo. Como líder do desenvolvimento de experiência de usuário na Mailchimp, criei uma persona para guiar o trabalho que fizemos. Seguindo a mesma estrutura que acabamos de ver, aqui está uma versão ligeiramente abreviada do documento:

_**Nome da marca: **_MailChimp

_**Resumo:**_ Freedie Von Chimpenheimer IV é o rosto da Mailchimp e incorpora a personalidade da marca (figura 3.4). A forte estrutura de Freddie comunica o poder da aplicação, e sua aparência permite que as pessoas saibam que tipo de negócio a marca oferece.

Freddie está sempre com um sorriso gentil que acolhe os usuários e faz com que eles se sintam em casa. O estilo cartoon comunicado pela Mailchimp oferece uma experiência divertida e informal. Sim, Freddie é um macaco em estilo cartoon, e de alguma maneira ele ainda consegue ser cool. Ele gosta de piadas espirituosas, mas quando a situação é grave, ele também sabe controlar suas brincadeiras.

A Mailchimp sempre surpreende os usuários com uma mensagem surpresa, ou um link para degustar um vídeo no YouTube. A diversão está em todos os cantos, mas nunca atrapalhando a funcionalidade do site.

<img class="aligncenter" src="https://www.alistapart.com/d/personality-in-design/figure3_4.jpg" alt="" width="320" height="264" />

_Figura 3.4: Freddie Von Chimpenheimer IV, mascote da Mailchimp_

_**Imagem da Personalidade:** _Figura 3.4.

_**Características da marca: **_Divertida, mas não infantil. Engraçada, mas não pateta. Poderosa, mas não complicada. Doida, mas não doente mental. Fácil, mas não simplista. Confiável, mas não indigesta. Informal, mas não descuidada.

_**Personality map**:_ Fig 3.5

<img class="aligncenter" src="https://www.alistapart.com/d/personality-in-design/figure3_5.jpg" alt="" width="320" height="313" />

_Fig 3.5: Mapa da personalidade do Mailchimp _

_**Voz:** _A voz do Mailchimp é familiar, amigável e, acima de tudo, humana. As personalidades das pessoas por trás da marca brilham de honestidade. A voz da Mailchimp solta piadas (que você pode compartilhar com sua mãe por exemplo), conta estórias, e se comunica com um tom bem popular, daqueles que você utiliza com um velho amigo. A mailchimp utiliza contrações como “pra” em vez de “para”, pois é assim que as pessoas conversam umas com as outras. a Mailchimp usa sons como “hmmmmmm…” quando quer dizer que você está pensando demais, ou “uau, isso é impressionante!” para comunicar empatia. A forma lowercase e os botões de texto ajudam a reforçar a informalidade da marca.

_**Exemplos de reprodução:**_ Mensagem de sucesso: “Toca aqui! Sua lista foi importada!”. Mensagem de erro: “Ops, parece que você esqueceu de digitar um endereço de e-mail”. Falha crítica: “Um de nossos servidores caiu temporariamente. Nossos engenheiros já estão cuidando do caso, e voltará em breve. Obrigado pela sua paciência.”

_**Visual léxico:** Cor:_ A paleta de cores ligeiramente desaturada da Mailchimp transmite um sensação de diversão e humor. As cores são refinadas e não ultrapassam os seus limites. A Mailchimp é divertida mas também é poderosa. _Tipografia:_ A Mailchimp é simples, eficiente e fácil de usar, e sua tipografia reflete isso. Simples, sem serifa, título e corpo variam de maneira apropriada a sua escala, peso, e sua cor, comunicando a informação de forma hierárquica, fazendo com que a Mailchimp soe como algo familiar e confortável, e que seja funcional e amável ao mesmo tempo. _Notas gerais de estilo:_ Os elementos de interface são planos e simples, mantendo as coisas mais fáceis de entender, não intimidando o usuário. Texturas sutis podem aparecer em determinados locais com o intuito de aquecer o espaço e deixá-lo mais humano. Freddie deve ser usado com moderação, e unicamente para interpor um pouco de humor. Freddie nunca dá feedbacks da aplicação, estatísticas, ou ajuda nas tarefas.

_**Métodos de envolvimento:** Surpresa e alegria:_ Telas temáticas de login comemoram feriados, eventos culturais ou uma pessoa querida. Easter eggs (telas/mensagens surpresa) criam momentos inesperados de humor que podem transmitir nostalgia ou uma referência a cultura pop kitsch.

_Antecipação:_ No topo de cada página, Freddy faz saudações randômicas e engraçadas, gerando uma antecipação em carregar a próxima página. Esses cumprimentos nunca dão informações ou feedbacks. Eles são layers divertidos, que nunca interferem na funcionalidade ou usabilidade.

Faça o download de um template para construção de persona e o modelo do Mailchimp em <a href="https://aarronwalter.com/design-personas" target="_blank">https://aarronwalter.com/design-personas</a>. Experimente em seu projeto, ou talvez até mesmo em um redesign.

Da mesma forma que os desenvolvedores de UX deixam as personas a disposição de designers, desenvolvedores e estrategistas de conteúdo ao longo do projeto, a sua persona deve estar visível para lembrar a equipe o tipo de relacionamento que você deseja construir com seu público. As personas devem guiar todos aqueles que queiram desenvolver/alterar um pixel, um parágrafo ou esteja envolvido em qualquer processo do website.

Muitos sites já estão usando a personalidade para dar forma a experiência do usuário, e prover o sucesso em seu negócio. Embora diferentes na marca, objetivos de negócios e plataforma, A_Tapbots_, _Carbonmade_ e _Housing Works_ descobriram que a personalidade é o ingrediente chave nas conexões emocionais que estão construindo com o seu público, e em seu sucesso esmagador.

## Tapbots: robot Love

A Tapbots é fabricante de aplicativos para iPhones e criou uma personalidade distinta em sua interface, tornando diversas tarefas chatas bem mais agradáveis (Figura 3.6).

<img class="aligncenter" src="https://www.alistapart.com/d/personality-in-design/figure3_6.jpg" alt="" width="540" height="405" />

_Figura 3.6: Os apps da Tapbots são como robozinhos prontos para fazer o seu fone fazer todo o trabalho sujo._

O app convertbot, como o próprio nome diz, faz simples conversões de unidades de medidas. Já o  Weightbot ajuda os usuários a controlarem as alterações de sua massa corporal. Nenhuma dessas tarefas é muito agradável de realizar, especialmente o acompanhamento de peso, coisa que pode balançar a sua auto-estima. Mas o design dos aplicativos adquiriu um público fiel que faz deles um sucesso estrondoso.

Os aplicativos parecem ter rostos pelos quais toda a interação acontece. O painel escuro no topo parece ser inspirado nos óculos de <a href="https://pt.wikipedia.org/wiki/Kool_Moe_Dee" target="_blank">Kool Moe Dee</a>, sendo apoiados sobre um nariz pequeno e uma boca larga.

Ao contrário de outros aplicativos para iPhone, a interface parece pequenos robôs-humanos. Um robô em particular inspirou o aplicativo Tapbot. O designer Mark Jardine, que desenvolveu a personalidade da UI, diz:

_“Todo o conceito de interface do usuário foi inspirado no filme Wall-e. Nosso conceito para os dois primeiros aplicativos era de projetá-los como se fossem robôs._

_Queremos que nossos aplicativos sejam utilizados com seriedade, mas que também dê um sensação de que são mais que apenas um software. Queremos que os usuários tenham uma conexão emocional com nossos aplicativos. A maior parte das pessoas não tem amor e nem se divertem com os seus softwares (como fazem os geeks)”._

O blogueiro <a href="https://daringfireball.net/linked/2009/04/02/designing-convertbot" target="_blank">John Gruber</a> resume o sentimento do público a respeito dos aplicativos Tapbots de uma forma bem simples:

_“Eu adoro a forma e os sons desses aplicativos”._

Ironicamente, Gruber sequer menciona a funcionalidade dos aplicativos, embora a sua apreciação esteja implícita. Ele usa o termo “adoro”, ou seja, ele não apenas “gosta” do aplicativo, ele “adora”. Essas interfaces antropomorfizadas dão aos usuários a sensação de que estão interagindo com outro ser vivo com personalidade, fazendo uma possível ligação emocional. Interfaces que conseguem tocar suas emoções, de maneira eficaz, não apenas criam uma ampla base de fãs, elas constroem um exército evangelizador.

A personalidade da marca transborda no próximo exemplo. A Carbonmade consegue construir uma personalidade eficaz para sua marca, que ressoa ao seu público num mar de excentricidades.

## Carbonmade: Polvos, unicórnios e bigodes

A personalidade pode estabelecer relações com um público, desde que seja única e autêntica, mas se utilizada como um artifício, pode ter o efeito contrário, pois notarão a personalidade forjada e sem autenticidade no design e deixarão de confiar em sua marca.

A <a href="https://carbonmade.com/" target="_blank">Carbonmade</a> é um pequeno e inteligente aplicativo que ajuda as pessoas a desenvolver portfólios elegantes, e expressa a sua personalidade em todo o seu site, combinando a seriedade de <a href="https://pt.wikipedia.org/wiki/James_Stewart" target="_blank">Jimmy Stewart</a> com o charme cômico de [Eddie Izzard][1]. Polvos e unicórnios brincam em sua paisagem fantástica (ver figura 3.7), o que é atípico  para um site com foco em conversão.

<img class="aligncenter" src="https://www.alistapart.com/d/personality-in-design/figure3_7.jpg" alt="" width="540" height="567" />

_Figura 3.7: A Carbonmade usa uma personalidade exagerada para atrair novos usuários_

Esta personalidade excêntrica e livre, é conjurada pelo seu criador, o designer Dave Gorum, e como se vê, incentiva designers e artista a se cadastrarem. Gorum explica:

_“Minha regra é adicionar diversão até o ponto de distração da mensagem. __Mantendo coisas informais e malucas, fica bem mais fácil obter usuários para clicar no botão ‘Sign-up’ “._

_“A informalidade facilita muito o diálogo com nosso público.  Somos como um amigo divertido, o qual é realmente fácil de falar e que ao mesmo tempo pode montar um portfólio encantador”. _

A personalidade da marca Carbonmade cria um contraste claro para o público que tenta compará-los a concorrência. Este contraste é parte essencial do processo humano de tomada de decisão.

Embora o humor seja o ponto central da personalidade do Carbonmade, nem sempre ele é apropriado. É nosso desejo compartilhar um pouco de nós mesmos com outros que afeiçoem-se a personalidade de nosso design, e que ajude-nos a conectar-se com nosso público. Somos pessoas complexas, com uma ampla gama de emoções. Quando se trata de design emocional, necessitamos adequar a personalidade ao conteúdo e ao público.

Poucos websites fazem isto tão bem quanto o Housing Works, que estampa rostos humanos numa importante causa.

## Housing Works: Um nome com um rosto

Assim como no mundo real, nem sempre podemos pontuar a personalidade nos sites com perspicácia e humor. Certas situações exigem táticas diferenciadas. A Housing Works é uma organização sem fins lucrativos, dedicada a inspirar aidéticos em estado terminal e sem moradia. A Housing Works transforma vidas todos os dias. Suas histórias são de empatia, bondade e esperança para pessoas comuns.

Quando o estúdio <a href="https://happycog.com/" target="_blank">Happy Cog</a> fez o redesign do site em 2008 (fig 3.8), a personalidade da organização e das pessoas a quem ela auxilia foi a musa inspiradora do processo de design.

<img class="aligncenter" src="https://www.alistapart.com/d/personality-in-design/figure3_8.jpg" alt="" width="540" height="362" />

_Figura 3.8: A Housing Works constrói um vínculo emocional com o seu público, compartilhando as histórias das pessoas que ela auxilia. _

Dan Mall, lead designer da Housing Works, explica:

_“Ficou muito claro que o coração da Housing Works são as pessoas que auxiliam e são auxiliadas, que são esmagadoramente calorosas e carinhosas. Nessa direção, foi muito fácil desenvolver o site atual”._

Fotografias enormes e citações de como a Housing Works mudou a vida das pessoas, figuram de forma proeminente na home, comunicando a personalidade da organização, enquanto inspira o seu público. Rostos sorridentes e um doce ciclo de histórias pessoais ajudam o site a obter uma comunicação humana verdadeira.

As imagens moldam a perspectiva emocional do público. A proporção em que os rostos são dispostos no design encorajam uma resposta emocional do espectador, e ao mesmo tempo enfatiza a personalidade do projeto. Este recorte mais amplo da imagem enfatiza a aparência física das pessoas. As fotos na Housing Works são estrategicamente recortadas para ajudar-nos a ver a bela personalidade das pessoas representadas, tornando-nos simpáticos a sua causa.

## O Poder da Personalidade

Assim como as personalidades mudam com o contexto da comunicação na vida real, elas devem mudar conforme o design que projetamos. Para isto, não há uma solução exclusiva. Se pararmos de pensar nas interfaces como meros painéis de controle, e pensar nelas como “pessoas que o nosso público-alvo vai interagir”, podemos criar experiências emocionais mais envolventes, que deixem uma impressão duradoura.

Tenha em mente que quando você enfatiza a personalidade na experiência do usuário, algumas pessoas podem não gostar.  Mas tudo bem. Personalidades confrontam, e no caso das empresas, podem realmente ser um bom negócio. Se as pessoas não entenderem a sua personalidade, as chances são de este cliente não ser o certo para você, e no final você está evitando um futuro cliente-problema. Personalidade é um risco, mas há muitos exemplos na vida real que mostram que a recompensa vale muito a pena.

&#8212;

_Artigo original escrito por <a href="https://www.alistapart.com/authors/w/awalter" target="_blank" rel="author">Aarron Walter</a>_

_Acesse o artigo original no <a href="https://www.alistapart.com/articles/personality-in-design/" target="_blank">A List Apart</a> &#8211; Personality in Design &#8211; 18 de Outubro de 2011_

 [1]: https://en.wikipedia.org/wiki/Eddie_Izzard