---
title: O mercado de desenvolvimento front-end
authors: Diego Eis
type: post
date: 2014-08-14
excerpt: Temos um novo rockstar no palco.
url: /pensamentos-sobre-o-mercado-de-desenvolvimento-front-end/
dsq_thread_id: 2911239344
categories:
  - Artigos
  - Mercado
  - Opinião
tags:
  - dev
  - front-end
  - mercado

---
Você já deve ter notado que o mercado cresceu demais nos últimos anos. De repente, codificar HTML virou a coisa mais importante do mundo e saber JavaScript transforma você automaticamente em um rockstar.

O interesse das empresas também aumentou bastante. Empresas gringas tem buscado desesperadamente profissionais no mundo todo, inclusive no Brasil. Hoje não é muito difícil ir trabalhar em Amsterdam ou em Bangkok. A mão de obra nestes países está bem escassa. Mal sabem eles que aqui no Brasil o cenário é o mesmo: falta profissionais. Isso é bom, por um lado, pois os novatos ganham importantes oportunidades . Quem se esforça para aprender certo e rápido, se dá muito bem.

Diversos fatores contribuíram para que a revolução acontecesse e que finalmente o dev front-end se tornasse a estrela da vez. E sim, isso é uma REvolução.

## A primeira Evolução

Se você é novo na profissão, pode não ter acompanhado quando a febre dos Padrões Web contaminou todos os devs. Foi um negócio bem incrível de viver.

O cenário do desenvolvimento web naquele início era bem grotesco. Tudo estava começando e ninguém — ninguém mesmo — sabia de verdade como produzir websites. Estou falando de um mercado pós-bolha.

Os browsers eram bem ruins. O W3C era mais lerdo que uma tartaruga para avançar com as recomendações. E os desenvolvedores sofriam de todas as maneiras possíveis.
  
Produzir websites para browsers ruins e uma conexão indecente era uma aventura. É por isso que dou risada quando alguém diz que o Internet Explorer 8 é uma porcaria. Ah! Se ele soubesse como é resolver um bug para o IE3/4…

Foi nesse cenário e em plena guerra dos browsers que o WaSP surgiu. O WaSP era composto de designers e desenvolvedores que estavam cansados de produzir websites de maneira espartana. Algo precisava acontecer, precisava mudar. Tudo precisava ser derrubado para algo novo se reerguer. Eles fizeram exatamente isso. A evolução foi iniciada nas trincheiras.

Hoje o mercado está no patamar atual muito por causa da iniciativa desses poucos profissionais inconformados. Este foi um fator importante, que abriu a trilha para o caminho correto. Vamos aos outros pontos.

## O HTML 5

A forma com que as novidades do HTML foram divulgadas pelo W3C e pelo grupo WHATWG ajudaram muito a adoção e principalmente na popularidade da linguagem. Nenhuma outra versão do HTML ganhou um logo, um site para divulgação, adesivos, camisetas e etc… Toda esse campanha contribuiu para que o HTML fosse divulgado como uma linguagem séria e madura.

O WHATWG teve uma atitude muito semelhante que a do WaSP. Eles estavam cansados de esperar as decisões do W3C, que literalmente levavam anos para serem tomadas. Foi aí que um grupo de desenvolvedores resolveu iniciar por conta própria a recomendação do que seria hoje o HTML5.

As novas APIs facilitaram milhões de vezes a manipulação do DOM com JavaScript. Isso chamou a atenção de outros profissionais, como designers e desenvolvedores back-end. A partir de então tudo começou a mudar, desde o processo de desenvolvimento até a divisão de responsabilidades em projetos.

Os desenvolvedores back-end sempre tiveram o suporte de várias ferramentas que os auxiliam no desenvolvimento. Mas esse suporte praticamente não existia no mundo front-end. Me lembro da empolgação geral quando saiu uma extensão do Firefox chamada Web Developer Tools. O que nos leva a outro ponto importante: ferramentário.

## Tooling

Quem nunca ouviu falar de Yeoman, Bower, Grunt, Middleman, Jekyll, Sass, Compass, Less e uma série de outras ferramentas que facilitam o desenvolvimento diário? Depois que o Node.js surgiu, uma série de ferramentas surgiriam com ele. Outras ferramentas vieram da comunidade Ruby, suprindo uma série de outras dificuldades.

Hoje podemos automatizar tarefas com o Grunt ou Gulp, gerenciar nossas dependências com o Bower, escrever sites estáticos com Middleman e Jekyll. Há uma série de outras ferramentas que medem a performance do site, que buscam erros no seu código etc etc etc.

A falta de ferramentas era um problema grande no início. Não havia nada que nos ajudasse a escrever código de alta qualidade, apenas nós mesmos e a fiscalização dos colegas de trabalho. Fazia parecer que a área era meio amadora, sabe? Tentando fazer as coisas no achismo. Parecia que todo mundo ainda estava tentando descobrir os truques da área. Hoje é muito difícil conhecer alguém que não conheça o Inspector dos browsers ou que não use qualquer outra ferramenta auxiliar.

## O JavaScript

Mas, na minha opinião, o que fez com que pessoas olhassem o front-end de forma diferente foi o JavaScript. De uma hora para outra uma série de iniciativas envolvendo a linguagem surgiram e de repente todo mundo achava o JavaScript uma linguagem maravilhosa. Principalmente os devs back-end que tinham uma visão ruim da nossa profissão. Muitos desdenhavam porque achavam que era só escrever HTML e pintar quadradinhos com CSS.

O Node.js abriu os olhos de muita gente. Gente que não dava nada para esse mercado. Daí em diante é história.

Depois que frameworks como Angular, Ember e Backbone surgiram, a badalação em volta do JavaScript cresceu muito. Isso é bom e ruim. É muito polêmico ainda escrever JS no servidor. Em vários lugares os devs ainda estão perdidos. A iniciativa de escrever JS no servidoré algo um pouco nebuloso ainda. Desenvolvedores que não sabem lidar com a novidade, acabam fazendo projetos híbridos, construindo parte de projetos com essas tecnologias. O projeto acaba ficando estranho, onde parte é escrita em JavaScript no servidor e a outra é escrita em linguagem server-side comum. Isso por que todo mundo quer experimentar. Eu ainda acho estranho abordagens assim. Se você quer escrever JS no servidor, ele precisa ser sua linguagem principal. Oras, você nunca misturou PHP com Ruby, não é? Por que fazer parte do projeto em Ruby e apenas um pedaço JavaScript então? Mesmo assim, essa visão é meio estranha, já que nenhuma linguagem resolve todos os problemas de um projeto. 

Mesmo assim o mercado vai caminhando. Não creio que essa confusão dure muito mais tempo e que todo mundo consiga encontrar uma maneira decente de fazer o processo funcionar.

Além disso, um dev front-end não é só aquele que escreve JavaScript. Envolve muito mais. Na verdade esse é outro problema. Para mim não existe front-end, existe designer e programador. Mas deixa essa conversa para próxima.

## Aceitação do grupo

Aos poucos os front-ends foram sendo aceitos no processo e em outros meios. Essa aceitação é ótima. Existe o lado ruim sim, mas toda essa vitrine que o mercado de front-end ganhou é interessante para essa comunidade que andava pelas sombras e com vergonha de si mesmo durante anos. Esse novo ciclo é bom para aprendermos o que realmente dá resultado e como podemos formar profissionais cada vez mais importantes no processo.

É importante que os devs tenham ideia do contexto geral desse mercado para que não sejam engolidos como aconteceu anos atrás, tanto na bolha, quanto no advento dos Padrões Web.

**Artigo originalmente [escrito no meu blog][1].**

 [1]: https://medium.com/@diegoeis/sobre-o-mercado-de-desenvolvimento-front-end-7fdd918c4206