---
title: Padrões de UX do mal
authors: Dani Guerrato
paid: true
type: post
date: 2014-03-17
excerpt: Conheça as armadilhas mais comuns, por que você deve evitar estes padrões e como escapar do lado sombrio da força.
url: /padroes-de-ux-mal/
dsq_thread_id: 2428959200
categories:
  - UX
tags:
  - boas praticas
  - dark patterns
  - experiência do usuário
  - más práticas

---
Em um mundo ideal o estudo de experiência do usuário deveria servir para colocar o usuário em primeiro lugar. Mas a ganância desenfreada, a necessidade por conversões desesperadas e em muitos casos simplesmente burrice pode usar este estudo para prejudicar o usuário ao invés de ajudar. Conheça os padrões de UX do mal.

## O lado sombrio da força

Falamos muito aqui no Tableless sobre boas práticas de experiência do usuário, criados para que o mundo seja feliz, cheio de arco-íris e interfaces úteis e com curva de aprendizado baixa. Mas existem pessoas utilizando este conhecimento para ganho próprio.

E isto nem é algo difícil. Alguns conceitos de design e psicologia são bem fáceis de subverter. Quando estamos navegando na internet &#8211; devido a sobrecarga de informação e correria do dia-a-dia &#8211; nós raramente lemos as páginas. Nós escaneamos o conteúdo em busca das informações que são relevantes. Por isto textos bem estruturados vão criar divisões objetivas de conteúdo com títulos, subtítulos e imagens para que o leitor possa facilmente encontrar a informação que está buscando, botões contrastantes com legendas bem claras para ações importantes, etc. Mas é possível utilizar a mesma lógica para esconder informações importantes. Como o leitor está mais concentrado no início do parágrafo e mais desatento no fim basta enterrar informações relevantes como, por exemplo, o valor a ser debitado de um cartão de crédito bem no meio de um parágrafo. É bem mais dificil de notar, certo?

Outro conceito de usabilidade clássico é que as pessoas tendem a escolher a opção padrão. Talvez isto esteja relacionado ao paradoxo da escolha, talvez seja por que é o caminho mais fácil ou uma combinação destes dois fatores. O fato é muitas pessoas ficam com o padrão. Por isto o ideal, do ponto de vista do usuário, seria não marcar nenhuma opção automaticamente. Assim a pessoa teria que tomar ativamente a opção da escolha binária sim ou não. Mas não é bem isto o que acontece em formulários de cadastro e carrinhos de compras internet afora… Estas más práticas de UX foram criadas com o intuito de enganar o usuário para que ele realize uma ação que ele não necessariamente queria fazer.

### Se estas práticas são erradas por que você está ensinando aqui?

&#8211; É preciso conhecer e divulgar estas armadilhas para evitar que mais pessoas ou até mesmo você caia em uma delas.
  
&#8211; Todas estas práticas, embora a principio aparentem trazer conversão rápida, fazem as empresas perderem credibilidade a longo prazo pois abusam da boa fé dos usuários. É importante conhecer como funcionam estes padrões para alertar a todos sobre os riscos deste tipo de interface.
  
&#8211; Através da difusão deste tipo de informação podemos melhorar nossos próprios projetos. Afinal, você mesmo ou seus colegas podem estar utilizando um destes padrões sem saber que é prejudicial&#8230;

## Fácil de entrar, difícil de sair.

Esta tática é o equivalente a atrair um bando de gente a entrar em uma sala com uma isca como comida grátis e depois barrar a porta de saída com concreto.

Existem exemplos desta técnica aos montes:
  
&#8211; E-mail newsletter sem um link para cancelar a inscrição na lista.
  
&#8211; Forçar o usuário a enviar um e-mail de cancelamento ao invés de ter a opção online com um clique.
  
&#8211; Serviços que não possuem uma maneira simples e objetiva de encerrar a conta e apagar os dados.

Um exemplo prático deste padrão é  o [site LA Fitness][1]. Era possível se cadastrar online facilmente, mas cancelar o serviço não era tão fácil assim. Os termos em vermelho afirmam que é necessário comparecer pessoalmente ou enviar uma carta pelo correio ao menos cinco dias antes da mensalidade expirar.

[<img class="alignnone size-full wp-image-41413" alt="exemplo-cancelamento" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/03/exemplo-cancelamento.jpg" width="800" height="730" srcset="uploads/2014/03/exemplo-cancelamento.jpg 800w, uploads/2014/03/exemplo-cancelamento-184x168.jpg 184w, uploads/2014/03/exemplo-cancelamento-339x310.jpg 339w, uploads/2014/03/exemplo-cancelamento-400x365.jpg 400w" sizes="(max-width: 800px) 100vw, 800px" />][2]

E isto não acontece só em webdesign. Quem já tentou cancelar algum serviço como operadora de telefone ou cartão de crédito sabe como é o drama. A questão aqui é: vale a pena ter um usuário insatisfeito com o seu serviço só para ter um número a mais na sua lista? Estas pessoas invariavelmente vão falar mal dos seu serviços para os amigos ou através de redes sociais. Ter a saída livre pode fazer com que as pessoas tenham mais vontade de voltar. Amarrar um cliente insatisfeito não.

## Continuidade Forçada

Um exemplo de continuidade forçada são os serviços que exigem o cartão de crédito durante o período de trial apenas para &#8220;verificar a identidade do usuário&#8221; e acabam renovando a assinatura automaticamente, começando a cobrança logo apos a finalização do período de testes sem ao menos um aviso via e-mail. E como muitas vezes o usuário esquece de cancelar a assinatura, ele acaba sendo cobrado por um serviço que nem queria utilizar em primeiro lugar&#8230; Para piorar muitos destes serviços também dificultam o cancelamento, forçando o usuário a enviar um e-mail ou ligar para um telefone para parar a cobrança (com um horário de atendimento específico, logicamente). Ou seja, mesmo que o usuário lembre-se de cancelar no último dia pode ser que o processo burocrático atrase o cancelamento em algum tempinho… O que pode ser suficiente para mais um mês de cobrança no cartão de crédito.

## Opt-out

Já passou pela experiência de instalar um programa, clicar em próximo, próximo, próximo só para no final descobrir que além do software que você de fato queria instalar você acabou de levar &#8220;de brinde&#8221; um anti-vírus, barrinhas de propaganda, uma nova página inicial no seu browser, mudança do seu sistema de busca padrão e dezenas de outros plugins irritantes? Pois é, a prática de já deixar selecionado automaticamente campos de escolha pode prejudicar quem não lê direito todos os termos de serviço.

Este exemplo de [atualização do Java][3] inclui por padrão uma barra de ferramentas e mudança do mecanismo de busca.

&nbsp;

[<img class="alignnone size-full wp-image-41416" alt="exemplo-optout" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/03/exemplo-optout.jpg" width="800" height="336" srcset="uploads/2014/03/exemplo-optout.jpg 800w, uploads/2014/03/exemplo-optout-329x138.jpg 329w, uploads/2014/03/exemplo-optout-588x246.jpg 588w, uploads/2014/03/exemplo-optout-660x277.jpg 660w, uploads/2014/03/exemplo-optout-400x168.jpg 400w" sizes="(max-width: 800px) 100vw, 800px" />][4]

E não é só na instalação de softwares não. Tem muita gente fazendo isto para obrigar o usuário a assinar listas de e-mail marketing ou até para pagar por produtos e serviços que ele não estava interessado. Funciona mais ou menos assim. Primeiro eles atraem a vítima com algum conteúdo gratuito interessante, pegam todos os dados e forçam a pessoa distraída a fazer algo que não quer. E isto é algo bem comum por que as pessoas, bem, não leem atentamente tudo o que está escrito, muito menos se for uma letra bem pequenininha&#8230; Teve até uma [loja de games][5] da Inglaterra que, para provar que ninguém lê contrato, incluiu uma clausula de venda de almas como pegadinha. Mais de 7,5 mil pessoas venderam (88% dos clientes)! Este é o famoso opt-out. É como se você quisesse automaticamente algo a não ser que negasse&#8230; A boa prática neste caso é deixar o campo sem seleção (opt-in) e esperar que o usuário tome a ação ativa de comprar, consumir, baixar e assinar o seu serviço. No final do dia a empresa devolveu a alma para os clientes o que também é uma boa prática.

Existe um padrão ainda mais malvado. Clicamos em uma checkbox para dizer que &#8220;sim&#8221; e deixamos o campo sem preencher para dizer &#8220;não&#8221;. Certo? Certo? Bem, algumas pessoas invertem o processo para confundir ainda mais o usuário. Algo como &#8220;selecione uma das caixas se você NÃO quiser um dos serviços&#8221;. Uma verdadeira pegadinha do malandro de UX! Mas este exemplo do Royal Mail consegue piorar a situação ainda mais alternando entre os padrões opt-in e opt-out. Reparem que na primeira pergunta o usuário deve clicar nas caixas que ele NÃO QUER receber, e na segunda pergunta ele deve clicar em quais ele QUER.

<img class="alignnone size-full wp-image-41418" alt="exemplo-trickquestion" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/03/exemplo-trickquestion.jpg" width="800" height="336" srcset="uploads/2014/03/exemplo-trickquestion.jpg 800w, uploads/2014/03/exemplo-trickquestion-329x138.jpg 329w, uploads/2014/03/exemplo-trickquestion-588x246.jpg 588w, uploads/2014/03/exemplo-trickquestion-660x277.jpg 660w, uploads/2014/03/exemplo-trickquestion-400x168.jpg 400w" sizes="(max-width: 800px) 100vw, 800px" />

&nbsp;

Mas dá para piorar ainda mais! A [empresa Ryanair][6] escondeu a opção de cancelar o seguro em um campo com outra legenda. Quem iria pensar que a opção para descadastrar estaria no campo &#8220;selecione seu país&#8221;.

[<img class="alignnone size-full wp-image-41419" alt="exemplo-campoescondido" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/03/exemplo-campoescondido.jpg" width="800" height="433" srcset="uploads/2014/03/exemplo-campoescondido.jpg 800w, uploads/2014/03/exemplo-campoescondido-310x168.jpg 310w, uploads/2014/03/exemplo-campoescondido-572x310.jpg 572w, uploads/2014/03/exemplo-campoescondido-400x216.jpg 400w" sizes="(max-width: 800px) 100vw, 800px" />][7]

## Custos ou produtos escondidos

Esta é uma tática famosa em sites de vendas de ingressos, hotéis e passagens áreas. Eles te mostram o &#8220;melhor preço&#8221; e no carrinho aparecem diversas cobranças extras como taxas de conveniência, encargos e impostos. E ainda por cima tentam empurrar itens extras como seguros. O valor da compra pode até dobrar na hora do check-out. Ao colocar estes valores apenas após um cadastro o serviço impede que o usuário possa fazer uma pesquisa de comparação de preços efetiva. O tal do &#8220;melhor preço&#8221; as vezes é igual ou maior que o do concorrente e foi apenas maquiado para parecer menor. Outra prática que se enquadra nesta categoria é acrescentar, sem a autorização ou conhecimento do usuário, itens ao carrinho final. O eCommerce [Comet][8] adiciona automaticamente um acessório quando o usuário coloca um iPad no carrinho.

[<img class="alignnone size-full wp-image-41424" alt="exemplo-carrinho" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/03/exemplo-carrinho.jpg" width="800" height="500" srcset="uploads/2014/03/exemplo-carrinho.jpg 800w, uploads/2014/03/exemplo-carrinho-268x168.jpg 268w, uploads/2014/03/exemplo-carrinho-496x310.jpg 496w, uploads/2014/03/exemplo-carrinho-400x250.jpg 400w" sizes="(max-width: 800px) 100vw, 800px" />][9]

&nbsp;

## Subvertendo a lei da proximidade

Você acabou de relacionar o título a este parágrafo pela proximidade dele em relação a este bloco de texto. Isto só acontece por conta do que, nos estudos de teoria da percepção aplicado ao design, chamamos de &#8220;lei da proximidade&#8221;. Esta lei dita que objetos próximos são agrupadas visualmente e tendem a ser percebidos como parte de um todo. Basicamente se está perto, faz parte de um conjuntinho. E isto pode ser utilizado para enganar os usuários… como ao colocar um telefone próximo ao endereço e descrição de uma empresa. A tendência de associar os dados nos leva a crer que aquele número é relacionado aquela empresa. Certo?

Bem, neste [caso da hotels.com][10] o telefone não é o do hotel descrito e sim o do próprio hotels.com. O que forçaria o usuário a realizar a reserva através do serviço site e não diretamente com o hotel.

[<img class="alignnone size-full wp-image-41425" alt="exemplo-proximidade" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/03/exemplo-proximidade.jpg" width="800" height="500" srcset="uploads/2014/03/exemplo-proximidade.jpg 800w, uploads/2014/03/exemplo-proximidade-268x168.jpg 268w, uploads/2014/03/exemplo-proximidade-496x310.jpg 496w, uploads/2014/03/exemplo-proximidade-400x250.jpg 400w" sizes="(max-width: 800px) 100vw, 800px" />][11]

## Jogar uma isca… e mudar o foco

E a tática de prometer conteúdos para depois empurrar outro serviço não é utilizada apenas para termos de contrato não. Pode ser algo relativamente inofensivo (mas ainda extremamente antiético), como atrair as pessoas com um vídeo que em seguida postar propagandas no mural do Facebook sem a autorização do usuário como nesta [campanha da Nike][12].

Isto afasta os usuários. As pessoas ficam com medo de interagir com a sua marca pois não sabem o que vai acontecer ao curtir ou fornecer dados de redes sociais via login.

Mas pior do que isto é prometer acesso gratuito e cobrar depois do cadastro. Este modelo já é manjado na industria de jogos casuais e está pipocando também em sites de prestação de serviços. O site [TheLadders][13] promete acesso gratuito a vagas de emprego com salários super altos…

[<img class="alignnone size-full wp-image-41429" alt="theladders-1" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/03/theladders-1.jpg" width="800" height="500" srcset="uploads/2014/03/theladders-1.jpg 800w, uploads/2014/03/theladders-1-268x168.jpg 268w, uploads/2014/03/theladders-1-496x310.jpg 496w, uploads/2014/03/theladders-1-400x250.jpg 400w" sizes="(max-width: 800px) 100vw, 800px" />][14]

E depois cobra para acesso aos conteúdos.

[<img class="alignnone size-full wp-image-41430" alt="theladders-2" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/03/theladders-2.jpg" width="800" height="500" srcset="uploads/2014/03/theladders-2.jpg 800w, uploads/2014/03/theladders-2-268x168.jpg 268w, uploads/2014/03/theladders-2-496x310.jpg 496w, uploads/2014/03/theladders-2-400x250.jpg 400w" sizes="(max-width: 800px) 100vw, 800px" />][14]

E a pegadinha dupla! As vagas de emprego são acessados externamente através de um iFrame. Ou seja, é um conteúdo que sempre esteve gratuito na internet…

[<img class="alignnone size-full wp-image-41431" alt="theladders-3" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/03/theladders-3.jpg" width="800" height="500" srcset="uploads/2014/03/theladders-3.jpg 800w, uploads/2014/03/theladders-3-268x168.jpg 268w, uploads/2014/03/theladders-3-496x310.jpg 496w, uploads/2014/03/theladders-3-400x250.jpg 400w" sizes="(max-width: 800px) 100vw, 800px" />][14]

Outro padrão do mal é inverter a posição de botões. O [aplicativo Days][15] coloca a opção pular sempre ao lado direito e na ultima etapa muda o botão para a esquerda, fazendo o usuário desatento enviar spam para todos os amigos.

[<img class="alignnone size-full wp-image-41433" alt="exemplo-mudanca" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/03/exemplo-mudanca.jpg" width="800" height="349" srcset="uploads/2014/03/exemplo-mudanca.jpg 800w, uploads/2014/03/exemplo-mudanca-329x143.jpg 329w, uploads/2014/03/exemplo-mudanca-588x256.jpg 588w, uploads/2014/03/exemplo-mudanca-660x287.jpg 660w, uploads/2014/03/exemplo-mudanca-400x174.jpg 400w" sizes="(max-width: 800px) 100vw, 800px" />][16]

## Botões e anúncios disfarçados

Odeio sites que mendigam likes no Facebook em uma janela modal antes do carregamento do conteúdo. O que passa na minha cabeça é algo como &#8220;Eu nem ao menos conheço você e você já quer que eu curta seu serviço?&#8221;. É como ter um estranho na rua pedindo para ser seu melhor amigo. A minha ação imediata sempre que isto acontece é clicar no xis para fechar da janela, escapar daquela situação ridícula e ver logo o conteúdo. Qual foi a minha surpresa ao ler um artigo em um site aleatório em descobrir que clicar no xis para fechar a janelinha… curtia o conteúdo! Foi um combo de práticas enganosas: invasão da privacidade ao utilizar redes sociais sem a permissão do usuário E disfarçar botões.

Alias, esta história de disfarçar botões está ficando cada vez mais comum. Você já deve ter visto algo disto por aí em sites de upload de arquivos gratuitos, por exemplo. É facinho subir um arquivo, difícil é saber que botão faz o download e que botão abre o anúncio de gosto duvidoso. Será que você consegue encontrar qual é o botão de download verdadeiro quando todos os botões tem o mesmo rótulo?

[<img class="alignnone size-full wp-image-41422" alt="exemplo-download" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/03/exemplo-download.jpg" width="800" height="570" srcset="uploads/2014/03/exemplo-download.jpg 800w, uploads/2014/03/exemplo-download-235x168.jpg 235w, uploads/2014/03/exemplo-download-435x310.jpg 435w, uploads/2014/03/exemplo-download-400x285.jpg 400w" sizes="(max-width: 800px) 100vw, 800px" />][17]

Ou artigos com links que você pensa que levam para um conteúdo relacionado relevante, mas são apenas anúncios disfarçados. Tudo isto para ganhar alguns centavos de um anunciante que, sem duvida nenhuma, está perdendo dinheiro e ganhando antipatia dos usuários.

## Por que estas práticas não funcionam

Pessoas irritadas são menos propensas a voltar. A tendência é que, uma vez percebido o modelo enganoso, os usuários busquem alternativas mais honestas. Entender a motivação e objetivos dos seus clientes (e futuros clientes) é uma maneira muito mais efetiva de aumentar os ganhos do seu serviço e trazer benefícios para as duas partes. Mais importante do que ter simplesmente um número maior de conversão é ter pessoas efetivamente felizes com o seu serviço.

### Nem tudo é preto-e-branco

Existem muitos tons de cinza entre uma abordagem 100% honesta e reta e um comportamento necessariamente &#8220;do mal&#8221;. As vezes o uso destes padrões não parte de uma malicia genuína e sim da falta de planejamento da interface. O melhor jeito de combater a ignorância é com conhecimento. Não devemos apenas julgar e apontar o dedo, mas questionar o tempo todo se estamos também conduzindo nossos negócios de maneira ética e transparente. Ser claro e objetivo em cobranças, oferecer opções para que o usuário tome decisões conscientes e não barrar a saída são princípios básicos para um bom relacionamento a longo prazo.

## Conhecer e denunciar este tipo de prática pode ter um efeito positivo

O site [darkpatterns.org][18] criou um espaço para as pessoas catalogarem este tipo de caso e conscientizar usuários e empresas. O site foi criado em 2010 como um showcase destes padrões do mal. Alias, as imagens de exemplos utilizados neste post foram retiradas de lá. Nem todas são atuais, mas servem para ilustrar o que não fazer! Sabe o caso do Ladders.uk que acabamos de comentar? Foi uma das empresas que se retratou publicamente e modificou a interface depois das críticas no site. Sempre dá tempo de se juntar ao lado da luz da força.

### Saiba Mais

[DarkPatterns][19]
  
[Dark patterns &#8211; Deception vs. Honesty in UI Design][20]
  
[Dark patterns in UX][21]
  
[UX Dark Patterns][22]
  
[Dark Patterns an overview for brand owners][23]

 [1]: https://darkpatterns.org/wired-co-uk-december-2010/ "LA Fitness"
 [2]: https://darkpatterns.org/wired-co-uk-december-2010/
 [3]: https://darkpatterns.org/java-update-february-2014/ "Dark Patterns - Java"
 [4]: https://darkpatterns.org/java-update-february-2014/
 [5]: https://meiobit.com/64608/alma-dos-consumidores-pertence-a-gamestation/ "Alma dos consumidores pertence a gamestation"
 [6]: https://darkpatterns.org/ryan-air-trick-insurance-opt-out-trick-question-august-2010/ "Dark Patterns - Ryanair"
 [7]: https://darkpatterns.org/ryan-air-trick-insurance-opt-out-trick-question-august-2010/
 [8]: https://darkpatterns.org/comet-co-uk-august-2010/ "Dark Patterns - Comet"
 [9]: https://darkpatterns.org/comet-co-uk-august-2010/
 [10]: https://darkpatterns.org/hotels-com-contact-phone-number-may-2013/ "Dark Patterns - hotel.com"
 [11]: https://darkpatterns.org/hotels-com-contact-phone-number-may-2013/
 [12]: https://darkpatterns.org/nikes-world-cup-2010-facebook-advert-may-2010/ "Dark Patterns - Nike"
 [13]: https://darkpatterns.org/theladders-co-uk-september-2010/ "The Ladders"
 [14]: https://darkpatterns.org/theladders-co-uk-september-2010/
 [15]: https://darkpatterns.org/days-am-app-november-2013/ "Dark Patterns - Days"
 [16]: https://darkpatterns.org/days-am-app-november-2013/
 [17]: https://darkpatterns.org/softpedia-com-july-2010/
 [18]: https://darkpatterns.org "darkpatterns.org"
 [19]: https://darkpatterns.org/ "DarkPatterns"
 [20]: https://alistapart.com/article/dark-patterns-deception-vs.-honesty-in-ui-design "Dark patterns deception vs. honesty in ui design"
 [21]: https://www.slideshare.net/Nomensa/dark-patterns-in-ux "Dark Patterns in UX"
 [22]: https://www.slideshare.net/harrybr/ux-brighton-dark-patterns "UX Dark Patterns"
 [23]: https://www.slideshare.net/harrybr/dark-patterns-an-overview-for-brand-owners "Dark Patterns an overview for brand owners"