+++
authors = "Diego Eis"
categories = ["carreira", "opinião"]
date = "2018-08-06T08:08:00+00:00"
publishdate = "2018-08-06T08:08:00+00:00"
excerpt = "Pessoas diferentes para momentos diferentes no processo de desenvolvimento."
image = "https://i.imgur.com/hntFZME.jpg"
tags = ["mercado"]
title = "Os dois front-ends: designer e engineer — Parte 2: Os dois perfis"
type = "post"

+++
_Escrevi esse artigo ouvindo essa música. Ouça enquanto lê:_
[**_The Showman (Little More Better)-U2_**](https://medium.com/r/?url=https%3A%2F%2Fopen.spotify.com%2Ftrack%2F20H1SrXMaUP5lPKtHCmVPs%3Fsi%3D7qW5-qo_R06u_bmaaK4xzg)

***

A [primeira parte desse artigo](https://tableless.com.br/os-dois-tipos-de-front-end-design-e-o-engineer-parte-1-uma-breve-historia/ "Primeira parte do artigo. São 3 partes.") foi destinado a falar um pouco sobre **como a interação do back-end e front-end mudou com o passar do tempo** e foi se adaptando de acordo com o avanço das tecnologias e ferramentas usadas no dia a dia no desenvolvimento de software para internet.

Além disso, vimos que por conta dessas mudanças, embora a relação dos back-ends e front-ends tenha melhorado, **surgiram no client-side outras complexidades que antes era resolvidas apenas no lado do servidor**. Isso fez com que surgissem dois perfis de front-end no mercado: um perfil que tem mais facilidade e é mais responsável pela parte de interface de usuário. E outro perfil mais responsável pela parte funcional e estrutura técnica do sistema.

Nesse artigo quero falar um pouco sobre esses dois perfis. Vamos começar pelo front-end designer.

### O front-end designer

**É o/a front-end que tem um apelo para o visual mais aguçado** que front-end engineer e o back-end. Ele não é um designer, mas estuda o assunto como se fosse um. Geralmente ele não é capaz de criar designs complexos desde o início ou dar a direção visual para o projeto. Contudo, tendo uma direção, ele sabe replicar exatamente o que foi definido pelo guide visual, tendo o discernimento correto sobre como usar cada um dos princípios definidos.

Alguns assuntos que esse profissional domina e se interessa:

* Grid;
* Interface para Mobiles (responsive, adaptativo, user behaviour etc);
* Arquitetura de Informação;
* Teoria e uso das cores;
* Motion design;
* User Experience / Research;
* Design de Interfaces / User Interface;
* Funil e fluxos de usuários;
* Design systems;
* Prototyping e suas ferramentas;
* Atomic Design e outros conceitos;
* Manipulação de SVG seja para fazer animação ou exibição de ilustrações;
* Manipulação de WebGL, talvez não profundamente, mas entende suas manipulações;
* Ferramentas como Sketch, Photoshop, Illustrator, Studio…

_Faça um exercício tentando lembrar outros conceitos e técnicas que esse perfil deve saber._

O front-end designer é um perfil que vai manjar muito da parte técnica de CSS, HTML e Javascript para manipulação de interface.

> A front-end designer (who may also go by UI developer, client-side developer, UI engineer, design engineer, front-end architect, designer/developer, prototyper, unicorn, or Bo Jackson) lives in a sort of purgatory between worlds. — **_Brad Frost_**

O ideal seria que esse perfil soubesse bastante sobre frameworks como o React, que se foca em manipulação de componentes e seus estados. Mas não é a realidade. Ele sabe o suficiente para aplicar a interface e até manipular o estado dos componentes, **mas ele _não_ vai querer escrever código JS a nível de aplicação, muito menos código back-end, contudo, ele sabe como as coisas funcionam debaixo do capo.**

Ele define junto com os designers padrões de uso de componentes, design systems, padronização visual e de comportamentos se estabelecendo assim **como a parte técnica de código do designer.**

### O front-end engineer

Esse perfil está mais próximo da lógica.

Ele manja pouco de CSS, sabe bem HTML, mas onde ele se destaca é na parte de aplicação, sendo mestre em JS — e aqui leia NodeJS, ReactJS, VueJS e qualquer outra coisa assim.

Embora não seja especialista em linguagens de servidor, ele procura aprender o máximo e até tem conhecimentos em uma ou outra linguagem back-end. Já trabalhei com devs front-end que poderiam até ser considerados back-ends junior/pleno por causa do seu conhecimento na linguagem de servidor que ele lidava todos os dias na empresa.

Algumas responsabilidades e interesses desse perfil:

* Lidar com o back-end a fim de definir padrões da API;
* Definir arquitetura de client-side;
* Definir as regras de negócio e lógica pelo lado do client;
* Responsável por gerenciar a segurança e comunicação entre client e servidor;
* Testes unitários, testes end-to-end, testes testes testes e suas ferramentas;
* Bancos de dados;
* Servidor e suas particularidades;
* Containers;
* Continuous Delivery/Integration;

**Cabe dizer que esse dev é um programador acima de tudo.** Embora ele goste mais ou tenha mais familiaridade com tecnologias que tem o Javascript como base (por exemplo o NodeJS), ele tem facilidade de aprender novas linguagens de servidor e tem um pensamento muito lógico.

![](https://cdn-images-1.medium.com/max/1000/1\*JeGEj0TnKnex-ThfkXcB7g.png)

Quando temos um dev front-end designer no meio de desenvolvedores que não tem esse perfil.

É muito comum que esse tipo de profissional acabe migrando para desenvolvimento back-end. E é aí que entramos em outro ponto importante.

### Ainda faz sentido essa divisão?

Não é incomum vermos que muitos back-ends estão se preocupando em aprender mais sobre NodeJS e outras tecnologias mais comuns para desenvolvedores front-end engineers. **Começamos a ver surgir um terceiro perfil, que é uma espécie de back-end que conhece e até se especializa em tecnologias como NodeJS, React, Angular e conseguem fazer a camada lógica do JS com facilidade.**

Também está se tornando cada vez mais comum — não na velocidade saudável e ideal para pegar tração — encontrarmos designers que aprenderam a codar HTML/CSS para materializar seus próprios layouts.

![](https://cdn-images-1.medium.com/max/1000/1\*uDDA28iT0vKm2v-QkA_U0g.png)

É importante que os designers consigam simpatizar com o código front-end para interface.

**Existem perfis de designers e fronts que transcenderam tanto os limites, que é difícil categorizá-los da forma que conhecemos hoje**. Veja o [Meng To](https://medium.com/@mengto). Ele é um designer que manja de HTML/CSS/JS, que ensina React e está se metendo a fazer coisas com Realidade Aumentada manipulando o ARKit da Apple. Esse tipo de profissional é extremamente raro no mercado.

> **_Os dois perfis de front-end acabam se categorizando em duas grandes áreas: designing e programming._**

Contudo, conheço alguns designers brasileiros que conseguem tranquilamente implementar seus layouts para código front-end, como é o caso do [Maurivan Luiz](https://medium.com/@maurivan), [Luis Vilela](https://medium.com/@vilela) e outros. Embora não seja o trabalho do dia a dia deles, e por causa disso não tem a facilidade que um front-end experiente tem, eles conseguem facilmente chegar no nível de prototipar suas hipóteses e ir mais além.

![](https://cdn-images-1.medium.com/max/1000/1\*dFQotHXacgbUruHOYTxvfg.png)

Há [muito tempo atrás eu fiz uma palestra](https://medium.com/r/?url=https%3A%2F%2Fwww.slideshare.net%2Fdiegoeis%2Fux-and-frontend) onde eu explicava sobre como o dev front-end podia ajudar e também influenciar o trabalho rotineiro de designers e back-ends. Lá eu divagava exatamente sobre esse assunto que abordamos aqui, mostrando que **os dois perfis de front-end acabam se categorizando em duas grandes áreas: designing e programming.**

Dentro dessas duas áreas já existem uma série de divisões de responsabilidades exercidos por pessoas com perfis bem diferentes. O front-end é absorvido nesses dois contextos como mais um perfil importante para levar um ponto de vista que faltava tanto para designers quanto para programadores.

### Onde você se encontra?

E essa é uma pergunta que você mesmo deve se responder. Se você sente que tem mais facilidade lógica, que consegue entender bem os meandros dos trabalhos feitos no servidor, que consegue absorver bem assuntos sobre banco de dados, que curte um pouco do trabalho de devops, operações e outras áreas mais técnicas, talvez você possa tentar ser um front-end engineer.

Se você já tem o olhar para o belo, tem a facilidade para entender o usuário, fluxos, sistemas de design, ergonomia, tipografia, cores e que sente prazer em implementar layouts bonitos e bem acabados, que fazem os usuários realmente gostarem de usar o sistema construído: talvez seja interessante você se embrenhar mais no mundo do design.

Lembre-se, isso não quer dizer que você tenha se tornar um designer ou um desenvolvedor back-end. Pelo contrário. O designer e o back-end exercem apenas uma das responsabilidades dentro das suas categorias principais de atuação.

Quais as oportunidades que existem? Você vai conseguir responder se experimentar.

***

### Para ler mais:

* [https://bradfrost.com/blog/post/frontend-design/](https://bradfrost.com/blog/post/frontend-design/ "https://bradfrost.com/blog/post/frontend-design/")
* [https://blog.salsitasoft.com/the-shifting-definition-of-front-end-developer/](https://blog.salsitasoft.com/the-shifting-definition-of-front-end-developer/ "https://blog.salsitasoft.com/the-shifting-definition-of-front-end-developer/")
* [https://bradfrost.com/blog/post/development-is-design](https://bradfrost.com/blog/post/development-is-design "https://bradfrost.com/blog/post/development-is-design")
* [https://medium.freecodecamp.org/how-i-landed-a-full-stack-developer-job-without-a-tech-degree-or-work-experience-6add97be2051](https://medium.freecodecamp.org/how-i-landed-a-full-stack-developer-job-without-a-tech-degree-or-work-experience-6add97be2051 "https://medium.freecodecamp.org/how-i-landed-a-full-stack-developer-job-without-a-tech-degree-or-work-experience-6add97be2051")