---
title: Você conhece o Framework brasileiro Maestro?
authors: Daniel Schmitz
type: post
date: 2015-04-27
url: /voce-conhece-o-framework-brasileiro-maestro/
categories:
  - Código
  - PHP
tags:
  - componentes
  - frameqork
  - mvc
  - php

---
Aqui em nossa Universidade tivemos o privilégio de poder construir um framework quase que do zero, adaptado inicialmente às nossas necessidades. Tínhamos como desafio criar uma ERP acadêmica, caminho este que temos percorrido desde 2002. São quase 13 anos de muita experiência e dedicação, e neste ano de 2015 estamos contribuindo (ou tentando) disponibilizando o framework para a comunidade. Sabemos que não basta apenas disponibilizar o código fonte, mas precisamos também criar artigos e prover suporte para que todos possam se beneficiar deste framework.

## Vamos então falar um pouco do Maestro Framework

O Maestro é um framework MVC em PHP (5.4 ou superior). Suporta os bancos de dados Oracle, Mysql, PostgreSQL, Sqlite. Ele é compatível com o Firefox/Safari/Chrome. A principal característica do framework é que ele foi concebido para o desenvolvimento de software exclusivamente. Se você pretende criar um blog ou um site, existem frameworks melhores por aí. Quando falamos em software, estamos abordando a criação de formulários, a entrada de dados, o processamento deles e posteriormente a sua saída seja em forma de relatórios (PDF) ou gráficos. Estamos sempre voltados a criação de software, pois é a nossa necessidade básica atualmente.

## Quer ver uma demo!

É claro que quando apresentamos uma tecnologia nova, é melhor dar uma &#8220;espiada&#8221; no seu funcionamento antes de partir para qualquer informação mais profunda. Vou deixar dois links a seguir para que você possa acessar e ver:

  * <https://www.danielschmitz.com.br/maestro/index.php/guia/main> Este é um guia que criamos com diversas informações sobre o framework. Você pode consultá-lo sempre que quiser. Se for seu desejo continuar a estudar o framework, este guia contém informações importantes.
  * <https://www.danielschmitz.com.br/maestro/index.php/exemplos/main> Aqui temos diversos exemplos tanto de componentes quanto de fluxo e utilidades em geral. Alguns exemplos contém erros e estamos empenhados em saná-los.

## Github & Instalação

Estamos exportando o framework para o Github. Inicialmente ele estava alocado no SVN da nossa instituição e sabemos que ele deve estar no Github para uma melhor distribuição do código. O endereço é:

<https://github.com/frameworkmaestro/maestro/releases/tag/v1.0>

Para executar o framework no seu computador, basta fazer o download do zip e colocar a pasta _maestro_ no seu diretório web. Também pode-se clonar o projeto diretamente do master, caso deseje.

Neste artigo estamos usando o WAMP SERVER para facilitar, então basta baixar o Maestro e colocá-lo na pasta **c:\wamp\www,** conforme a imagem a seguir:

[<img class="alignnone size-full wp-image-48348" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/04/004.png" alt="004" width="522" height="460" />][1]

Com o maestro no lugar certo, basta acessar:

https://localhost/maestro/

Para ver o mesmo guia online que disponibilizei no início do artigo. Se quiser ver os exemplos diretamente da sua instalação, basta acessar:

https://localhost/maestro/index.php/exemplos/main

Se tudo funcionou, estamos prontos para começar a entender melhor o framework, no qual veremos mais informações no próximo artigo! Qualquer dificuldade ou dúvida, comente!

Até a próxima pessoal!

 [1]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/04/004.png