---
title: O SEO moderno e o foco no usuário
authors: Douglas Faria
type: post
date: 2013-08-20
excerpt: Faça um bom SEO focando-se no usuário.
url: /o-seo-moderno-e-o-foco-no-usuario/
dsq_thread_id: 1614094532
categories:
  - SEO
tags:
  - 2013
  - experiência do usuário
  - SEO
  - usuarios

---
Google força Analistas de SEO a se especializarem cada vez mais no intuito de aumentar o foco no usuário e melhorar a qualidade do conteúdo oferecido em suas buscas.

O mercado de SEO vem sofrendo algumas mudanças ao longo dos últimos anos e isso se deve à persistência do Google em oferecer buscas cada vez melhores aos usuários. Assim, fica fácil perceber qual deve ser o seu foco principal para atingir conversões e ter sucesso nas campanhas de SEO: O usuário!

É imprescindível que você crie conteúdos relevantes, porém aquela onda de se preocupar em popular o conteúdo com keywords e outras práticas do tipo acabaram. Agora, você precisa criar facilitadores no seu site, ser mais claro e objetivo e focar em um marketing mais personalizado.

Pensando nisso, segue algumas dicas e observações pontuais para ajudar você a desenvolver melhores estratégias de otimização.

## Relacionamento e mídias sociais

É importante abrir um canal de comunicação para interagir com o cliente. Se você não tem, abra um. O uso das redes sociais vem se expandindo, mas é preciso entrar de cabeça e oferecer atenção aos seus seguidores e clientes. Pensando nisso, crie relacionamentos, fidelize o usuário e traga ele até você com conteúdo útil e interessante. Isso será um grande diferencial.

**Dica:** Aumente sua presença do Google +. Isso não é oficial, mas existe uma tendência muito forte de que o Google irá dar (ou já está dando ;)) relevância ao famoso +1.

## Vídeos

O Google vem dando muita importância para a otimização utilizando vídeos no conteúdo, ainda mais agora com as rich snippets, é interessante criar vídeos e associá-los ao conteúdo das páginas, isso traz mais interatividade.

## Pensar como usuário

Essa é uma grande sacada para planejar bem sua campanha. Pensar como alguém que irá fazer o que você está planejando é essencial para obter sucesso. O usuário quer se sentir satisfeito. Seja com a informação obtida em um artigo, com a compra fácil e segura, com a boa experiência na navegação, etc. Evite induzir de forma agressiva o seu visitante. Descubra a sua necessidade e ofereça a ele a solução.

## Pensar como o buscador

Se você fosse o Google e alguém te pedisse para buscar um bom texto sobre “como obter bons resultados com SEO” você provavelmente iria olhar no seu índice um conteúdo diferenciado para o seu leitor. É de extrema importância ajudar os buscadores e desenvolver conteúdo relevante. Evitar Keyword Stuffing e afins é obrigação, mas entender como funcionam as buscas e os fatores de rankeamento são essenciais para o bom desenvolvimento da campanha.

Por isso, capriche nas práticas Onpage e no seu Link Building e estruture bem o seu HTML, trabalhe a semântica, enfim, faça um bom trabalho!

## Uma boa navegação faz o seu conteúdo aparecer

Faça o conteúdo aparecer. Mostre ao usuário que você tem a solução para o “problema” dele e não uma nova forma dele gastar dinheiro. Desenvolva uma boa arquitetura, com estruturas de links fáceis e títulos bem feitos é uma boa opção para mostra-lo que o seu serviço/produto vale o investimento, seja qual for.

## Qualidade x Quantidade

Antes de ter muito é preciso ter qualidade. O seu conteúdo tem que pensar em ajudar e atender às necessidades de quem está buscando por aquilo. Cabe a você usar boas estratégias de webwrinting para otimizá-lo. Tente unir os dois e você terá grandes resultados. Mantenha o foco no usuário e pense estrategicamente. Sabendo dessa regra, você pode aumentar o volume de informações no seu site e isso atrai visitantes!

## Conclusão

O Google está cada vez mais atento ao conteúdo dos sites para oferecer algo útil aos seus visitantes (que podem ser seus futuros clientes).
  
Seus algoritmos de busca estão mais eficientes e, hoje, já existem algoritmos contra Black-hat, monitoramentos mais eficazes e diversos motivos para você se especializar e fazer um trabalho de qualidade.

Mantenha o foco no usuário e pense em oferecer a ele o que há de melhor. A partir disso seu trabalho ficará mais fácil! As práticas de SEO continuam, mas sobressaem aqueles que mesclam a criatividade com o conhecimento.