---
type: post
title: O que Hollywood pode ensinar sobre experiência do usuário (UX)?
excerpt: >-
  Muitos designers cometem o erro de achar que, para qualquer produto que estão
  projetando, os usuários seguirão os fluxos de tarefas, estruturas
  organizacionais e nomenclaturas que lhes foi imposta, perfeitamente e sem
  hesitação. 
authors: Tableless
date: '2019-05-01'
publishDate: '2019-05-01'
image: 'https://i.imgur.com/zNGJDkN.png'
categories:
  - Publieditorial
tags:
  - ux
---
Nós, humanos, somos criaturas imperfeitas por natureza emocional. Muitos designers cometem o erro de achar que, para qualquer produto que estão projetando, os usuários seguirão os fluxos de tarefas, estruturas organizacionais e nomenclaturas que lhes foi imposta, perfeitamente e sem hesitação. Isso força os usuários a se adaptarem ao modo de pensar do designer, e não o contrário. Nesse contexto, sites como [https://www.moneyman.com.br/](https://www.moneyman.com.br/) e outros se destacam pela sua fácil usabilidade.

Indo na contramão, inúmeras aplicações e experiências digitais colocam o fardo de atenção e esforço no usuário. Como usuário, você acaba fazendo grande parte do trabalho. Você acaba tendo que:

* Percorrer essa longa lista de funções no menu suspenso para descobrir qual delas se aplica a você;
* Passar por dez telas de conteúdo para encontrar o aplicativo que você realmente deseja;
* Fazer várias pesquisas e telefonemas para encontrar outra maneira de chegar em casa quando a companhia aérea cancelar o seu voo sem nenhuma alternativa.
* Em todos esses casos, embora a tecnologia e os algoritmos inteligentes estejam implicitamente presentes, eles ainda não estão ajudando o usuário.

![](/images/uploads/screen-shot-2019-10-23-at-06.47.46.png)

## O que Hollywood pode nos ensinar

Mesmo na Hollywood futurista, a experiência do usuário geralmente é chamativa, mas não muito utilizável. O filme Minority Report é frequentemente citado pela introdução de uma interface exuberante baseada em gestos. Como protagonista do filme, Tom Cruise vive em um mundo onde todas as máquinas sabem tudo sobre ele. Ele recebe anúncios direcionados, pois simplesmente está andando pela rua. Ele é capaz de controlar e transmitir grandes quantidades de dados com gestos feitos usando luvas aparentemente mágicas — apresentadas como pontos para controlar a enorme quantidade de informações que voam pelo ar à sua frente.

Embora grande parte da tecnologia apresentada no filme — de scanners de retina a softwares de previsão de crimes — fosse presciente e só agora estejam começando a se tornar realidade, a própria interface do usuário deixa muito a desejar. Parece bom, mas o ônus da atenção e do esforço está no usuário para aprender um novo tipo de linguagem multi-toque para controlar o computador. 

Compare isso com o filme de Spike Jonze, Her. A interface entre humano e máquina é tão perfeita e sem esforço que o personagem interpretado por Joaquin Phoenix pode se apaixonar por seu sistema operacional. Seu sistema operacional está ciente do contexto de sua agenda, contatos e — através da câmera do smartphone — todas as experiências que vê. Nesse contexto, todas as sugestões se tornam mais relevantes à medida que o sistema operacional aprende mais sobre ele ao longo do tempo. É um mundo futurista com máquinas inteligentes e algoritmos preditivos, mas a tecnologia não sobrecarrega o ser humano. Em vez disso, as máquinas complementam os humanos.

A lição aqui é por que não deixar que o poder computacional de uma máquina comece a remover parte da carga sobre o usuário? Deixe o humano focar no que um humano faz melhor.

## Projetando para seres humanos

De muitas maneiras, os dados disponíveis para nós no espaço corporativo hoje são tão ricos e abundantes quanto os dados no Minority Report, mas é preciso criar uma interface acessível. Estamos tentando aproveitar o poder computacional dos algoritmos para reduzir a carga de atenção e pensamento do usuário. 

Se o Big Data mostrar seu potencial nas empresas, os criadores de tecnologia precisam garantir que os usuários de negócios possam chegar a um ponto em que possam se concentrar em fazer as perguntas e análises corretas — sem manipular manualmente os dados para que possam ser analisados. Os seres humanos têm uma tremenda capacidade de detectar padrões e insights nos dados e podem ser auxiliados pela inteligência da máquina.

Para atingir esse objetivo, existem alguns princípios fundamentais de design que se aplicam prontamente a qualquer equipe de design no espaço de dados:

## Visualmente simples e funcionalmente forte

Os analistas devem poder começar a explorar e transformar dados imediatamente. Interagir com valores reais de dados é muito mais natural que os metadados abstraídos na forma de nomes de colunas e linhas. Quando os dados são grandes demais para serem varridos em sua forma nativa, resumos visuais simples, como histogramas, podem ajudar, fornecendo visibilidade da floresta e das árvores.

## Elegância em escala

Os conjuntos de dados de hoje abrangem kilobytes a petabytes. Isso significa permitir que os analistas realizem a transformação de dados nos valores mais detalhados, além de ampliar seus recursos para trabalhar em escala. E toda essa atividade precisa ocorrer quase em tempo real, para que o usuário possa entender imediatamente o potencial resultado das transformações que estão implementando.

## Empoderamento do usuário

Cada interação deve aprimorar a experiência com os dados e fazer com que o usuário se sinta mais inteligente. Como os usuários não necessariamente sabem exatamente de antemão o que estão procurando, deve-se permite que eles repitam o processo sem penalidades por falhas ou testes de hipóteses.

Seguindo esses princípios de design, podemos nos concentrar em garantir que nossos algoritmos e poder computacional sejam alavancados a serviço da facilidade e trabalhabilidade humanas. Podemos manter as máquinas fazendo o que fazem de melhor — analisando muitos algoritmos computacionais diferentes para oferecer os melhores para nós — e manter os humanos fazendo o que fazem de melhor: reconhecendo padrões nos dados e fazendo escolhas com base no contexto completo e na conscientização de que vem com ser humano.
