---
title: O que é Usabilidade?
authors: Talita Pagani
type: post
date: 2011-08-22
excerpt: A usabilidade é apenas um dos conceitos que abrangem a experiência de uso de pessoas com produtos, tendo também algumas limitações.
url: /o-que-e-usabilidade/
categories:
  - design
tags:
  - usabilidade
  - Mercado
  - Tecnologia e Tendências
  - UX
  - experiência do usuário

---
Já vimos em um [artigo anterior][1] como a usabilidade beneficia o desenvolvimento web. Mas, o que de fato compreende a usabilidade? Nem tudo que se refere à experiência de uso está dentro do escopo dela. Sim, a usabilidade tem limitações e lacunas que são complementadas por outros paradigmas, como o design de interação. Porém, podemos considera-la a _base da pirâmide_ que sustenta o projeto de uma aplicação com boa experiência de uso.  Neste artigo, veremos brevemente o que faz parte do conceito de usabilidade e qual o papel que ela tem no processo de desenvolvimento de aplicações.

## Afinal, o que é usabilidade?

A Usabilidade é “filha” da Interação Humano-Computador (IHC) e “neta” da Engenharia de Software, carregando esse legado ao longo de sua evolução, podendo ser definida como o **grau de facilidade** com que o usuário consegue interagir com determinada interface.

Partindo da IHC, a usabilidade aborda a forma como o usuário se comunica com a máquina e como a tecnologia responde à interação do usuário, considerando as seguintes habilidades, de acordo com a norma <a title="Norma ISO 9241" href="https://en.wikipedia.org/wiki/ISO_9241" target="_blank">ISO 9241</a>:

  * **Facilidade de aprendizado:** a utilização do sistema requer pouco treinamento;
  * **Fácil de memorizar:** o usuário deve lembrar como utilizar a interface depois de algum tempo;
  * **Maximizar a produtividade:** a interface deve permitir que o usuário realize a tarefa de forma rápida e eficiente;
  * **Minimizar a taxa de erros:** caso aconteçam erros, a interface deve avisar o usuário e permitir a correção de modo fácil;
  * **Maximizar a satisfação do usuário:** a interface deve dar-lhe confiança e segurança.

<div>
  <p>
    Partindo da Engenharia de Software, a usabilidade é englobada dentro da qualidade e visa garantir uma parte da eficiência e eficácia do sistema. A eficiência refere-se a uma interação produtiva entre o usuário e o sistema, permitindo a realização de tarefas com menor esforço sob uma experiência agradável. A eficácia pode ser entendida como a capacidade do sistema e da interface possibilitarem ao usuário a completude da tarefa e o alcance de seus objetivos no sistema.
  </p>
  
  <h2>
    A importância da usabilidade no desenvolvimento de projetos
  </h2>
  
  <p>
    A usabilidade se encaixa em qualquer tipo de projeto de interface, tendo amplitude diferente de acordo com a criticidade do projeto, ou seja, quanto mais crítico for o sistema, maiores serão as perdas caso ele não seja de fácil utilização e proporcione satisfação. Ela deve ser pensada desde o planejamento do projeto, até a etapa de desenvolvimento e teste.
  </p>
  
  <p>
    As empresas têm consciência da importância da usabilidade. Porém, muitas ainda a veem como um fator que só deve ser levado em conta durante o desenvolvimento se houver tempo e recurso, como se ela representasse um custo adicional, fora do que é essencial. Mas as empresas têm muito mais a perder ao minimizar a usabilidade dessa forma. De acordo com Cybis, Betiol e Faust (2007):
  </p>
  
  <p>
    “<em>Dependendo da frequência com que o software é empregado, os prejuízos para as empresas podem também ser expressivos, não só em decorrência do absenteísmo e da rotatividade do pessoal, mas também pela baixa produtividade, competitividade e menor retorno de investimento. Sistemas difíceis de usar implicam em erros e perda de tempo, fatores que se multiplicam com a frequência das tarefas e o número de usuários. A perda de dados e informações pode implicar na perda de clientes e de oportunidades. Acontecimentos deste tipo causam desde uma resistência ao uso do sistema até a sua subutilização e abandono completo, com o devido consentimento da empresa. O barato terá custado caro.</em>”
  </p>
  
  <p>
    A usabilidade pode ser abordada de diferentes formas ao longo do projeto:
  </p>
  
  <div id="attachment_4011" style="width: 548px" class="wp-caption aligncenter">
    <a href="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2011/07/Slide1.png"><img class="size-full wp-image-4011  " src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2011/07/Slide1.png" alt="Técnicas utilizadas para garantir e verificar a usabilidade em diferentes etapas" width="538" height="403" srcset="uploads/2011/07/Slide1.png 960w, uploads/2011/07/Slide1-300x225.png 300w" sizes="(max-width: 538px) 100vw, 538px" /></a>
    
    <p class="wp-caption-text">
      Técnicas utilizadas para garantir e verificar a usabilidade em diferentes etapas
    </p>
  </div>
  
  <h2>
    Lacunas a serem preenchidas
  </h2>
  
  <p>
    Apesar de a usabilidade ser responsável por assegurar grande parte dos quesitos de experiência do usuário, ela possui duas grandes limitações:
  </p>
  
  <ol start="1">
    <li>
      Embora considere a satisfação do usuário, trata apenas dessa satisfação perante a realização de uma determinada tarefa, concentrando-se na função, sem considerar fatores físicos, ambientais e emocionais inerentes ao contexto de utilização do sistema. Mais do que ser de fácil utilização, aprendizagem e permitir completude da tarefa, uma boa experiência de uso está baseada em uma interação agradável, considerando a forma como as pessoas percebem a interação com o sistema;
    </li>
    <li>
      O contexto usualmente analisado pela usabilidade é mais restrito: abrange apenas a visão do usuário. Para garantir uma boa experiência de uso, é necessário abranger a visão de diferentes <em>stakeholders</em>: do usuário, da organização e da equipe de desenvolvimento, cada qual com requisitos e necessidades diferentes frente ao sistema.
    </li>
  </ol>
  
  <p>
    Adaptando um gráfico apresentado durante a nnGroup Conference de 2008, podemos ver a usabilidade enquadrada da seguinte forma:
  </p>
  
  <div id="attachment_4012" style="width: 586px" class="wp-caption aligncenter">
    <a href="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2011/07/Slide2.png"><img class="size-full wp-image-4012 " src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2011/07/Slide2.png" alt="O escopo da usabilidade" width="576" height="432" srcset="uploads/2011/07/Slide2.png 960w, uploads/2011/07/Slide2-300x225.png 300w" sizes="(max-width: 576px) 100vw, 576px" /></a>
    
    <p class="wp-caption-text">
      O escopo da usabilidade
    </p>
  </div>
  
  <h3>
    Referências e Leitura Complementar
  </h3>
  
  <p>
    ABRAS, C.; MALONEY-KRICHMAR, D.; PREECE, J. <strong>User-Centered Design</strong>. In: Bainbridge, W. <em>Encyclopedia of Human-Computer Interaction</em>. Thousand Oaks: Sage Publications, 2004.
  </p>
  
  <p>
    CYBIS, W.; BETIOL, A. H.; FAUST, R. <strong>Ergonomia e Usabilidade: </strong>Conhecimentos, Métodos e Aplicações. São Paulo: Novatec Editora, 2007. 344p.
  </p>
  
  <p>
    SUMATHI, B. <strong>Chapter Three: User Centered Design Approach</strong>. Disponível em: <a href="https://dspace.fsktm.um.edu.my/bitstream/1812/214/8/Chapter%20Three.pdf">https://dspace.fsktm.um.edu.my/bitstream/1812/214/8/Chapter%20Three.pdf</a>.
  </p>
  
  <p>
    NIELSEN, J.; LORANGER, H. <strong>Usabilidade na Web: </strong>Projetando Websites com qualidade. Rio de Janeiro: Elsevier, 2007. 406p.
  </p>
  
  <p>
    OLIVEIRA NETTO, A. A. <strong>IHC – Interação Humano Computador:</strong> Modelagem e Gerência de Interfaces com o Usuário. Florianópolis: VisualBooks, 2004. 120p.
  </p>
  
  <p>
    PREECE, J.; ROGERS; Y.; SHARP, H. <strong>Interaction Design: </strong>Beyond Human-Computer Interaction. New York: John Wiley & Sons, Inc., 2002. 551p.
  </p>
  
  <p>
    ROCHA, H. R.; BARANAUSKAS, M. C. C. <strong>Design e Avaliação de Interfaces Humano-Computador</strong>. Campinas: Universidade Estadual de Campinas, 2007.
  </p>
  
  <p>
    UX Revisions. <strong>The Difference Between Usability and User Experience</strong>. Disponível em: <a href="https://www.uxrevisions.com/user-experience-design/the-difference-between-usability-and-user-experience/18/">https://www.uxrevisions.com/user-experience-design/the-difference-between-usability-and-user-experience/18/</a>
  </p>
  
  <p>
    UX Revisions. <strong>User Experience vs User Interaction</strong>. Disponível em: <a href="https://www.uxrevisions.com/user-experience-design/user-experience-vs-user-interaction/16/">https://www.uxrevisions.com/user-experience-design/user-experience-vs-user-interaction/16/</a>
  </p>
  
  <p>
    Usability Geek. <strong>The Difference (And Relationship) Between Usability And User Experience</strong>. Disponível em: <a href="https://usabilitygeek.com/the-difference-between-usability-and-user-experience/">https://usabilitygeek.com/the-difference-between-usability-and-user-experience/</a>
  </p>
  
  <p>
    NeoSpot. <strong>Usability vs. User Experience (UX)</strong>. Disponível em: <a href="https://neospot.se/usability-vs-user-experience/">https://neospot.se/usability-vs-user-experience/</a>
  </p>
  
  <p>
    Interaction by Design. <strong>Usability vs. user experience</strong>. Disponível em: <a href="https://www.interactionbydesign.com/thoughts/thumbnails/00000050.html">https://www.interactionbydesign.com/thoughts/thumbnails/00000050.html</a>
  </p>
</div>

 [1]: https://tableless.com.br/estabelecendo-uma-metodologia-agil-para-avaliacao-de-usabilidade