---
title: Você sabe o que é a “nova usabilidade”? – parte II
authors: Talita Pagani
type: post
date: 2011-12-12
excerpt: A nova usabilidade procura trazer abordagens para lidar com os novos desafios para o desenvolvimento de aplicações baseadas em tecnologias emergentes, como dispositivos móveis.
url: /o-que-e-nova-usabilidade-parte2/
categories:
  - Design
  - Acessibilidade
tags:
  - Mercado
  - Mobile
  - Tecnologia e Tendências
  - UX
  - usabilidade

---
A nova usabilidade procura trazer abordagens para lidar com os novos desafios para o desenvolvimento de aplicações baseadas em tecnologias emergentes, como os dispositivos móveis.

A intenção dessa denominação é chamar a atenção para o fato de que a os métodos, técnicas e ferramentas de usabilidade que possuímos hoje precisam ser revistos para contemplar a evolução tecnológica e as especificidades dos interesses dos usuários.

## O problema com os testes de usabilidade

Os testes de usabilidade como conhecemos hoje (realizados em laboratório) passam a não ter o mesmo grau de eficiência nestes novos cenários de uso.

Testes de usabilidade geralmente são realizados sob um ambiente controlado. Os avaliadores têm controle sobre todas as variáveis (o contexto) que se refere à interação entre usuário e aplicação. No cenário real, o uso pode ser bem distinto e endereçar problemas imprevistos.

Um exemplo: um teste de usabilidade de um tablet realizado em laboratório, onde o usuário interage com o tablet em cima de uma mesa, sentado corretamente em uma cadeira. Este é o cenário real de uso? O mais comum seria o usuário utilizar o tablet nas mãos, no colo, durante uma aula, uma palestra, checando os e-mails antes de dormir, entre outros.

Entretanto, os testes de usabilidade não perderam sua relevância, apenas precisam de uma abordagem reciclada. Além disso, cada vez mais os atributos a serem avaliados passam a ser mais qualitativos do que quantitativos. Como testar a concentração de um usuário com dispositivo móvel em um cenário real de uso? Como mensurar isso?

> “A maioria dos testes de usabilidade, e experiência em design de interação, tem sido desenvolvida no contexto de uma pessoa diante de um computador, onde você tem o luxo de atenção integral da pessoa, em um ambiente confortável com distrações em um nível administrável. Dispositivos informacionais, por outro lado, precisam trabalhar em situações de baixa atenção ou onde a atenção do usuário precisa ser canalizada através do dispositivo enquanto ele caminha, fala ou realiza qualquer outra atividade do dia-a-dia que seria rotineiramente classificada como &#8220;distração&#8221;.” [Thomas e Macredie, 2002]

## Os pontos-chave da Nova Usabilidade

A nova usabilidade estende os conceitos fundamentados na usabilidade tradicional. Fatores como Comunicação, Colaboração, Ética e Valor Agregado tornam-se mais relevantes e pertinentes às aplicações desenvolvidas atualmente e, com isso, passam a representar pontos críticos da interação que têm impacto na satisfação de uso.

<div id="attachment_4593" style="width: 548px" class="wp-caption aligncenter">
  <a href="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2011/11/Slide2.jpg"><img class="size-full wp-image-4593  " src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2011/11/Slide2.jpg" alt="Pontos chaves da Nova Usabilidade" width="538" height="403" srcset="uploads/2011/11/Slide2.jpg 960w, uploads/2011/11/Slide2-300x225.jpg 300w" sizes="(max-width: 538px) 100vw, 538px" /></a>
  
  <p class="wp-caption-text">
    Pontos chaves da Nova Usabilidade
  </p>
</div>

### Comunicação

As aplicações são cada vez mais interativas entre pessoas do que entre usuário-máquina. A Interação Humano-Computador passa a ser cada vez mais vista como Interação Humano-Computador-Humano, onde o dispositivo é o meio que garante esse intercâmbio de informações e a qualidade da mensagem transmitida.

### Colaboração

Realização de atividades mútuas entre usuários, com participação colaborativa em determinadas tarefas.

### Ética

Com aplicações cada vez mais sociais, as aplicações devem estar atentas à questão de conduta, que pode também ser influenciada pelo projeto da interface.

### Eficiência de Interação

Facilidade de execução das tarefas.

### Eficácia de Interação

Capacidade da tarefa ser realizada de forma completa e correta

### Segurança

Refere-se ao nível de confiança da aplicação. Com o uso de _wi-fi_ e _cloud computing_, a segurança que o usuário tem ao utilizar a aplicação determina até que ponto ele confia e se dispõe a utilizar os recursos que a aplicação oferece.

### Confiabilidade

Se refere ao sentimento que as pessoas possuem com relação a acreditar ou não na forma de interação proposta. Isto está diretamente relacionado com a comunicação e a colaboração.

### Privacidade

É a liberdade de escolha do usuário de tornar públicas ou não determinadas informações suas. Este fator está relacionado à segurança.

### Valor Agregado

O quanto as funcionalidades de sua aplicação trazem de contribuição para a vida de seus usuários, o quanto de impacto e de valor agregado ele traz para a rotina das pessoas que o utilizam.

## Concluindo&#8230;

Este série de posts não foi de conteúdo técnico. Sim, é totalmente teórico. Mas são questões que temos que nos colocar a pensar quando falamos de atender novas demandas computacionais.

A usabilidade deve evoluir para se flexibilizar à avaliação e garantia de qualidade em interfaces disponíveis em diferentes dispositivos.

Embora o termo tenha sido cunhado há quase uma década, ainda estamos tentando atingir os objetivos que a Nova Usabilidade estabelece e isto hoje já está se tornando pertinente a qualquer tipo de aplicação, visto que esta diversidade de dispositivos tende a ser predominante.

Precisamos sair da zona de conforto do que conhecemos e pensar como as metodologias atuais podem ser recicladas para agregar esta demanda.

## Referências

IHC 2006. Workshop de Usabilidade de Aplicações e Tecnologias Emergentes: a Necessidade de uma “Nova Usabilidade”?. Disponível em: <https://www.dimap.ufrn.br/ihc2006/workshop.php>

Peter Thomas and Robert D. Macredie. 2002. Introduction to the new usability. ACM Trans. Comput.-Hum. Interact. 9, 2 (June 2002), 69-73. <https://doi.acm.org/10.1145/513665.513666>

Peter Thomas and Harold Thimbleby. 2002. The new usability: the challenge of designing for pervasive computing. In Proceedings of the 15th international conference on Computer communication (ICCC &#8217;02), S. V. Raghavan and Sudhir P. Mudur (Eds.). International Council for Computer Communication, Washington, DC, USA, 382-388.

Kelma Madeira et al. Uma Avaliação do Orkut utilizando Personas sob a ótica da Nova Usabilidade. In: VIII Simpósio Brasileiro de Fatores Humanos em Sistemas Computacionais (IHC 2008), Porto Alegre, 2008.