---
title: O que é link canônico
authors: Diego Eis
type: post
excerpt: O Link Canônico melhora os sinais de ranking de conteúdos diferentes, que podem ter suas referências relacionadas à uma página específica.
publishdate: 2018-03-26
date: 2018-03-18
image: https://i.imgur.com/ZJuYmvx.png
categories:
  - seo
  - html
  - Tecnologia e Tendências
  - acessibilidade
---

Usar um link canônico define uma URL preferencial para os buscadores. Além dos buscadores, algumas redes sociais usam essa propriedade para melhorar o uso dos seus plugins ou compartilhamentos. O Link Canônico melhora os sinais de ranking de conteúdos diferentes, que podem ter suas referências relacionadas à uma página específica.

O principal problema que o link canonico resolve, é a ajuda que ele dá para os buscadores ao determinar qual é a fonte original de conteúdos e documentos que podem estar espalhados em várias páginas diferentes. Duplicação de conteúdo entre vários sites, por exemplo.

Em fevereiro de 2009, o Google, Yahoo e Microsoft anunciaram o suporte para o elemento de link canônico. Se você se preocupa um pouco com SEO e pode ter problemas de conteúdos duplicados e quase idênticos seria interessante você usar.

Sintaxe:

```
<link rel="canonical" href="https://tableless.com.br/graphql-a-nova-era-das-apis-web/" />
```

Não é muito útil usar o link canônico em apenas uma página. Mas imagine que sua empresa faz várias campanhas com landing pages sobre um determinado produto que já tem uma página principal. Todas essas landing pages podem ter um link canônico para essa página principal.

Ou, podemos ter links de formas variadas para o website:

- https://um-site-legal.com/
- https://um-site-legal.com
- https://um-site-legal.com/
- https://um-site-legal.com/index.html
- https://um-site-legal.com/index.html
- https://www.um-site-legal.com/
- https://www.um-site-legal.com
- https://www.um-site-legal.com/
- https://www.um-site-legal.com/index.html
- https://www.um-site-legal.com/index.html

Assim, temos que avisar os buscadores que TODOS essas variações são apenas uma página, que é a indicada no link canônico.

Há plugins de botões de redes sociais, como o Twitter, que usam a URL que se encontra no link canônico para compartilhar seus conteúdos.