---
title: O que é autoridade do domínio ou Domain Authority?
authors: Douglas Faria
type: post
date: 2014-10-07
excerpt: Entenda o que significa Domain Authority.
url: /o-que-e-autoridade-dominio-ou-domain-authority/
categories:
  - Semântica
  - SEO
tags:
  - da
  - domain authority
  - SEO

---
Autoridade do domínio ou Domain Authority (DA), é uma [métrica criada pela empresa americana MOZ][1], que simula o algoritmo do Google. Seu número vai de 0 a 100 e você pode checá-lo através do <a title="Open Site Explorer" href="https://www.google.com/url?q=http%3A%2F%2Fmoz.com%2Fresearchtools%2Fose%2F&sa=D&sntz=1&usg=AFQjCNGQTQlm22lsnOhnxt285DvadrPeQg" target="_blank">Open Site Explorer</a>.

## Porque devo me preocupar com o Domain Authority?

Em primeiro lugar, é um indicador de qualidade que analisa links, volumes de visitas e outros aspectos que demonstram a relevância do seu domínio. Geralmente, sites que possuem melhores rankings tem o DA mais alto do que o de seus concorrentes.

Outra coisa importante é que ter um DA saudável é uma prova de que o conteúdo do seu site e é bem linkado, tanto internamente quanto externamente.

## Como faço para aumentar a autoridade do meu domínio?

Separei aqui algumas dicas para que você melhorar o DA de seus projetos, iniciando uma base mais consistente na busca por rankings melhores, vamos lá:

### Checar o SEO Onpage

É imprescindível que suas técnicas de SEO Onpage estejam corretamente aplicadas no website. Urls amigáveis, alt nas imagens, semântica do HTML e outros fatores são obrigação para qualquer campanha de SEO.

### Marketing de Conteúdo

Ter conteúdo de qualidade é essencial. Um blog é sempre a primeira ideia. Mesmo assim, o conteúdo estático do seu próprio site pode ser uma boa porta de entrada. Sempre faça mudanças nos textos do seu site. Teste a conversão, visitas, calls to action. Lembre-se que conteúdo é só o que o Google procura, logo, pequenas mudanças de texto podem trazer muitos resultados.

### Deixe seu site Social Friendly

Aqui está uma grande sacada: deixar seu site Socia Frendly, ou melhor dizendo, compartilhável. Quando você possui conteúdo relevante, os botões de compartilhamento são verdadeiros **calls to actions** para o seu site. Nós temos esse desejo de se comunicar e contribuir com as informações legais que chegam para a gente a todo tempo. Por isso, configure de forma correta as metatags do Opengraph e Twittercard, e posicione os botões de forma estratégica para que os leitores possam replicar as páginas do seu site.

### Linkagem interna

A linkagem interna é um dos aspectos mais importantes para melhorar a autoridade do seu domínio. Só perde para os backlinks de qualidade que seu site possa ter. Quando você cria uma boa linkagem interna, você distribui a autoridade de outros links (Page Athority) e consequentemente melhora o da página em questão.

### Construção e manutenção de backlinks

O link building continua sendo um fator importante para qualquer estratégia de SEO, só que vem sendo cada vez mais monitorado pelo Google. Em tempos remotos, possuir links era uma coisa fácil, bastava se cadastrar em diretórios e comentar sites relevantes que estava tudo certo. Hoje, os tempos são outros e essa técnica se tornou um blackhat pesado.

Construir links de qualidade exige práticas inteligentes ao invés de SPAM. O ideal é que você tenha links relevantes e seja lembrado (linkado) por sites que comprovem a sua autoridade. Não entrarei em detalhes de como fazer link building porque o assunto é amplo.

Identifique links ruins que apontam para o seu site e remova-os. Caso você não consiga, poderá utilizar a ferramenta do Google para negação de linkagens, a <a title="Disavow Links Tools" href="https://www.google.com/webmasters/tools/disavow-links-main" target="_blank">Disavow Links Tools</a>.

### Paciencia!

Última dica: tenha paciência! Como tudo em SEO e Marketing Digital, as mudanças não ocorrem do dia para a noite. Leva um tempo para construir autoridade.

 [1]: https://moz.com/learn/seo/domain-authority