---
type: post
title: >-
  O porquê do Bitcoin — Parte 2: A mitologia grega, o Napster e os Refugiados da
  Síria
excerpt: Porque Bitcoin não é algo trivial.
authors: Matheus Lima
date: 2018-05-28T00:00:00.000Z
publishDate: '2020-02-06'
image: 'https://i.imgur.com/L71bKGO.jpg'
categories:
  - Bitcoin
  - Javascript
  - Na Prática
tags:
  - javascript
  - blockchain
  - Bitcoin
  - Na Prática
---
Após o sucesso da primeira edição, a embarcamos na sua jornada para a segunda edição de forma a explorar este universo cripto. Esse post faz parte de uma coletânea de artigos sobre o Bitcoin, Ethereum, Blockchain e [criptomoedas](https://www.avatradeportuguese.com/forex/cryptocurrencies) em geral. Fique ligado que mais novidades estão por vir! [Leia o primeiro post](https://tableless.com.br/o-porque-do-bitcoin-parte-1-la-casa-de-papel-roma-antiga-decada-perdida/). 

- - -

Olá jovem, que bom ver você de volta por aqui. 👍

Bem, se você leu (e entendeu né) o *post* anterior, então você já deve compreender os principais problemas da inflação, e quais as vantagens que o Bitcoin pode trazer por ser uma moeda digital deflacionária.

Aliás, só pra deixar todo mundo na mesma página, vamos relembrar rapidamente a definição que foi apresentada na parte 1 dessa série:

> O Bitcoin é uma moeda digital deflacionária descentralizada que permite transações sem intermediários.

Nesse *post* vamos focar na parte da descentralização, que é o que falta para realmente entendermos não apenas a definição do Bitcoin que foi apresentada, mas também pra compreender de fato as verdadeiras motivações para adotarmos a moeda
digital.

Mas se acalme, porque antes de tudo precisamos dar uma passadinha na mitologia grega.

## Hidra de Lerna

Uma das partes mais interessantes na mitologia grega é [o mito da Hidra](https://www.britannica.com/topic/Hydra-Greek-mythology). O monstro, que vivia no lago de Lerna (daí o nome, Hidra de Lerna), tinha um corpo de dragão e diversas cabeças de serpente.

![](https://cdn-images-1.medium.com/max/800/1*uiwZlXO88e4D2M6PRVR47A.jpeg) <span class="figcaption_hack">Fonte: <https://orig01.deviantart.net/557f/f/2014/084/9/f/hydra_by_yoso999-d7bmpqg.jpg></span>

Segundo as primeiras versões do conto, toda vez que uma das cabeças do monstro fosse cortado, outra nasceria em seu lugar. A história porém foi alterada mais tarde para a versão que é mais conhecida hoje: toda vez que uma, das várias
cabeças que a Hidra possui for cortada, outras duas nasceriam em seu lugar.

Pense nessa diferença por um momento, porque ela é crucial.

Se a Hidra fosse um ser comum, e não um monstro mitológico, ao ter a cabeça cortada ela simplesmente morreria. Péssimo negócio pra ela. A Hidra nesse caso seria **frágil**.

Na primeira versão da mitologia porém, quando se corta uma cabeça outra igual nasce no seu lugar. Nada se ganha, nada se perde. Não é bom negócio, mas também não é tão ruim. Nesse caso, a Hidra é **robusta**.

Agora é na segunda versão que as coisas ficam realmente interessantes.

Se você é um monstro mitológico e toda vez que uma das suas cabeças é cortada e outras duas nascem no seu lugar, então é exatamente isso que você iria querer.

*A Hidra abraça o caos e a aleatoriedade*. Afinal de contas, ela *ganha* com isso. A Hidra, da versão mais conhecida do conto, está um degrau acima da robustez. Ela é **antifrágil**.

- - -

![](https://cdn-images-1.medium.com/max/600/1*61F7jvXS_mZYXZJeX8gBmw.jpeg) <span class="figcaption_hack">[Livro Antifrágil, por Nassim Taleb](https://www.amazon.com.br/AntifrÃ¡gil-Nassim-Nicholas-Taleb/dp/8576846136?__mk_pt_BR=ÃMÃÅ½ÃÃ&crid=1TLXBUI4S14VN&keywords=antifragil&qid=1526125804&sprefix=antifr,aps,265&sr=1-1&ref=sr_1_1)</span>

## Antifrágil

O termo antifrágil, [criado por Nassim Taleb num livro de mesmo nome](https://www.amazon.com.br/AntifrÃ¡gil-Nassim-Nicholas-Taleb/dp/8576846136?keywords=nassim+taleb&qid=1525620421&sr=1-1&ref=sr_1_1), remete a todas as coisas que se *beneficiam* da aleatoriedade, do caos, da desordem e de fatores estressores, assim como a Hidra da mitologia grega.

Um exemplo mais pé no chão para entendermos o conceito da antifragilidade é a aviação.

Quando uma tragédia acontece e um avião vem a cair, a aviação colhe os dados e tenta entender os erros que aconteceram e provocaram a queda. Isso faz com que novas tragédias sejam prevenidas. Ou seja, um avião perde com o caos e a
aleatoriedade. Mas a aviação, como um conceito coletivo, *ganha* com isso.

O avião em si é frágil. Mas a aviação como um todo, é antifrágil.

A evolução, a cultura, sistemas políticos, a tecnologia, o surgimento de cidades, desenvolvimento de resistência à bactérias e até mesmo a espécie humana são perfeitos exemplos de antifragilidade.

Guarde essa ideia. Ela vai ser bem importante durante todo esse *post*.

## Por que o Napster falhou

Nos primórdios da internet, aproximadamente até o final da década de 90, não era tão fácil compartilhar arquivos quanto é hoje.

Tudo começou a mudar quando o [Napster](https://pt.wikipedia.org/wiki/Napster) foi criado em 1999.

![](https://cdn-images-1.medium.com/max/600/1*l0Wizj3iskf02Y0SqJDZ_A.jpeg) <span class="figcaption_hack">Fonte: <https://www.oficinadanet.com.br/post/13870-historia-do-napster></span>

Apesar de ser possível compartilhar diversos tipos de arquivos, o grande foco do Napster era o de música. Isso foi extremamente disruptivo porque na época a única forma de se ouvir música era comprando CDs (pergunte aos seus pais).

O projeto deu tão certo que eventualmente virou uma empresa, que no seu auge, teve [8 milhões de usuários simultâneos compartilhando 20 milhões de músicas](https://pt.wikipedia.org/wiki/Napster#HistÃ³ria).

De forma resumida, o serviço funcionava da seguinte forma: os usuários compartilhavam os arquivos que tinham em seus computadores com um servidor centralizado do Napster. A partir desse servidor, outros usuários conseguiam
fazer o *download* das músicas.

O ponto principal do parágrafo acima é: **servidor centralizado**. Esse foi o grande calcanhar de Aquiles do Napster que fez com que todo o projeto fosse por água abaixo.

![](https://cdn-images-1.medium.com/max/600/1*ZnjC5nTFdakvGuWDD738Mw.gif) <span class="figcaption_hack">Fonte: <https://money.cnn.com/2010/02/02/news/companies/napster_music_industry/></span>

E por quê? Bem, obviamente a indústria da música não ia deixar barato. Afinal, ela faturava bilhões exclusivamente com as vendas de CDs.

E como o Napster era uma empresa localizada nos EUA, com servidores centralizados, onde todos os arquivos estavam fisicamente, bastava a indústria processar a empresa e pedir o encerramento do serviço.

[E foi exatamente isso que aconteceu](https://news.bbc.co.uk/2/hi/852283.stm).

E isso tudo, vale frisar novamente, só ocorreu porque o Napster era uma *empresa americana*, com *servidores centralizados*.

- - -

Percebendo essas falhas, outros serviços parecidos surgiram pra consertar os erros do Napster. Limewire, Kazaa, eMule, Shareaza e BitTorrent, só pra nomear alguns. A ideia era a mesma, mas com uma diferença que foi crucial: dessa vez a
troca de arquivos seria realmente
[peer-to-peer,](https://en.wikipedia.org/wiki/Peer-to-peer) de forma completamente descentralizada.

Ao invés de usuários fazendo o *upload* das suas músicas para um único servidor central e depois outros usuários requisitando o *download* dos arquivos desse servidor centralizado, os usuários iriam literalmente trocar suas músicas entre si usando os seus próprios computadores como se fossem servidores. E o que é
mais importante: sem nenhum ponto central.

E como faz pra fechar um serviço descentralizado? Não faz. Pra acabar com o Napster bastou derrubar o servidor central. Ponto final. Se tentassem derrubar o BitTorrent por exemplo, seria necessário visitar todas as milhões de máquinas
dos usuários do serviço. Uma a uma. Ou seja, impossível. Tanto que o serviço [tá aí até hoje.](https://www.bittorrent.com/)

Pra resumir, o que eu quero que você entenda com essa história é que:

* Centralizado = fácil de censurar, **frágil**
* Descentralizado = difícil de censurar, **antifrágil**

![](https://cdn-images-1.medium.com/max/600/1*kQAFc9-YGPqJlwzw8wQGNw.jpeg) <span class="figcaption_hack">Fonte: <https://www.narmitech.com/insights/is-blockchain-relevant-to-regional-and-community-financial-institutions/></span>

O criador misterioso do Bitcoin, [Satoshi Nakamoto](https://pt.wikipedia.org/wiki/Satoshi_Nakamoto), sabia muito bem disso. Tanto que o [BitTorrent foi um dos principais projetos em que ele se baseou](https://youtu.be/Bhe61JaNFLU?t=8m39s) para criar o Bitcoin.

Mas acho que me adiantei demais.

Para que você realmente possa entender a importância da descentralização, vamos conhecer um pouco mais sobre a vida de um refugiado.

## Os refugiados da Síria

Imagine que o país em que você vive entra numa guerra brutal. Em menos de 10 minutos você precisa largar tudo pra trás: seus familiares, sua casa e seus pertences. As únicas pessoas que você consegue salvar são a sua esposa e seus
filhos.

Agora, sem absolutamente nada além das roupas do corpo, você precisa ir até a fronteira e tentar começar a vida do zero em outro país.

Para você leitor, isso pode até parecer estranho e algo muito fora do comum. Mas isso ocorreu [diversas](https://pt.wikipedia.org/wiki/Bene_Israel) [vezes](https://pt.wikipedia.org/wiki/Peregrinos) [na](https://pt.wikipedia.org/wiki/Povos_do_Mar) [história](https://www.theguardian.com/science/2011/jun/20/hadrians-wall-roman-britain-refugee-camp). E nos últimos anos as migrações em massa de refugiados voltaram a acontecer principalmente por causa da [guerra civil na Síria](https://www.bbc.com/portuguese/internacional-43204513).

Essa guerra, que ainda está em andamento, já deixou [pelo menos 5 milhões de refugiados](https://brasil.elpais.com/brasil/2018/03/12/internacional/1520865451_577510.html), metade desses crianças e adolescentes.

![](https://cdn-images-1.medium.com/max/1000/1*4rOCBmgxF68eYv-RJRF9kQ.jpeg) <span class="figcaption_hack">Fonte: <https://theberkshireedge.com/wp-content/uploads/2015/09/asylumseeker-1024x614.jpg></span>

Não há dúvidas de que o drama que os refugiados são obrigados a enfrentar é absolutamente terrível. Mas e se uma parte importante dessa tragédia pudesse ser aliviada? E se fosse possível levar a riqueza que você acumulou com anos e anos
de trabalho junto com você? Pelo menos você não precisaria começar tão do zero
assim.

Tentar levar dinheiro físico ou moedas preciosas está fora de cogitação. Imagine, numa zona de guerra, você andando por aí com uma maleta com dinheiro e barras de ouro. Você seria um alvo fácil.

![](https://cdn-images-1.medium.com/max/600/1*lItVhx6-eSCeUS81SQLSfA.jpeg) <span class="figcaption_hack">Fonte: <https://static2.businessinsider.com/image/557871ec6da811a40274389d-4708-2687/rtx1fx37.jpg></span>

Deixar no sistema bancário também pode ser uma péssima ideia, porque quando você chegar num país seguro, vai ser bem difícil (se não for impossível) transferir o dinheiro que você deixou no seu país de origem: primeiro porque o país está em
guerra, segundo porque você não terá documentos comprovando que você é você, e
terceiro porque é possível que o sistema bancário esteja simplesmente parado por
lá ([o Collor já congelou a poupança aqui no Brasil](https://g1.globo.com/economia/noticia/entenda-os-planos-economicos-bresser-verao-collor-1-e-collor-2-e-as-perdas-na-poupanca.ghtml) por muito menos).

E mesmo se você conseguir tirar o seu dinheiro de lá, talvez ele já não valha mais nada. Instabilidades políticas, como guerras, geralmente vem acompanhadas de instabilidades econômicas, como a desvalorização da moeda local.

## E o que o Bitcoin tem a ver com isso?

Com o Bitcoin, pela primeira vez na história, transportar todo esse dinheiro não só seria possível, como seria extremamente fácil. Bastaria guardar sua [chave privada](https://en.bitcoin.it/wiki/Private_key) (é basicamente uma senha mas vou entrar em mais detalhes nos *posts* técnicos que virão pela frente) e pronto. Suas economias de vida estariam junto com você. Independente de guerras, governos corruptos ou de bancos locais.

Ou seja, [o Bitcoin é anti-censura](https://coincentral.com/bitcoin-censorship-resistance/).

![](https://cdn-images-1.medium.com/max/600/1*2-coLy2vOubmnRjvAD12dw.jpeg) <span class="figcaption_hack">Fonte: <https://www.theamericanmirror.com/wp-content/uploads/2015/11/refugees.jpg></span>

Ah, tem mais. Lembra que os refugiados nem sempre conseguem fugir com toda a família? É muito comum ter que abandonar seus pais, por exemplo, por questões de sobrevivência, no país de origem onde a guerra está acontecendo. Mas e se fosse
possível enviar dinheiro pra eles? Essa poderia ser a diferença entre a vida e a
morte. Com o Bitcoin, em questão de minutos e (quase) de graça é possível enviar
dinheiro de ajuda de qualquer lugar para qualquer outro lugar do mundo.

> Nota: o envio de dinheiro para o exterior é um mercado multibilionário que [movimentou U$500 bi só em 2016](https://www.foreignaffairs.com/articles/2015-02-26/bitcoin-unbanked). Existem [algumas poucas empresas](https://www.westernunion.com/us/en/home.html) controlando esse mercado e logicamente, cobrando tarifas altíssimas para realizar esse serviço.

E muitos ainda dizem que o [Bitcoin não tem valor intrínseco](https://www.marketwatch.com/story/bitcoins-intrinsic-value-must-be-zero-allianz-2018-03-14). Pra quem nunca teve que pensar num cenário apocalíptico e vive num país de primeiro mundo, onde as instituições são confiáveis, pode ser difícil vislumbrar
como essa nova moeda digital é importante.

Isso tudo porque o Bitcoin e outras [criptomoedas](https://pt.wikipedia.org/wiki/Criptomoeda) apresentam uma nova forma, que nunca foi possível antes na história, de pessoas transacionarem entre si, de forma [peer-to-peer](https://en.wikipedia.org/wiki/Peer-to-peer), sem nenhum agente centralizador e fora do sistema financeiro atual.

Ou seja, você não precisa mais de um banco para fazer transações financeiras. Você é seu próprio banco. Basta um *smartphone*, escolher uma dentre [diversas opções de carteiras digitais de Bitcoin](https://bitcoin.org/en/wallets/mobile/android/bitcoinwallet/), e pronto. **Você agora virou seu próprio banco.**

- - -

## Os desbancarizados

E por falar em bancos, no locais mais remotos e mais pobres da Terra existem [2 bilhões de indivíduos desbancarizados](https://uk.businessinsider.com/the-worlds-unbanked-population-in-6-charts-2017-8) (pessoas sem conta em banco). A maioria desses vivendo em [zonas rurais e ganhando menos que U$5 por dia](https://www.cnbc.com/2015/07/05/can-bitcoin-help-the-worlds-unbanked.html).

Os desbancarizados, assim como os refugiados, não podem abrir uma conta poupança ([o que faz com que sejam reféns da inflação, lembra?](https://medium.com/tableless/o-porquÃª-do-bitcoin-parte-1-la-casa-de-papel-a-roma-antiga-e-a-dÃ©cada-perdida-523e9116cfe2)), muito menos cartões de crédito, nem enviar ou receber dinheiro, dentre outras coisas que nós privilegiados tomamos como certo.

![](https://cdn-images-1.medium.com/max/600/1*Q43wi22Fui9FYSEMOIOHfw.png) <span class="figcaption_hack">Fonte: <https://womenlovetech.com/bridging-the-gap-smartphones-in-third-world-countries/></span>

O Bitcoin pode ser uma mudança de paradigma para todos esses indivíduos que tanto precisam. E com o [aumento expressivo do número de smartphones em países em desenvolvimento](https://www.pewglobal.org/2016/02/22/smartphone-ownership-and-internet-usage-continues-to-climb-in-emerging-economies/) todos os benefícios do Bitcoin, que já foram citados anteriormente, seriam possíveis.

[A inclusão financeira é um conceito chave](https://thehill.com/opinion/technology/380115-for-worlds-unbanked-bitcoin-is-the-future) para que possamos tentar diminuir a pobreza no mundo. E é bem possível que o Bitcoin seja a maior oportunidade de inclusão financeira de todos os tempos.

## A estabilidade dos ricos

Indivíduos privilegiados, acostumados com uma sociedade *estável e previsível* não entendem os benefícios do Bitcoin. [Banqueiros](https://www.coindesk.com/2017-review-bankers-think-bitcoin/), [Bill Gates](https://portaldobitcoin.com/bitcoin-bill-gates-diz-que-apostaria-contra-se-pudesse/) e [Warren Buffet](https://economia.estadao.com.br/noticias/geral,criptomoeda-e-um-veneno-afirma-warren-buffett,70002299133) (os dois últimos, apesar de tudo, sempre foram meus heróis) são só alguns exemplos que vieram a público recentemente criticar a moeda digital.

![](https://cdn-images-1.medium.com/max/600/1*E3dY8tBwloN8LLZbyUG5-g.jpeg) <span class="figcaption_hack">Fonte: <https://portaldobitcoin.com/bitcoin-bill-gates-diz-que-apostaria-contra-se-pudesse/></span>

É evidente que eles pensam assim. Como poderiam pensar de outro jeito? As chances de que cada um deles perca tudo o que tem do dia pra noite, é próxima de zero. Pra eles o Bitcoin é uma somente a brincadeira especulativa do momento.

Pros refugiados e desbancarizados, a conversa muda de tom. Eles vivem numa *sociedade instável e imprevisível*. Ter o poder de proteção contra governos corruptos que expropriam o dinheiro da própria população é uma questão de sobrevivência.

Além disso, os refugiados e desbancarizados precisam de algo que seja fácil, rápido e barato de enviar recursos pra qualquer lugar do mundo, para que os parentes que ficaram pra trás também tenham alguma chance.

E como a realidade deles é de instabilidade, o que eles mais precisam é de algo que não apenas aguente esse cenário de incertezas, mas que fique *melhor* com isso.

O que os refugiados e desbancarizados precisam é do Bitcoin: *a primeira moeda antifrágil de todos os tempos*. Afinal, todas as vezes que tentaram cortar uma cabeça do Bitcoin, duas novas surgiram no seu lugar.

Leia o [primeiro post dessa série](https://tableless.com.br/o-porque-do-bitcoin-parte-1-la-casa-de-papel-roma-antiga-decada-perdida/).

**Leia mais posts como esse, [assine a newsletter](https://eepurl.com/bHZHC1).**

Obrigado por ler! ❤

## Fontes:

* [Bitcoin as the first anti-fragile economy entity — https://medium.com/@eranshir/bitcoin-as-the-first-anti-fragile-economical-entity-b52bc600ec91](https://medium.com/@eranshir/bitcoin-as-the-first-anti-fragile-economical-entity-b52bc600ec91)
* [Can bitcoin help the world’s unbanked? — https://www.cnbc.com/2015/07/05/can-bitcoin-help-the-worlds-unbanked.html](https://www.cnbc.com/2015/07/05/can-bitcoin-help-the-worlds-unbanked.html)
* [Why Decentralization Matters — https://medium.com/@cdixon/why-decentralization-matters-5e3f79f7638e](https://medium.com/@cdixon/why-decentralization-matters-5e3f79f7638e)
* [Bitcoin for the Unbanked — https://www.foreignaffairs.com/articles/2015-02-26/bitcoin-unbanked](https://www.foreignaffairs.com/articles/2015-02-26/bitcoin-unbanked)
* [The History of Money and the Future of Bitcoin and the Cryptocurrency Economy — https://hackernoon.com/the-history-of-money-the-future-of-bitcoin-and-the-cryptocurrency-economy-5cc25e808275](https://hackernoon.com/the-history-of-money-the-future-of-bitcoin-and-the-cryptocurrency-economy-5cc25e808275)
