---
title: "O porquê do Bitcoin — Parte 1: La casa de papel, a Roma Antiga e a Década Perdida"
authors: Matheus Lima
type: post
publishdate: 2018-05-21
date: 2018-05-21
excerpt: Porque Bitcoin não é algo trivial.
image: https://i.imgur.com/L71bKGO.jpg
categories:
  - Bitcoin
  - Javascript
  - Na Prática
tags:
  - javascript
  - Bitcoin
  - Na Prática
---


Esse post faz parte de uma coletânea de artigos sobre o Bitcoin, Ethereum, Blockchain e criptomoedas em geral. Fique ligado que mais novidades estão
por vir! [Leia o segundo post](https://tableless.com.br/o-porque-do-bitcoin-parte-2-a-mitologia-grega-napster-refugiados-siria/).

*****

> O Ministério da Saúde adverte: esse post contém diversas opiniões políticas
> polêmicas, palavrões desnecessários e traços de soja.

Você está empolgado?

Eu estou.

Vou te dizer o quanto: a primeira vez que fiquei realmente empolgado com uma
tecnologia foi em 1998 quando fui conhecer a Internet ainda criança.

A segunda vez? O Bitcoin.

Uma das frases mais batidas dos últimos anos vai bem nessa linha:

> O Blockchain é a tecnologia mais disruptiva desde a internet

A ideia com essa série de *posts* é justamente esclarecer por que tem tanta
gente animada com o Bitcoin, Blockchain, Ethereum e em todo esse novo
ecossistema que se formou baseado na **descentralização**, estimulando soluções como o [Bitcoin Bank](https://criptoeconomia.com.br/bitcoin-bank/).

Os *posts* são longos, porque precisam ser. Sem o devido contexto você no máximo
vai conseguir entender o *como* e não o que mais importa: [o
porquê](https://www.amazon.com.br/Start-Why-Leaders-Inspire-Everyone/dp/1591846447?__mk_pt_BR=ÃMÃÅ½ÃÃ&keywords=sinek&qid=1523490575&sr=8-3&ref=sr_1_3).

*****

## Bitcoin

Antes de qualquer coisa, vamos definir o que é o Bitcoin:

> O Bitcoin é uma moeda digital deflacionária descentralizada que permite
> transações sem intermediários.

Ok.

Você continua perdido.

Para que você possa realmente entender essa definição vamos precisar dar um
mergulho em um dos conceitos mais importantes da economia. E pra isso, que tal
começarmos por [La Casa de Papel](https://www.netflix.com/title/80192098)?

![](https://cdn-images-1.medium.com/max/1000/1*QQ2SEnaAiRKvFXNkDwfrtg.jpeg)
<span class="figcaption_hack">Fonte:
[https://nerdtatuado.com.br/la-casa-de-papel-serie-que-voce-precisa-ver/](https://nerdtatuado.com.br/la-casa-de-papel-serie-que-voce-precisa-ver/)</span>

A série retrata o golpe perfeito.

Oito criminosos liderados pelo Professor, tem uma meta simples: roubar, mas sem
roubar de ninguém.

A ideia é ir até a Casa da Moeda, o órgão responsável pela impressão das notas
de euros, e imprimir a maior quantidade de dinheiro possível. E pra isso, eles
tem que ficar dentro da Casa da Moeda pelo maior tempo que puderem.

Tempo é dinheiro, afinal.

Maravilha né?

É o roubo do bem.

Um roubo *millenial*, vegano, sem glúten.

Só tem um problema: quando os criminosos imprimiram 1 bilhão de euros, eles
roubaram de todos nós ao mesmo tempo. E nos roubaram do mesmo jeito que o
governo nos rouba todos os anos, pela **inflação**.

## O que é a inflação?

Digamos que o tomate custe hoje R$10,00/kg. Semana que vem, vamos no mercado de
novo, e ele passou pra R$16,00/kg. Mais de 50% de aumento em uma semana? Eita
porra.

Mas se acalme. Isso pode ter diversas causas. Por exemplo pode ter acontecido
uma mudança climática que gerou uma seca em grande escala. Com isso, menos
tomates estarão disponíveis, já que grande parte deles apodreceu devido a seca.
**Mas a procura por tomates se manteve igual, então o preço subiu.**

O que eu acabei de descrever acima é um dos conceitos mais básicos da economia,
a famosa [Lei da Oferta e da
Procura](https://pt.wikipedia.org/wiki/Lei_da_oferta_e_da_procura).

![](https://cdn-images-1.medium.com/max/800/1*CWY_A8P-WRW90yAaonNrDg.png)
<span class="figcaption_hack">Fonte:
[https://aleconomico.org.br/o-que-acontece-quando-o-governo-limita-os-precos/](https://aleconomico.org.br/o-que-acontece-quando-o-governo-limita-os-precos/)</span>

Em resumo, essa Lei diz o seguinte:

* Muita oferta e pouca procura = os preços descem
* Pouca oferta e muita procura = os preços sobem

Dito isso, quando alguns poucos itens no mercado sobem de preço, isso pode ter
diversas causas. Sem problemas, faz parte do jogo.

Agora, quando há um **aumento generalizado dos preços** não tem jeito: está
havendo uma expansão monetária (aumento do dinheiro em circulação). E pela Lei
da Oferta e da Procura, se temos mais dinheiro em circulação, mas os bens e
serviços se mantiveram estáveis, então o nosso dinheiro está valendo menos do
que antes.

E isso meus jovens, é a maldita inflação.

<span class="figcaption_hack">Fernando Ulrich sobre as causas da Inflação</span>

Resumindo:

1.  bens e serviços continuam iguais, mas
1.  houve um aumento expressivo da quantidade de dinheiro circulando na economia,
então
1.  os preços vão aumentar, e nosso dinheiro vai se desvalorizar.

> Nesse ponto espero que você tenha entendido porque os assaltantes da série La
> Casa de Papel roubaram toda a população ao mesmo tempo ao imprimir 1 bilhão de
euros de uma vez.

*****

## Os culpados

Mas quem provoca a inflação?

Bem, se a inflação vem do aumento da quantidade de dinheiro de forma
descontrolada na economia, obviamente o culpado só pode ser um: **quem tem o
poder de imprimir o dinheiro.**

E quem tem esse poder?

O melhor amigo de todo o brasileiro, o **governo **(pra ser mais exato, uma
parte dele: o Banco Central).

![](https://cdn-images-1.medium.com/max/800/1*huY3X3IU6sxrlSYX6zX2uA.png)

E porque o governo injeta dinheiro novo na economia, e muitas vezes de forma
descontrolada? Ué, porque ele *ganha* com isso.

Mas antes de entender como eles ganham, vamos ver primeiro quem perde. Se você
chutou os mais pobres, parabéns. São eles mesmos.

Não apenas os mais pobres: os aposentados e basicamente todo mundo que depende
de um salário fixo mensal perdem com a inflação.

Ou seja, quem tá embaixo.

Os mais ricos, por outro lado, sabem se proteger porque:

1.  eles não dependem de salário mensal, e
1.  eles não tem dinheiro parado, tá tudo aplicado. E grande parte dessas aplicações rendem mais que a inflação.

Já ouviu falar num investimento chamado [Tesouro Direto](https://www.tesouro.fazenda.gov.br/tesouro-direto)? Uma das modalidades
mais conhecidas do Tesouro, o [NTN-B](https://www.tesouro.gov.br/documents/10180/410323/NTN-B%20principal_novidades.pdf), paga seja lá o que a inflação for e mais um pouco.

Ou seja, pra eles tá sempre tudo bem.

Mas e pro seu João, carpinteiro de 57 anos que vive no interior da Paraíba? O
seu João nunca teve sequer uma conta no banco. Corretora de investimentos então?
Nunca ouviu falar. O pouco de dinheiro que sobra, ele guarda dentro de casa
mesmo. Só que com uma inflação alta, esse dinheiro vai valer cada vez menos.

**Inflação não tem jeito, quem fica com a conta são os mais pobres.**

Tá, mas se a gente já sabe o que causa a inflação e a gente sabe que ela é ruim,
por que diabos os governos do mundo continuam a provocando?

![](https://cdn-images-1.medium.com/max/800/1*e0GOaICKllowFjr3IQFBJw.jpeg)
<span class="figcaption_hack">Fonte: Fonte:
[https://www.criptomoedasfacil.com/wp-content/uploads/2018/02/Petro-Maduro-Venezuela.jpg](https://www.criptomoedasfacil.com/wp-content/uploads/2018/02/Petro-Maduro-Venezuela.jpg)</span>

Como eu tinha dito lá em cima, porque o governo ganha com isso. Mas chegou a
hora de entender como.

## Por que os governos causam a inflação?

É bem simples na verdade.

Os governantes prometem o que não podem cumprir *(sério? jurava que eles não
faziam isso)*. E pra conseguir os recursos necessários pra realizar o que foi
prometido, existem duas opções:

1.  cortar gastos públicos *(ruim pra eles)*
1.  aumentar os impostos *(ruim pra nós)*

Sobra então a saída fácil: botas as impressoras pra funcionarem, faz a grana que
precisa e o seu João do interior da Paraíba (indiretamente) vai ficar com a
conta.

Meus jovens, **a inflação no final das contas é só mais um imposto**.<br> Você
não votou a favor, mas vai ser obrigado a pagar mesmo assim.

Ou como dizia [Milton
Friedman](https://www.amazon.com.br/Livre-Para-Escolher-Depoimento-Pessoal/dp/8501103667?__mk_pt_BR=ÃMÃÅ½ÃÃ&crid=2NGPDFP6P6DKQ&keywords=milton+friedman&qid=1523492074&sprefix=milton+fri,aps,1348&sr=8-1&ref=sr_1_1):

> A inflação é a única forma de taxação que pode ser imposta sem legislação

Profundo né? A propósito, isso não é de hoje.

Um dos argumentos mais sólidos sobre a queda do Império Romano, está ligado a
inflação descontrolada que aconteceu na época.

Quer saber como isso aconteceu? Então chega mais, ajeita a postura e pega um
café que eu te conto.

*****

## Roma Antiga

Perto de VIII a.C. Roma surgiu como um vilarejo simples. Por mais de 500 anos o
dinheiro usado eram bens simples como trigo e sal.

> Informação completamente inútil: a palavra “salário” vem de “sal” justamente por
> causa dessa época. Como não haviam geladeiras, uma das únicas formas de se
preservar a carne era com o sal, que acabou virando meio de pagamento.

Até que os romanos resolveram copiar os gregos e passaram a usar moedas como
forma de pagamento. A primeira delas foi o
[Asse](https://pt.wikipedia.org/wiki/Asse). Ela era bastante pesada, com
aproximadamente 300g de bronze.

![](https://cdn-images-1.medium.com/max/800/1*rVHw44NEqyYCOwySSoEyDQ.jpeg)
<span class="figcaption_hack">Fonte:
[https://pt.wikipedia.org/wiki/Asse#/media/File:As-Nero-Ara_pacis-RIC_0562.jpg](https://pt.wikipedia.org/wiki/Asse#/media/File:As-Nero-Ara_pacis-RIC_0562.jpg)</span>

Poucos anos depois da introdução do Asse como moeda, Roma entraria em uma guerra
de 23 anos de duração contra Cartago, que ficou conhecida como a [Primeira
Guerra Púnica](https://pt.wikipedia.org/wiki/Primeira_Guerra_PÃºnica).

Já te adianto o *spoiler*: Roma venceu. Mas o que realmente importa é *como*
venceu: inflacionando a própria moeda.

O exército de Cartago era enorme pra época, [segundo um historiador da
época](https://pt.wikipedia.org/wiki/Primeira_Guerra_PÃºnica#Cartago_se_prepara_para_a_guerra):

> (…) este exército era composto por 50 000 homens na infantaria, 6 000 na
> cavalaria e 60 elefantes de guerra

Pra Roma vencer, ia precisar mobilizar um exército mais forte ainda. E qual a
forma mais fácil de se fazer isso? Tendo dinheiro, lógico.

Só que Roma não tinha de onde tirar esse dinheiro, então os governantes foram
produzindo novos Asses. E como não tinham de onde tirar tanto bronze pra fazer
cada moeda de 300g, foram aos poucos diminuindo o tamanho de cada moeda, mas por
lei forçaram que elas valiam a mesma coisa do que antes.

Era o plano perfeito. Conseguiram gerar dinheiro do nada, o que deu pra bancar
os enormes custos da guerra. Sucesso né? Não. O problema foi que depois de
alguns poucos anos de cunhagem de novas moedas do nada, o Asse ficou tão
desvalorizado que a população parou de ter confiança na moeda.

Os governantes tiveram outra ideia. Que tal se a gente substituir então o Asse
por outra moeda? Surgiu então o
[Denário](https://pt.wikipedia.org/wiki/DenÃ¡rio). Denário vem do latim
*denarius*, que significa “contém dez”, porque cada unidade valia 10 Asses.

> Conte para o seu crush: a palavra “dinheiro”, vem de “denário”.

Mas não tem jeito. Não adianta ficar mudando de moeda se a política continua
igual. E foi igual. Pouco tempo depois da adoção do Denário, o povo romano viu
que tinha treta e, de novo, parou de usar a moeda e voltou a usar coisas mais
sólidas como o ouro, prata e o bom e velho sal.

Pra não alongar muito, o resumo da obra é que: toda essa instabilidade
financeira gerou também uma instabilidade política que eventualmente culminou na
queda do Império Romano.

Se você quiser ler mais sobre isso, dá uma olhada [aqui
](https://mises.org/library/inflation-and-fall-roman-empire)e [principalmente
aqui](https://www.amazon.com.br/Crash-2-Âª-ediÃ§Ã£o-Alexandre-Versignassi-ebook/dp/B00SACY95C?__mk_pt_BR=ÃMÃÅ½ÃÃ&crid=2FA1A9VHIIG71&keywords=crash&qid=1523653934&sprefix=crash+,aps,480&sr=1-1&ref=sr_1_1).

*****

Mais de 2.000 anos depois do fracasso do Império Romano e (praticamente) não
aprendemos nada:

![](https://cdn-images-1.medium.com/max/800/1*cF9y6PeDlV0PJLFO2dhh6g.png)
<span class="figcaption_hack">Fonte:
[https://www.paulogala.com.br/o-caos-da-inflacao-nos-anos-80/](https://www.paulogala.com.br/o-caos-da-inflacao-nos-anos-80/)</span>

O gráfico acima mostra a inflação mensal no Brasil da década de 80/90. Note que
tem meses que a inflação bate 80%. Ou seja, em apenas um mês os preços do
supermercado praticamente dobraram.

Isso ajuda a explicar inclusive a cultura do brasileiro de ir no supermercado
fazer compras de mês. Em praticamente nenhum lugar do mundo as pessoas fazem
isso, geralmente o mais comum são compras menores semanais. Mas devido a
inflação o brasileiro aprendeu que assim que receber o salário, ele deveria ir
direto no supermercado, comprar o máximo possível e fazer estoque.

_Vou voltar pro Bitcoin em breve, não vá embora!_

Esse período foi tão ruim (não só no Brasil mas em grande parte da América
Latina) que ficou conhecido como a [Década
Perdida](https://pt.wikipedia.org/wiki/DÃ©cada_perdida). Durante esse tempo nós
tivemos: estagnação econômica, controle de preços, retração da produção
industrial, dentre outras maravilhas.

Até que o [Plano Real entrou em vigor e resolveu a hiperinflação no
Brasil](https://g1.globo.com/economia/inflacao-como-os-governos-controlam/platb/).
Compare os índices dos últimos anos e veja a diferença:

![](https://cdn-images-1.medium.com/max/800/1*NNmfP_p1QZ7VpWj8LvKgOA.png)
<span class="figcaption_hack">Fonte:
[https://especiais.g1.globo.com/politica/politica/processo-de-impeachment-de-dilma/2016/da-esperanca-a-crise-os-13-anos-do-pt/](https://especiais.g1.globo.com/politica/politica/processo-de-impeachment-de-dilma/2016/da-esperanca-a-crise-os-13-anos-do-pt/)</span>

Mesmo assim, tivemos momentos ruins principalmente em 2002 (transição do governo
FHC/Lula) e em 2015 (Dilma) tivemos inflação de dois dígitos, o que é muito mais
alto do que a grande maioria dos economistas recomendam.

Pra ter uma ideia se a gente for pegar a inflação acumulada desde que o Real foi
criado em 1994, a moeda perdeu mais de 80% do seu valor de compra. [Ou seja, os
R$100 de antigamente hoje valem menos do que
R$20](https://economia.uol.com.br/noticias/redacao/2016/04/12/inflacao-de-438-desde-criacao-do-real-faz-nota-de-r-100-valer-r-1859.htm).

Isso porque o Real é uma das moedas mais estáveis que o Brasil já criou. Não
preciso nem falar sobre o Cruzeiro e o Cruzado pra provar meu ponto.

> Nota de rodapé: algumas escolas econômicas (principalmente a [Keynesiana](https://pt.wikipedia.org/wiki/Escola_keynesiana)) acreditam que uma inflação alta é saudável e consegue até mesmo ajudar no crescimento da economia. Acredito que esse debate está fora do escopo desse post, mas independente de qualquer coisa: **a imensa maioria dos economistas tem como fato que uma inflação descontrolada é terrível para a economia**.

*****

## Voltando pro Bitcoin

Tá, mas o que todo esse blá-blá-blá sem sentido tem a ver com o Bitcoin?

Calma, gafanhoto. Eu explico.

Vamos revisar a definição que foi apresentada no começo desse *post*:

> O Bitcoin é uma moeda digital deflacionária descentralizada que permite
> transações sem intermediários.

A palavra mágica aqui é: **deflacionária**.

## Deflação

Deflação é igual inflação. Só que ao contrário.

Ao invés de uma moeda valer menos a cada dia (como acontece com o nosso querido
dinheirinho) uma moeda deflacionária tende a valer *mais* a cada dia.

Porque? Lei da Oferta e da Procura de novo.

No caso do Bitcoin, a quantidade total da moeda em circulação será de 21 milhões
([nesse momento, existem aproximadamente 17
milhões](https://blockchain.info/pt/charts/total-bitcoins)). Ou seja, nós
sabemos que a oferta da moeda é fixa e ela vai continuar assim.

Então, se cada vez menos Bitcoins são criados (mais sobre como acontece a magia
da criação dos Bitcoins num *post* futuro) e a procura pela moeda continuar
aumentando, não tem jeito: **o preço sobe junto**.

Observe o gráfico abaixo:

![](https://cdn-images-1.medium.com/max/800/1*-pHUPVvNSdEbbxydZgfjMg.jpeg)
<span class="figcaption_hack">Fonte:
[https://medium.com/@vijayboyapati/the-bullish-case-for-bitcoin-6ecc8bdecc1](https://medium.com/@vijayboyapati/the-bullish-case-for-bitcoin-6ecc8bdecc1)</span>

A linha azul mostra que cada vez menos Bitcoins serão criados, e com isso, a
linha vermelha mostra a inflação da moeda despencando.

Ou seja, o Bitcoin vai ajudar a combater a inflação desenfreada provocada por
governos irresponsáveis e que atingem justamente a camada de baixo da população.

**E essa pode ser a diferença entre passar fome ou não.**

Em casos mais absurdos como na Venezuela atual, a inflação vem piorando a cada
ano. E somente em 2017, foram incríveis *4.651% *(!!!).

![](https://cdn-images-1.medium.com/max/800/1*24agZCm8bbfiRDjAKyRGFA.jpeg)
<span class="figcaption_hack">Fonte:
[https://www.mises.org.br/Article.aspx?id=2847](https://www.mises.org.br/Article.aspx?id=2847)</span>

Com essa crise, que parece sem solução, o povo venezualano vê o Bitcoin como o
refúgio monetário ideal para fugir das variações absurdas que a moeda local
sofre e pra [literalmente não ter que passar
fome](https://www1.folha.uol.com.br/mundo/2017/12/1944435-enquanto-venezuela-entra-em-colapso-as-criancas-estao-morrendo-de-fome.shtml).

Só pra ter uma ideia, o gráfico abaixo mostra o volume de transações entre o
Bolívar, [a moeda venezuelana que passou a valer menos que a moeda virtual do
World of
Warcraft](https://www.theenemy.com.br/pc/bolivar-venezuelano-vale-menos-do-que-moeda-virtual-de-world-of-warcraft),
e o Bitcoin. Olhe o crescimento exponencial que começou a ocorrer a partir de
2016, com o agravamento da crise:

![](https://cdn-images-1.medium.com/max/800/1*gVSogoIEe4LPawc30HJbVw.png)
<span class="figcaption_hack">Fonte:
[https://www.newsbtc.com/2017/02/20/localbitcoins-gains-from-regulations/](https://www.newsbtc.com/2017/02/20/localbitcoins-gains-from-regulations/)</span>

Isso inclusive, [pode estar por trás da valorização expressiva que o Bitcoin
começou a ter](https://www.bbc.com/portuguese/internacional-38553632) nos últimos
anos, principalmente em 2017.

*****

Talvez você esteja se perguntando se o fenônemo da inflação só acontece em em
países de Terceiro Mundo como os citados Brasil e Venezuela.

Na verdade não.

Olha o que aconteceu com o dólar somente no período de 1913–2013:

![](https://cdn-images-1.medium.com/max/800/1*8VbbhxcKpTrOVb5kA8U8-Q.png)
<span class="figcaption_hack">Fonte:
[https://comparegoldandsilverprices.com/news/economics-101/dollar-devaluation-since-1913/](https://comparegoldandsilverprices.com/news/economics-101/dollar-devaluation-since-1913/)</span>

Um dólar em 1913 valiam em 2013 menos do que 6 centavos de dólar.

No livro [Paper Money Collapse](https://www.amazon.com/gp/product/1118877322/),
o autor argumenta que o dinheiro fiduciário (dólar, euro, real e outras moedas
sem lastro) não apenas é desnecessário, como gera dívidas ([os EUA agora devem
$21 trilhões](https://www.usdebtclock.org/)) e sempre vão ter seu valor reduzido
a zero, como o gráfico dos dólares acima demonstra.

Segundo o autor, não existem exceções pra isso. E a história sempre mostra o
mesmo resultado.

*****

E com isso meus amigos e minhas amigas, temos o primeiro grande porquê do
Bitcoin, **ser uma reserva de valor** contra governos incompetentes e corruptos
que usam a artimanha de imprimir dinheiro de forma descontrolada em benefício
próprio e deixando a conta pra quem justamente o governo deveria se importar
mais: a camada de baixo da população.

Mas essa é somente uma das vantagens do Bitcoin. E além disso, tenho certeza que
você ainda tem muitas dúvidas sobre como o Bitcoin realmente funciona e quais
outros impactos ele pode trazer.

Então fique ligado que a série continua.

*****

**Se quiser receber de antemão mais posts como esse, [assine a newsletter](https://eepurl.com/bHZHC1).**

Obrigado por ler! ❤

*****

## Fontes:

* [Crash — Alexandre Versignassi](https://www.amazon.com.br/Crash-2-Âª-ediÃ§Ã£o-Alexandre-Versignassi-ebook/dp/B00SACY95C)
* [The History of Money & the Future of Bitcoin and the Cryptocurrency Economy](https://hackernoon.com/the-history-of-money-the-future-of-bitcoin-and-the-cryptocurrency-economy-5cc25e808275)
* [O que o Governo fez com nosso dinheiro? — Murray Rothbard](https://www.amazon.com.br/que-Governo-Fez-Nosso-Dinheiro/dp/8581190510?__mk_pt_BR=ÃMÃÅ½ÃÃ&keywords=rothbard+governo&qid=1523715773&sr=8-1-fkmrnull&ref=sr_1_fkmrnull_1)
* [The bullish case for Bitcoin](https://medium.com/@vijayboyapati/the-bullish-case-for-bitcoin-6ecc8bdecc1)
* [Deflação (wikipedia)](https://pt.wikipedia.org/wiki/DeflaÃ§Ã£o)
* [G1 — Venezuelanos investem em bitcoin para encarar desemprego, hiperinflação e falta de notas](https://g1.globo.com/mundo/noticia/venezuelanos-investem-em-bitcoin-para-encarar-desemprego-hiperinflacao-e-falta-de-notas.ghtml)
* [This Time is Different Part 2: What Bitcoin Really Is.](https://hackernoon.com/this-time-is-different-part-2-what-bitcoin-really-is-ae58c69b3bf0)
