---
title: O melhor do Codrops
authors: Davi Ferreira
type: post
date: 2013-07-02
excerpt: Confira uma coletânea dos melhores artigos e tutoriais lançados no Codrops, blog sobre desenvolvimento web com grande foco em interfaces.
url: /o-melhor-do-codrops/
dsq_thread_id: 1454722711
categories:
  - Código

---
Talvez você não reconheça o nome, mas muito provavelmente já clicou em algum link do <a target="_blank" href="https://tympanus.net/codrops/">Codrops</a>, blog sobre desenvolvimento web mantido por Manoela Ilic e Pedro Botelho, com grande foco em _interaction design_ e UX.

Neste artigo compilei os 10 melhores posts de experimentos de interfaces publicados no Codrops. Independente desta seleção, recomendo muito que você perca algumas horas lendo os artigos e conferindo todas as demos do site.

Os experimentos contemplam efeitos de hover em imagens, modais, botões, galerias e formulários. Façam bom proveito!

## BookBlock {#bookblock}

<a target="_blank" href="https://tympanus.net/codrops/2012/09/03/bookblock-a-content-flip-plugin/">artigo</a> | <a target="_blank" href="https://tympanus.net/Development/BookBlock/">demo</a> | <a target="_blank" href="https://github.com/codrops/BookBlock">código-fonte</a>

<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/07/bookblock.jpg" alt="bookblock" width="580" height="315" class="alignnone size-full wp-image-37957" srcset="uploads/2013/07/bookblock.jpg 580w, uploads/2013/07/bookblock-309x168.jpg 309w, uploads/2013/07/bookblock-570x310.jpg 570w" sizes="(max-width: 580px) 100vw, 580px" />

BookBlock é um plugin jQuery que habilita uma navegação estilo livro em qualquer tipo de conteúdo. O link de demonstração inclui diversos exemplos, desde uma simples galeria de fotos até uma navegação _fullscreen_.

## Stack Slider {#stack-slider}

<a target="_blank" href="https://tympanus.net/codrops/2012/12/03/stackslider-a-fun-3d-image-slider/">artigo</a> | <a target="_blank" href="https://tympanus.net/Development/StackSlider/">demo</a> | <a target="_blank" href="https://github.com/codrops/StackSlider">código-fonte</a>

<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/07/StackSlider.jpg" alt="StackSlider" width="580" height="315" class="alignnone size-full wp-image-37965" srcset="uploads/2013/07/StackSlider.jpg 580w, uploads/2013/07/StackSlider-309x168.jpg 309w, uploads/2013/07/StackSlider-570x310.jpg 570w" sizes="(max-width: 580px) 100vw, 580px" />

Segundo o seu criador, este é um plugin altamente experimental que brinca com CSS3 transforms e efeitos de perspectiva. O resultado final é algo bem diferente do que estamos acostumados a ver em galerias de imagens. O plugin ainda implementa um _flow_ contínuo bem bacana.

## Stapel {#stapel}

<a target="_blank" href="https://tympanus.net/codrops/2012/11/21/adaptive-thumbnail-pile-effect-with-automatic-grouping/">artigo</a> | <a target="_blank" href="https://tympanus.net/Development/Stapel/">demo</a> | <a target="_blank" href="https://github.com/codrops/Stapel">código-fonte</a>

<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/07/ThumbnailPileEffect.jpg" alt="ThumbnailPileEffect" width="580" height="315" class="alignnone size-full wp-image-37966" srcset="uploads/2013/07/ThumbnailPileEffect.jpg 580w, uploads/2013/07/ThumbnailPileEffect-309x168.jpg 309w, uploads/2013/07/ThumbnailPileEffect-570x310.jpg 570w" sizes="(max-width: 580px) 100vw, 580px" />

Outro efeito legal para galerias desenvolvido pelo pessoal do Codrops é o plugin jQuery Staple, que agrupa e empilha diferentes fotos e, além disso, se auto-ajusta no tamanho do viewport.

## Page Transitions {#page-transitions}

<a target="_blank" href="https://tympanus.net/codrops/2013/05/07/a-collection-of-page-transitions/">artigo</a> | <a target="_blank" href="https://tympanus.net/Development/PageTransitions/">demo</a> | <a target="_blank" href="https://github.com/codrops/PageTransitions">código-fonte</a>

<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/07/PageTransitions.jpg" alt="PageTransitions" width="580" height="315" class="alignnone size-full wp-image-37963" srcset="uploads/2013/07/PageTransitions.jpg 580w, uploads/2013/07/PageTransitions-309x168.jpg 309w, uploads/2013/07/PageTransitions-570x310.jpg 570w" sizes="(max-width: 580px) 100vw, 580px" />

Neste artigo, o autor apresenta uma séria de transições de páginas utilizando apenas CSS, sem JavaScript. Os exemplos incluem desde técnicas simples de _sliding_ até transições 3D.

## Modal Window Effects {#modal-window-effects}

<a target="_blank" href="https://tympanus.net/codrops/2013/06/25/nifty-modal-window-effects/">artigo</a> | <a target="_blank" href="https://tympanus.net/Development/ModalWindowEffects/">demo</a> | <a target="_blank" href="https://tympanus.net/Development/ModalWindowEffects/ModalWindowEffects.zip">código-fonte</a>

<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/07/ModalWindowEffects.png" alt="ModalWindowEffects" width="580" height="315" class="alignnone size-full wp-image-37961" srcset="uploads/2013/07/ModalWindowEffects.png 580w, uploads/2013/07/ModalWindowEffects-309x168.png 309w, uploads/2013/07/ModalWindowEffects-570x310.png 570w" sizes="(max-width: 580px) 100vw, 580px" />

Este experimento, publicado recentemente, é um dos meus favoritos. O artigo mostra 19 exemplos de janelas modais, com efeitos bem diferentes e fluidos.

## Caption Hover Effects {#caption-hover-effects}

<a target="_blank" href="https://tympanus.net/codrops/2013/06/18/caption-hover-effects/">artigo</a> | <a target="_blank" href="https://tympanus.net/Tutorials/CaptionHoverEffects/">demo</a> | <a target="_blank" href="https://tympanus.net/Tutorials/CaptionHoverEffects/CaptionHoverEffects.zip">código-fonte</a>

<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/07/CaptionHoverEffect.png" alt="CaptionHoverEffect" width="580" height="315" class="alignnone size-full wp-image-37958" srcset="uploads/2013/07/CaptionHoverEffect.png 580w, uploads/2013/07/CaptionHoverEffect-309x168.png 309w, uploads/2013/07/CaptionHoverEffect-570x310.png 570w" sizes="(max-width: 580px) 100vw, 580px" />

O que me impressiona nas demos do Codrops é que elas são extremamente simples e, mesmo assim, impactantes. Com esses efeitos de hover em imagens não é diferente. Mais uma vez, sem nenhum JavaScript, o Codrops vai fazer o seu queixo cair com algumas linhas de CSS e muita criatividade.

## Icon Hover Effects {#icon-hover-effects}

<a target="_blank" href="https://tympanus.net/codrops/2013/05/30/simple-icon-hover-effects/">artigo</a> | <a target="_blank" href="https://tympanus.net/Development/IconHoverEffects/">demo</a> | <a target="_blank" href="https://tympanus.net/Development/IconHoverEffects/IconHoverEffects.zip">código-fonte</a>

<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/07/IconHoverEffects1.png" alt="IconHoverEffects1" width="580" height="315" class="alignnone size-full wp-image-37960" srcset="uploads/2013/07/IconHoverEffects1.png 580w, uploads/2013/07/IconHoverEffects1-309x168.png 309w, uploads/2013/07/IconHoverEffects1-570x310.png 570w" sizes="(max-width: 580px) 100vw, 580px" />

De imagens para ícones e mais uma vez utilizando apenas CSS, este experimento mostra efeitos suaves e fluidos para o _mouseover_ em botões circulares.

## Natural Language Form {#natural-language-form}

<a target="_blank" href="https://tympanus.net/codrops/2013/05/21/natural-language-form-with-custom-input-elements/">artigo</a> | <a target="_blank" href="https://tympanus.net/Tutorials/NaturalLanguageForm/">demo</a> | <a target="_blank" href="https://tympanus.net/Tutorials/NaturalLanguageForm/NaturalLanguageForm.zip">código-fonte</a>

<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/07/NaturalLanguageForm2.png" alt="NaturalLanguageForm2" width="580" height="315" class="alignnone size-full wp-image-37962" srcset="uploads/2013/07/NaturalLanguageForm2.png 580w, uploads/2013/07/NaturalLanguageForm2-309x168.png 309w, uploads/2013/07/NaturalLanguageForm2-570x310.png 570w" sizes="(max-width: 580px) 100vw, 580px" />

Mais um dos meus favoritos, este tutorial mostra um protótipo interessantíssimo para formulários web utilizando o conceito e <a target="_blank" href="https://en.wikipedia.org/wiki/Natural_language_user_interface">Natural Language User Interface</a>. No exemplo, os formulários estão “escondidos” no texto e o objetivo final é que tudo fique muito transparente para o usuário.

## Simple Drop Down Effects {#simple-drop-down-effects}

<a target="_blank" href="https://tympanus.net/codrops/2012/11/29/simple-effects-for-drop-down-lists/">artigo</a> | <a target="_blank" href="https://tympanus.net/Development/SimpleDropDownEffects/">demo</a> | <a target="_blank" href="https://github.com/codrops/SimpleDropDownEffects">código-fonte</a>

<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/07/SimpleDropDownEffects.jpg" alt="SimpleDropDownEffects" width="580" height="315" class="alignnone size-full wp-image-37964" srcset="uploads/2013/07/SimpleDropDownEffects.jpg 580w, uploads/2013/07/SimpleDropDownEffects-309x168.jpg 309w, uploads/2013/07/SimpleDropDownEffects-570x310.jpg 570w" sizes="(max-width: 580px) 100vw, 580px" />

Seguindo no campo de formulários (com o perdão do trocadilho) temos um artigo que mostra um plugin jQuery para melhorar o visual e usabilidade de listas _drop-down_.

## Creative Buttons {#creative-buttons}

<a target="_blank" href="https://tympanus.net/codrops/2013/06/13/creative-button-styles/">artigo</a> | <a target="_blank" href="https://tympanus.net/Development/CreativeButtons/">demo</a> | <a target="_blank" href="https://github.com/codrops/CreativeButtons">código-fonte</a>

<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/07/CreativeButtons.png" alt="CreativeButtons" width="580" height="315" class="alignnone size-full wp-image-37959" srcset="uploads/2013/07/CreativeButtons.png 580w, uploads/2013/07/CreativeButtons-309x168.png 309w, uploads/2013/07/CreativeButtons-570x310.png 570w" sizes="(max-width: 580px) 100vw, 580px" />

E, finalizando, confiram dezenas de efeitos bastante sutis e inspiradores para botões e ações em interfaces web. A maioria dos efeitos são para _mouseover_, mas o experimento traz também alguns exemplos para eventos de clique.

## Bônus: Blueprints

Em meio aos artigos e tutoriais, o Codrops conta com uma categoria chamada <a target="_blank" href="https://tympanus.net/codrops/category/blueprints">Blueprints</a> que se destina a ser uma coleção de exemplos minimalistas de interfaces e componentes.

Os experimentos nesta categoria incluem <a target="_blank" href="https://tympanus.net/codrops/2013/05/17/horizontal-slide-out-menu/">menus</a>, <a target="_blank" href="https://tympanus.net/codrops/2013/04/17/responsive-full-width-grid/">grids</a>, <a target="_blank" href="https://tympanus.net/codrops/2013/02/26/full-width-image-slider/">sliders</a> e até mesmo um <a target="_blank" href="https://tympanus.net/codrops/2013/06/06/responsive-multi-column-form/">formulário responsive em mútliplas colunas</a>.

## Bônus 2: Collective

Outra categoria legal no Codrops é a <a target="_blank" href="https://tympanus.net/codrops/collective/">Collective</a>, uma compilação das últimas novidades no mundo do desenvolvimento web. As listas, lançadas semanalmente, trazem os últimos plugins, tutoriais, fontes, ícones e muito mais.