---
title: O kit do desenvolvedor Front-end
authors: Tailo Mateus Gonsalves
type: post
date: 2017-10-18
excerpt: Precisamos falar de código bom.
categories:
  - Tecnologias e tendências
tags:
  - Web Starter Kit
  - Front-end
image: https://cdn.slidesharecdn.com/ss_thumbnails/gwsk-141027203238-conversion-gate01-thumbnail-4.jpg?cb=1414514843
---


Quantas vezes você iniciou algum projeto e desistiu no meio do caminho? Ou entregou algo que não era o esperado?

A quem diga que projeto bom, é projeto entregue. Mas aqui entre nós programadores, quem não gosta de um código bonito e bem estruturado. A Google possui um "kit" de desenvolvimento front-end, podemos deixar esse processo de desenvolvimento um pouco mais simples. A finalidade deste artigo é lhe dar um caminho para estudos com links interessantes para cada item do [Web Starter Kit][1]. OBS: Lembrando que cada projeto é diferente, cabe a você e sua equipe definir o que é melhor.   

Você pode reproduzir o Web Starter Kit seguindo [esse artigo][2].

Vamos aos tópicos e os links:

1. Responsividade

	- [Framework Material Design][3]
	- [Design Responsivo na prática 2: do layout ao HTML][4] 
	- [Princípios básicos do Web design responsivo: https][5] 
	- [Web para dispositivos móveis][6] 
	- [Responsive Web Design - Media Queries][7] 
	- [9 basic principles of responsive web design][8] 

2. Compatibilidade com Sass

	- [Site Sass][9] 
	- [Working with Gulp (2)][10]  
	- [Getting Started with SASS (with Interactive Examples)][11] 
	- [Getting Started with Sass][12] 

3. Otimização de desempenho

	- [Introduction to Gulp][13] 
	- [An Introduction to Gulp.js][14] 
	- [GulpJS - Um gole de otimização no seu workflow][15] 

4. Inspeção de código

	- [Site Eslint][16] 
	- [Evitando erros com ESLint][17] 
	- [Detectando problemas automaticamente no JavaScript com ESLint][18] 

5. Servidor http

	- [Web Server for Chrome][19] 
	- [Introdução ao HTTP/2][20] 
	
6. Recarregamento de navegador em tempo real e sincronização entre dispositivos

	- [Browser-sync, indispensável para desenvolver sites em vários dispositivos][21] 
	- [How to Use BrowserSync for Faster Development][22] 
	- [BrowserSync: browsers sincronizados][23] 

7. Compatibilidade com modo off-line

	- [Service Workers: uma Introdução][24] 
	- [Getting started with Progressive Web Apps][25] 
	- [Your First Progressive Web App][26] 

8. Métricas de desempenho

	- [PageSpeed Tools][27] 


Esse kit não é um padrão que você deve seguir. Mas vale verificar e quem sabe adotar. 

Esqueci de algum link importante? Deixa nos comentários :) 


[1]: https://developers.google.com/web/tools/starter-kit/ 
[2]: https://tableless.com.br/google-web-starter-kit/
[3]: https://getmdl.io
[4]: https://tableless.com.br/design-responsivo-na-pratica-2-layout-ao-html/
[5]: https://developers.google.com/web/fundamentals/design-and-ux/responsive/?hl=pt-br
[6]: https://www.caelum.com.br/apostila-html-css-javascript/web-para-dispositivos-moveis/
[7]: https://www.w3schools.com/css/css_rwd_mediaqueries.asp
[8]: https://blog.froont.com/9-basic-principles-of-responsive-web-design/
[9]: https://sass-lang.com/
[10]: https://medium.com/@jontorrado/working-with-gulp-2-19376bfdd077
[11]: https://scotch.io/tutorials/getting-started-with-sass
[12]: https://alistapart.com/article/getting-started-with-sass
[13]: https://developers.google.com/web/ilt/pwa/introduction-to-gulp
[14]: https://www.sitepoint.com/introduction-gulp-js/
[15]: https://blog.da2k.com.br/2015/01/24/gulpjs-um-gole-de-otimizacao-no-seu-workflow/
[16]: https://eslint.org/
[17]: https://medium.com/@oieduardorabelo/evitando-erros-com-eslint-91b5a4bb9471
[18]: https://imasters.com.br/desenvolvimento/detectando-problemas-automaticamente-no-javascript-com-eslint/
[19]: https://chrome.google.com/webstore/detail/web-server-for-chrome/ofhbbkphhbklhfoeikjpcbhemlocgigb
[20]: https://developers.google.com/web/fundamentals/performance/http2/?hl=pt-br
[21]: https://blog.caelum.com.br/browser-sync-indispensavel-para-desenvolver-sites-em-varios-dispositivos/
[22]: https://scotch.io/tutorials/how-to-use-browsersync-for-faster-development
[23]: https://hugobessa.com.br/browsersync-browsers-sincronizados/
[24]: https://developers.google.com/web/fundamentals/primers/service-workers/
[25]: https://addyosmani.com/blog/getting-started-with-progressive-web-apps/
[26]: https://codelabs.developers.google.com/codelabs/your-first-pwapp/
[27]: https://developers.google.com/speed/pagespeed/