---
title: 'O futuro das interfaces: Chatbots'
authors: Raphael Guastaferro
type: post
date: 2017-02-13
url: /o-futuro-das-interfaces-chatbots/
categories:
  - Design
  - Javascript
  - Mercado
  - Mobile
  - Tecnologia e Tendências
  - UX
tags:
  - bot
  - chatbot
  - interface
  - Javascript
  - ui
  - ux

---
Estamos acostumados a interagir diariamente com interfaces gráficas, seja no computador, celular, tablet, smart tv, etc. Naturalmente incorporamos a utilização dessas interfaces para obter nossos objetivos no dispositivo em questão, seja fazer uma busca no google, ver uma página no Facebook, ler um artigo em um portal de notícias ou escolher um filme no Netflix.

Podemos não perceber, mas quando ligamos para um _call-center_ onde a máquina (**_URA — Unidade de Resposta Audível_**) nos pede para dizer em voz alta o que desejamos, ou o número correspondente ao que queremos, também estamos interagindo com uma interface de voz para atingir nosso propósito.

Nesses dois casos, o ponto a se notar é que, não importa como, mas é preciso de uma interface para que nós humanos possamos utilizar sistemas e dispositivos digitais.

## Legal, mas onde estão os chatbots nessa história?

Simples. Chatbots podem ser interfaces no qual vamos interagir para atingir nossos objetivos obter !

Para entender melhor, vamos a um exemplo clássico:

Você está passeando no shopping, passa na frente do cinema, e descobre que aquele filme que você queria ver já está em cartaz, então decide assistí-lo.

Porém a fila para comprar ingresso está enorme, você não quer perder todo esse tempo. Então você pega seu celular, entra na loja de aplicativos, procura o app de cinema, começa o download, após finalizar abre o app, seleciona sua cidade, shopping em que está, filme desejado, horário, quantidade de ingressos, e finaliza fazendo o pagamento. Você utilizou a interface gráfica do app de cinema do seu celular para atingir seu objetivo, ótimo, funcionou!

Porém, não poderia ser mais simples? E se você pudesse interagir via chat com um bot do cinema para comprar seus ingressos?

Vamos imaginar que o cinema tem um chatbot disponível no seu app de messenger favorito, o Facebook Messenger.

Você acessa seu messenger clica no usuário do cinema e envia a seguinte mensagem: &#8220;_Quero comprar dois ingressos para o filme Star Wars Rogue One, no shopping X, para a sessão das 21:45_&#8220;_._ Sua mensagem rapidamente vai ser interpretada, e em mais algumas frases rápidas de conversa (talvez para pagamento), você terá alcançado sua meta de comprar ingresso.

Você pode não ter percebido, mas assim como fazemos com interfaces gráficas, você interagiu com uma interface para manipular um sistema, e atingir seu objetivo! Você interagiu com uma interface de chatbot!

<img src="https://diegoeis.github.io/tableless-static-images/2017/02/cb2.jpg" alt="" width="626" height="782" />

## **Porque esse tipo de interface é promissora?**

Falando especificamente sobre a era da internet, e das interfaces para os dispositivos atuais (desktop, celulares, tablets), há anos equipes inteiras (UI Designers, UX Designers, Developers, CEO, etc) discutem incansavelmente sobre qual a melhor forma de atingir seus usuários.

Inúmeros fatores nas interfaces/interação podem ser relevantes em produtos e sistemas. Nas empresas e instituições, sempre existem discussões voltadas para esses e outros fatores:

&#8211; Cores, formas, fontes e fotos &#8211; Performance e velocidade de páginas e procedimentos &#8211; Quais conteúdos são mais relevantes para o usuário &#8211; Qual o máximo de cliques que um usuário pode ter para alcançar o que deseja

Portanto, o caminho para uma boa conversa com nosso usuário em questão não é tão simples como parece.

Além desses pontos, temos uma discussão importantíssima sobre o negócio em si, sobre como o sistema lê, processa e devolve dados e informações, sobre como o sistema irá se comportar diante do usuário.

E se pudéssemos &#8220;_pular uma etapa_&#8221; e focar mais tempo para o que importa? Se pudéssemos focar no objetivo do usuário, e buscar a forma melhor e mais rápida de concluir processos?

Partindo do pressuposto de que a maioria dos usuários de internet sabem utilizar um chat, os chatbots excluem a curva de aprendizado das interfaces gráficas, facilitando para os desenvolvedores do produto, e para o usuário, que poderá interagir utilizando um processo que se assemelha com a comunicação com outros humanos via internet.

> “_Nós pensamos que você deve enviar uma mensagem para uma empresa da mesma maneira que você envia a um amigo_” — Mark Zuckerberg na Facebook F8 Conference

E ainda não falamos dos detalhes mais técnicos: conexão, rede de dados, apps, espaço disponível no dispositivo…

Para interagir com um chatbot, sua conexão não precisa ser tão rápida quanto para baixar um app, ou carregar um site. Você não precisa trafegar muitos dados a ponto de acabar com seu pacote diário de internet para conversar num chat. E se o bot está no app que você utilizar para conversar com seus amigos, não será necessário ocupar mais espaço no seu dispositivo.

São muitas vantagens, não?!

## As interfaces gráficas vão morrer?

Não há nenhuma resposta certa, para essa pergunta. É uma questão que só poderá ser respondida com o passar dos anos.

Na minha opinião, as interfaces podem perder muito espaço, mas não vão morrer completamente. Mesmo num futuro, imagino que sempre haverá algum caso em que pode uma interface gráfica pode ser útil, mesmo que para pequenas interações.

Também não conseguimos prever com certeza o futuro dos chats. O próprio chatbot do Facebook Messenger tem a capacidade de enviar <a href="https://developers.facebook.com/docs/messenger-platform/product-overview" target="_blank" rel="nofollow noopener">botões, imagens e outros elementos gráfico</a>s.

## Concluindo

A intenção desse post foi refletir um pouco sobre interfaces, e sobre vantagens e o poder dos chatbots.

Obviamente, isso é só a ponta do iceberg das discussões sobre chatbots e seu futuro. Mas em pouco tempo de reflexão podemos enxergar um futuro promissor!

Originalmente postado em: <https://medium.com/botsbrasil/o-futuro-das-interfaces-chatbots-b222c638bdb1>