---
title: Vote no Especialista em Usabilidade para Presidente
authors: Alysson Franklin
type: post
date: 2010-10-21
excerpt: A usabilidade é algo muito abrangente e você, profissional front-end, tem muito a ver com isso.
url: /vote-no-especialista-em-usabilidade-para-presidente/
categories:
  - AJAX
  - Artigos
  - Browsers
  - Código
  - CSS
  - HTML
  - Javascript
  - JQuery
tags:
  - acessibilidade
  - Browsers
  - CSS
  - desenvolvimento web
  - design
  - Javascript
  - JQuery
  - Na Prática
  - UCD
  - usabilidade

---
###### ﻿(A discussão deste post vale para aplicações de grande porte, o que não significa que a mesma abordagem possa ser aplicada com sucesso em ambientes menores como blogs, por exemplo)

**Usabilidade** é um termo usado para definir a facilidade com que as pessoas podem empregar uma ferramenta ou objeto a fim de realizar uma tarefa específica e importante. Podemos dizer que a Usabilidade é empregada também para oferecer uma experiência de aprendizado fácil e intuitiva, fazendo com que o usuário tenha maior produtividade, navegando / utilizando sua aplicação rapidamente, memorizando operações e comentendo menos erros.

Usabilidade é um assunto muitas vezes subestimado em toda a cadeia de produção de um aplicativo. Veja bem, estou me referindo a **aplicativos** porque este assunto vai além do escopo de desenvolvimento web. A Usabilidade é um assunto pertinente a **todo** o ciclo de vida do projeto, e sua aplicabilidade envolve o nível executivo, o tático e o operacional.

E apesar de envolver vários níveis em uma organização, um dos roles mais importantes na _hierarquia de poder_ do projeto (ainda mais agora com o HTML5) é o do desenvolvedor web responsável pela prototipação dos templates que recebem as funcionalidades de uma aplicação. Componentes e objetos desenvolvidos em outras camadas devem obedecer formatos de saída definidos para a camada web, o que transforma a responsabilidade (o poder&#8230;) do Especialista de Usabilidade em diferencial na otimização de processos de desenvolvimento de outras frentes, fornecendo as informações necessárias sobre o comportamento do browser com os componentes criados (e como ele deveria se comportar) &#8211; como a informação entra e sai das telas, como ela é embalada para consumo, o que pode ser feito no front-end X o que vai para o middleware, economizando horas de desenvolvimento&#8230; obviamente a lista de vantagens é maior e fica visível a medida que o projeto caminha. Uma camada web bem escrita é um mar aberto, tranquilo. Navegar com _navios e jangadas_ em um cenário desses é mais rápido, mais tranquilo e o melhor de tudo, mais barato.

As aplicações web de grande porte hoje em dia são monstruosas quando analisadas do ponto de vista da arquitetura. Não é raro você encontrar projetos que façam uso de várias tecnologias para atingir determinado objetivo. Um exemplo pertinente é o <a title="Veja o Google Instant em ação" href="https://www.google.com/instant/" target="_blank">Google Instant</a>: Lançado em setembro, o Instant é uma colcha-de-retalhos de 16 diferentes tecnologias feito para otimizar suas pesquisas. O ganho com esse upgrade no engine de busca fica entre 2-5 segundos por busca. Aonde entra a Usabilidade aqui? Facilitando o usuário a fazer uma pesquisa de maneira mais rápida. &#8211; “Mas a rapidez do search do Google já é incrível. Pra que melhorar um tempo de busca que já é absurdamente rápido? Vale o custo-benefício?”

Sim. Vale e muito. Perguntar isso é pensar apenas em um ambiente restrito. É manter a cabeça no ambiente desktop. A web é maior que isso. Temos uma infinidade de dispositivos que hoje a acessam para compartilhar e usar informação. Quando aplicamos a solução nas pesquisas dos browsers dos smartphones, o Instant se transforma em uma das melhores soluções deste ano em termos de Usabilidade.

<div id="attachment_2138" style="width: 207px" class="wp-caption alignright">
  <a href="../uploads/2010/10/usability-as-a-top1.png"><img class="size-medium wp-image-2138" src="../uploads/2010/10/usability-as-a-top1-296x300.png" alt="Do planejamento a execucao de testes, a Usabilidade deve ser uma discussão constante" width="197" height="199" srcset="uploads/2010/10/usability-as-a-top1-296x300.png 296w, uploads/2010/10/usability-as-a-top1.png 454w" sizes="(max-width: 197px) 100vw, 197px" /></a><br /> 
  
  <p class="wp-caption-text">
    Usabilidade deve ser tratada em todas as competências do projeto
  </p>
</div>

E se isso é feito em um browser, a responsabilidade de encapsular todas essas 16 tecnologias em uma sopa de letrinhas que o navegador vai ler bonitinho, sem erros, e com coesão visual é do desenvolvedor web, mas com certeza podemos considerar que em um futuro próximo o seu estoque de leite estará acabando e além da sua geladeira informar o fato, ela vai te dar uma lista dos locais mais baratos para garantir que você não fique sem o produto.

Quem vai garantir que a ferramenta de busca da geladeira vai conseguir ler o catálogo de produtos que sua empresa tem que criar com o mais novo contrato assinado (Aquele do portal de laticínios)? Fica visível o impacto da atuação do Especialista nas vendas da empresa.

Um bom Plano de Usabilidade tem que passar por todas as competências envolvidas em um projeto: **Planejamento, Análise, Design e Testes / Upgrades.**

Como falamos, uma aplicação web é exibida na maioria das vezes em um browser. E os Especialistas em navegadores somos nós. Se os navegadores fossem balanças, teríamos em um prato a **aplicação,** e no ****outro teríamos a **necessidade do usuário.** Os dois são muito pesados e seus valores aumentam e diminuem ao longo do projeto. Para atingir o **equilíbrio** em uma balança desse tipo precisamos de **lastros** para balanceá-la, e nosso lastro é a **Usabilidade.**

<div style="width: 386px" class="wp-caption alignleft">
  <img src="https://upload.wikimedia.org/wikipedia/commons/9/96/Basmati_Johns_%28peas_and_basmati_rice%29.jpg" alt="Um mexidão preparado em um prato altamente decorado." width="376" height="249" />
  
  <p class="wp-caption-text">
    Em uma boa embalagem, até um mexidão fica mais apetitoso
  </p>
</div>

Defendo fortemente o uso de desenvolvedores web com fluência no front-end (nossa amada trinca HTML/CSS/JS) como os Especialistas de Usabilidade. A culinária francesa é um grande exemplo: famosa pelo sabor mas também pela &#8220;embalagem&#8221; na qual oferece seus alimentos, ela mostra que o design é algo fundamental na experiência de quem consome o produto. Organizar o prato em &#8220;fases&#8221; para que os sabores possam combinar harmoniosamente tambem é uma abordagem usada nessa fase de design &#8211; indicando ao cliente a sequência de ações para que o sabor de ingredientes mais fortes não faça desaparecer a mais suave especiaria. Em outras palavras, o chef está ensinando o cliente a comer o seu prato. Nós também precisamos fazer isso quando trabalhamos o design de nossas aplicações &#8211; mesmo com os features e plugins do jQuery mais bem desenhados da internet, nós ainda temos que nos preocupar em como a informação trafega por este design para garantir que a experiencia do usuário, independente da plataforma ou navegador seja a mais rica possível (e a mais próxima da pedida pelo seu cliente).

Por sermos em nossa maioria multidisciplinares, normalmente o perfil do desenvolvedor de front-end não o restringe apenas as tecnologias mencionadas acima (e um Especialista não pode se escorar apenas nestes skills para atuar, o roadmap para esta carreira é maior, porém de aprendizado fácil e lógico para nós) mas a um combinado de tecnologias para garantir que se necessário, ele possa gerar uma solução de front-end do zero, embalando diferentes camadas de aplicação em um produto que o usuário não pense para operar, mas seja levado pela intuição, agregando valor a experiência vivida no produto que você criou. Isso garante que ele poderá, em conjunto com o Arquiteto e líderes de outras frentes (Java, Banco de dados, Negócio) discutir abordagens mais eficazes para os componentes que a aplicação terá, uma vez que elas terão que ser embarcadas, inevitavelmente, em HTML para renderização em browsers. O papel do Especialista é evitar que problemas no desenvolvimento explodam na ponta do usuário, _domando_ tudo que foi desenvolvido por todos os times para a aplicação em um documento com significado, heurística, taxonomia e funcionalidade reconhecíveis por browsers, web services, motores de busca, dispositivos e o que mais pintar por ai. E dos 5 maiores problemas em Usabilidade, 4 sao de responsabilidade direta do HTML:

Conteudo
:   Quando você abre a página em um navegador, o que você vê? Se você criou um site aplicando regras de Usabilidade, você deve ver 80-90% o que seu cliente está procurando. No entanto, com a maioria dos sites, geralmente o que seu cliente está procurando constitui apenas entre 50-60% (ou menos), a parte principal da página. O resto está nas intrusivas propagandas, navegação confusa e gráficos e cores estranhos.

Layout
:   Intimamente relacionado ao conteúdo é a forma como esse conteúdo é exibido na página. Embora os estudos têm mostrado que usuários estão dispostos a dar scroll para ler páginas web, se eles não encontram conteúdo relevante rapidamente eles são saem do seu website. Mantenha sua páginas limpas e simples. Teste remoção de elementos, faça análises e pondere se sua aplicação precisa realmente deles.

Cores
:   As cores afetam a usabilidade do seu website. Elas podem ser uma importante ferramenta cognitiva – como também podem confundir. Cor em elementos de páginas podem afetar leitores de tela por exemplo. Informações codificadas em imagens ou cores podem não ser reconhecidas por leitores de tela e Progressive Enhancement pode ser usado para resolver o problema. Um estudo de cores é também necessário para que pessoas com daltonismo não sejam impactadas em sua experiência.

Velocidade de renderização
:   O acesso à Internet pode estar ficando mais e mais rápido, mas isso não significa que o HTML deve ficar maior. Estudos de Usabilidade para Web continuam a mostrar que a velocidade de renderização da página/componentes é muito importante. Em um portal de conteúdo a demora pode fazer o usuário perder o interesse, não importa o quanto eles estavam interessados no tema. Você não pode controlar todos os aspectos da renderização (download) &#8211; por isso é importante fazer o que puder para que o HTML &#8211; o documento que carrega o significado da página &#8211; seja renderizado (e compreendido) rapidamente pelo browser.

Um HTML bem escrito, limpo e escalonado garante uma melhora sensível no desenvolvimento de um projeto. Ter um desenvolvedor HTML como Especialista de Usabilidade garante que o cóodigo gerado pelo time de integração vai ser o mais enxuto possível, afinal de contas um desenvolvedor HTML precisa saber que para resolver situações como a de velocidade de renderização de página por exemplo, precisamos*:

  * Fazer o menor número possível de requisições HTTP em uma página;
  * Garantir o uso de CDNs para otimizar o tempo de resposta de uma requisição HTTP;
  * Garantir um uso eficiente da memória cache do navegador, adicionando cabecalhos Expires para otimizar as requisições HTTP, fazendo AJAX ou outra tecnologia se aproveitar de tudo que pode ser deixado no cliente;
  * Utilizar gzip para compactar HTML, scripts e estilos;
  * Chamar o estilo no topo das páginas, evitando declarações inline e se possivel chamando pela tag <link>, ou seja, sempre em arquivos externos;
  * Rodar os scripts no final da página (ou garantir que uma função apenas rode após o document.ready) e sempre que possível em arquivos externos
  * Usar o Keep-alive e poucos dominios para reduzir as pesquisas de DNS (isso pode mudar agora no HTML com o localStorage em alguns casos específicos);
  * Sempre compactar o javascript e remover chamadas duplicadas, garantindo uma biblioteca leve e centralizada para suas funções;
  * Evitar redirecionamentos.

Algumas coisas podem soar como óbvias mas é comum o já _marginalizado_ HTML (assunto para outro post) ser entregue a responsabilidade de desenvolvedores de outras frentes (como java por exemplo) para garantir um prazo de entrega mais rápido e menor custo, uma vez que desenvolvimento e integração acontecem no mesmo momento. HTML é sim uma linguagem realmente simples. Porém ela também é muito criteriosa e domina-lá é a garantia entre os milhões de page-views e um mirror do seu-site-que-fechou-ano-passado no web archive. Estamos falando de milhares/milhões de visitas e transações simultâneas, alta performance, alta colaboração, interoperabilidade de dispositivos, garantia cross-browser, garantia de baixo impacto e custo para mudanças estruturais futuras da aplicação (design), redução de gastos na implementação do projeto devido a rapidez da integração dos componentes ao front-end, de um responsável em entender as requisições do cliente e discutí-las com linguagem simples, para garantir que as expectativas criadas possam ser atingidas na camada web da aplicação e devidamente repassadas para as outras frentes do projeto. A lista é maior. Não é pouca coisa e o mais indicado para preencher esta demanda somos nós. Se a satisfação do usuário é medida diretamente pela sua experiência no front-end, somos nós os presidentes. Detalhando um passo-a-passo de Usabilidade, isso fica mais claro ainda:

[<img class="aligncenter size-full wp-image-2139" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2010/10/visual_map.png" alt="Um mapa mostrando todas as etapas de um Plano de Usabilidade" width="681" height="454" srcset="uploads/2010/10/visual_map.png 890w, uploads/2010/10/visual_map-300x200.png 300w" sizes="(max-width: 681px) 100vw, 681px" />][1]

Voltaremos a esse Plano de Usabilidade no próximo post, discutindo a criticidade de cada uma das etapas, e aplicabilidade de acordo com tamanho e prazo de entrega do projeto, porém posso adiantar que das 26 etapas, em pelo menos 17 um profissional sênior de HTML/CSS/JS deve ter grande desenvoltura, com atuação moderada/leve ou massiva:

Colaboração leve e moderada
:   Criação do SOW (Statement of Work), Condução de Análise de Tarefas, Desenvolvimento de Atores, Cenários de Teste, Definição de métricas, objetivos, Análise de cartas, Casos de uso, Preparação do Plano de Testes, Análise e geração de relatórios.

Colaboração massiva
:   Especificação do site, Inventório de conteúdo, Arquitetura da Informação, Reconhecimento de padrões visuais para textos, Design paralelo, Release da aplicação, Testes de Usabilidade, Testes de Heurística.

Com certeza o Plano de Usabilidade acima é utópico. É como o socialismo &#8211; se pudéssemos aplicar 100% da sua teoria, o mundo seria lindo. Porém o custo para a manutenção de uma estrutura aonde o diagrama acima possa ser 100% executado não é proibitivo, porém considerável. E quanto maior o projeto, mais necessária a sua aplicação, e maior o ROI de Usabilidade.

Mas lidar com a Usabilidade requer as etapas descritas, isso é fato. O negócio é **flexibilizar**, entendendo as necessidades do cliente e aplicando seus conhecimentos nas etapas que forem aplicadas no seu projeto. E sempre pensar em Usabilidade e Escalabilidade e Acessibilidade enquanto escreve seus templates. Acabou de criar um portal de venda de lingerie? Sera que suas listviews estao preparadas para o inevitável sucesso da aplicação (afinal você é um grande desenvolvedor) e futura integração via webservices com seus mais novos contratos, um portal de produtos de beleza e um portal de cabeleireiros?

Como eu disse no inicio do post, este fluxo de trabalho é muito mais real para portais e aplicações web de médio/grande porte. Se seu site tem um stickiness alto, independente do porte, você também pode ponderar sobre a adoção dos métodos acima, afinal se você otimiza a experiência do usuário e ele feliz, recomenda seu produto, é o seu nome que está na vitrine. E este tipo de profissional está em falta no mercado, sendo disputado a _tapa_ por empresas.

No próximo post detalho o passo-a-passo do Plano de Usabilidade, e tambem alguns métodos de Usabilidade para serem aplicados no desenvolvimento web, alem de Design Centrado no Usuário (UCD).

*Se estes bullets soam como Javanês nos seus ouvidos, recomendo fortemente a leitura de um livro sensacional do **Steve Souders** chamado **High Performance Web Sites.**

******<a title="Aprendendo o estado-da-arte em Usabilidade" href="https://www.nngroup.com/events/tutorials/usability.html" target="_blank">Tá com grana no bolso para o investimento de uma carreira?</a>

Referências:

  * <a href="https://webdesign.about.com/od/usability/tp/aatpwebusable.htm" target="_blank">Most Important Web Usability Issues</a>
  * [Usability.gov &#8211; Visual Map][2]
  * [How do colors affect purchases?][3]
  * <a href="https://oreilly.com/catalog/9780596529307" target="_blank">High Performance Web Sites &#8211; Essential Knowledge for Front-End Engineers</a>

 [1]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2010/10/visual_map.png
 [2]: https://www.usability.gov/methods/process.html
 [3]: https://blog.kissmetrics.com/color-psychology/?wide=1