---
title: O Designer Gladiador
authors: Bernard De Luna
type: post
date: 2013-08-27
excerpt: 'Maximus era um grande guerreiro e demonstrava ser um excelente observador, desde pegar um punho de terra até reconhecer gladiadores nervosos e grandes parceiros de batalha. Antes de iniciar um projeto, você precisa reconhecer a arena e todas as suas variáveis. '
url: /o-designer-gladiador/
dsq_thread_id: 1654355123
categories:
  - Artigos
  - Design
tags:
  - bernard
  - design
  - gerenciamento
  - projeto
  - redesign

---
> Em 2012 fechei um contrato de lançar um livro sobre as etapas e conceitos em cima de um projeto digital, no meio do caminho decidi abortar o livro e seguir um caminho aberto onde todos possam ter acesso ao conteúdo de forma gratuita. Assim, publicarei alguns dos textos criados 🙂

Em Design, a primeira coisa a ser feita em um projeto é a pesquisa sobre o negócio do cliente, mas só ouvi chamarem essa pesquisa inicial de arena em um curso de planejamento que fiz com o Professor Jorge Langone em 2009 na PUC Rio. Fiquei apaixonado pelo conceito de ARENA, principalmente por me fazer lembrar do aclamado filme de Ridley Scott &#8211; O Gladiador. Principalmente pela atuação de Russell Crowe e seu personagem General Máximus, que tem uma relação de soberania com a arena e com aqueles que fazem parte dela.

O que faz Máximus triunfar nas batalhas, tanto como general quanto gladiador é ser um exímio espectador. Consigo ainda separar três qualidades do personagem na arena, que fariam Máximus ser também um designer de sucesso:

### Relacionar com o cenário antes de um projeto

Antes de erguer-se para um combate, o personagem de Russel Crowe sempre pegava um punhado de terra em suas mãos como forma de ritual, assim conseguia imergir na arena.

### Identificar os pontos fracos

Em uma outra cena, antes de abrirem os portões, Máximus observa o nervosismo de um jovem que está a sua frente. Sabiamente, o general traça uma nova estratégia, mantendo distancia do ponto fraco para um combate vitorioso.

### Identificar e potencializar os diferenciais

O que fez o aclamado “Espanhol” conseguir triunfar em sua missão pessoal contra Cómodo, foi saber aplicar seus diferenciais de combate adquiridos em guerras para sobreviver, conseguir o respeito dos outros gladiadores, liderá-los na arena e por fim conquistar os romanos.

## Reconhecendo a Arena

Quando temos a missão de iniciar um novo projeto ou um redesign, devemos começar com cinco perguntas simples e primordiais:

  * Por que você criou esse projeto?
  * Para que você criou esse projeto?
  * Para quem você criou esse projeto?
  * Por que alguém usaria o seu projeto?
  * Por que alguém NÃO usaria o seu projeto?

Essas perguntas podem ser feitas através de um questionário por email, uma conversa informal em um café ou em um bar (de preferência o segundo), até mesmo dissolvido em um Briefing. O importante é forçar aquele que será o seu cliente (mesmo que seja um cliente interno) a pensar no projeto antes de confiá-lo a você. Iniciar um projeto sem ter essas perguntas bem respondidas e definidas pode gerar um grande ruído e até mesmo uma ruptura de projeto mais para frente.

Há alguns anos atrás, um cliente chegou para mim com um projeto inovador para eu gerenciar, montei a equipe indicada para desenhar esse aplicativo e começamos a projetar a interface desse App que poderia suprir a necessidade de muitos profissionais e empresas. No fim dos processos de Design, os sócios acreditavam que a interface não estava valorizando o serviço como uma empresa séria. Foi a primeira vez entre todos os meses de projeto que foi informado que o Design não era de um App e sim de uma empresa. Culpa toda nossa por ter feito as perguntas erradas, assumimos o prejuízo do retrabalho e nos realinhamos em cima da realidade do projeto e ele foi lançado em cima das expectativas e exigências do cliente.

## Resistindo à tentação da arte

Seus pais, sua namorada(o) e a maioria dos seus amigos não conseguem saber a diferença entre Design e Arte, mas e você?

Antes de se pensar no projeto, precisamos definir quem somos e como atuaremos, pois só sabendo quem somos poderemos traçar uma postura para lidar com nosso cliente. Uma das formas mais ricas que já encontrei sobre quem somos é através dos ideais traçados por Jakob Nielsen, onde o mesmo diz:

> O ideal artístico de expressar-se e o ideal da engenharia de resolver um problema para o cliente. Este livro coloca-se firmemente ao lado da engenharia. Embora eu reconheça que haja necessidade de arte, alegria e diversão na Web, acredito que o principal objetivo da maioria dos projetos da web seja facilitar aos clientes o desempenho de tarefas.
> 
> <p align="right">
>   Jakob Nielsen, Designing web usability: The practice of simplicity
> </p>

Sendo assim, podemos assumir que somos engenheiros, somos facilitadores, somos resolvedores de problemas, somos projetistas e utilizamos a arte como uma das estratégias criativas para resolução dos problemas de nossos clientes. Então, assumindo que “o principal objetivo da maioria dos projetos da web seja facilitar aos clientes o desempenho das tarefas“, como podemos limitar o nosso trabalho à interface? Devemos primeiro investigar toda a atmosfera, ou se preferir, a Arena e todas as suas variáveis, identificando:

  * O cenário
  * Os clientes
  * Os objetivos
  * As tarefas
  * O problema

Esses itens ordenados são tão inspiradores que podemos traçar até um roteiro, onde “ao observar um cenário, podemos identificar os nossos clientes e quais objetivos que eles desejam realizar, observando cada tarefa que precisa ser cumprida e a interação dos usuários com essas tarefas, a fim de mapear possíveis problemas e projetar uma melhor experiência“.

Infelizmente, nem sempre poderemos resolver os problemas, seja por motivo técnico, filosófico, organizacional ou até mesmo de logística da empresa. Já vi empresa de médio porte trocar de marca e de nome por causa de reclamações de usuários. O problema claramente não era na interface, nem nos produtos e sim de logística que gerava muitas vezes a não entrega ou a entrega fora do prazo.

Atualmente com as redes sociais e ferramentas de monitoramento, é muito mais simples identificar tais problemas de descontentamento, seja para um projeto de valorização da marca, ou até mesmo para se guarnecer de um possível não retorno esperado do seu cliente.

Lançar algum projeto pulando etapas pode gerar uma frustração para os usuários e para o seu cliente. Se o tempo ou o investimento for curto, dê preferência a retirada de algumas funcionalidades e não da perda de qualidade do projeto, pense que você deseja comprar um carro, se você não tiver dinheiro para aquele modelo completo, você vai comprar aquele modelo só que sem ar condicionado, sem ser 4 portas, sem trava e vidro elétrico, mas nunca com o carro funcionando pior ou feito de qualquer maneira.

_
  
**Que o preparo e pesquisa referencial é importante todos sabemos. Mas no dia-a-dia de correria, deadlines e cobranças, a tentação de pular etapas sempre fica presente, e infelizmente as gambiarras chegam a ser recomendadas pelos colegas, o que acaba aumentando a inclinação do profissional à ceder às pressões. Apenas os indivíduos realmente sérios e convictos mantém a cabeça fria e seguem os processos necessários para entregarem soluções embasadas a seus clientes.
  
** 
  
**Após ouvir centenas de idéias de negócios, minha paciência com as pessoas preguiçosas se esgotou. Caso você tenha assistido o programa Dragons Den* [BBC] você verá que investidores não tem tempo para idéias sem fundamento e pesquisa. Palavras são totalmente inúteis caso a pessoa não tenha números sólidos e de fontes confiáveis comprovando as teorias sendo apresentadas.
  
** 
  
**Um exemplo de falta de pesquisa é a decisão da implementação da linguagem de programação criada pelo Facebook: o FBML, caso eles tivessem perguntado a sua base de usuários, teriam descoberto que as pessoas prefeririam usar o bom e velho HTML, ou sua versão nova o HTML5, que além de mais flexível e robusto, já faz parte da base de conhecimento dos programadores de interface que por tanto tempo lutaram com as restrições da rede social mais popular do mundo. Veja outros #fails do Facebook: <https://on.mash.to/q4JoF3>
  
** 
  
**Tendo trabalhado em uma dezena de agências digitais, já sofri as conseqüências de assumir projetos sem pesquisa. Sites que irritam, campanhas que não convencem e aplicativos que não são baixados são muitas vezes frutos de arrogância, pressa ou inexatidão de dados de pesquisa. Por exemplo: muitos criativos publicitários parecem esquecer que o país inteiro não possui um Iphone 4S, nível superior completo e pagaria R$300 pela entrada de um show ao vivo. De fato nem a metade dos Brasileiros sequer tem acesso a internet hoje (Ibope NetRatings).
  
** 
  
**Portanto antes de falar tenha absoluta certeza de seus dados, tenha a segurança e conforto do conhecimento, a riqueza e apoio dos dados verídicos, para depois não ficar com cara de bobo, ou pior, sofrer as conseqüências de um fracasso financeiro e/ou jurídico. Entenda seu público, seus concorrentes e seu produto para poder fazer bonito, e ainda mostrar os resultados de um trabalho bem planejado. Caso depois o projeto não dê certo, pelo menos você fez toda a preparação necessária para no mínimo, salvar seu emprego!
  
** 
  
**Bernardo Carvalho** é ex-diretor de Projetos na NBS (NoBullshit.com.br) com 13 anos de experiência no mercado de criação digital em Londres e no Rio de Janeiro.
  
_