---
title: Sobre o design oco
authors: Diego Eis
type: post
date: 2014-12-11
excerpt: Sobre design ordinário e argumentos.
url: /o-design-ordinario-oco/
categories:
  - Design
  - UX

---
Quando construímos um padrão de interface para qualquer tipo de produto digital, é necessário que esse padrão se perpetue, caso contrário seu trabalho não valerá de nada. Esse padrão precisa ser protegido durante todo a produção do projeto, offline ou online, não importa. Para que essa perpetuidade seja real, você e sua equipe precisarão defender esse padrão e para defendê-lo você precisa de argumentos. É aí que o problema aparece.

Não sei se você já tentou convencer alguém que o design e o trabalho de user experience são importantes. Eu já tentei algumas vezes e nenhuma das vezes foi agradável. O trabalho de design e da experiência do usuário são coisas intangíveis. Eu não consigo mostrar o quanto a mudança de design de um site aumentarão as vendas, antes desse design for publicado.

> Entender que design é importante precisa estar na essência de quem dirige o produto.

Manter um design antigo só por que vende, pode ser a decisão mais racional, mas está longe de ser a ideal. Era assim com o Google até eles decidirem mudar toda sua interface e a experiência de uso dos seus produtos. Um concorrente direto do Google é a Apple, uma empresa que respira design. O Google era uma empresa essencialmente dominada por programadores. O Google soube em algum momento que a falta de design — ou o design ruim — atrapalharia seus planos a longo prazo. Sim, o design é um fator decisivo para diversos usuários. Mas é comum as empresas não priorizarem decisões de mudanças no site/produto baseadas nas necessidades de design ou UX.

É engraçado pois todo mundo gosta de ver algo bonito. Você compra coisas físicas julgando principalmente dois aspectos: design e facilidade de uso. Você não compra algo porque é feio e difícil de usar. Ou compra?

Com software isso não deveria ser diferente. E na verdade não é. O usuário geralmente prefere algo atraente, que funciona bem e que ele não perca tempo usando.

## Arranjando argumentos

Mas como nós arranjamos argumentos para defender um padrão visual? Como arranjamos argumentos para defender um novo design para produtos ou sites que já estão dando certo?

Simples: não faça aquele design que é bonito mas ordinário.

> Manja aquele design bonito, mas oco? É esse que você não pode fazer.

Você encontra esse tipo de design em toda parte. Dá um pulo no Theme Forest ou até no Dribbble. Já rolaram algumas [discussões sobre a superficialidade dos designs][1] que rondam o Dribbble e outros serviços parecidos.

### Nenhum elemento vem do além

Eu quero dar um exemplo claro usando ainda o Material Design do Google. Se você ainda não viu a documentação deles, vamos ver agora a parte onde eles explicam sobre botões, [entra aí nesse link][2].

> We struggle with the right words to describe the design process at Apple, but it is very much about designing and prototyping and making. [Jonathan Ive][3]

No Material Design existem três tipos de botões: o floating button, raised button e o flat button. No início parece que não é necessário ter tantos tipos de botões, mas se você pensar direito, há diversos cenários diferentes no ambiente mobile e também no desktop. Cada cenário tem um contexto diferente e que exige uma atenção maior ou menor para as ações.
  
<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/12/material-design.png" alt="material-design" width="928" height="799" class="alignnone size-full wp-image-46185" srcset="uploads/2014/12/material-design.png 928w, uploads/2014/12/material-design-161x139.png 161w, uploads/2014/12/material-design-400x344.png 400w" sizes="(max-width: 928px) 100vw, 928px" />

Eles também tomaram cuidado para indicar a frequência de uso de cada tipo de botão, além dos lugares específicos onde cada tipo de botão é usado. Entenda que há ciência nisso aí! Se há um padrão, há organização. Se há organização o cérebro do usuário entende melhor as regras de uso, as restrições etc etc.

<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/12/material-buttons.png" alt="material-buttons" width="1400" height="736" class="alignnone size-full wp-image-46186" srcset="uploads/2014/12/material-buttons.png 1400w, uploads/2014/12/material-buttons-265x139.png 265w, uploads/2014/12/material-buttons-400x210.png 400w" sizes="(max-width: 1400px) 100vw, 1400px" />

A quantidade de elementos de um mesmo tipo também não será problema, já que há restrições de uso. Claro que você não vai adotar uma coleção de 10 botões… Nesse caso inteligência e bom senso precisam ser uma qualidade na sua equipe.

Quando há um motivo para cada elemento na tela, você ganha argumentos. Se você simplesmente coloca um elemento na tela porque achou que era tendência do mercado, você perde. Se você coloca porque achou bonitinho, você perde. Esse é o design oco, vazio, ordinário.

Você também ganha argumentos descobrindo as falhas e as vantagens do site/produto atual. Tendo informações sobre o projeto atual, você não precisa sair da estaca zero. Você saberá exatamente como as vendas acontecem ou como elas são perdidas. Isso pode ser levado para a próxima versão, pode ser testado e aprimorado.

Esse é o ponto onde é preferível [realinhar seu visual e os comportamentos do que fazer um redesign total][4]. Quando você realinha você evolui o design. Você filtra as coisas ruins. Quando você redesenha, você cai num mundo de incertezas e precisa fazer o trabalho de evolução partindo do zero. E claro, seus argumentos terão que ser bem fortes para defender um redesign completo. Quando você realinha, você refaz uma pequena parte do website/produto. Se você faz um realinhamento de vários componentes durante o ano, ao final você vai ter um produto novo, testado de forma modular e sabendo que cada componente tem um sentido para estar ali.

Obviamente você só pode fazer um realinhamento se você tem uma boa base estrutural. Há coisas que só se resolvem refazendo tudo. Outras não. O Redesign nesse caso é um reboot importante para que o produto não seja modificado dramaticamente nas próximas vezes.

## Concluindo

Na verdade esse é um pensamento ainda pouco explorado em um monte de empresas. Aqui na Locaweb estamos no processo de reboot. Infelizmente é um processo doloroso. Mas há a certeza de que os próximos passos serão mais fáceis. Os argumentos serão mais fortes e teremos números importantes falando ao nosso favor. Aqui é um pouco mais fácil porque [temos um framework][5] que nos ajuda no processo de padronização de (quase) todas as interfaces da empresa. Mas esse é outro papo.

 [1]: https://blog.intercom.io/the-dribbblisation-of-design/
 [2]: https://www.google.com/design/spec/components/buttons.html
 [3]: https://www.standard.co.uk/lifestyle/london-life/sir-jonathan-ive-the-iman-cometh-7562170.html
 [4]: https://alistapart.com/article/redesignrealign
 [5]: https://locaweb.github.io/locawebstyle/