---
title: 2015 – O ano em que o celular ultrapassou o desktop
authors: Rodrigo Fávaro
type: post
date: 2015-07-20
excerpt: Como o Mobile mudou não apenas a internet, mas também a nossa vida e como lidamos com a tecnologia.
url: /2015-o-ano-em-que-o-celular-ultrapassou-o-desktop/
categories:
  - Artigos
tags:
  - google
  - Mobile
  - ux

---
O Google promoveu este ano o <a href="https://www.thinkwithgoogle.com/intl/pt-br/collections/mobile-day.html" target="_blank">Mobile Day</a> e ajudou a compreendermos ainda mais tudo que envolve este mercado que está mudando completamente a forma que o ser humano interage com tecnologia.

Todo o material compartilhado pode ser encontrado diretamente nos blogs do Google, mas eu vou compartilhar com vocês aqui algo de forma um pouco mais resumida e também com algumas opiniões a respeito do tema baseado em minha experiência.

## Por que Mobile?

A resposta vem com outras simples perguntas:

  * Por que eu vou ficar na fila do banco?
  * Por que eu vou ficar na chuva para pedir um taxi?
  * Por que eu vou tentar ficar discando 50x na lanchonete que eu gosto até que o telefone não esteja mais ocupado e o atendente anote meu pedido?

Muitas dessas revoluções aconteceram há pouco mais de um ano e, por incrível que pareça, tornamos tão dependentes disso que parece que é algo que sempre foi parte da nossa realidade. Resumidamente, não conseguimos mais imaginar o mundo sem todas essas facilidades.

Atualmente temos um mundo onde novos usuários de internet estão nascendo graças ao Mobile. Celulares com valores acessíveis em países emergentes principalmente estão facilitando muito a adesão de tecnologia por parte da grande massa. O que poderemos tirar de benefício dessa nova leva de usuários?

Antes do Mobile, tínhamos no mundo aproximadamente 1.4 bilhões de usuários desktop de um total de 7 bilhões de pessoas. Com o Mobile a possibilidade de conectar todo mundo é bem real e isso jamais foi visto na história da humanidade.

Pesquisas apontam que visualizamos o celular aproximadamente 150 vezes ao dia. Fazendo então uma conta simples, se cada usuário utilizada tanto assim o celular, e temos cada vez mais usuários, a soma de conexões possíveis é algo inimaginável, e por incrível que pareça, isso ainda está apenas no começo.

Pessoas e principalmente empresas estão aprendendo ainda a como tirar proveito disso tudo. Mal posso esperar pelo dia em que vamos conseguir tirar o máximo disso tudo.

A pergunta então não é mais &#8220;Por que fazer Mobile&#8221; e sim &#8220;Como fazer Mobile?&#8221; e aí temos três pontos que temos que levar em consideração na hora de fazer bem mobile:

  1. Repensar a experiência;
  2. Repensar a comunicação;
  3. Repensar as métricas;

## Site ou App?

Esta é uma boa pergunta. Temos alguns dados de que os usuários passam aproximadamente 14% do tempo em navegadores e 86% em aplicativos. Isso não necessariamente implica em uma preferência por aplicativos e consequentemente uma necessidade de se criar um aplicativo. Algumas das experiências nos browsers foram feitas para serem rápidas, como uma pesquisa de uma receita, uma notícia esportiva ou mesmo localizar o endereço de uma empresa. São experiências rápidas e é assim que deveriam ser. Dessa forma, cada tipo de segmento precisa elaborar uma estratégia para ver qual canal se adéqua melhor para conquistar usuários.

Para começar, é fundamental ter um Mobile Site (site móvel), pois durante uma pesquisa no Google por exemplo, seu site estará visível para qualquer usuário. Quando essa experiência do usuário começar a ficar reduzida por falta de recursos, aí sim é o momento de pensar num aplicativo. Os navegadores não conseguem oferecer ao usuário todas as experiências que o app consegue, e é neste momento em que o app passa a ser uma necessidade.

Vamos a um simples exemplo:

Caso você fosse um banco, provavelmente iria querer que todos os seus clientes consigam achar a sua localização. Uma Mobile Site neste caso seria suficiente. Ninguém iria baixar um App apenas para achar seu endereço. No entanto, esses clientes podem querer fazer mais coisas além de apenar achar o endereço, como depósitos, transferências e pagamentos, por exemplo. Esta é uma experiência mais rica do que a suportada pela web. Sendo assim, **você tem a web para alcance e os aplicativos para uma experiência mais rica**. Esta certamente é a melhor resposta para a pergunta &#8220;Site ou App?&#8221;

**UX (Repensar a Experiência)**

UX é uma expressão que vem do inglês _User Experience_, ou seja, a experiência de utilizar alguma coisa. Apesar de muitas definições, basicamente podemos considerar UX como sendo a forma de facilitar a vida do usuário para que ele não precise de manual para utilizar seu aplicativo. Torne a vida do usuário mais fácil, e consequentemente a sua vida também será mais fácil.

Neste momento, surge uma nova pergunta: como desenvolver então um site/app que garanta uma boa experiência para meu usuário?

Segundo <a href="https://plus.google.com/+avinash/posts" target="_blank">Avinash Kaushik</a>, o Google gastou muito tempo e dinheiro no último ano levantando uma lista com 25 técnicas para ter o melhor site mobile. O material serve tanto para quem está começando a desenvolver algo mobile tanto para quem já é experiente, principalmente para reforçar e driblar os vícios que todo bom programador tem.

A lista contempla as seguintes técnicas:

  1. Destaque seus _calls-to-action_ (botões de ação);
  2. Mantenha os menus curtos;
  3. Facilite a volta para a página principal;
  4. Não permita que as promoções roubem a cena;
  5. Torne o campo de busca visível;
  6. Certifique-se de que a busca é relevante;
  7. Implemente os filtros de busca;
  8. Ofereça melhores resultados de busca;
  9. Navegação sem cadastro inicial;
 10. Permita que façam compras como visitantes;
 11. Use informações já existentes (login Facebook/Google+);
 12. Crie botões de &#8220;clique para ligar&#8221;;
 13. Facilite a conclusão da conversão em outro dispositivo;
 14. Simplifique a entrada de informações;
 15. Facilite a forma de inserir informações;
 16. Forneça um calendário visual ao selecionar datas;
 17. Reduza erros e faça validação em tempo real;
 18. Projete formulários eficientes;
 19. Otimize o site inteiro para mobile;
 20. Não force o zoom na tela;
 21. Ofereça imagens de produtos expansíveis;
 22. Informe os usuários sobre a melhor orientação da tela;
 23. Mantenha o usuário em uma única janela;
 24. Evite falar em &#8220;Site Completo&#8221;;
 25. Facilite a localização do usuário;

São muitos tópicos que realmente merecem atenção e vão onerar um pouco o prazo e também o orçamento para desenvolvimento, mas são coisas fundamentais que garantirão uma melhor experiência do usuário. Para ver a lista criada pelo Google com todos os detalhes, basta clicar <a href="https://think.storage.googleapis.com/intl/ALL_br/docs/25-tecnicas-site-mobile_research-studies.pdf" target="_blank">aqui</a>.

## Anúncios Mobile (Repensar a Comunicação)

Muitos usuários não são muito fãs de anúncios, principalmente os Anúncios Mobile. Será que talvez esse fato não seja uma oportunidade? Uma questão interessante que podemos levantar é a seguinte: imagine três meios de divulgar um anúncio, sendo ele um jornal, uma tv e um celular. Todos estão divulgando um livro. Qual desses três meios possui um botão de comprar? Ou seja, em qual deles é mais fácil o usuário já efetuar a compra imediatamente? Esta é uma questão que nos faz pensar e muito a respeito de Anúncios Mobile.

Nós temos a web, uma incrível plataforma de relacionamento. Podemos falar com nossos consumidores em todos os momentos, não só os com fins comerciais. Nós podemos ver todos os seus comportamentos. Podemos entretê-los, informá-los e fornecer utilidade para eles.

_See, Think, Do and Care _(Veja, Pensa, Faça, Cuide) nos mostram que existem quatro grupos de audiência diferentes, e nós, como profissionais/empresas de marketing precisamos nos certificar de que vamos estar presentes em todos esses grupos.

  * _See _ &#8211; Nada mais é do que o momento inicial em que o usuário está buscando informações sobre determinado produto ou serviço. É o que podemos chamar de pesquisa geral, ainda sem intenção de compra.
  * _Think _&#8211; Aqui já há uma pré-seleção de marcas e/ou produtos/serviços, ou seja, o usuário afunilou todas as opções que tinha para uma quantidade menor para filtrar melhor até que possa decidir pela compra.
  * _Do _ &#8211; Esta é a etapa principal. Aqui o usuário já escolheu o que quer e está no momento de compra. Para chegar até aqui, todo o trabalho que já discutimos até aqui precisa ter sido feito com qualidade, para garantir que estivéssemos entre os escolhidos e por fim estarmos na decisão final de compra do usuário.
  * _Care _&#8211; Não menos importante, aqui precisamos cuidar daquele usuário que se relaciona com a empresa mais de uma vez, ou seja, ele vira um cliente fiel, que compra mais de duas vezes com a empresa. Este cliente precisa de uma atenção especial, pois como diz o ditado, é mil vezes mais fácil e barato manter um cliente do que conquistar um novo cliente.

[<img class="aligncenter wp-image-50216 size-full" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/07/see-think-do-care-audience-intent-clusters.png" alt="see-think-do-care-audience-intent-clusters" width="625" height="460" />][1]

## Mensuração e Atribuição (Repensar as Métricas)

Todos nós que anunciamos buscamos por conversões, conversões e conversões. Se a audiência não estiver no estado _Do, _medir conversões nas etapas _See _e _Think _é idiotice, estupidez. Medir todos os momentos que importam é essencial para o sucesso. Atualmente, uma grande parte mede apenas o sucesso do último clique, esquecendo de todo o processo que fez o usuário efetuar a compra, que incluí portanto o conhecimento da existência do produto através de um anúncio de revista na quinta-feira, uma pesquisa para mais detalhes deste produto no Google via celular na sexta-feira, uma olhada com detalhes em fotos de grande resolução do produto através de meu desktop no sábado, e por fim a compra em um domingo a tarde em meu tablet deitado no sofá da sala.

Vamos falar um pouco sobre mensuração. No celular, os formatos de mensuração são os mais diversos possíveis, mais eficientes e em tempo real. Alguns exemplos:

  * Geração de Leads;
  * Ligações para a Empresa;
  * Cross-device;
  * Comércio móvel;
  * Download do aplicativo;
  * Visitas à loja;
  * Tráfego do site;
  * Engajamento do usuário;

A importância do Mobile pode ser equiparada a um jogo de futebol. Todo o crédito fica sempre com o artilheiro, ou seja, aquele que faz o gol. Ninguém lembra do outro jogador, que deu o passe para que o artilheiro pudesse marcar o gol. Com o Mobile é a mesma coisa, ou seja, tudo pode começar por ele, mas a finalização (o gol) é feito através de um desktop, por exemplo.

Falando em **Micro Conversões**, que são importantes de serem medidas para chegar num ROI (_return on investment_ &#8211; retorno sobre o investimento), podemos utilizar como exemplo a situação a seguir:

<div id="attachment_50215" style="width: 610px" class="wp-caption aligncenter">
  <img class="wp-image-50215" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/07/ROI.jpg" alt="ROI" width="600" height="353" />
  
  <p class="wp-caption-text">
    Exemplo de análise de retorno sobre o investimento mobile
  </p>
</div>

Temos portanto um investimento de $ 1 Milhão que, se não contabilizadas as Micro Conversões, teríamos um resultado de apenas $ 1 Milhão, ou seja, eu gastei 1, e tive 1 de resultado. Neste modelo, analisando as Micro Conversões, que são compras através de cross device (vi pelo celular, comprei pelo desktop), vendas pelo telefone (vi no celular, liguei e fiz a compra por telefone) e download de apps (que me geraram receitas futuras), observamos que o retorno foi de $ 4.5 Milhões, e não apenas de $ 1 Milhão. Este é portando o desafio na hora de analisar as métricas. Não fazendo uma análise detalhada, o cliente poderá deixar de anunciar simplesmente porque o X que ele investiu trouxe o mesmo X de retorno, não sendo portanto algo vantajoso para ele.

Como faço então para analisar essas métricas? O primeiro passo é deixar o Google Analytics funcionando corretamente em seu site ou app. O Google Analytics por si só exige um tempo considerável de estudo para que se possa fazer todos os tipos de análise e chegar a relatórios que realmente tragam informações relevantes para o negócio. O foco desta postagem não é ensinar a usar o Google Analytics. Sendo assim, eu recomendo que você faça o <a href="https://analyticsacademy.withgoogle.com/course01" target="_blank">Curso Oficial de Google Analytics</a> caso queria aprender mais sobre a ferramenta.

## Análises Finais

Brasil:

  * Quinto maior mercado de smartphones do mundo;
  * Apenas 5% do investimento publicitário é em mobile;

Site Mobile:

  * Mais alcance;
  * Primeiro contato;

App:

  * Experiência mais rica;
  * Consumidores fiéis;

25 Princípios:

  * Teste seu site

_See Think Do Care_

  * Escolha o formato certo;
  * E a mensagem certa;

Micro Conversões

  * Enxergue valor além do último clique;

Minhas considerações sobre tudo isso são simples. Temos &#8211; felizmente &#8211; muita informação na web para que possamos aprender e aplicar todas as boas práticas para termos um bom negócio Mobile. Assim como as práticas de SEO, as práticas Mobile são fundamentais mas na correria acabam ficando de lado. Sempre que elas ficarem de lado, lembre-se de que gastar um pouco mais de energia agora é o que garantirá que você não gaste o dobro de energia no futuro tendo um retrabalho por falta de resultados.

&#8220;_Os consumidores esperam e merecem experiências mobile incríveis&#8221; &#8211; Larry Page_

Esta publicação foi inspirada no documentário que você pode assistir a qualquer momento abaixo:

[youtube https://www.youtube.com/watch?v=CK_j5Qbuq5k?rel=0]

Inspirado: <a href="https://www.thinkwithgoogle.com/intl/pt-br/collections/mobile-day.html" target="_blank">Think With Google</a> &#8211; <a href="https://www.kaushik.net/avinash/see-think-do-care-win-content-marketing-measurement/" target="_blank">Avinash</a>

 [1]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2015/07/see-think-do-care-audience-intent-clusters.png