---
title: Novidades Adobe Creative Cloud 2017
authors: Diego Eis
type: post
date: 2016-12-19
url: /novidades-adobe-creative-cloud-2017/
enclosure:
  - https://images-tv.adobe.com/avp/vr/17da0fa7-490c-4daa-a14e-9507b290149a/dff07833-7104-474a-a2ff-ab7c541aa8b6/5a25eade-06f4-4ae7-980b-286f35a97369_20161021120402.960x540at1200_h264.mp4
categories:
  - Publieditorial
  - Tecnologia e Tendências
---

A Adobe anunciou esses dias algumas novidades para o [Creative Cloud 2017][1]. Muitas das atualizações focaram em usabilidade e também algumas novas integrações nos serviços de cloud, como o TipeKit e o Creative Cloud Libraries.

Aqui vão algumas novidades do Photoshop e do Illustrator, que são os programas que mais uso. Mas toda a suite do Creative Cloud teve alterações.

## Photoshop

Como esperado, o Photoshop ganhou suporte de uso com o Touch Bar do novo MacBook lançado pela Apple meses atrás. Você consegue usar a Touch Bar em algumas modos: Layers Properties (que é o modo default), Brushes, Favorites. [Nesse link][2] você consegue ter mais detalhes sobre a interface e as funcionalidades que a Adobe preparou para a Touch Bar.

![][3]

Além dos comandos desses três modos, outras operações especificas ficaram disponíveis dependendo do que você está trabalhando no Photoshop. São coisas bem simples, que na minha opinião, talvez você nem vá se acostumar tanto (mas acho que isso vai de pessoa para pessoa). Por exemplo, quando você ferramentas de Transform ou Texto, a Touch Bar mostra as opções de OK ou Cancel. Coisas que você já consegue resolver hoje usando o teclado.

O Photoshop também ganhou suporte para fontes OpenType SVG. Agora é possível acessar qualquer uma das fontes OpenType instaladas no seu computador diretamente pelo menu do Photoshop.

Uma feature, e talvez a mais interessante, foi a Busca. Como se fosse um Spotlight do Mac, onde você ativa com o comando CMD/CTRL+F, digita o comando desejado ou outros termos.

![][4]

Se liga [nesse vídeo de apresentação][5] dessa feature de busca.

## Illustrator

Sem dúvida meu software favorito do Adobe Creative Cloud. Com ele eu comecei a aprender a pintar quadrinhos ([dá uma olhada aqui][6]). É com ele também que eu fazia layouts para sites. Eu sei, você pode ser daqueles caras que vão me julgar por não fazer layouts usando Photoshop&#8230; Na verdade, a ferramenta pouco vai importar perante o resultado, não é verdade? Vamos para as novidades&#8230;

Para começar o Illustrator teve sua interface quase que totalmente remodelada, saindo do antigo cinza sem graça para um cinza mais claro, perto do branco, praticamente a mesma interface do Photoshop e InDesign.

Outra novidade é o que eles chamam de Live Font Previewing, que já tem no Photoshop e agora também no Illustrator, que é a possibilidade de ver o preview da font direto na letra enquanto você escolhe. Isso adianta um trabalho gigante e não sei por que não havia antes.

<img src="https://diegoeis.github.io/tableless-static-images/2016/12/live-font-preview.gif" alt="live-font-preview" width="800" height="480" class="aligncenter size-full wp-image-56691" />

Uma feature MUITO bacana é a possibilidade de importar um texto direto de um arquivo para dentro de um shape específico. Tipo, se você tiver um triângulo, por exemplo, você preenchê-lo com um texto vindo de um arquivo **.txt**, por exemplo. Logo, alguém, que não tenha o programa, consegue atualizar e modificar o texto, com as especificações do designer, claro.

Uma coisa que sempre me deixava furioso no Illustrator era o zoom. Geralmente o Zoom aproximava a arte levando em consideração o centro da tela. Agora, apertando o atalho **cmd/ctrl + + (sinal de mais)**, o Illustrator faz o zoom levando em consideração a sua seleção.

<img src="https://diegoeis.github.io/tableless-static-images/2016/12/zoom-to-selection_3.gif" alt="zoom-to-selection_3" width="964" height="822" class="aligncenter size-full wp-image-56693" />

Existem várias [outras novidades do Illustrator nesse link][7].

É possível acompanhar todas as [novidades dos produtos da Adobe nesse link][8]. Além disso, dá para ver os vídeos do [evento MAX, que rolou no dia 2 de Novembro de 2016][9].

## Só um pitaco sobre o Dreamweaver

Eu sempre brinquei sobre usar seriamente o Dreamweaver como um editor para desenvolvedores profissionais. Mas o Dreamweaver melhorou demais nos últimos tempos, incluindo uma série de features bem legais.

<video allowairplay="allow" controls style="width: 100%; height: auto;" src="https://images-tv.adobe.com/avp/vr/17da0fa7-490c-4daa-a14e-9507b290149a/dff07833-7104-474a-a2ff-ab7c541aa8b6/5a25eade-06f4-4ae7-980b-286f35a97369\_20161021120402.960x540at1200\_h264.mp4"></video>

Ele foi quase que totalmente reestruturado pra facilitar a gestão dos assets, além de ajudar muito a combinação HTML+CSS. A Adobe tem dado uma atenção bem legal para quem está começando na área e tem o DreamWeaver como ponto inicial de contato, com várias ajudas contextuais para tirar dúvidas sobre HTML, CSS e JS. Além de ter suporte nativo aos pré-processadores comuns do mercado.

![][10]

A feature que mais me chamou atenção foi o que eles chamam de **Quick Edit**. Quando você encontra uma classe no seu HTML, e essa classe está atrelada a algum CSS, você consegue alterar o CSS desse elemento rapidamente ali mesmo, contratualmente, no HTML.

<img src="https://diegoeis.github.io/tableless-static-images/2016/12/quick-edit.gif" alt="quick-edit" width="768" height="432" class="aligncenter size-full wp-image-56692" />

Veja [todas as features do Dreamweaver 2017 aqui][11]. Vale a pena dar uma nova chance, já que ele tem ficado mais esperto a cada versão.

 [1]: https://www.software.com.br/p/adobe-creative-cloud
 [2]: https://helpx.adobe.com/photoshop/using/touchbar.html
 [3]: uploads/2016/12/v3_TopView_new.jpg
 [4]: uploads/2016/12/All_tab.png
 [5]: https://www.adobe.com/creativecloud/features.photoshop-cc-in-app-search.socialshare.html?scid=social67131146#photoshop-cc-in-app-search
 [6]: https://diegoeis.deviantart.com/art/Battle-Chasers-in-vetor-6907950
 [7]: https://helpx.adobe.com/illustrator/using/whats-new.html
 [8]: https://www.adobe.com/creativecloud/features.html
 [9]: https://max.adobe.com/sessions/max-online/
 [10]: https://helpx.adobe.com/dreamweaver/using/whats-new/_jcr_content/main-pars/image_1350455085.img.gif/codehint.gif
 [11]: https://www.adobe.com/br/products/dreamweaver/features.html