---
title: Você sabe o que é a “nova usabilidade”? – parte I
authors: Talita Pagani
type: post
date: 2011-12-05
excerpt: A usabilidade não pode se focar apenas para desktops e notebooks, mas para dispositivos emergentes, que são utilizados hoje e os que ainda irão surgir.
url: /nova-usabilidade-parte1/
categories:
  - Design
  - Acessibilidade
tags:
  - Mercado
  - Mobile
  - Tecnologia e Tendências
  - UX
  - usabilidade
---

Vimos na [parte I][1] e [parte II][2] dos artigos [sobre usabilidade em dispositivos móveis][3] que as heurísticas permanecem praticamente as mesmas tanto para as aplicações móveis quanto convencionais, a diferença é o quão crítica ou severa elas se tornam para as aplicações móveis. Por este motivo, Thomas e Macredie propuseram em 2002 (sim, há 9 anos!) o paradigma da Nova Usabilidade.

> &#8220;A usabilidade convencional e mais amplamente disseminada tem suas bases no paradigma do computador pessoal. Tecnologias e aplicativos emergentes, como telefones celulares, TV interativa e computação ubíqua, trazem novos desafios para a usabilidade e demandam uma análise crítica de seus pressupostos. A “nova usabilidade” busca metodologias, teorias e ferramentas que sejam adequadas às tecnologias e aplicativos emergentes.&#8221; [[Workshop sobre “Usabilidade de Aplicações e Tecnologias Emergentes: a Necessidade de uma “Nova Usabilidade”?” no IHC 2006][4]].

Este novo paradigma denota uma revisão a usabilidade com outro olhar para atender novos dispositivos e novas formas de interação. O que muda neste novo olhar sobre a usabilidade é basicamente o a abrangência contextual. Como assim? A usabilidade como conhecemos considera essencialmente o contexto da interação entre o usuário e o sistema e já vimos que isto traz limitações. Neste novo cenário, é preciso agregar novas variáveis sobre o contexto de uso:

  * Informações dos hábitos e preferências do usuário
  * O ambiente social do usuário
  * As tarefas e objetivos do usuário

<div id="attachment_4590" style="width: 548px" class="wp-caption aligncenter">
  <a href="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2011/11/Slide1.jpg"><img class="size-full wp-image-4590  " src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2011/11/Slide1.jpg" alt="Escopo da Nova Usabilidade" width="538" height="403" srcset="uploads/2011/11/Slide1.jpg 960w, uploads/2011/11/Slide1-300x225.jpg 300w" sizes="(max-width: 538px) 100vw, 538px" /></a>
  
  <p class="wp-caption-text">
    Escopo da Nova Usabilidade
  </p>
</div>

Agregando múltiplas informações de contexto e mais a necessidade de uso e os interesses do usuário em relação a estes dispositivos, temos uma amplitude do modelo do usuário. Isto permite flexibilizar interfaces para que elas se adaptem ao contexto de uso.  Isto tem totalmente a ver com a [Qualidade em Uso][5].

Para este primeiro contato com o tema, deixo aqui as seguintes reflexões adaptadas do artigo clássico de Thomas e Macredie:

  * Quanto detalhe estamos perdendo com as metodologias tradicionais?
  * Qual a função do teste de usabilidade na avaliação destas novas formas de interação?
  * Quais metodologias de design e avaliação (teste/inspeção) são requeridas para garantir a facilidade de uso de tecnologias emergentes e ubíquas?
  * Como as abordagens de design e avaliação de interfaces podem ser flexíveis para abranger tecnologias futuras?

No próximo artigo, serão abordados os novos desafios que este paradigma tenta solucionar.

## Referências

IHC 2006. Workshop de Usabilidade de Aplicações e Tecnologias Emergentes: a Necessidade de uma “Nova Usabilidade”?. Disponível em: <https://www.dimap.ufrn.br/ihc2006/workshop.php>

Peter Thomas and Robert D. Macredie. 2002. Introduction to the new usability. ACM Trans. Comput.-Hum. Interact. 9, 2 (June 2002), 69-73. <https://doi.acm.org/10.1145/513665.513666>

Peter Thomas and Harold Thimbleby. 2002. The new usability: the challenge of designing for pervasive computing. In Proceedings of the 15th international conference on Computer communication (ICCC &#8217;02), S. V. Raghavan and Sudhir P. Mudur (Eds.). International Council for Computer Communication, Washington, DC, USA, 382-388.

Kelma Madeira et al. Uma Avaliação do Orkut utilizando Personas sob a ótica da Nova Usabilidade. In: VIII Simpósio Brasileiro de Fatores Humanos em Sistemas Computacionais (IHC 2008), Porto Alegre, 2008.

 [1]: https://tableless.com.br/usabilidade-de-interfaces-para-dispositivos-moveis-parte1/
 [2]: https://tableless.com.br/usabilidade-interfaces-dispositivos-moveis-parte2/ "Usabilidade de interfaces para dispositivos móveis – parte II"
 [3]: https://tableless.com.br/usabilidade-de-interfaces-para-dispositivos-moveis-parte1/ "Usabilidade de interfaces para dispositivos móveis – parte I"
 [4]: https://www.dimap.ufrn.br/ihc2006/workshop.php
 [5]: https://tableless.com.br/qualidade-em-uso-expandindo-a-usabilidade/