---
title: Nem só de client-side vive um site
authors: Diego Eis
type: post
date: 2011-08-28
excerpt: |
  |
    É errado pensar que apenas por que você escreveu código HTML semântico seu site aparecerá em primeiro no Google ou ficará mais acessível para deficientes visuais. O código client-side é apenas a porta de entrada para uma série de outras pendências.
url: /nem-so-de-client-side-vive-um-site/
tweetbackscheck:
  - 1356397670
shorturls:
  - 'a:3:{s:9:"permalink";s:58:"https://tableless.com.br/nem-so-de-client-side-vive-um-site";s:7:"tinyurl";s:26:"https://tinyurl.com/436m26o";s:4:"isgd";s:19:"https://is.gd/iWRjuG";}'
twittercomments:
  - 'a:7:{i:108272256345583618;s:7:"retweet";i:111144456949989376;s:7:"retweet";i:109004925756907520;s:7:"retweet";i:108917283732209664;s:7:"retweet";i:164732688195010562;s:7:"retweet";i:164375208889827329;s:7:"retweet";i:164373101767954432;s:7:"retweet";}'
tweetcount:
  - 14
dsq_thread_id: 503040230
categories:
  - Código
  - CSS
  - HTML
tags:
  - 2011
  - acessibilidade
  - CSS
  - html
  - revistawide
  - SEO

---
<small>Artigo publicado originalmente na revista Wide em Janeiro/Fevereiro de 2011.</small>

Estou feliz porque o mercado de client-side tem amadurecido de forma inteligente no Brasil. Empresas mais espertas entenderam a importância do código HTML/CSS/ JavaScript bem escrito. O problema é que grande parte das empresas, clientes e desenvolvedores acham que o trio HTML/CSS/JavaScript faz milagres. É certo pensar que um código bem escrito traz grandes vantagens para o projeto, mas ele sozinho não faz milages.

É errado pensar que apenas por que você escreveu código HTML semântico seu site aparecerá em primeiro no Google ou ficará mais acessível para deficientes visuais. O código client-side é apenas a porta de entrada para uma série de outras tarefas.

### SEO

Para criar um projeto de SEO é preciso seguir uma série de etapas que formam um grande pacote e que só então é possível perceber as vantagens do trabalho do SEO.
  
O código client-side entrará como uma pequena parte do esforço. De forma bem simples, podemos listar alguns pontos importantes que precisamos tomar atenção além do HTML bem feito:

  * Estudo de concorrentes;
  * Definição de diagramação e quantidade de texto nas diversas partes do site;
  * Estudo de palavras chave e termos de uso;
  * Planejamento de landing pages, entradas e saídas;
  * Criação de robot.txt e sitemap.xml;
  * Monitoramento de palavras, visitação e buscadores;
  * Estudo de funil e preparação de goals;

Eu não sou um especialista do Google nem nada do gênero, mas sei que estes tópicos são importantes ao manter ou criar um website otimizado. O HTML certamente faz parte destes tópicos, mas ele não invalida nenhum dos outros pontos.
  
Obviamente não adianta nada fazer um bom estudo de palavraschave e marcá-las de forma errada com HTML.

### Acessibilidade

Como em projetos de SEO, o planejamento de Acessibilidade precisa de uma série de etapas funcionar corretamente. No caso da acessibilidade o HTML ocupa um grau de importância muito grande, contudo, há pequenos pontos que o HTML não pode resolver sozinho. Veja alguns exemplos:

  * Contraste e cores do layout;
  * Estudo de atalhos de teclado;
  * Menu de navegação rápida;
  * Textos em tooltips, titles, alts de imagens etc;
  * Tamanho de botões e textos;
  * Arquitetura de Informação sensata e simples;

Embora algumas das tarefas sejam resolvidas com HTML/CSS, as definições e metas são pensadas pelos desenvolvedores. Qual cor, tamanho de botões e etc são decididos pelo designer e não pelo HTML. Não é incomum acharmos que apenas porque o site tem um código bem estruturado e semântico ele será bem acessado por cegos com leitores de tela ou pessoas com outro tipo de necessidade. Há tópicos que se dependem meramente do bom senso.

Se analisarmos bem as disciplinas de Acessibilidade, Usabilidade e Arquitetura de Informação, perceberemos que elas comandam a forma com que o trio HTML/CSS/Javascript devem se comportar. Há várias etapas e decisões que tomamos antes de colocarmos a mão no código. Cada um tem sua importância. Muitos erros de HTML podem ser evitados com um planejamento de Arquitetura de Informação. Muito código CSS pode ser otimizado estudando os wireframes do projeto.

Lembre-se de que o HTML/CSS/Javascript serve o conteúdo e não contrário. Eles devem trabalhar para que a informação seja bem exibida, formatada e que chegue integralmente para o usuário.