---
title: 'Não se esqueça: você é um comunicador'
authors: Eduardo Fernandes
paid: true
type: post
date: 2014-07-14
excerpt: Comunicação é o objetivo final do nosso trabalho. E o meio pelo qual ele se realiza
url: /nao-se-esqueca-voce-e-um-comunicador/
dsq_thread_id: 2842469122
categories:
  - Mercado

---
Se você já está há alguns anos na profissão de fazer websites, provavelmente percebeu que o cerne do seu trabalho é a comunicação, não necessariamente a tecnologia.

Mas, espere aí? Por definição, tecnologia não é comunicação? Isso não é completamente óbvio?

Vamos com calma. Refiro-me, especialmente, à comunicação interpessoal, em sua forma escrita ou presencial.

Agora questione: quantas vezes você já pensou em si mesmo como um comunicador? Ou melhor: como alguém cuja principal tarefa é ser compreensível?

Explico:

  1. Direta e indiretamente, passamos muito tempo estabelecendo acordos com clientes, gerenciando relações com colegas de trabalho e estilos de chefias.

  2. Também precisamos escrever, ler e entender corretamente certas documentações.

  3. Exercemos a cidadania em ambientes coletivos on-line como Stack Overflow, GitHub etc. Temos que aprender a perguntar, procurar, responder, criticar, aceitar críticas. Tudo isso limitados e potencializados por certas interfaces e códigos de comportamento<sup id="fnref:1"><a href="1" rel="footnote">1</a></sup>.

  4. Nosso código, em si, também precisa ser limpo e bem comentado. Usamos técnicas como Object-oriented programming, entre outras, para nos tornarmos compreensíveis entre colegas de trabalho. E inteligíveis / flexíveis / responsáveis ao longo do tempo<sup id="fnref:2"><a href="2" rel="footnote">2</a></sup>.

  5. O próprio código é comunicação. Com computadores e com pessoas, claro. É por isso que você vai encontrar parágrafos [como esse][1], escrito por Marco Arment, o criador do Instapaper, sobre a nova linguagem da Apple, a [Swift][2]:
    
    > Código mais simples é ótimo, mas menos código que não é, na verdade, mais simples, não necessariamente ajuda — é só mais difícil de ler, de aprender e mais difícil de enxergar erros. A maioria dos exemplos que vi do Swift não é muito mais simples que seus equivalentes de Objective-C — apenas mais concisa.

  6. Com a popularização da internet, temos que aprender a lidar com mais diversidade. De repente, questões como gêneros (especialmente como se comunicar adequadamente com mulheres), classes sociais, nacionalidades, identidades sexuais, tudo isso acaba se tornando mais visível e urgente no ambiente de trabalho (on e off-line).

Eu poderia ir muito mais além nesses itens. Mas poucos teriam saco de lê-los. O que eu quero deixar muito claro é a ideia de que **a profissão de produzir sites é 100% comunicação**, em diversos níveis. Isso não é um detalhe. Não é uma responsabilidade para outros.

Portanto, em vez de nos preocuparmos apenas em aprender novas tecnologias, novos frameworks etc, ajudaria imensamente aprender a flexibilizar nossa comunicação. Ou melhor: **estudar** comunicação. Pelo menos nos abrirmos para o fato de que somos **comunicadores**.

Muitos de nós somos autodidatas, aprendemos na raça — ao custo de habilidades sociais — e perdemos uma noção mais ampla da nossa profissão.

Outros, por terem feito faculdade de comunicação, tendem a desprezar o assunto. Pensam na comunicação apenas como uma disciplina acadêmica ou uma espécie de gaveta, na qual, por exemplo, o design está incluído.

Mas comunicação é o objetivo do nosso trabalho. E o meio pelo qual ele se realiza.

Eu preciso me lembrar disso de vez em quando, você não?

[^1]:    
    Por exemplo, no Stack Overflow, posts agradecendo por respostas são considerados ruído de comunicação e, às vezes, filtrados pelo próprio sistema. O que não significa que as pessoas sejam necessariamente rudes.<a href="1" rev="footnote">&#8617;</a>

[^2]:    
    E isso poderia ser chamado de **Ecologia da Programação**. Quer dizer: a maneira pela qual os códigos (de Ruby a CSS, com suas funções específicas) lidam com o ambiente. Que resíduos eles produzem, que transformações induzem na web etc. E também **Economia da Programação**: o mercado, as modas e as flutuações no valor de certas linguagens.<a href="2" rev="footnote">&#8617;</a>

 [1]: https://www.marco.org/2014/07/11/developers-dystopian-future
 [2]: https://swift-lang.org/main/