---
title: Mulheres na área de TI e Respeito
authors: Diego Eis
type: post
date: 2017-09-02
excerpt: Você não precisa de muito para criar um ambiente ótimo para as mulheres, você só precisa de respeito.
categories:
  - Diversidade
  - Na Prática
  - Artigos
  - Tecnologia e Tendências
image: https://i.imgur.com/nrRWK4S.jpg
---

Faz algum tempo que tenho me dedicado a não escrever tantos artigos técnicos. Se você perceber, tenho escrito cada vez menos artigos falando sobre linhas de código e mais artigos falando sobre comportamento, mercado e carreira. Tenho feito isso por vários motivos, mas o mais básico é que eu acho que o mercado precisa amadurecer em outros pontos que nada tem a ver com a parte técnica. 

Um desses pontos é o respeito pelo próximo, principalmente pelas mulheres. As mulheres nunca foram maioria nesse mundo de TI, isso é um fato. Desde o começo da minha carreira eu encontrei poucas mulheres nessa área e devo confessar que nunca me debrucei para entender os motivos. Sou homem, desligado, que nunca "sofreu" qualquer tipo de "opressão" e por isso não senti na pele as dificuldades que as mulheres (e outras minorias) enfrentam para chegar onde chegaram. 

Mas nos últimos anos, as mulheres tecnológicas desse país tem se juntado numa força única, fazendo com que as mulheres ganhem mais espaço nessa área, com mais igualdade e respeito. Mas, sinceramente, eu não sou a melhor pessoa para falar sobre isso, como disse no início, não sou mulher e não saberia retratar aqui qualquer tipo de dificuldade. Contudo, você não precisa saber muita coisa para não ser um babaca, você só precisa ter respeito.

Há uma grande possibilidade de você que está lendo esse artigo ser homem. Se for, há uma grande possibilidade de você fazer piadinhas machistas, de olhar para uma mulher e assobiar, de comentar com seu amiguinho do lado sobre a “mina” que passou de saia… Essas coisas “pequenas e sem importância” só apontam a falta de respeito da sua parte para com as mulheres. Se essa bobeira continuar, NUNCA teremos um ambiente saudável para todas as pessoas.

O mínimo que você, homem, que trabalha nessa área de TI precisa fazer é ter **respeito**. Piadinhas importam sim. Assobios importam sim. Comentários velados importam sim. O jeito que você trata as mulheres quando você está conversando sozinho com o seu melhor amigo, importa sim... Porque o respeito de verdade não é dado apenas na presença de uma mulher, mas principalmente na ausência dela. Este é o respeito genuíno. Uma piada machista não deixa de ser machista se for feita apenas na presença de homens. 

O ambiente cruel é um dos motivos de não haver mais mulheres nessa área. É difícil encontrar lugares onde o ambiente seja realmente agradável e confortável para as mulheres. Ambientes que incentivam a diversidade só podem existir se houver respeito entre os seres viventes (hehehe!) desses ambientes.

Os famosos Códigos de Conduta que os eventos começaram a divulgar uns anos atrás, existem exatamente para criar um ambiente "seguro". E eu confesso: sou totalmente contra ter um Código de Conduta, não porque eu acho errado, mas porque não entra na minha cabeça que em pleno 2017 *nós precisamos ensinar pessoas a criarem um ambiente "livre de assédio para todos"*. Mas *infelizmente existem os babacas* e nós precisamos ajudá-los a serem pessoas melhores. Logo, Códigos de Conduta são necessários e importantes para criar uma cultura ótima.

Então, a minha dica é simples: Não seja babaca. E para não ser babaca é mais simples ainda: tenha respeito pela pessoa próxima a você.

## Iniciativas, heroínas e discursos
Para finalizar esse rap, é interessante que você saiba e divulgue as iniciativas que a mulherada tem feito Brasil afora, não apenas para fortalecer a identidade feminina nesse mercado, mas também para ajudar o mercado a crescer em todos os sentidos, inclusive guiando a galera jovem que está chegando agora nesse mundão complexo do desenvolvimento web. 

### Mulheres para seguir
Algumas heroínas que você deveria seguir. Elas manjam MUITO sobre desenvolvimento web, sobre cultura feminina, mercado e carreira. 

- [Talita Pagani](https://talitapagani.com/)
- [Alda Rocha](https://mjcoffeeholick.github.io/)
- [Vanessa Me Tonini](https://github.com/vanessametonini)
- [Aline Bastos](https://twitter.com/AlineBastos)
- [Livia Amorim](https://t.co/93wjxzJZJP)
- [Evelyn](https://transnerd.com.br/)
- [Iana Chan](https://www.programaria.org/)
- [Débora Cardu](https://twitter.com/deboracardu)
- [Andréa Zambrana](https://twitter.com/akfzambrana)
- [Roberta Arcoverde](https://twitter.com/rla4)
- [Bianca Brancaleone](https://twitter.com/biab)
- [Amanda Rover](https://github.com/amandarover)
- [Daniela Araujo](https://twitter.com/nyan07)

E uma menção especial para duas das mulheres que mais admiro nesse mundão das interwebs: [Lucia Freitas](https://ladybugbrazil.com/) e a [Simone Villas Boas](https://s1mone.net/). 


### Iniciativas
Algumas iniciativas destinadas para as mulheres ou lideradas por mulheres:

- [Luluzinha Camp](https://www.luluzinhacamp.com/)
- [Rails Girls](https://railsgirls.com/)
- [Programaria](https://www.programaria.org/)
- [Projeto Devas](https://twitter.com/projetodevas)
- [Codamos](https://www.meetup.com/pt-BR/Codamos-Club/)
- [Code Like a Girl](https://twitter.com/CodeLikeAGirlBR)
- [Senai Code Experience](https://codexp.sp.senai.br/)
- [Mulheres Palestrantes](https://insideoutproject.xyz/mulheres-palestrantes/)
- [PodProgramar](https://mundopodcast.com.br/podprogramar/)
- [Women Techmakers](https://www.womentechmakers.com/)

### Artigos e outras coisas
Alguns artigos sobre poder feminino no mercado de TI:

- [030 - Deb Xavier: criando uma rede poderosa para incentivar o protagonismo profissional feminino](https://www.youtube.com/watch?v=H9EJF3Q1mis)
- [Mulheres na TI: codando a igualdade](https://imasters.com.br/desenvolvimento/mulheres-na-ti-codando-igualdade/)
- [Ajudando Mulheres a se tornarem Palestrantes TECH — #1 Desconstrução do Medo](https://medium.com/@bernarddeluna/ajudando-mulheres-a-se-tornarem-palestrantes-tech-1-desconstrução-do-medo-2a2c4e3c33cb)
- [Todos nós deveríamos ser feministas | Chimamanda Ngozi Adichie | TEDxEuston](https://www.youtube.com/watch?v=hg3umXU_qWc)
- [Como organizamos o Rails Girls e como você pode começar a programar](https://shipit.resultadosdigitais.com.br/blog/como-organizamos-o-rails-girls-e-como-voce-pode-comecar-a-programar/)
- [Comitê de Diversidade](https://braziljs.org/comite-de-diversidade/)
- [Empoderamento feminino | Maíra Liguori](https://www.youtube.com/watch?v=0HBeBrp3xJc)
- [The TechGirlz Manifesto](https://code.likeagirl.io/the-techgirlz-manifesto-20a0b798bc19)
- [Falei sobre os machistas no Twitter (e eles não gostaram)](https://medium.com/@liviamorim/falei-sobre-os-machistas-no-twitter-e-eles-não-gostaram-b9873a4ef075)
- [I finally got a job as a Software Engineer!](https://code.likeagirl.io/i-finally-got-a-job-as-a-software-engineer-a83c7a745afb)

### Compartilhe
Eu não devo ter colocado um monte de links interessantes aí em cima. Mas me ajuda aí nos comentários, com links e outras iniciativas que você conhece. 




