---
title: Mobile First – A arte de pensar com foco
authors: Diego Eis
type: post
date: 2011-12-13
excerpt: Os dispositivos móveis estão tomando conta do mundo. Sendo assim, o que você acha de pensarmos nos dispositivos móveis antes de pensarmos nos desktops?
url: /mobile-first-a-arte-de-pensar-com-foco/
categories:
  - Mobile
  - Tecnologia e Tendências
tags:
  - design
  - internet
  - internetmovel
  - mobilidade
  - usabilidade

---
Durante muito tempo especialistas de diversas áreas previram o crescimento do uso dos dispositivos móveis. Demorou um pouco mas a previsão se tornou verdadeira. Hoje todo mundo carrega um pedaço de plástico com uma tela de vidro na mão o dia inteiro&#8230; quase uma extensão de nossos corpos.

Os dispositivos móveis se tornaram uma febre e vieram para ficar. É a melhor forma de fazer a inclusão digital para aqueles que não tem uma forma de ter um notebook ou um desktop em casa. Não estou falando daqueles smartphones de R$1500, mas dos muitos smartphones, com teclados qwerty, prontos para internet e que custam R$200. Isso sim é inclusão digital para as massas de verdade.

### Alguns números

As [vendas de smartphones já passaram as de PCs][1]. A utilização de emails pelos dispositivos móveis aumentou em 36%. Sem contar que [o tráfego de visitação de websites utilizando smartphones cresceu 600% em 2010][2]!

O Paypal tempos atrás recebia algo em torno de $10 Milhões de dólares em pagamentos via mobiles. Por dia! [Eles tem uma predição de movimentar algo em torno de 6 Bilhões só este ano][3]! E em 2016 serão $31 Bilhões!

As perspectivas globais são enormes. Abaixo, veja um inforgráfico que o blog [The Meta Cloud][4] preparou. Cuidado para não se assustar.

[<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2011/12/mobile-first-mobile-only.png" alt="" title="mobile-first-mobile-only" width="570" height="902" class="alignnone size-full wp-image-4704" srcset="uploads/2011/12/mobile-first-mobile-only.png 570w, uploads/2011/12/mobile-first-mobile-only-189x300.png 189w" sizes="(max-width: 570px) 100vw, 570px" />][5]

### O conceito

Você consegue entender estes números? Se sim, você vai entender que o conceito do Mobile First faz muito sentido, mas vai contra toda uma tradição de desenvolvimento de sites que você está acostumado. A ideia do Mobiles First é que comecemos a desenvolver e planejar projetos web, desde um pequeno site até um grande sistema, primeiramente para dispositivos móveis e somente depois para desktops/notebooks.

#### Algumas vantagens

Se o mundo inteiro está passando mais tempo acessando a internet com dispositivos móveis, não é muito sensato pensarmos primeiramente em fazermos sites para desktops/notebooks, não é? O fato é que ao colocar os mobiles primeiro lugar, desfrutamos de uma série de vantagens:

  * **As capacidades técnicas são mais interessantes.** Com o mobiles você pode brincar com o acelerometro, GPS, multitouch, giroscópio e etc. Isso amplia a experiência do usuário para um patamar que o desktop nunca terá. 
  * **Foco.** Quem já teve que adaptar um site para mobiles entende que informação demais prejudica. Se focar nas ações essenciais que o usuário executará ao acessar seu site com um dispositivo móvel é o básico.
  * **A atenção em áreas como Arquitetura de Informação, Usabilidade e Acessibilidade é aumentada.** Em mobiles, decidir onde cada botão vai ser posicionado é tão essencial quanto a programação server-side ou um HTML bem feito. 
  * **Te prepara para outros cenários.** Fazer sites mobile é só o primeiro passo. Mas e os grandes formatos como SmartTVs ou outros dispositivos? Não vai demorar muito para acessarmos a internet de qualquer dispositivo sem bloqueios ou restrições. 

### O design

O design também precisa ser revisto. Na verdade, o design mais do que nunca conta com as respostas e os conceitos de AI, Acessibilidade e Usabilidade. Se antes fazíamos festa porque a resolução dos desktops aumentaram e agora temos mais espaço para trabalharmos, nos mobiles o cenário é completamente o contrário.

#### Arquitetura de Informação

As informações que você previa no desktop precisam ser remanejadas, diminuidas e retrabalhadas para que se adaptem nas telas menores. A maioria dos celulares tem algo em torno de 320&#215;480 pixels. Se não tomarmos cuidado, toda a informação pode se perder em uma tela tão pequena. No mundo mobile o simples é a palavra que manda.

Você pode perceber que alguns websites conseguiram resolver bem seus problemas de excesso de informação promovendo em seus websites mobiles apenas as ações realmente importantes e dando foco ao conteúdo que provavelmente o usuário irá consumir quando estiver utilizando um pequeno dispositivo. 

Se você é usuário do Flickr, conhece aquele bando de opções que ele guarda em seu menu principal. São centenas de opções e ações que certamente não cabem em uma tela tão pequena.

![screenshot da tela do site do Flickr versão desktop][6]

Um estudo profundo certamente deve ser feito para que você saiba exatamente quais informações e ações serão mais úteis na versão mobile.

[![screenshot da tela do site do Flickr versão mobile][7]][8]

#### Mantendo informações importantes

Existem também outras formas de acomodar um grande número de informações sem que isso atrapalhe o usuário. Uma delas é criando menus dropdown ou separando uma tela que guarda as informações que serão menos utilizadas mas que são igualmente importantes para a utilização do site/sistema. Veja abaixo dois bons exemplos vindo dos sites Gmail e ESPN.

[<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2011/12/gmail.gif" alt="gmail versão mobile" title="gmail" width="640" height="417" class="alignnone size-full wp-image-4678" srcset="uploads/2011/12/gmail.gif 640w, uploads/2011/12/gmail-300x195.gif 300w" sizes="(max-width: 640px) 100vw, 640px" />][9]

[<img src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2011/12/espn.gif" alt="epsn.com versão mobile" title="espn" width="638" height="355" class="alignnone size-full wp-image-4677" srcset="uploads/2011/12/espn.gif 638w, uploads/2011/12/espn-300x166.gif 300w" sizes="(max-width: 638px) 100vw, 638px" />][10]

Onde os usuários utilizam seus mobiles e visitam seu site? Bem, de todo lugar. Algumas pessoas acham que usuários utilizam apenas quando estão em filas, ônibus, parados no trânsito etc. Mas algumas pesquisas mostram que 84% dos usuários usam seus dispositivos em casa. Isso mesmo&#8230; em casa. Veja bem: quando as pessoas estão em casa, elas preferem utilizar seus smartphones em vez do notebook/desktop!
  
62% utilizam enquanto assistem a TV. Até a TV perde atenção quando briga com os mobiles.

Não existem mais desculpas. Os browsers para mobiles estão tão modernos quanto os dos desktops. O hardware está muito mais poderoso, mais do que poderíamos imaginar a dois anos atrás. Existe um número gigante de usuários utilizando estes dispositivos, isso os torna potenciais visitantes e claro, compradores. Porque desperdiçar esta oportunidade?

Você pode [ler mais sobre este assunto neste livro][11] esperto escrito por [LUKE WROBLEWSKI][12]. Aproveite!

Esse post é patrocinado pelo [UpSites - Quanto custa um site profissional?](https://upsites.digital/criacao-de-site/quanto-custa-site-profissional/).

 [1]: https://tech.fortune.cnn.com/2011/02/07/idc-smartphone-shipment-numbers-passed-pc-in-q4-2010/
 [2]: https://news.bango.com/2010/02/16/600-percent-growth-in-mobile-web-usage/
 [3]: https://prowireless.com.au/paypal-mobile-payments
 [4]: https://www.plexical.com/blog/2011/09/29/mobile-first-mobile-only/
 [5]: https://www.plexical.com/blog/uploads/2011/09/mobile-first-mobile-only.pdf
 [6]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2011/12/flickr1.png
 [7]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2011/12/flickr2.png
 [8]: https://m.flickr.com/
 [9]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2011/12/gmail.gif
 [10]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2011/12/espn.gif
 [11]: https://www.abookapart.com/products/mobile-first
 [12]: https://www.lukew.com/