---
title: Mitos sobre dispositivos móveis
authors: Dani Guerrato
paid: true
type: post
date: 2013-03-26
excerpt: 'Tentar generalizar como as pessoas utilizam seus aparelhos móveis com base em conceitos de fundamentação duvidosa pode muitas vezes levar ao engano. E quem sai prejudicado é o próprio usuário. Conheça os principais mitos sobre o uso de dispositivos móveis. '
url: /mitos-sobre-dispositivos-moveis/
dsq_thread_id: 1165978518
categories:
  - Mercado
  - Mobile
  - Tecnologia e Tendências
tags:
  - 2013
  - desenvolvimento mobile
  - design mobile
  - design responsivo
  - mobile

---
## Mito 1 &#8211; Usuários utilizam dispositivos móveis apenas na rua (e a conexão é sempre lenta)

Entre todos os meus gadgets o meu tablet é o meu favorito. Ele fica sempre por perto e nunca desliga. Se eu preciso de uma informação é só estender o braço e ler. Muito mais rápido e prático do que andar até o escritório, ligar o computador, esperar o navegador abrir e realizar uma busca. Mas não estou baseando esta informação apenas na forma como eu pessoalmente utilizo a internet. 

Acreditar que um usuário de dispositivo móvel necessariamente tem uma conexão de internet pior, está com pressa ou só acessa a internet através do aparelho da rua é um erro. [Pesquisas realizadas pela Google][1] aqui mesmo no Brasil mostram que a maior parte dos usuários utiliza internet em aparelhos móveis prioritariamente em casa (96% dos entrevistados) ou no trabalho (82%) e só 64% utiliza o aparelho na rua.

> O lugar comum em termos de discussão entre desenvolvedores gira atualmente em torno de &#8220;design mobile versus design desktop&#8221;, mas por que não pensar nos dois como aliados ao invés de antagonistas?

## Mito 2 &#8211; Usuários de dispositivos móveis não precisam do conteúdo total

Imagine que a sua pizzaria favorita abriu um serviço de delivery. Mas ao olhar no menu você percebe que eles só tem disponível para entrega pizza de muzzarela e calabresa. Você já visitou o restaurante e sabe que eles oferecem dezenas de outros sabores para os clientes presenciais. Mas por agum motivo eles acham que quem pede pizza por delivery não está interessado no cardápio completo. É provável que você fique bravo com o estabelecimento e prefira pedir comida em outro lugar. A mesma coisa acontece com os usuários de dispositivos móveis. Na verdade [32% dos usuários][2] preferem ver a versão para desktop do que a versão móvel. Isto acontece pois muitas vezes a versão mobile possui menos conteúdo que a versão desktop. Não é por que alguém tem uma tela menor que ele deve ser sentenciado a ver menos informações. O ideal é que o conteúdo seja diagramado de forma que o layout adapte-se ao meio. É o design que deve ser modificado para criar a melhor experiência, não o conteúdo.

A média de [vendas de carros no eBay][3] mobile do Reino Unido é um a cada 57 segundos. Foram mais de 70 millhões de libras em vendas só nos primeiros três meses do ano passado. Ainda acha que o usuário mobile não quer o conteúdo completo?

## Mito 3 &#8211; Usuários de dispositivos móveis preferem uma experiência mais simples

Alguns desenvolvedores pensam que quem acessa um site via smartphone quer ver uma versão lite, como se complexidade fosse necessariamente uma coisa ruim. Não é por que você esta em um dispositivo móvel que você quer ter uma experiência menor ou menos complexa do que em um computador de mesa. Isto não significa que você deva mostrar todas as informações espremidas na mesma tela. Complexidade é diferente de complicação. Usuários de dispositivos móveis farão tudo que um usuários de desktop podem desde que o conteúdo seja apresentado com usabilidade. Limitar as interações é o mesmo que decidir pelos usuários o que eles podem ou não fazer em seus próprios aparelhos. Liberdade de escolha é fundamental.

> Acreditar que um usuário de dispositivo móvel necessariamente tem uma conexão de internet pior, está com pressa ou só acessa a internet através do aparelho da rua é um erro.

## Mito 4 &#8211; Existe uma &#8220;internet móvel&#8221;

Quem nunca se irritou ao encontrar um link interessante em um mecanismo de busca apenas para ser redirecionado para a página inicial da versão mobile? Isto acontece por que alguns desenvolvedores tratam as experiências de navegação em diferentes aparelhos como mundos separados, como se existissem duas internets uma &#8220;normal&#8221; e uma &#8220;móvel&#8221;. Esta visão pode quebrar um galho na hora de criar um modelinho de desenvolvimento, mas na real ela é muito rasa. Não faz diferença se você é do time de versões mobile ou do design responsivo, o que importa é centralizar a navegação em um único endereço que possa idealmente ser sincronizado de acordo com o dispositivo. Utilizar uma mesma URL para o conteúdo desktop e mobile não é apenas uma [boa prática recomendada pelo Google][4], é uma questão de bom senso!

## Conclusão

O lugar comum em termos de discussão entre desenvolvedores gira atualmente em torno de &#8220;design mobile versus design desktop&#8221;, mas por que não pensar nos dois como aliados ao invés de antagonistas? Tablets, smartphones, desktops, televisores e games portáteis formam um verdadeiro ecosssistema de telas. Ao invés de sempre optar pela simplificação, pense em estratégias para tornar a experiência mais atrativa em cada tipo de mídia. Os dispositivos móveis modernos contam com features diferentes de computadores desktops: tela sensível ao toque, microfone, GPS, giroscopio, NFC&#8230; E ainda assim estamos perdendo a oportunidade de explorar estes features ao querer sempre diminuir o número de interações. Projetar experiências complementares e sincrônicas é a grande tendência para o futuro. Tanto o Safari quando o Google Chrome já sincronizam abas e favoritos entre dispositivos. O artigo [Patterns for Multiscreen Strategies][5] aponta ao menos 6 modelos de interação entre dispositivos: coesão, sincronização, compartilhamento da tela, migração de dispositivos, complementação e simultaneidade. 

Com todos estes caminhos a explorar, por que se contentar com &#8220;menos é mais&#8221;? As vezes menos pode ser menos. Deixe seu usuário decidir. Um exemplo recente disto é o uso das hashtags. Popularizadas pelo Twitter, muitos usuários começaram a utilizar o recurso no Facebook, mesmo sem nenhuma função prática de busca ou registro de palavras-chave. Graças a popularização das hashtags o [Facebook pretende implantar][6] oficialmente o recurso. A lição que podemos aprender com o Facebook é: não tente adivinhar o que usuários querem ou impor qual é o &#8220;jeito certo&#8221; de interagir em uma aplicação. Escute as solicitações. Assim você terá o feedback necessário para projetar interfaces que as pessoas realmente queiram utilizar. 

### Saiba mais

[## Mito 1 &#8211; Usuários utilizam dispositivos móveis apenas na rua (e a conexão é sempre lenta)

Entre todos os meus gadgets o meu tablet é o meu favorito. Ele fica sempre por perto e nunca desliga. Se eu preciso de uma informação é só estender o braço e ler. Muito mais rápido e prático do que andar até o escritório, ligar o computador, esperar o navegador abrir e realizar uma busca. Mas não estou baseando esta informação apenas na forma como eu pessoalmente utilizo a internet. 

Acreditar que um usuário de dispositivo móvel necessariamente tem uma conexão de internet pior, está com pressa ou só acessa a internet através do aparelho da rua é um erro. [Pesquisas realizadas pela Google][1] aqui mesmo no Brasil mostram que a maior parte dos usuários utiliza internet em aparelhos móveis prioritariamente em casa (96% dos entrevistados) ou no trabalho (82%) e só 64% utiliza o aparelho na rua.

> O lugar comum em termos de discussão entre desenvolvedores gira atualmente em torno de &#8220;design mobile versus design desktop&#8221;, mas por que não pensar nos dois como aliados ao invés de antagonistas?

## Mito 2 &#8211; Usuários de dispositivos móveis não precisam do conteúdo total

Imagine que a sua pizzaria favorita abriu um serviço de delivery. Mas ao olhar no menu você percebe que eles só tem disponível para entrega pizza de muzzarela e calabresa. Você já visitou o restaurante e sabe que eles oferecem dezenas de outros sabores para os clientes presenciais. Mas por agum motivo eles acham que quem pede pizza por delivery não está interessado no cardápio completo. É provável que você fique bravo com o estabelecimento e prefira pedir comida em outro lugar. A mesma coisa acontece com os usuários de dispositivos móveis. Na verdade [32% dos usuários][2] preferem ver a versão para desktop do que a versão móvel. Isto acontece pois muitas vezes a versão mobile possui menos conteúdo que a versão desktop. Não é por que alguém tem uma tela menor que ele deve ser sentenciado a ver menos informações. O ideal é que o conteúdo seja diagramado de forma que o layout adapte-se ao meio. É o design que deve ser modificado para criar a melhor experiência, não o conteúdo.

A média de [vendas de carros no eBay][3] mobile do Reino Unido é um a cada 57 segundos. Foram mais de 70 millhões de libras em vendas só nos primeiros três meses do ano passado. Ainda acha que o usuário mobile não quer o conteúdo completo?

## Mito 3 &#8211; Usuários de dispositivos móveis preferem uma experiência mais simples

Alguns desenvolvedores pensam que quem acessa um site via smartphone quer ver uma versão lite, como se complexidade fosse necessariamente uma coisa ruim. Não é por que você esta em um dispositivo móvel que você quer ter uma experiência menor ou menos complexa do que em um computador de mesa. Isto não significa que você deva mostrar todas as informações espremidas na mesma tela. Complexidade é diferente de complicação. Usuários de dispositivos móveis farão tudo que um usuários de desktop podem desde que o conteúdo seja apresentado com usabilidade. Limitar as interações é o mesmo que decidir pelos usuários o que eles podem ou não fazer em seus próprios aparelhos. Liberdade de escolha é fundamental.

> Acreditar que um usuário de dispositivo móvel necessariamente tem uma conexão de internet pior, está com pressa ou só acessa a internet através do aparelho da rua é um erro.

## Mito 4 &#8211; Existe uma &#8220;internet móvel&#8221;

Quem nunca se irritou ao encontrar um link interessante em um mecanismo de busca apenas para ser redirecionado para a página inicial da versão mobile? Isto acontece por que alguns desenvolvedores tratam as experiências de navegação em diferentes aparelhos como mundos separados, como se existissem duas internets uma &#8220;normal&#8221; e uma &#8220;móvel&#8221;. Esta visão pode quebrar um galho na hora de criar um modelinho de desenvolvimento, mas na real ela é muito rasa. Não faz diferença se você é do time de versões mobile ou do design responsivo, o que importa é centralizar a navegação em um único endereço que possa idealmente ser sincronizado de acordo com o dispositivo. Utilizar uma mesma URL para o conteúdo desktop e mobile não é apenas uma [boa prática recomendada pelo Google][4], é uma questão de bom senso!

## Conclusão

O lugar comum em termos de discussão entre desenvolvedores gira atualmente em torno de &#8220;design mobile versus design desktop&#8221;, mas por que não pensar nos dois como aliados ao invés de antagonistas? Tablets, smartphones, desktops, televisores e games portáteis formam um verdadeiro ecosssistema de telas. Ao invés de sempre optar pela simplificação, pense em estratégias para tornar a experiência mais atrativa em cada tipo de mídia. Os dispositivos móveis modernos contam com features diferentes de computadores desktops: tela sensível ao toque, microfone, GPS, giroscopio, NFC&#8230; E ainda assim estamos perdendo a oportunidade de explorar estes features ao querer sempre diminuir o número de interações. Projetar experiências complementares e sincrônicas é a grande tendência para o futuro. Tanto o Safari quando o Google Chrome já sincronizam abas e favoritos entre dispositivos. O artigo [Patterns for Multiscreen Strategies][5] aponta ao menos 6 modelos de interação entre dispositivos: coesão, sincronização, compartilhamento da tela, migração de dispositivos, complementação e simultaneidade. 

Com todos estes caminhos a explorar, por que se contentar com &#8220;menos é mais&#8221;? As vezes menos pode ser menos. Deixe seu usuário decidir. Um exemplo recente disto é o uso das hashtags. Popularizadas pelo Twitter, muitos usuários começaram a utilizar o recurso no Facebook, mesmo sem nenhuma função prática de busca ou registro de palavras-chave. Graças a popularização das hashtags o [Facebook pretende implantar][6] oficialmente o recurso. A lição que podemos aprender com o Facebook é: não tente adivinhar o que usuários querem ou impor qual é o &#8220;jeito certo&#8221; de interagir em uma aplicação. Escute as solicitações. Assim você terá o feedback necessário para projetar interfaces que as pessoas realmente queiram utilizar. 

### Saiba mais

][7] 
  
[There Is No Mobile Internet!][8]
  
[Assumptions About Mobile To Reconsider][9]

 [1]: https://www.thinkwithgoogle.com/mobileplanet/en/graph/?country=br&country=cn&country=se&country=uk&country=us&category=DETAILS&topic=DETAILS_LOCA&stat=LOCA01&stat=LOCA02&stat=LOCA03&stat=LOCA04&stat=LOCA06&stat=LOCA10&subcategory=GSA&wave=wave2&age=all&gender=all&active=stat "Our mobile planet"
 [2]: https://www.strangeloopnetworks.com/resources/infographics/mobile-infographics/32-percent-of-customers-choose-to-view-the-full-site-on-their-mobile-device/ "32% of customers  choose to view the full site on their mobile device"
 [3]: https://cardealermagazine.co.uk/publish/ebay-sees-huge-acceleration-in-mobile-car-sales-and-launches-its-own-app/66471 "Rise in mobile car sale"
 [4]: https://googlewebmastercentral.blogspot.se/2012/06/recommendations-for-building-smartphone.html "Recommendations for smartphone-optimized websites"
 [5]: https://precious-forever.com/2011/05/26/patterns-for-multiscreen-strategies/ " Patterns for Multiscreen Strategies"
 [6]: https://online.wsj.com/article/SB10001424127887323393304578360651345373308.html "Facebook Working on Incorporating the Hashtag"
 [7]: https://vimeo.com/48327889 "The Seven Deadly Myths of Mobile "
 [8]: https://www.smashingmagazine.com/2013/02/25/there-is-no-mobile-internet/ "Read 'There Is No Mobile Internet!'"
 [9]: https://mobile.smashingmagazine.com/2013/01/18/assumptions-about-mobile-to-reconsider/ "Read 'Think Again: Assumptions About Mobile To Reconsider'"